-- Dave 3.0.0
-- Written by FrontBase Server - 8.2.18
-- Created by FrontBase Server - 8.2.18 64-bit
;
--SET CATALOG 'DAVE300'
;
--SET DATABASE IDENTITY '607ff6a100010d775ae01bac';

SET TRANSACTION ISOLATION LEVEL SERIALIZABLE, LOCKING PESSIMISTIC;
SET SESSION AUTHORIZATION "_SYSTEM";
DROP SCHEMA "_SYSTEM" CASCADE;
COMMIT;
CREATE SCHEMA "_SYSTEM" AUTHORIZATION "_SYSTEM";
COMMIT;
SET SCHEMA "_SYSTEM";
SET SESSION AUTHORIZATION "_SYSTEM";
CREATE TABLE "TALGEMENEREKENINGEN"(
   "CALGEMENEREKENINGEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMAALGEMENEREKENINGEN" CHARACTER VARYING(10),
   "CALGEMENEREKENING" CHARACTER VARYING(10),
   "CNIETACTIEF" BOOLEAN,
   "CANALYTISCHOPVOLGEN" BOOLEAN,
   "COMSCHRIJVING1" CHARACTER VARYING(50) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "COMSCHRIJVING2" CHARACTER VARYING(50),
   "COMSCHRIJVING3" CHARACTER VARYING(50),
   "COMSCHRIJVING4" CHARACTER VARYING(50),
   "CPERCENTAGENIETAFTR" NUMERIC(5,2)
);


CREATE TABLE "TBETALINGSVOORWAARDEN"(
   "CBETALINGSVOORWAARDEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CBETALINGSVOORWAARDE" CHARACTER VARYING(10),
   "CDOMICILIERING" BOOLEAN,
   "CKREDIETBEPERKINGPERCENTAGE" NUMERIC(4,2),
   "COMSCHRIJVING1" CHARACTER VARYING(80),
   "COMSCHRIJVING2" CHARACTER VARYING(80),
   "COMSCHRIJVING3" CHARACTER VARYING(80),
   "COMSCHRIJVING4" CHARACTER VARYING(80),
   "CVERVALDAGAANTALDAGEN" INTEGER,
   "CVERVALDAGEINDEMAAND" BOOLEAN,
   "CREMBOURS" BOOLEAN,
   "CNIETACTIEF" BOOLEAN DEFAULT FALSE,
   "CVERVALDAGEXTRADAGEN" INTEGER DEFAULT 0
);


CREATE TABLE "TBTWREGIMES"(
   "CBTWREGIMES_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "COMSCHRIJVING1" CHARACTER VARYING(20),
   "CBTWREGIME" CHARACTER VARYING(10),
   "COMSCHRIJVING2" CHARACTER VARYING(20),
   "COMSCHRIJVING3" CHARACTER VARYING(20),
   "COMSCHRIJVING4" CHARACTER VARYING(20)
);


CREATE TABLE "TCOLINFO"(
   "CCOLINFO_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CDISPLAYFORMAT" CHARACTER VARYING(25),
   "CINFO" CHARACTER VARYING(500),
   "CINITIALVALUE" CHARACTER VARYING(30),
   "CINPUTCHECK" CHARACTER VARYING(100),
   "CINPUTFORMAT" CHARACTER VARYING(25),
   "CKOLOM" INTEGER,
   "CLOOKUP" CHARACTER VARYING(500),
   "CNEGATIVEALLOWED" BOOLEAN,
   "COBJECTTYPE" CHARACTER VARYING(20),
   "COMSCHRIJVING" CHARACTER VARYING(500),
   "CTOOLTIP" CHARACTER VARYING(100),
   "CUPPERCASE" BOOLEAN,
   "CVERPLICHT" BOOLEAN,
   "CZEROEMPTY" BOOLEAN
);


CREATE TABLE "TCONTACTEN"(
   "CCONTACTEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMACONTACTEN" CHARACTER VARYING(10),
   "CCONTACT" CHARACTER VARYING(10),
   "CNAAM1" CHARACTER VARYING(50) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "CNAAM2" CHARACTER VARYING(50),
   "CADRES1" CHARACTER VARYING(50),
   "CADRES2" CHARACTER VARYING(50),
   "CEMAILADRES" CHARACTER VARYING(128) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "CFAX" CHARACTER VARYING(20),
   "CGEMEENTE" CHARACTER VARYING(50) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "CLAND" CHARACTER VARYING(2),
   "CMEDEWERKER" CHARACTER VARYING(10),
   "CMEDEWERKERCOMMISSIEPERC" NUMERIC(5,2),
   "CMEDEWERKERS_FK" INTEGER,
   "CMOBILE" CHARACTER VARYING(20),
   "CNIETACTIEF" BOOLEAN DEFAULT FALSE,
   "CONDERNEMINGSNUMMER" CHARACTER VARYING(20),
   "CPARTICULIER" BOOLEAN DEFAULT FALSE,
   "CPOSTBUS" CHARACTER VARYING(10),
   "CPOSTBUSPLAATS" CHARACTER VARYING(50),
   "CPOSTBUSPOSTCODE" CHARACTER VARYING(10),
   "CPOSTCODE" CHARACTER VARYING(10),
   "CPROSPECT" BOOLEAN DEFAULT FALSE,
   "CRECHTSVORM" CHARACTER VARYING(10),
   "CTAAL" CHARACTER VARYING(1),
   "CTELEFOON" CHARACTER VARYING(20),
   "CWEBSITE" CHARACTER VARYING(50),
   "CBTWNUMMER" CHARACTER VARYING(25),
   "CHOOFDCONTACT" CHARACTER VARYING(10),
   "CHOOFDCONTACTEN_FK" INTEGER,
   "CZOEKNAAM" CHARACTER VARYING(100),
   "CREGIO" CHARACTER VARYING(20) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "CTELEFOON2" CHARACTER VARYING(20),
   "CSECTOR" CHARACTER VARYING(40) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "CISKLANT" BOOLEAN DEFAULT FALSE,
   "CISLEVERANCIER" BOOLEAN DEFAULT FALSE,
   "CINFO" CHARACTER VARYING(10000),
   "CBANKREKENINGNUMMER" CHARACTER VARYING(42),
   "CBANKREKENINGNUMMER2" CHARACTER VARYING(42),
   "CBANKBIC" CHARACTER VARYING(11),
   "CBANKBIC2" CHARACTER VARYING(11),
   "CSELECTIECODE" CHARACTER VARYING(20),
   "CGEENMAILING" BOOLEAN DEFAULT FALSE,
   "CAANTALARBEIDERS" CHARACTER VARYING(30),
   "CAANTALBEDIENDEN" CHARACTER VARYING(30),
   "CACTIVITEIT" CHARACTER VARYING(128),
   "CBRON" CHARACTER VARYING(128),
   "CNACECODE" CHARACTER VARYING(10),
   "CNACECODES_FK" INTEGER,
   "COMZET" CHARACTER VARYING(30),
   "COORSPRONGCONTACT" CHARACTER VARYING(10),
   "COORSPRONGCONTACTEN_FK" INTEGER,
   "CPROSPECTGOEDGEKEURD" BOOLEAN DEFAULT FALSE,
   "CPROSPECTGROEP" CHARACTER VARYING(128),
   "CPROSPECTSTATUS" CHARACTER VARYING(128),
   "CPROSPECTSTATUSDATUM" DATE,
   "COORSPRONG" CHARACTER VARYING(128),
   "CMEDEWERKERINTERN" CHARACTER VARYING(10),
   "CMEDEWERKERSINTERN_FK" INTEGER,
   "CSUBOORSPRONG" CHARACTER VARYING(128)
);


CREATE TABLE "TCONTACTGROEPEN"(
   "CCONTACTGROEPEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CCONTACTGROEP" CHARACTER VARYING(10),
   "COMSCHRIJVING" CHARACTER VARYING(30),
   "CNIETACTIEF" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TCONTACTGROEPENCONTACT"(
   "CCONTACTGROEPENCONTACT_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CCONTACTEN_FK" INTEGER,
   "CCONTACTGROEPEN_FK" INTEGER,
   "CWAARDE" CHARACTER VARYING(10)
);


CREATE TABLE "TCONTACTPERSONEN"(
   "CCONTACTPERSONEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CNAAM" CHARACTER VARYING(30) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "CAFDELING" CHARACTER VARYING(30),
   "CCONTACTEN_FK" INTEGER,
   "CEMAILADRES" CHARACTER VARYING(128) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "CFAX" CHARACTER VARYING(20),
   "CFUNCTIE" CHARACTER VARYING(50),
   "CGEBOORTEDATUM" DATE,
   "CINFO" CHARACTER VARYING(1024),
   "CMOBILE" CHARACTER VARYING(20),
   "CTELEFOON" CHARACTER VARYING(20),
   "CVERJAARDAG" CHARACTER VARYING(10),
   "CTAAL" CHARACTER VARYING(1),
   "CAANSPREEKTITEL" CHARACTER VARYING(20),
   "CAANHEF" CHARACTER VARYING(20),
   "CGESLACHT" SMALLINT,
   "CVOORNAAM" CHARACTER VARYING(30) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "CTELEFOONPRIVE" CHARACTER VARYING(20),
   "CSELECTIECODE" CHARACTER VARYING(20),
   "CNIETACTIEF" BOOLEAN DEFAULT FALSE,
   "CGEENMAILING" BOOLEAN DEFAULT FALSE,
   "CZOEKNAAM" CHARACTER VARYING(60)
);


CREATE TABLE "TCONTACTROLLEN"(
   "CCONTACTROLLEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CCONTACTROL" CHARACTER VARYING(10),
   "CALGEMENEREKENING" CHARACTER VARYING(10),
   "CALGEMENEREKENINGEN_FK" INTEGER,
   "CBETALINGSVOORWAARDE" CHARACTER VARYING(10),
   "CBETALINGSVOORWAARDEN_FK" INTEGER,
   "CCOLLECTIEVEREKENING" CHARACTER VARYING(10),
   "CCOLLECTIEVEREKENINGEN_FK" INTEGER,
   "CCONTACTEN_FK" INTEGER,
   "CCRDEXTERNKLANTNUMMER" CHARACTER VARYING(10),
   "CCRDFICHE28150" BOOLEAN,
   "CCRDFICHE28150ECHTGENOTE" CHARACTER VARYING(50),
   "CCRDFICHE28150BEROEP" CHARACTER VARYING(50),
   "CCRDNIETBTWPLICHTIG" BOOLEAN DEFAULT FALSE,
   "CDEBBTWREGIME" CHARACTER VARYING(10),
   "CDEBBTWREGIMES_FK" INTEGER,
   "CDEBFACTUURAANTALEXEMPLAREN" INTEGER,
   "CDEBKREDIETLIJN" NUMERIC(12,2),
   "CDEBRAPPELAANSPREKING" CHARACTER VARYING(128),
   "CDEBRAPPELMAXIMUMNUMMER" INTEGER,
   "CDEBRAPPELS" BOOLEAN DEFAULT TRUE,
   "CDEBTRANSPORTEUR" CHARACTER VARYING(10),
   "CDEBTRANSPORTEURS_FK" INTEGER,
   "CDEBVOORWAARENECHT" BOOLEAN DEFAULT FALSE,
   "CFINKORTINGPERCENTAGE" NUMERIC(5,2),
   "CGEBLOKKEERD" BOOLEAN DEFAULT FALSE,
   "CGEBLOKKEERDINFO" CHARACTER VARYING(128),
   "CINFO" CHARACTER VARYING(10000),
   "CKORTINGPERCENTAGE" NUMERIC(5,2),
   "CLEVERINGSVOORWAARDE" CHARACTER VARYING(10),
   "CLEVERINGSVOORWAARDEN_FK" INTEGER,
   "CMUNT" CHARACTER VARYING(3),
   "CMUNTEN_FK" INTEGER,
   "CROLGROEP" CHARACTER VARYING(10),
   "CROLGROEPEN_FK" INTEGER,
   "CKORTINGGROEP" CHARACTER VARYING(10),
   "CINTRASTATTRANSACTIE" CHARACTER VARYING(10),
   "CEXTRA1" CHARACTER VARYING(1024),
   "CEXTRA2" CHARACTER VARYING(1024),
   "CEXTRA3" CHARACTER VARYING(1024),
   "CEXTRA4" CHARACTER VARYING(1024),
   "CEXTRA5" CHARACTER VARYING(1024),
   "CTARIEF" CHARACTER VARYING(10),
   "CTARIEVEN_FK" INTEGER,
   "CCRDMINIMUMBEDRAG" NUMERIC(10,2),
   "CMETFOSTPLUS" BOOLEAN DEFAULT FALSE,
   "CMETMILIEUHEFFING" BOOLEAN DEFAULT FALSE,
   "CDEBRAPPELEMAILADRES" CHARACTER VARYING(60),
   "CDEBFACTUURVERZAMELEN" BOOLEAN DEFAULT FALSE,
   "CEXTRADATUM1" DATE,
   "CEXTRADATUM2" DATE,
   "CDEBDOMICILIERINGNUMMER" CHARACTER VARYING(20),
   "CDEBFACTUUREMAILADRES" CHARACTER VARYING(128),
   "CRIJKSREGISTERNUMMER" CHARACTER VARYING(20),
   "CISMEDECONTRACTANT" BOOLEAN DEFAULT FALSE,
   "CISFACTORING" BOOLEAN DEFAULT TRUE,
   "CINFOSUPPORT" CHARACTER VARYING(128),
   "CMETKILOMETERHEFFING" BOOLEAN DEFAULT TRUE,
   "CGLN" CHARACTER VARYING(15),
   "CDEBFACTUURVIA" CHARACTER VARYING(20)
);


CREATE TABLE "TCONTACTROLLENBB"(
   "CCONTACTROLLENBB_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CBANKBETAALWIJZE" CHARACTER VARYING(3),
   "CBANKBIC" CHARACTER VARYING(11),
   "CBANKINSTRUCTIES" CHARACTER VARYING(70),
   "CBANKISOLANDCODE" CHARACTER VARYING(2),
   "CBANKMEDEDELING" CHARACTER VARYING(70),
   "CBANKNAAM" CHARACTER VARYING(35),
   "CBANKPLAATS" CHARACTER VARYING(24),
   "CBANKPOSTLANDCODE" CHARACTER VARYING(3),
   "CBANKSTRAAT" CHARACTER VARYING(35),
   "CBEGUNSTIGDEIBAN" CHARACTER VARYING(42),
   "CBEGUNSTIGDENAAM" CHARACTER VARYING(35),
   "CBEGUNSTIGDEPLAATS" CHARACTER VARYING(24),
   "CBEGUNSTIGDEPOSTLANDCODE" CHARACTER VARYING(3),
   "CBEGUNSTIGDESTRAAT" CHARACTER VARYING(35),
   "CCONTACTROLLEN_FK" INTEGER,
   "CTUSSENBANKBIC" CHARACTER VARYING(11),
   "CISIBAN" BOOLEAN DEFAULT TRUE,
   "CBANKKOSTEN" CHARACTER VARYING(4),
   "CBEGUNSTIGDEISOLANDCODE" CHARACTER VARYING(2),
   "CBEGUNSTIGDEPOSTCODE" CHARACTER VARYING(10),
   "CBANKPOSTCODE" CHARACTER VARYING(10)
);


CREATE TABLE "TINTERNEFIRMAMEDEWERKERS"(
   "CINTERNEFIRMAMEDEWERKERS_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CMEDEWERKER" CHARACTER VARYING(10),
   "CMEDEWERKERS_FK" INTEGER,
   "CMEDEWERKERGROEP" CHARACTER VARYING(10),
   "CMEDEWERKERGROEPEN_FK" INTEGER,
   "CINTERNEFIRMAVESTIGING" CHARACTER VARYING(10),
   "CINTERNEFIRMAVESTIGINGEN_FK" INTEGER
);


CREATE TABLE "TINTERNEFIRMAS"(
   "CINTERNEFIRMAS_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CNAAM1" CHARACTER VARYING(50),
   "CNAAM2" CHARACTER VARYING(50),
   "CACTIVITEIT" CHARACTER VARYING(50),
   "CINTERNEFIRMAALGEMENEREKENINGEN" CHARACTER VARYING(10),
   "CINTERNEFIRMACONTACTEN" CHARACTER VARYING(10),
   "CLOGO" BLOB,
   "CMOBILE" CHARACTER VARYING(20),
   "CONDERNEMINGSNUMMER" CHARACTER VARYING(20),
   "CWEBSITE" CHARACTER VARYING(50),
   "CBTWNUMMER" CHARACTER VARYING(25),
   "CINTERNEFIRMAARTIKELS" CHARACTER VARYING(10),
   "CACTIVATIECODE" CHARACTER VARYING(128),
   "CACTIVATIECONTROLECODE" CHARACTER VARYING(20),
   "CDATUMAANVRAAG" DATE,
   "CHOOFDFIRMA" BOOLEAN,
   "CNIETACTIEF" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TLANDEN"(
   "CLANDEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CLAND" CHARACTER VARYING(2),
   "CLANDBTW" CHARACTER VARYING(2),
   "CEU" BOOLEAN,
   "COMSCHRIJVING" CHARACTER VARYING(30) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "CTELEFOONPREFIX" INTEGER,
   "CFORMATTERINGBTWNUMMER" CHARACTER VARYING(25),
   "CVLAG" BLOB,
   "CLANDBELCOTAX" CHARACTER VARYING(5)
);


CREATE TABLE "TDOCUMENTSTATUSSEN"(
   "CDOCUMENTSTATUSSEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CDOCUMENTTYPES_FK" INTEGER,
   "COMSCHRIJVING1" CHARACTER VARYING(30),
   "COMSCHRIJVING2" CHARACTER VARYING(30),
   "COMSCHRIJVING3" CHARACTER VARYING(30),
   "COMSCHRIJVING4" CHARACTER VARYING(30),
   "CSTATUS" INTEGER,
   "CACTIE1" CHARACTER VARYING(30),
   "CACTIE2" CHARACTER VARYING(30),
   "CACTIE3" CHARACTER VARYING(30),
   "CACTIE4" CHARACTER VARYING(30),
   "CDOCUMENTTYPE" CHARACTER VARYING(20),
   "CVERKORT1" CHARACTER VARYING(3),
   "CVERKORT2" CHARACTER VARYING(3),
   "CVERKORT3" CHARACTER VARYING(3),
   "CVERKORT4" CHARACTER VARYING(3)
);


CREATE TABLE "TLEVERINGSVOORWAARDEN"(
   "CLEVERINGSVOORWAARDEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CLEVERINGSVOORWAARDE" CHARACTER VARYING(10),
   "COMSCHRIJVING1" CHARACTER VARYING(80),
   "COMSCHRIJVING2" CHARACTER VARYING(80),
   "COMSCHRIJVING3" CHARACTER VARYING(80),
   "COMSCHRIJVING4" CHARACTER VARYING(80),
   "CNIETACTIEF" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TMEDEWERKERGROEPEN"(
   "CMEDEWERKERGROEPEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CMEDEWERKERGROEP" CHARACTER VARYING(10),
   "COMSCHRIJVING" CHARACTER VARYING(50) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE"
);


CREATE TABLE "TMEDEWERKERS"(
   "CMEDEWERKERS_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CMEDEWERKER" CHARACTER VARYING(10),
   "CNAAM" CHARACTER VARYING(30),
   "CVOORNAAM" CHARACTER VARYING(30),
   "CADRES1" CHARACTER VARYING(50),
   "CADRES2" CHARACTER VARYING(50),
   "CEMAILADRES" CHARACTER VARYING(128),
   "CFAX" CHARACTER VARYING(20),
   "CGEMEENTE" CHARACTER VARYING(50),
   "CLAND" CHARACTER VARYING(2),
   "CMOBILE" CHARACTER VARYING(20),
   "CPOSTCODE" CHARACTER VARYING(15),
   "CTAAL" CHARACTER VARYING(1),
   "CTELEFOON" CHARACTER VARYING(20),
   "CFOTO" BLOB,
   "CGESLACHT" SMALLINT,
   "CAUTOWIJZIG" BOOLEAN,
   "CAUTOSELECTIE" BOOLEAN,
   "CREPINGAVE" BOOLEAN,
   "CGEBRUIKER" BOOLEAN,
   "CAUTOGEPRINT" BOOLEAN,
   "CNIETACTIEF" BOOLEAN,
   "CISVERTEGENWOORDIGER" BOOLEAN,
   "CISTECHNICUS" BOOLEAN,
   "CISMONTEUR" BOOLEAN,
   "CISBEHEERDER" BOOLEAN,
   "CINITIALEN" CHARACTER VARYING(10),
   "CMETEIGENCONTACTEN" BOOLEAN DEFAULT FALSE,
   "CAANSPREEKTITEL" CHARACTER VARYING(20),
   "CMETAGENDA" BOOLEAN DEFAULT TRUE,
   "CISSUPPORT" BOOLEAN DEFAULT FALSE,
   "CGEENSELECTIE" BOOLEAN DEFAULT FALSE,
   "CSTARTPRESTATIE" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TMUNTEN"(
   "CMUNTEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CKOERS" NUMERIC(12,6),
   "CMUNT" CHARACTER VARYING(3),
   "COMSCHRIJVING" CHARACTER VARYING(30),
   "CNIETACTIEF" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TNOACCESS"(
   "CNOACCESS_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CTOEGANG" BOOLEAN,
   "CINSERT" BOOLEAN,
   "CUPDATE" BOOLEAN,
   "CDELETE" BOOLEAN,
   "CLIBRARY" CHARACTER VARYING(50),
   "CMEDEWERKERGROEP" CHARACTER VARYING(10),
   "CMEDEWERKERGROEPEN_FK" INTEGER,
   "COBJECT" CHARACTER VARYING(50)
);


CREATE TABLE "TPOSTCODES"(
   "CPOSTCODES_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CPOSTCODE" CHARACTER VARYING(10),
   "CGEMEENTE" CHARACTER VARYING(50) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "CLAND" CHARACTER VARYING(2),
   "CADRES1" CHARACTER VARYING(50) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "CPROVINCIE" CHARACTER VARYING(50)
);


CREATE TABLE "TROLGROEPEN"(
   "CROLGROEPEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CROLGROEP" CHARACTER VARYING(10),
   "COMSCHRIJVING" CHARACTER VARYING(30),
   "CNIETACTIEF" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TTALEN"(
   "CTALEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CTAAL" CHARACTER VARYING(1),
   "COMSCHRIJVING" CHARACTER VARYING(30)
);


CREATE TABLE "TTRANSPORTEURS"(
   "CTRANSPORTEURS_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CTRANSPORTEUR" CHARACTER VARYING(10),
   "COMSCHRIJVING" CHARACTER VARYING(30) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "CDAGEN" CHARACTER VARYING(10),
   "CNIETACTIEF" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TVOORSTELREKENINGEN"(
   "CVOORSTELREKENINGEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CALGEMENEREKENINGEN_FK" INTEGER,
   "CCONTACTROLLEN_FK" INTEGER
);


CREATE TABLE "TWINPOSITIES"(
   "CWINPOSITIES_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CHEIGHT" INTEGER,
   "CLEFT" INTEGER,
   "CLIBRARY" CHARACTER VARYING(50),
   "CMEDEWERKER" CHARACTER VARYING(10),
   "CMEDEWERKERS_FK" INTEGER,
   "COBJECT" CHARACTER VARYING(50),
   "CTOP" INTEGER,
   "CWIDTH" INTEGER,
   "CCOLUMNWIDTHS" CHARACTER VARYING(128)
);


CREATE TABLE "TROLLEN"(
   "CROLLEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CROL" CHARACTER VARYING(10),
   "COMSCHRIJVING1" CHARACTER VARYING(30),
   "COMSCHRIJVING2" CHARACTER VARYING(30),
   "COMSCHRIJVING3" CHARACTER VARYING(30),
   "COMSCHRIJVING4" CHARACTER VARYING(30)
);


CREATE TABLE "TCODELIJSTEN"(
   "CCODELIJSTEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "COMSCHRIJVING" CHARACTER VARYING(128) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "CCODE" CHARACTER VARYING(15)
);


CREATE TABLE "TCOLSELECT"(
   "CCOLSELECT_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CSORTASCENDING" BOOLEAN,
   "CKOLOMNAAM" CHARACTER VARYING(50),
   "CMEDEWERKER" CHARACTER VARYING(10),
   "CMEDEWERKERS_FK" INTEGER,
   "COMSCHRIJVING" CHARACTER VARYING(50),
   "COPERATOR" CHARACTER VARYING(10),
   "CTABELNAAM" CHARACTER VARYING(50),
   "CWAARDE" CHARACTER VARYING(30),
   "CCLASS" CHARACTER VARYING(50)
);


CREATE TABLE "TCATEGORIEN"(
   "CCATEGORIEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CCATEGORIE" CHARACTER VARYING(15),
   "CKLEUR" CHARACTER VARYING(20)
);


CREATE TABLE "TARTIKELKORTINGENLEVERANCIERS"(
   "CARTIKELKORTINGENLEVERANCIERS_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CARTIKELS_FK" INTEGER,
   "CCONTACTEN_FK" INTEGER,
   "CKORTINGPERCENTAGE" NUMERIC(5,2),
   "CAANKOOPPRIJS" NUMERIC(12,4),
   "CDATUMVAN" DATE,
   "CDATUMTOT" DATE,
   "COPERATOR" CHARACTER VARYING(1),
   "CMUNT" CHARACTER VARYING(3),
   "CMUNTEN_FK" INTEGER,
   "CEENHEIDAANKOOP" CHARACTER VARYING(10),
   "CAANKOOPPRIJSFACTOR" FLOAT DEFAULT 0,
   "CMINIMUMAANTAL" FLOAT,
   "CINFO" CHARACTER VARYING(1024),
   "CGRATISAANTAL" FLOAT DEFAULT 0
);


CREATE TABLE "TSUBCATEGORIEN"(
   "CSUBCATEGORIEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CCATEGORIEN_FK" INTEGER,
   "CSUBCATEGORIE" CHARACTER VARYING(15)
);


CREATE TABLE "TREPORTS"(
   "CREPORTS_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CREPORT" CHARACTER VARYING(50),
   "CREPTEMPLATES_FK" INTEGER,
   "CLIBRARY" CHARACTER VARYING(50),
   "CPLATFORM" CHARACTER VARYING(1)
);


CREATE TABLE "TREPTEMPLATES"(
   "CREPTEMPLATES_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CREPTEMPLATE" CHARACTER VARYING(50),
   "CTOONPAGESETUP" BOOLEAN,
   "CSELECTPRINTER" BOOLEAN,
   "CNAAMPRINTER" CHARACTER VARYING(100),
   "CSELECTDESTINATION" BOOLEAN,
   "CDESTINATION" CHARACTER VARYING(50),
   "CLMARGE" NUMERIC(6,3),
   "CRMARGE" NUMERIC(6,3),
   "CTMARGE" NUMERIC(6,3),
   "CBMARGE" NUMERIC(6,3),
   "CLABELREPORT" BOOLEAN,
   "CLABELCOUNT" INTEGER,
   "CLABELWIDTH" NUMERIC(6,3),
   "CLABELSPACING" NUMERIC(6,3),
   "CLABELREPEAT" INTEGER,
   "CMANUALSCALE" INTEGER,
   "CCHARSPERINCH" INTEGER,
   "CLINESPERINCH" INTEGER,
   "CGENERATEPAGES" BOOLEAN,
   "CLINESPERPAGE" INTEGER,
   "CRESTRICTPAGEWIDTH" BOOLEAN,
   "CCHARSPERLINE" INTEGER,
   "CSENDFORMFEED" BOOLEAN,
   "CPORTNAME" CHARACTER VARYING(50),
   "CPORTSPEED" INTEGER,
   "CPORTHANDSHAKE" CHARACTER VARYING(20),
   "CPORTPARITY" CHARACTER VARYING(20),
   "CPORTDATABITS" CHARACTER VARYING(20),
   "CPORTSTOPBIT" CHARACTER VARYING(20),
   "CPLATFORM" CHARACTER VARYING(1),
   "CPAPERLENGTH" NUMERIC(7,4),
   "CPAPERWIDTH" NUMERIC(7,4),
   "CSCALE" INTEGER,
   "CCOPIES" INTEGER,
   "CORIENTATION" INTEGER,
   "CPAPER" INTEGER,
   "COPENJOBSETUP" BOOLEAN,
   "CPAGESETUPDATA" BLOB
);


CREATE TABLE "TMODULES"(
   "CMODULES_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CMODULE" CHARACTER VARYING(10),
   "CVERSIE" CHARACTER VARYING(10),
   "CISSTANDAARD" BOOLEAN
);


CREATE TABLE "TINSTELLINGEN"(
   "CINSTELLINGEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CINTERNEFIRMAVESTIGING" CHARACTER VARYING(10),
   "CINTERNEFIRMAVESTIGINGEN_FK" INTEGER,
   "CMODULEVOLGNUMMER" INTEGER,
   "CTYPEVOLGNUMMER" INTEGER,
   "CINSTELLING" CHARACTER VARYING(25),
   "CINDEX" CHARACTER VARYING(25),
   "CWAARDE" CHARACTER VARYING(1024),
   "CMODULE1" CHARACTER VARYING(10),
   "CMODULE2" CHARACTER VARYING(10),
   "CMODULE3" CHARACTER VARYING(10),
   "CMODULE4" CHARACTER VARYING(10),
   "CTYPE1" CHARACTER VARYING(25),
   "CTYPE2" CHARACTER VARYING(25),
   "CTYPE3" CHARACTER VARYING(25),
   "CTYPE4" CHARACTER VARYING(25)
);


CREATE TABLE "TDOCUMENTTYPES"(
   "CDOCUMENTTYPES_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "COMSCHRIJVING1" CHARACTER VARYING(50),
   "COMSCHRIJVING2" CHARACTER VARYING(50),
   "COMSCHRIJVING3" CHARACTER VARYING(50),
   "COMSCHRIJVING4" CHARACTER VARYING(50),
   "CDOCUMENTTYPE" CHARACTER VARYING(20),
   "CMEERVOUD1" CHARACTER VARYING(50),
   "CMEERVOUD2" CHARACTER VARYING(50),
   "CMEERVOUD3" CHARACTER VARYING(50),
   "CMEERVOUD4" CHARACTER VARYING(50)
);


CREATE TABLE "TINTERNEFIRMAVESTIGINGEN"(
   "CINTERNEFIRMAVESTIGINGEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CINTERNEFIRMAVESTIGING" CHARACTER VARYING(10),
   "CHOOFDVESTIGING" BOOLEAN,
   "CADRES1" CHARACTER VARYING(50),
   "CADRES2" CHARACTER VARYING(50),
   "CCONTACTPERSOON" CHARACTER VARYING(30),
   "CEMAILADRES" CHARACTER VARYING(128),
   "CFAX" CHARACTER VARYING(20),
   "CGEMEENTE" CHARACTER VARYING(50),
   "CLAND" CHARACTER VARYING(2),
   "CMOBILE" CHARACTER VARYING(20),
   "CPOSTCODE" CHARACTER VARYING(10),
   "CTELEFOON" CHARACTER VARYING(20),
   "CNIETACTIEF" BOOLEAN DEFAULT FALSE,
   "CGLN" CHARACTER VARYING(15)
);


CREATE TABLE "TRUIMTEN"(
   "CRUIMTEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CRUIMTE" CHARACTER VARYING(20)
);


CREATE TABLE "TANALYTISCHEREKENINGEN"(
   "CANALYTISCHEREKENINGEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMAALGEMENEREKENINGEN" CHARACTER VARYING(10),
   "CANALYTISCHEREKENING" CHARACTER VARYING(10),
   "CNIETACTIEF" BOOLEAN,
   "COMSCHRIJVING2" CHARACTER VARYING(128),
   "COMSCHRIJVING3" CHARACTER VARYING(128),
   "COMSCHRIJVING4" CHARACTER VARYING(128),
   "COMSCHRIJVING1" CHARACTER VARYING(128) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "CNIVEAU" SMALLINT DEFAULT 1
);


CREATE TABLE "TBTWCODES"(
   "CBTWCODES_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CBTWCODE" CHARACTER VARYING(10),
   "CBTWPERCENTAGE" NUMERIC(5,2),
   "CLANDBTW" CHARACTER VARYING(2),
   "CAANKOOP" BOOLEAN,
   "CVERKOOP" BOOLEAN,
   "CBTWPLICHTIG" BOOLEAN,
   "CEXPORT" BOOLEAN,
   "CIMPORT" BOOLEAN,
   "CINTRA" BOOLEAN,
   "CMEDECONTRACTANT" BOOLEAN,
   "COMSCHRIJVING1" CHARACTER VARYING(30),
   "COMSCHRIJVING2" CHARACTER VARYING(30),
   "COMSCHRIJVING3" CHARACTER VARYING(30),
   "COMSCHRIJVING4" CHARACTER VARYING(30),
   "CVRIJ" BOOLEAN,
   "CFIN" BOOLEAN,
   "CALGREKBUITENLAND" CHARACTER VARYING(10),
   "CKOSTBIJVERKOOP" BOOLEAN DEFAULT FALSE,
   "CINTRADIENSTEN" BOOLEAN DEFAULT FALSE,
   "CUN5305" CHARACTER VARYING(3),
   "CUNCL5305" CHARACTER VARYING(3),
   "CVATEX" CHARACTER VARYING(16)
);


CREATE TABLE "TGNCODES"(
   "CGNCODES_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "COMSCHRIJVING" CHARACTER VARYING(1024),
   "CEENHEDENVERPLICHT" BOOLEAN,
   "CMASSAOPTIONEEL" BOOLEAN,
   "CGNCODE" CHARACTER VARYING(8),
   "CNIETACTIEF" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TARTIKELGROEPEN"(
   "CARTIKELGROEPEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CNIVEAU11" CHARACTER VARYING(30),
   "CNIVEAU21" CHARACTER VARYING(30),
   "CNIVEAU31" CHARACTER VARYING(30),
   "CARTIKELGROEP2" CHARACTER VARYING(30),
   "CNIVEAU12" CHARACTER VARYING(30),
   "CNIVEAU22" CHARACTER VARYING(30),
   "CNIVEAU32" CHARACTER VARYING(30),
   "CARTIKELGROEP3" CHARACTER VARYING(30),
   "CNIVEAU13" CHARACTER VARYING(30),
   "CNIVEAU23" CHARACTER VARYING(30),
   "CNIVEAU33" CHARACTER VARYING(30),
   "CARTIKELGROEP4" CHARACTER VARYING(30),
   "CNIVEAU14" CHARACTER VARYING(30),
   "CNIVEAU24" CHARACTER VARYING(30),
   "CNIVEAU34" CHARACTER VARYING(30),
   "CINTERNEFIRMAARTIKELS" CHARACTER VARYING(10),
   "CNIVEAU41" CHARACTER VARYING(30),
   "CNIVEAU42" CHARACTER VARYING(30),
   "CNIVEAU43" CHARACTER VARYING(30),
   "CNIVEAU44" CHARACTER VARYING(30),
   "CARTIKELGROEP1" CHARACTER VARYING(30) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "CNIVEAU" INTEGER,
   "CARTIKELGROEP" CHARACTER VARYING(10)
);


CREATE TABLE "TDOCUMENTACTIES"(
   "CDOCUMENTACTIES_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CDOCUMENTTYPE" CHARACTER VARYING(20),
   "CDOCUMENTTYPES_FK" INTEGER,
   "CDOCUMENTACTIE" INTEGER,
   "CACTIE1" CHARACTER VARYING(40),
   "CACTIE2" CHARACTER VARYING(40),
   "CACTIE3" CHARACTER VARYING(40),
   "CACTIE4" CHARACTER VARYING(40),
   "CKOPIEREN" BOOLEAN
);


CREATE TABLE "TINCOTERMS"(
   "CINCOTERMS_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINCOTERM" CHARACTER VARYING(3),
   "COMSCHRIJVING1" CHARACTER VARYING(80),
   "COMSCHRIJVING2" CHARACTER VARYING(80),
   "COMSCHRIJVING3" CHARACTER VARYING(80),
   "COMSCHRIJVING4" CHARACTER VARYING(80)
);


CREATE TABLE "TINTRASTATGEWESTEN"(
   "CINTRASTATGEWESTEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "COMSCHRIJVING1" CHARACTER VARYING(80),
   "COMSCHRIJVING2" CHARACTER VARYING(80),
   "COMSCHRIJVING3" CHARACTER VARYING(80),
   "COMSCHRIJVING4" CHARACTER VARYING(80),
   "CINTRASTATGEWEST" CHARACTER VARYING(10)
);


CREATE TABLE "TINTRASTATTRANSACTIES"(
   "CINTRASTATTRANSACTIES_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "COMSCHRIJVING1" CHARACTER VARYING(80),
   "COMSCHRIJVING2" CHARACTER VARYING(80),
   "COMSCHRIJVING3" CHARACTER VARYING(80),
   "COMSCHRIJVING4" CHARACTER VARYING(80),
   "CINTRASTATTRANSACTIE" CHARACTER VARYING(10)
);


CREATE TABLE "TINTRASTATVERVOER"(
   "CINTRASTATVERVOER_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "COMSCHRIJVING1" CHARACTER VARYING(80),
   "COMSCHRIJVING2" CHARACTER VARYING(80),
   "COMSCHRIJVING3" CHARACTER VARYING(80),
   "COMSCHRIJVING4" CHARACTER VARYING(80),
   "CINTRASTATVERVOER" CHARACTER VARYING(10)
);


CREATE TABLE "TVESTIGINGMAGAZIJNEN"(
   "CVESTIGINGMAGAZIJNEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMAVESTIGINGEN_FK" INTEGER,
   "CVESTIGINGMAGAZIJN" CHARACTER VARYING(10),
   "CHOOFDMAGAZIJN" BOOLEAN DEFAULT FALSE,
   "CLIJNNUMMER" INTEGER DEFAULT 0,
   "CNIETACTIEF" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TARTIKELS"(
   "CARTIKELS_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CARTIKEL" CHARACTER VARYING(25),
   "CINTERNEFIRMAARTIKELS" CHARACTER VARYING(10),
   "CAANKOOPREKENING" CHARACTER VARYING(10),
   "CAANKOOPREKENINGEN_FK" INTEGER,
   "CARTIKELBARCODE" CHARACTER VARYING(25),
   "CARTIKELGROEPEN_FK" INTEGER,
   "CBREEDTE" FLOAT DEFAULT 0,
   "CBTWCODE" CHARACTER VARYING(10),
   "CBTWCODES_FK" INTEGER,
   "CCONTACTEN_FK" INTEGER,
   "CEENHEIDVOORRAAD" CHARACTER VARYING(10),
   "CEERSTEAANKOOP" DATE,
   "CEERSTEVERKOOP" DATE,
   "CFOTO" BLOB,
   "CGEENKORTINGEN" BOOLEAN DEFAULT FALSE,
   "CGEMAANKOOPPRIJS" NUMERIC(10,2),
   "CGEWICHT" NUMERIC(10,3) DEFAULT 0,
   "CGNCODE" CHARACTER VARYING(8),
   "CGNCODES_FK" INTEGER,
   "CHOOGTE" FLOAT DEFAULT 0,
   "CINFO1" CHARACTER VARYING(10000),
   "CINFO2" CHARACTER VARYING(10000),
   "CINFO3" CHARACTER VARYING(10000),
   "CINFO4" CHARACTER VARYING(10000),
   "CINFOINTERN" CHARACTER VARYING(10000),
   "CKORTINGGROEP" CHARACTER VARYING(10),
   "CLAATSTEAANKOOP" DATE,
   "CLAATSTEAANKOOPPRIJS" NUMERIC(12,4),
   "CLAATSTEVERKOOP" DATE,
   "CLENGTE" FLOAT DEFAULT 0,
   "CMETLOTNUMMERS" BOOLEAN DEFAULT FALSE,
   "CMETSERIENUMMERS" BOOLEAN DEFAULT FALSE,
   "CMETVOORRAAD" BOOLEAN DEFAULT FALSE,
   "CMETMONTAGE" BOOLEAN DEFAULT FALSE,
   "CNIETACTIEF" BOOLEAN DEFAULT FALSE,
   "COMSCHRIJVING1" CHARACTER VARYING(2056) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "COMSCHRIJVING2" CHARACTER VARYING(2056),
   "COMSCHRIJVING3" CHARACTER VARYING(2056),
   "COMSCHRIJVING4" CHARACTER VARYING(2056),
   "CSELECTIECODE" CHARACTER VARYING(10),
   "CVERKOOPREKENING" CHARACTER VARYING(10),
   "CVERKOOPREKENINGEN_FK" INTEGER,
   "CVERVANGARTIKEL" CHARACTER VARYING(25),
   "CMETKOPPELARTIKELEN" BOOLEAN DEFAULT FALSE,
   "CVOLUME" FLOAT DEFAULT 0,
   "CMATENBALKEN_FK" INTEGER,
   "CKLEURENKAARTEN_FK" INTEGER,
   "CLAATSTEAANKOOPKOSTEN" NUMERIC(12,4),
   "CEXTRA1" CHARACTER VARYING(1024),
   "CEXTRA2" CHARACTER VARYING(1024),
   "CEXTRA3" CHARACTER VARYING(1024),
   "CEXTRA4" CHARACTER VARYING(1024),
   "CEXTRA5" CHARACTER VARYING(1024),
   "CARTIKELGROEP" CHARACTER VARYING(30) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "CGEENHERBEREKENING" BOOLEAN DEFAULT FALSE,
   "CEINDEREEKS" BOOLEAN DEFAULT FALSE,
   "CEENHEID" CHARACTER VARYING(10),
   "CEENHEIDVOLUME" CHARACTER VARYING(10),
   "CEXTRA6" CHARACTER VARYING(1024),
   "CEXTRA7" CHARACTER VARYING(1024),
   "CEXTRA8" CHARACTER VARYING(1024),
   "CEXTRADATUM1" DATE,
   "CEXTRADATUM2" DATE,
   "CISFOSTPLUS" BOOLEAN DEFAULT FALSE,
   "CISMILIEUHEFFING" BOOLEAN DEFAULT FALSE,
   "CLAND" CHARACTER VARYING(2),
   "CINFOINSTRUCTIE" CHARACTER VARYING(1024),
   "CLENGTE2" FLOAT DEFAULT 0,
   "CBREEDTE2" FLOAT DEFAULT 0,
   "CHOOGTE2" FLOAT DEFAULT 0,
   "CEENHEID2" CHARACTER VARYING(10),
   "CVOLUME2" FLOAT DEFAULT 0,
   "CEENHEIDVOLUME2" CHARACTER VARYING(10),
   "CISDIENST" BOOLEAN DEFAULT FALSE,
   "CISABONNEMENTARTIKEL" BOOLEAN DEFAULT FALSE,
   "CISSUPPORTPRODUCT" BOOLEAN DEFAULT FALSE,
   "CWAARSCHUWING" CHARACTER VARYING(128),
   "CMERK" CHARACTER VARYING(50),
   "CCONTACT" CHARACTER VARYING(10),
   "CARTIKELFABRIKANT" CHARACTER VARYING(25),
   "CISWEBSITE" BOOLEAN DEFAULT FALSE,
   "CISBESTELARTIKEL" BOOLEAN DEFAULT FALSE,
   "CISGEWOGEN" BOOLEAN DEFAULT FALSE,
   "CISLEEGGOED" BOOLEAN DEFAULT FALSE,
   "CWAARSCHUWINGAANKOOP" CHARACTER VARYING(128),
   "CEXTRACHECKBOX1" BOOLEAN DEFAULT FALSE,
   "CEXTRACHECKBOX2" BOOLEAN DEFAULT FALSE,
   "CEXTRACHECKBOX3" BOOLEAN DEFAULT FALSE,
   "CEXTRACHECKBOX4" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TARTIKELLEVERANCIERS"(
   "CARTIKELLEVERANCIERS_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CAANKOOPPRIJS" NUMERIC(12,4),
   "CAANKOOPPRIJSDATUM" DATE,
   "CARTIKELLEVERANCIER" CHARACTER VARYING(25),
   "CARTIKELS_FK" INTEGER,
   "CBEDRAG" NUMERIC(12,4),
   "CCONTACTEN_FK" INTEGER,
   "CEENHEIDAANKOOP" CHARACTER VARYING(10),
   "CKORTINGPERCENTAGE" NUMERIC(5,2) DEFAULT 0,
   "CMUNT" CHARACTER VARYING(3),
   "CMUNTEN_FK" INTEGER,
   "COMSCHRIJVING" CHARACTER VARYING(256),
   "CAANKOOPKOSTEN" NUMERIC(12,4) DEFAULT 0,
   "CHOOFDLEVERANCIER" BOOLEAN,
   "CMINIMUMAANTAL" FLOAT DEFAULT 0,
   "CAANKOOPPRIJSFACTOR" FLOAT DEFAULT 0,
   "CVERPAKTPER" FLOAT DEFAULT 0,
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER
);


CREATE TABLE "TARTIKELVOORRAAD"(
   "CARTIKELVOORRAAD_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CARTIKELS_FK" INTEGER,
   "CINTERNEFIRMAVESTIGING" CHARACTER VARYING(10),
   "CVESTIGINGMAGAZIJN" CHARACTER VARYING(10),
   "CKLEUR" CHARACTER VARYING(10),
   "CMAAT" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CINTERNEFIRMAVESTIGINGEN_FK" INTEGER,
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CLOTDATUM" DATE,
   "CVOORRAAD" FLOAT,
   "CVOORRAADBESCHIKBAAR" FLOAT,
   "CLOTNUMMER" CHARACTER VARYING(20) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "CINPICKING" FLOAT DEFAULT 0
);


CREATE TABLE "TKLEURENKAARTEN"(
   "CKLEURENKAARTEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CKLEURENKAART" CHARACTER VARYING(10),
   "COMSCHRIJVING" CHARACTER VARYING(30)
);


CREATE TABLE "TKLEUREN"(
   "CKLEUREN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CKLEUR" CHARACTER VARYING(10),
   "CKLEURENKAARTEN_FK" INTEGER,
   "COMSCHRIJVING1" CHARACTER VARYING(30),
   "COMSCHRIJVING2" CHARACTER VARYING(30),
   "COMSCHRIJVING3" CHARACTER VARYING(30),
   "COMSCHRIJVING4" CHARACTER VARYING(30)
);


CREATE TABLE "TMATENBALKEN"(
   "CMATENBALKEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CMATENBALK" CHARACTER VARYING(10),
   "COMSCHRIJVING" CHARACTER VARYING(30)
);


CREATE TABLE "TMATEN"(
   "CMATEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CMAAT" CHARACTER VARYING(10),
   "CMATENBALKEN_FK" INTEGER
);


CREATE TABLE "TARTIKELINVESTIGING"(
   "CARTIKELINVESTIGING_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CARTIKELS_FK" INTEGER,
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CINTERNEFIRMAVESTIGING" CHARACTER VARYING(10),
   "CINTERNEFIRMAVESTIGINGEN_FK" INTEGER,
   "CINBESTELLINGKLANT" FLOAT,
   "CINBESTELLINGLEVERANCIER" FLOAT,
   "CINCONSIGNATIEKLANT" FLOAT,
   "CINCONSIGNATIELEVERANCIER" FLOAT,
   "CINRESERVATIE" FLOAT,
   "CKLEUR" CHARACTER VARYING(10),
   "CMAAT" CHARACTER VARYING(10),
   "CMAXVOORRAAD" FLOAT DEFAULT 0,
   "CMINVOORRAAD" FLOAT DEFAULT 0,
   "CINPRODUCTIE" FLOAT,
   "CVOORPRODUCTIE" FLOAT
);


CREATE TABLE "TARTIKELKORTINGEN"(
   "CARTIKELKORTINGEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CARTIKELS_FK" INTEGER,
   "CARTIKELKORTINGGROEP" CHARACTER VARYING(10),
   "CCONTACTEN_FK" INTEGER,
   "CKLANTKORTINGGROEP" CHARACTER VARYING(10),
   "CKORTINGPERCENTAGE" NUMERIC(5,2),
   "CVERKOOPPRIJS" NUMERIC(12,4),
   "CMUNT" CHARACTER VARYING(3),
   "CMUNTEN_FK" INTEGER,
   "CDATUMVAN" DATE,
   "CDATUMTOT" DATE,
   "COPERATOR" CHARACTER VARYING(1),
   "CTARIEF" CHARACTER VARYING(10),
   "CTARIEVEN_FK" INTEGER,
   "CKORTINGPERCENTAGETEKST" CHARACTER VARYING(15),
   "CEENHEIDVERKOOP" CHARACTER VARYING(10),
   "CAANTALFACTOR" FLOAT DEFAULT 0,
   "CMINIMUMAANTAL" FLOAT,
   "CINFO" CHARACTER VARYING(1024),
   "CGRATISAANTAL" FLOAT DEFAULT 0
);


CREATE TABLE "TARTIKELONDERDELEN"(
   "CARTIKELONDERDELEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CARTIKELS_FK" INTEGER,
   "CONDERDELEN_FK" INTEGER,
   "CAANTAL" FLOAT(10),
   "COMSCHRIJVING" CHARACTER VARYING(1024),
   "CLIJNNUMMER" INTEGER DEFAULT 0
);


CREATE TABLE "TARTIKELGEKOPPELD"(
   "CARTIKELGEKOPPELD_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CARTIKELS_FK" INTEGER,
   "COMSCHRIJVING" CHARACTER VARYING(30),
   "CGEKOPPELD_FK" INTEGER,
   "CAANTAL" FLOAT,
   "CVERPLICHT" BOOLEAN DEFAULT TRUE,
   "CTAKSEN" BOOLEAN DEFAULT FALSE,
   "CMETPRIJZEN" BOOLEAN DEFAULT TRUE,
   "CLIJNNUMMER" INTEGER DEFAULT 0
);


CREATE TABLE "TADRESTYPES"(
   "CADRESTYPES_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CADRESTYPE" CHARACTER VARYING(10),
   "COMSCHRIJVING1" CHARACTER VARYING(30),
   "COMSCHRIJVING2" CHARACTER VARYING(30),
   "COMSCHRIJVING3" CHARACTER VARYING(30),
   "COMSCHRIJVING4" CHARACTER VARYING(30)
);


CREATE TABLE "TCONTACTADRESSEN"(
   "CCONTACTADRESSEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CNAAM1" CHARACTER VARYING(50) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "CNAAM2" CHARACTER VARYING(50),
   "CADRESTYPE" CHARACTER VARYING(10),
   "CADRES1" CHARACTER VARYING(50) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "CADRES2" CHARACTER VARYING(50),
   "CCONTACTEN_FK" INTEGER,
   "CEMAILADRES" CHARACTER VARYING(128) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "CFAX" CHARACTER VARYING(20),
   "CGEMEENTE" CHARACTER VARYING(50),
   "CINFO" CHARACTER VARYING(1024),
   "CLAND" CHARACTER VARYING(2),
   "CMOBILE" CHARACTER VARYING(20),
   "CPOSTCODE" CHARACTER VARYING(10),
   "CTAAL" CHARACTER VARYING(1),
   "CTELEFOON" CHARACTER VARYING(20),
   "CTERATTENTIEVAN" CHARACTER VARYING(60),
   "CINFOINTERN" CHARACTER VARYING(1024),
   "CLEVERINGSVOORWAARDE" CHARACTER VARYING(10),
   "CLEVERINGSVOORWAARDEN_FK" INTEGER,
   "CINFOUREN" CHARACTER VARYING(1024),
   "CTELEFOON2" CHARACTER VARYING(20),
   "CISSTANDAARD" BOOLEAN DEFAULT FALSE,
   "CNIETACTIEF" BOOLEAN DEFAULT FALSE,
   "CGEENMAILING" BOOLEAN DEFAULT FALSE,
   "CCONTACTPERSONEN_FK" INTEGER,
   "CGLN" CHARACTER VARYING(15)
);


CREATE TABLE "TTARIEVEN"(
   "CTARIEVEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINCLBTW" BOOLEAN,
   "CKOERS" NUMERIC(12,6),
   "CMARGE" NUMERIC(5,2),
   "CMUNT" CHARACTER VARYING(3),
   "CMUNTEN_FK" INTEGER,
   "CTARIEF" CHARACTER VARYING(10),
   "COMSCHRIJVING1" CHARACTER VARYING(30),
   "COMSCHRIJVING2" CHARACTER VARYING(30),
   "COMSCHRIJVING3" CHARACTER VARYING(30),
   "COMSCHRIJVING4" CHARACTER VARYING(30),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CNIETACTIEF" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TARTIKELPRIJZEN"(
   "CARTIKELPRIJZEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CARTIKELS_FK" INTEGER,
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CTARIEVEN_FK" INTEGER,
   "CEENHEIDSPRIJS" NUMERIC(12,4) DEFAULT 0,
   "CEENHEIDSPRIJSFACTOR" NUMERIC(12,4) DEFAULT 0,
   "CEENHEIDSPRIJSEENHEID" CHARACTER VARYING(10),
   "CMINIMUMVERKOOPPRIJS" NUMERIC(12,4) DEFAULT 0,
   "CTARIEF" CHARACTER VARYING(10),
   "CVERKOOPPRIJS" NUMERIC(12,4),
   "CMARGE" NUMERIC(5,2),
   "CAANTALFACTOR" FLOAT DEFAULT 0,
   "CEENHEIDVERKOOP" CHARACTER VARYING(10)
);


CREATE TABLE "TVERKOPEN"(
   "CVERKOPEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CDOCUMENTTYPE" CHARACTER VARYING(20),
   "CDOCUMENTTYPES_FK" INTEGER,
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CINTERNEFIRMAVESTIGING" CHARACTER VARYING(10),
   "CINTERNEFIRMAVESTIGINGEN_FK" INTEGER,
   "CNUMMER" INTEGER,
   "CPREFIX" CHARACTER VARYING(10),
   "CVERSIE" INTEGER,
   "CAFGESLOTENDOOR" CHARACTER VARYING(10),
   "CBEDRAGBTW" NUMERIC(10,2),
   "CBEDRAGEXCL" NUMERIC(10,2),
   "CBEDRAGINCL" NUMERIC(10,2),
   "CBETALINGSVOORWAARDE" CHARACTER VARYING(10),
   "CBETALINGSVOORWAARDEN_FK" INTEGER,
   "CCONTACTEN_FK" INTEGER,
   "CDATUM" DATE,
   "CDATUMAFGESLOTEN" TIMESTAMP,
   "CDATUMGOEDGEKEURD" TIMESTAMP,
   "CDATUMVERSTUURD" TIMESTAMP,
   "CDOCUMENTGROEP" CHARACTER VARYING(10),
   "CFACTURATIEADRES" CHARACTER VARYING(1024),
   "CFINKORTINGPERCENTAGE" NUMERIC(5,2),
   "CGOEDGEKEURDDOOR" CHARACTER VARYING(10),
   "CINFOINTERN" CHARACTER VARYING(10000),
   "CINFOINTRO" CHARACTER VARYING(1024),
   "CINFOSLOT" CHARACTER VARYING(1024),
   "CINTRASTATTRANSACTIE" CHARACTER VARYING(10),
   "CKASSANUMMER" INTEGER,
   "CKASVERKOPEN" BOOLEAN,
   "CKORTINGPERCENTAGE" NUMERIC(5,2),
   "CKREDIETBEPERKING" NUMERIC(10,2),
   "CKREDIETBEPERKINGPERC" NUMERIC(5,2),
   "CLEVERINGSADRES" CHARACTER VARYING(1024),
   "CLEVERINGSDATUM" DATE,
   "CLEVERINGSVOORWAARDE" CHARACTER VARYING(10),
   "CLEVERINGSVOORWAARDEN_FK" INTEGER,
   "CMUNT" CHARACTER VARYING(3),
   "CMUNTEN_FK" INTEGER,
   "COFFBUDGET" NUMERIC(10,2),
   "COFFDATUMOPVOLGING" DATE,
   "COFFDATUMVERWBESTEL" DATE,
   "COFFSLAAGKANS" INTEGER,
   "CPRIORITEIT" INTEGER,
   "CSTATUS" INTEGER,
   "CSTATUSPERCENTAGE" INTEGER,
   "CTARIEF" CHARACTER VARYING(10),
   "CTARIEVEN_FK" INTEGER,
   "CTERATTENTIEVAN" CHARACTER VARYING(60),
   "CTRANSPORTEUR" CHARACTER VARYING(10),
   "CTRANSPORTEURS_FK" INTEGER,
   "CVERSTUURDDOOR" CHARACTER VARYING(10),
   "CVERTEGENWOORDIGER" CHARACTER VARYING(10),
   "CVERTEGENWOORDIGERS_FK" INTEGER,
   "CVERVALDATUM" DATE,
   "CTAAL" CHARACTER VARYING(1),
   "CINCLBTW" BOOLEAN,
   "CKORTINGGROEP" CHARACTER VARYING(10),
   "CMETRESERVATIE" BOOLEAN,
   "CAFGESLOTEN" BOOLEAN,
   "CKOERS" NUMERIC(12,6),
   "CFINKORTING" NUMERIC(10,2),
   "COFFSTATUS" INTEGER,
   "COFFINFO" CHARACTER VARYING(50),
   "CVOLLEDIG" BOOLEAN,
   "CBTWREGIME" SMALLINT,
   "CKORTING" NUMERIC(10,2),
   "CCONTACTPERSONEN_FK" INTEGER,
   "CGEPRINT" BOOLEAN,
   "CONZEREFERENTIE" CHARACTER VARYING(20) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "CUWREFERENTIE" CHARACTER VARYING(40) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "CGEVERIFIEERD" BOOLEAN,
   "CCONTACTADRESSEN_FK" INTEGER,
   "CLEVERINGSDATUMGEWENST" DATE,
   "CDOCUMENTBLOB" BLOB,
   "CDOCUMENTBLOBBYTES" INTEGER,
   "CVERKOOPSTATUS" CHARACTER VARYING(10),
   "CELEKTRONISCHVERSTUURD" BOOLEAN DEFAULT FALSE,
   "CNUMMERPLAAT" CHARACTER VARYING(20),
   "CNAAMCHAUFFEUR" CHARACTER VARYING(30),
   "CMEDEWERKERINTERN" CHARACTER VARYING(10),
   "CMEDEWERKERSINTERN_FK" INTEGER,
   "CGEPRINTPICKING" BOOLEAN DEFAULT FALSE,
   "CBEDRAGLEEGGOED" NUMERIC(10,2) DEFAULT 0,
   "CEDI" BOOLEAN DEFAULT FALSE,
   "CEDI_OK" BOOLEAN DEFAULT FALSE,
   "CSELECTIECODE" CHARACTER VARYING(20),
   "CNUMMER5" INTEGER DEFAULT 0,
   "CAFRONDINGSVERSCHIL" NUMERIC(10,2) DEFAULT 0
);


CREATE TABLE "TVERKOOPCOLLI"(
   "CVERKOOPCOLLI_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CCOLLINUMMER" INTEGER,
   "CVERKOPEN_FK" INTEGER,
   "CAANTAL" INTEGER,
   "CGEWICHT" NUMERIC(10,3),
   "CPALLETNUMMER" INTEGER,
   "CAFMETINGEN" CHARACTER VARYING(20)
);


CREATE TABLE "TVERKOOPBETALINGEN"(
   "CVERKOOPBETALINGEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CLIJNNUMMER" INTEGER,
   "CVERKOPEN_FK" INTEGER,
   "CBEDRAG" NUMERIC(10,2),
   "CBETAALWIJZE" CHARACTER VARYING(15),
   "CCASH" BOOLEAN,
   "CDATUM" TIMESTAMP,
   "CMUNT" CHARACTER VARYING(3),
   "CMUNTEN_FK" INTEGER,
   "CVERWERKT" BOOLEAN,
   "COMSCHRIJVING" CHARACTER VARYING(30),
   "CKASSAAFSL_FK" INTEGER
);


CREATE TABLE "TVERKOOPLIJNEN"(
   "CVERKOOPLIJNEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CLIJNNUMMER" INTEGER,
   "CVERKOPEN_FK" INTEGER,
   "CAANKOOPPRIJS" NUMERIC(12,4),
   "CAANTALTEKST" CHARACTER VARYING(30),
   "CALGEMENEREKENING" CHARACTER VARYING(10),
   "CALGEMENEREKENINGEN_FK" INTEGER,
   "CANALYTISCHEREKENING" CHARACTER VARYING(10),
   "CANALYTISCHEREKENINGEN_FK" INTEGER,
   "CARTIKELS_FK" INTEGER,
   "CBEDRAG" NUMERIC(10,2),
   "CBTWCODE" CHARACTER VARYING(10),
   "CBTWPERCENTAGE" NUMERIC(5,2),
   "CGEENKORTINGEN" BOOLEAN,
   "CGEWICHT" NUMERIC(10,3),
   "CGNCODE" CHARACTER VARYING(8),
   "CGNCODES_FK" INTEGER,
   "CINCLBTW" BOOLEAN,
   "CINFO" CHARACTER VARYING(10000),
   "CINFOINTERN" CHARACTER VARYING(10000),
   "CKLEUR" CHARACTER VARYING(10),
   "CKLEURENKAARTEN_FK" INTEGER,
   "CLEVERINGSDATUM" DATE,
   "CLIJNFLOW_FK" INTEGER,
   "CLIJNGEKOPPELD_FK" INTEGER,
   "CLIJNKORTINGPERCENTAGE" NUMERIC(5,2),
   "CLIJNVORIGE_FK" INTEGER,
   "CMAAT" CHARACTER VARYING(10),
   "CMATENBALKEN_FK" INTEGER,
   "CMETKOPPELARTIKELEN" BOOLEAN,
   "CMETSERIENUMMERS" BOOLEAN,
   "CMETVOORRAAD" BOOLEAN,
   "COMSCHRIJVING" CHARACTER VARYING(256),
   "CSTATUS" INTEGER,
   "CTARIEF" CHARACTER VARYING(10),
   "CTARIEVEN_FK" INTEGER,
   "CVERKOOPPRIJS" NUMERIC(12,4),
   "CVESTIGINGMAGAZIJN" CHARACTER VARYING(10),
   "CAANTAL" FLOAT,
   "CAANTALGERESERVEERD" FLOAT,
   "CAANTALVERWERKT" FLOAT,
   "CKORTINGGROEP" CHARACTER VARYING(10),
   "CMETRESERVATIE" BOOLEAN,
   "CMETLOTNUMMERS" BOOLEAN,
   "CARTIKEL" CHARACTER VARYING(25),
   "CEENHEIDVOORRAAD" CHARACTER VARYING(10),
   "CAANTALGEKOPPELD" FLOAT,
   "CNUMMERVORIGE" CHARACTER VARYING(20),
   "CAANTALTEVERWERKEN" FLOAT,
   "CMETTITEL" BOOLEAN,
   "CLIJNVORIGETYPE" INTEGER,
   "CLIJNKORTINGTEKST" CHARACTER VARYING(15),
   "CLOTNUMMER" CHARACTER VARYING(20) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "CLEVERINGSDATUMGEWENST" DATE,
   "CEENHEIDVERKOOP" CHARACTER VARYING(10),
   "CAANTALFACTOR" FLOAT DEFAULT 0,
   "CAANTALVOORRAAD" FLOAT,
   "CAANTALVOORRAADVERWERKT" FLOAT,
   "CAANTALLEEGGOED" NUMERIC(10,2) DEFAULT 0,
   "CPRIJSLEEGGOED" NUMERIC(10,2) DEFAULT 0,
   "CTOTAALLEEGGOED" NUMERIC(10,2) DEFAULT 0,
   "CARTIKELLEEGGOED" CHARACTER VARYING(25),
   "CARTIKELLEEGGOED_FK" INTEGER,
   "CLIJNNUMMER_PARTNER" INTEGER DEFAULT 0,
   "CSELECTIECODE" CHARACTER VARYING(20),
   "CARTIKELKLANT" CHARACTER VARYING(25)
);


CREATE TABLE "TMATERIALEN"(
   "CMATERIALEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CMATERIAAL" CHARACTER VARYING(50)
);


CREATE TABLE "TAGENDALABELS"(
   "CAGENDALABELS_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CAGENDALABEL" CHARACTER VARYING(15),
   "CKLEUR" CHARACTER VARYING(20)
);


CREATE TABLE "TAANKOPEN"(
   "CAANKOPEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CDOCUMENTTYPE" CHARACTER VARYING(20),
   "CDOCUMENTTYPES_FK" INTEGER,
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CINTERNEFIRMAVESTIGING" CHARACTER VARYING(10),
   "CINTERNEFIRMAVESTIGINGEN_FK" INTEGER,
   "CNUMMER" INTEGER,
   "CPREFIX" CHARACTER VARYING(10),
   "CAFGESLOTEN" BOOLEAN,
   "CAFGESLOTENDOOR" CHARACTER VARYING(10),
   "CBEDRAGBTW" NUMERIC(12,2),
   "CBEDRAGEXCL" NUMERIC(12,2),
   "CBEDRAGINCL" NUMERIC(12,2),
   "CBETAALD" BOOLEAN,
   "CBETALINGSVOORWAARDE" CHARACTER VARYING(10),
   "CBETALINGSVOORWAARDEN_FK" INTEGER,
   "CCONTACTEN_FK" INTEGER,
   "CDATUM" DATE,
   "CDATUMAFGESLOTEN" TIMESTAMP,
   "CDATUMGOEDGEKEURD" TIMESTAMP,
   "CDATUMVERSTUURD" TIMESTAMP,
   "CDOCUMENTGROEP" CHARACTER VARYING(10),
   "CFACTURATIEADRES" CHARACTER VARYING(1024),
   "CFINKORTING" NUMERIC(10,2),
   "CFINKORTINGPERCENTAGE" NUMERIC(5,2),
   "CGOEDGEKEURDDOOR" CHARACTER VARYING(10),
   "CINCLBTW" BOOLEAN,
   "CINFOBETALING" CHARACTER VARYING(30),
   "CINFOINTERN" CHARACTER VARYING(10000),
   "CINFOINTRO" CHARACTER VARYING(1024),
   "CINFOSLOT" CHARACTER VARYING(1024),
   "CINTRASTATTRANSACTIE" CHARACTER VARYING(10),
   "CKOERS" NUMERIC(12,6),
   "CKORTINGPERCENTAGE" NUMERIC(5,2),
   "CMUNT" CHARACTER VARYING(3),
   "CMUNTEN_FK" INTEGER,
   "CSTATUS" INTEGER,
   "CSTATUSPERCENTAGE" INTEGER,
   "CTAAL" CHARACTER VARYING(1),
   "CTERATTENTIEVAN" CHARACTER VARYING(60),
   "CVERSTUURDDOOR" CHARACTER VARYING(10),
   "CVERVALDATUM" DATE,
   "CNIETBTWPLICHTIG" BOOLEAN,
   "CKORTING" NUMERIC(10,2),
   "CCONTACTPERSONEN_FK" INTEGER,
   "CLEVERINGSDATUM" DATE,
   "CGEPRINT" BOOLEAN,
   "CONZEREFERENTIE" CHARACTER VARYING(20) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "CUWREFERENTIE" CHARACTER VARYING(40) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "CGEVERIFIEERD" BOOLEAN,
   "CLEVERINGSADRES" CHARACTER VARYING(1024),
   "CLEVERINGSDATUMGEWENST" DATE,
   "CDATUMETD" DATE,
   "CMEDEWERKER" CHARACTER VARYING(10),
   "CMEDEWERKERS_FK" INTEGER,
   "CTRANSPORTEUR" CHARACTER VARYING(10),
   "CTRANSPORTEURS_FK" INTEGER,
   "CCONTACTADRESSEN_FK" INTEGER,
   "CLEVERINGSVOORWAARDE" CHARACTER VARYING(10),
   "CLEVERINGSVOORWAARDEN_FK" INTEGER,
   "CDOCUMENTBLOB" BLOB,
   "CDOCUMENTBLOBBYTES" INTEGER DEFAULT 0,
   "CNUMMERLEVERANCIER" CHARACTER VARYING(35)
);


CREATE TABLE "TAANKOOPLIJNEN"(
   "CAANKOOPLIJNEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CAANKOPEN_FK" INTEGER,
   "CLIJNNUMMER" INTEGER,
   "CAANKOOPPRIJS" NUMERIC(12,4),
   "CAANKOOPPRIJSFACTOR" FLOAT,
   "CAANTAL" FLOAT,
   "CAANTALVERWERKT" FLOAT,
   "CALGEMENEREKENING" CHARACTER VARYING(10),
   "CALGEMENEREKENINGEN_FK" INTEGER,
   "CANALYTISCHEREKENING" CHARACTER VARYING(10),
   "CANALYTISCHEREKENINGEN_FK" INTEGER,
   "CARTIKELLEVERANCIER" CHARACTER VARYING(25),
   "CARTIKELS_FK" INTEGER,
   "CBEDRAG" NUMERIC(10,2),
   "CBTWCODE" CHARACTER VARYING(10),
   "CBTWPERCENTAGE" NUMERIC(5,2),
   "CEENHEIDAANKOOP" CHARACTER VARYING(10),
   "CGEWICHT" NUMERIC(10,3),
   "CGNCODE" CHARACTER VARYING(8),
   "CGNCODES_FK" INTEGER,
   "CINCLBTW" BOOLEAN,
   "CINFO" CHARACTER VARYING(10000),
   "CINFOINTERN" CHARACTER VARYING(10000),
   "CKLEUR" CHARACTER VARYING(10),
   "CKLEURENKAARTEN_FK" INTEGER,
   "CLIJNFLOW_FK" INTEGER,
   "CLIJNKORTINGPERCENTAGE" NUMERIC(5,2),
   "CLIJNVORIGE_FK" INTEGER,
   "CMAAT" CHARACTER VARYING(10),
   "CMATENBALKEN_FK" INTEGER,
   "CMETLOTNUMMERS" BOOLEAN,
   "CMETSERIENUMMERS" BOOLEAN,
   "CMETVOORRAAD" BOOLEAN,
   "COMSCHRIJVING" CHARACTER VARYING(256),
   "CSTATUS" INTEGER,
   "CUPDARTIKELLEVERANCIERS" BOOLEAN,
   "CUPDLAATSTEAANKOOPPRIJS" BOOLEAN,
   "CVESTIGINGMAGAZIJN" CHARACTER VARYING(10),
   "CAANTALVOORRAAD" FLOAT,
   "CLOTDATUM" DATE,
   "CARTIKEL" CHARACTER VARYING(25),
   "CEENHEIDVOORRAAD" CHARACTER VARYING(10),
   "CLEVERINGSDATUM" DATE,
   "CNUMMERVORIGE" CHARACTER VARYING(20),
   "CAANTALVOORRAADVERWERKT" FLOAT,
   "CAANTALTEVERWERKEN" FLOAT,
   "CLIJNVORIGETYPE" INTEGER,
   "CLOTNUMMER" CHARACTER VARYING(20) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "CLEVERINGSDATUMGEWENST" DATE,
   "CDATUMETD" DATE,
   "CREFERENTIE" CHARACTER VARYING(30),
   "CGEENKORTINGEN" BOOLEAN DEFAULT FALSE,
   "CLIJNGEKOPPELD_FK" INTEGER
);


CREATE TABLE "TAGENDA"(
   "CAGENDA_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CAGENDALABEL" CHARACTER VARYING(15),
   "CAGENDALABELS_FK" INTEGER,
   "CDOCUMENT_FK" INTEGER,
   "CDOCUMENT2_FK" INTEGER,
   "CDOCUMENTTYPE" CHARACTER VARYING(15),
   "CDOCUMENTTYPES_FK" INTEGER,
   "CGEHELEDAG" BOOLEAN DEFAULT FALSE,
   "CHERHALING" BOOLEAN DEFAULT FALSE,
   "CMEDEWERKER" CHARACTER VARYING(10),
   "CMEDEWERKERS_FK" INTEGER,
   "CNUMMER" CHARACTER VARYING(10),
   "CONDERWERP" CHARACTER VARYING(128),
   "CPLANDATUMTOT" TIMESTAMP,
   "CPLANDATUMVAN" TIMESTAMP,
   "CPLANDUURTIJD" INTEGER,
   "CPRIVE" BOOLEAN DEFAULT FALSE,
   "CRUIMTE" CHARACTER VARYING(20),
   "CRUIMTEN_FK" INTEGER,
   "CLOCATIE" CHARACTER VARYING(50),
   "CCONTACTEN_FK" INTEGER,
   "CALARMTYPE" CHARACTER VARYING(10),
   "CALARMINTERVAL" INTEGER DEFAULT 0,
   "CLIJNFLOW_FK" INTEGER,
   "CCONTACTPERSONEN_FK" INTEGER,
   "CNAAMCONTACTPERSOON" CHARACTER VARYING(60),
   "CVERWIJDERD" BOOLEAN DEFAULT FALSE,
   "CSTATUS" INTEGER DEFAULT 0,
   "CCONTACTADRESSEN_FK" INTEGER,
   "COFFICE365ID" CHARACTER VARYING(192),
   "COFFICE365CHANGEKEY" CHARACTER VARYING(128),
   "COFFICE365MASTERID" CHARACTER VARYING(192),
   "CINFO" CLOB
);


CREATE TABLE "TVOORRAADWIJZIGINGEN"(
   "CVOORRAADWIJZIGINGEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CARTIKELS_FK" INTEGER,
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CINTERNEFIRMAVESTIGING" CHARACTER VARYING(10),
   "CINTERNEFIRMAVESTIGINGEN_FK" INTEGER,
   "CVESTIGINGMAGAZIJN" CHARACTER VARYING(10),
   "CDATUM" DATE,
   "CKLEUR" CHARACTER VARYING(10),
   "CMAAT" CHARACTER VARYING(10),
   "CVOORRAADVOOR" FLOAT,
   "CVOORRAADNA" FLOAT,
   "CVOORRAADWIJZIGING" FLOAT,
   "CLOTNUMMER" CHARACTER VARYING(20) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "CMAGAZIJNLOCATIE" CHARACTER VARYING(15),
   "CLOTDATUM" DATE,
   "CREDEN" CHARACTER VARYING(25),
   "COMSCHRIJVING" CHARACTER VARYING(128)
);


CREATE TABLE "TVOORRAADTRANSFERSERIENUMMERS"(
   "CVOORRAADTRANSFERSERIENUMMERS_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CVOORRAADTRANSFERS_FK" INTEGER,
   "CSERIENUMMER" CHARACTER VARYING(30) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE"
);


CREATE TABLE "TVOORRAADWIJZIGINGSERIENUMMERS"(
   "CVOORRAADWIJZIGINGSERIENUMMERS_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CVOORRAADWIJZIGINGEN_FK" INTEGER,
   "CSERIENUMMER" CHARACTER VARYING(30) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE"
);


CREATE TABLE "TVOORRAADTRANSFERS"(
   "CVOORRAADTRANSFERS_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CDATUM" DATE,
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CINTERNEFIRMAVESTIGING" CHARACTER VARYING(10),
   "CINTERNEFIRMAVESTIGINGEN_FK" INTEGER,
   "CINTERNEFIRMAVESTIGINGENNAAR_FK" INTEGER,
   "CINTERNEFIRMAVESTIGINGNAAR" CHARACTER VARYING(10),
   "CVESTIGINGMAGAZIJN" CHARACTER VARYING(10),
   "CVESTIGINGMAGAZIJNNAAR" CHARACTER VARYING(10),
   "CARTIKELS_FK" INTEGER,
   "CKLEUR" CHARACTER VARYING(10),
   "CMAAT" CHARACTER VARYING(10),
   "COMSCHRIJVING" CHARACTER VARYING(30),
   "CVOORRAADTRANSFER" FLOAT,
   "CLOTNUMMER" CHARACTER VARYING(20) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "CMAGAZIJNLOCATIE" CHARACTER VARYING(15),
   "CMAGAZIJNLOCATIENAAR" CHARACTER VARYING(15)
);


CREATE TABLE "TLICENTIE"(
   "CLICENTIE_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CREGISTRATIECODE" CHARACTER VARYING(128),
   "CREGISTRATIECONTROLECODE" CHARACTER VARYING(20),
   "CDATUMAANVRAAG" DATE
);


CREATE TABLE "TSESSIES"(
   "CSESSIES_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CMEDEWERKER" CHARACTER VARYING(10),
   "CMODULE" CHARACTER VARYING(10),
   "CTCPIPADRES" CHARACTER VARYING(15),
   "CTICKET_FK" INTEGER,
   "CVERSIE" CHARACTER VARYING(10),
   "COMNISSERIENUMMER" CHARACTER VARYING(32)
);


CREATE TABLE "TARTIKELLOCATIES"(
   "CARTIKELLOCATIES_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CARTIKELS_FK" INTEGER,
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CINTERNEFIRMAVESTIGING" CHARACTER VARYING(10),
   "CINTERNEFIRMAVESTIGINGEN_FK" INTEGER,
   "CVESTIGINGMAGAZIJN" CHARACTER VARYING(10),
   "CLOCATIE" CHARACTER VARYING(25)
);


CREATE TABLE "TPRODUCTIE"(
   "CPRODUCTIE_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CDOCUMENTTYPE" CHARACTER VARYING(20),
   "CDOCUMENTTYPES_FK" INTEGER,
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CINTERNEFIRMAVESTIGING" CHARACTER VARYING(10),
   "CINTERNEFIRMAVESTIGINGEN_FK" INTEGER,
   "CVESTIGINGMAGAZIJN" CHARACTER VARYING(10),
   "CNUMMER" INTEGER,
   "CPREFIX" CHARACTER VARYING(10),
   "CAANTAL" FLOAT,
   "CAANTALREEEL" FLOAT,
   "CAFGESLOTEN" BOOLEAN,
   "CAFGESLOTENDOOR" CHARACTER VARYING(10),
   "CARTIKELS_FK" INTEGER,
   "CCONTACTEN_FK" INTEGER,
   "CDATUM" DATE,
   "CDATUMINPRODUCTIE" TIMESTAMP,
   "CDATUMPRODUCTIE" TIMESTAMP,
   "CEENHEID" CHARACTER VARYING(10),
   "CGEPRODUCEERDDOOR" CHARACTER VARYING(10),
   "CGEPLAND" BOOLEAN,
   "CINFOINSTRUCTIE" CHARACTER VARYING(1024),
   "CINFOOPMERKING" CHARACTER VARYING(1024),
   "CKLEUR" CHARACTER VARYING(10),
   "CKLEURENKAARTEN_FK" INTEGER,
   "CLEVERINGSDATUM" DATE,
   "CLOTDATUM" DATE,
   "CMAAT" CHARACTER VARYING(10),
   "CMATENBALKEN_FK" INTEGER,
   "CMEDEWERKER" CHARACTER VARYING(10),
   "CMEDEWERKERS_FK" INTEGER,
   "CMETLOTNUMMERS" BOOLEAN,
   "CMETSERIENUMMERS" BOOLEAN,
   "CMETVOORRAAD" BOOLEAN,
   "CMONTEREN" INTEGER,
   "COMSCHRIJVING" CHARACTER VARYING(100),
   "CPLANNING_FK" INTEGER,
   "CSTATUS" INTEGER,
   "CUPDLAATSTEAANKOOPPRIJS" BOOLEAN,
   "CARTIKEL" CHARACTER VARYING(25),
   "CLOTNUMMER" CHARACTER VARYING(20) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "CAANTALORIGINEEL" FLOAT,
   "CVERSIE" INTEGER,
   "CUWREFERENTIE" CHARACTER VARYING(40) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE"
);


CREATE TABLE "TARTIKELVERPAKKINGEN"(
   "CARTIKELVERPAKKINGEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CARTIKELS_FK" INTEGER,
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CVERPAKKING" CHARACTER VARYING(10),
   "CAANTAL" FLOAT,
   "CBREEDTE" FLOAT,
   "CHOOGTE" FLOAT,
   "CEENHEID" CHARACTER VARYING(10),
   "CEENHEIDVOLUME1" CHARACTER VARYING(10),
   "CEENHEIDVOLUME2" CHARACTER VARYING(10),
   "CGEWICHT" NUMERIC(10,3),
   "CLENGTE" FLOAT,
   "CVOLUME1" FLOAT,
   "CVOLUME2" FLOAT,
   "CARTIKELBARCODE" CHARACTER VARYING(25)
);


CREATE TABLE "TCRMCOMMUNICATIES"(
   "CCRMCOMMUNICATIES_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CCATEGORIE" CHARACTER VARYING(15),
   "CCATEGORIEN_FK" INTEGER,
   "CCOMMUNICATIESOORT" CHARACTER VARYING(15),
   "CCONTACTEN_FK" INTEGER,
   "CCONTACTPERSONEN_FK" INTEGER,
   "CDATUM" TIMESTAMP,
   "CDATUMVERSTUURD" TIMESTAMP,
   "CFAX" CHARACTER VARYING(20),
   "CINFO" CLOB,
   "CNAAMCONTACTPERSOON" CHARACTER VARYING(60),
   "CONDERWERP" CHARACTER VARYING(128) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "CRICHTING" BOOLEAN,
   "CSUBCATEGORIE" CHARACTER VARYING(15),
   "CTELEFOON" CHARACTER VARYING(20),
   "CMAILVERSTUURDDOOR" CHARACTER VARYING(10),
   "CMAILVERSTUURDNAAR" CHARACTER VARYING(1024),
   "CMAILVERSTUURDNAARCC" CHARACTER VARYING(1024),
   "CMEDEWERKER" CHARACTER VARYING(10),
   "CMEDEWERKERS_FK" INTEGER,
   "CCOMMUNICATIESOORTNR" SMALLINT,
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CDOCUMENTBLOB" BLOB,
   "CDOCUMENTBLOBBYTES" INTEGER DEFAULT 0,
   "CFLOW_FK" INTEGER,
   "CONDERWERPINTERN" CHARACTER VARYING(128) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "CPRIVE" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TCRMCOMMUNICATIEBIJLAGEN"(
   "CCRMCOMMUNICATIEBIJLAGEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CCRMCOMMUNICATIES_FK" INTEGER,
   "CTYPE" CHARACTER VARYING(10),
   "CTYPENUMMER" INTEGER,
   "CDOCUMENT_FK" INTEGER,
   "CDOCUMENTBLOBBYTES" INTEGER,
   "CDOCUMENTBLOBNAAM" CHARACTER VARYING(512),
   "CDOCUMENTPAD" CHARACTER VARYING(512),
   "CDOCUMENTTYPE" CHARACTER VARYING(15),
   "CDOCUMENTTYPES_FK" INTEGER,
   "CONDERWERP" CHARACTER VARYING(128),
   "CDOCUMENTBLOB" BLOB,
   "CINFO" CLOB,
   "CNUMMER" CHARACTER VARYING(10)
);


CREATE TABLE "TCRMTAKEN"(
   "CCRMTAKEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CCATEGORIE" CHARACTER VARYING(15),
   "CCATEGORIEN_FK" INTEGER,
   "CCONTACTEN_FK" INTEGER,
   "CCONTACTPERSONEN_FK" INTEGER,
   "CDEADLINE" TIMESTAMP,
   "CGEPLAND" BOOLEAN,
   "CINFO" CLOB,
   "CMEDEWERKERVAN" CHARACTER VARYING(10),
   "CMEDEWERKERSVAN_FK" INTEGER,
   "CMETOPVOLGING" BOOLEAN,
   "CNAAMCONTACTPERSOON" CHARACTER VARYING(60),
   "CPLANNING_FK" INTEGER,
   "CPRIORITEIT" INTEGER,
   "CSTARTDATUM" DATE,
   "CSTATUS" INTEGER,
   "CSTATUSDATUM" TIMESTAMP,
   "CSUBCATEGORIE" CHARACTER VARYING(15),
   "CTELEFOON" CHARACTER VARYING(20),
   "CMEDEWERKERVOOR" CHARACTER VARYING(10),
   "CMEDEWERKERSVOOR_FK" INTEGER,
   "CTAAK" CHARACTER VARYING(128) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "CFLOW_FK" INTEGER,
   "CAFGESLOTEN" BOOLEAN DEFAULT FALSE,
   "CAFGESLOTENDOOR" CHARACTER VARYING(10),
   "CDATUMAFGESLOTEN" TIMESTAMP,
   "CDATUMTAAK" TIMESTAMP,
   "CMEDEWERKERVOORCC" CHARACTER VARYING(1024),
   "CGESCHATDUURTIJD" INTEGER DEFAULT 0,
   "CONDERWERPINTERN" CHARACTER VARYING(128) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "CISOPDRACHT" BOOLEAN DEFAULT FALSE,
   "CMETVASTEPRIJS" BOOLEAN DEFAULT FALSE,
   "CNUMMER" INTEGER,
   "CGESCHATBEDRAG" NUMERIC(12,2) DEFAULT 0,
   "CFACTDUURTIJD" INTEGER DEFAULT 0,
   "CBEDRAGGEFACTUREERD" NUMERIC(12,2) DEFAULT 0,
   "CGEFACTUREERD" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TCRMTAAKBIJLAGEN"(
   "CCRMTAAKBIJLAGEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CCRMTAKEN_FK" INTEGER,
   "CTYPE" CHARACTER VARYING(10),
   "CTYPENUMMER" INTEGER,
   "CDOCUMENT_FK" INTEGER,
   "CDOCUMENTBLOBBYTES" INTEGER,
   "CDOCUMENTBLOBNAAM" CHARACTER VARYING(512),
   "CDOCUMENTPAD" CHARACTER VARYING(512),
   "CDOCUMENTTYPE" CHARACTER VARYING(15),
   "CDOCUMENTTYPES_FK" INTEGER,
   "CONDERWERP" CHARACTER VARYING(50),
   "CDOCUMENTBLOB" BLOB,
   "CINFO" CLOB,
   "CNUMMER" CHARACTER VARYING(10)
);


CREATE TABLE "TPRODUCTIELIJNEN"(
   "CPRODUCTIELIJNEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CPRODUCTIE_FK" INTEGER,
   "CAANTAL" FLOAT,
   "CAANTALREEEL" FLOAT,
   "CAANTALVOORRAAD" FLOAT,
   "CARTIKELS_FK" INTEGER,
   "CEENHEID" CHARACTER VARYING(10),
   "CINFO" CHARACTER VARYING(10000),
   "CKLEUR" CHARACTER VARYING(10),
   "CKLEURENKAARTEN_FK" INTEGER,
   "CLEVERINGSDATUM" DATE,
   "CMAAT" CHARACTER VARYING(10),
   "CMATENBALKEN_FK" INTEGER,
   "CMETLOTNUMMERS" BOOLEAN,
   "CMETSERIENUMMERS" BOOLEAN,
   "CMETVOORRAAD" BOOLEAN,
   "COMSCHRIJVING" CHARACTER VARYING(100),
   "CVESTIGINGMAGAZIJN" CHARACTER VARYING(10),
   "CLIJNNUMMER" INTEGER,
   "CARTIKEL" CHARACTER VARYING(25),
   "CLOTNUMMER" CHARACTER VARYING(20) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE"
);


CREATE TABLE "TAGENDAEXTRA"(
   "CAGENDAEXTRA_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CAGENDA_FK" INTEGER,
   "CTYPENR" INTEGER,
   "CMEDEWERKER" CHARACTER VARYING(10),
   "CMEDEWERKERS_FK" INTEGER,
   "CMATERIAAL" CHARACTER VARYING(50),
   "CMATERIALEN_FK" INTEGER,
   "CVERWIJDERD" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TAGENDAPREFS"(
   "CAGENDAPREFS_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CMEDEWERKER" CHARACTER VARYING(10),
   "CMEDEWERKERS_FK" INTEGER,
   "CAGENDAPREF" CHARACTER VARYING(20),
   "CWAARDE" CHARACTER VARYING(20)
);


CREATE TABLE "TKASSAAFSL"(
   "CKASSAAFSL_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CINTERNEFIRMAVESTIGING" CHARACTER VARYING(10),
   "CINTERNEFIRMAVESTIGINGEN_FK" INTEGER,
   "CAFGESLOTEN" BOOLEAN,
   "CBEDRAGBETAALWIJZEN" NUMERIC(10,2),
   "CBEDRAGCASH" NUMERIC(10,2),
   "CBEDRAGOMZETTEN" NUMERIC(10,2),
   "CBEGINKAS" NUMERIC(10,2),
   "CDATUM" DATE,
   "CEINDKAS" NUMERIC(10,2),
   "CKASSANUMMER" INTEGER,
   "CVERSCHIL" NUMERIC(10,2),
   "CTRANSFER" NUMERIC(10,2),
   "CINFO" CHARACTER VARYING(10000),
   "CAFRONDINGSVERSCHIL" NUMERIC(10,2) DEFAULT 0
);


CREATE TABLE "TKASSAAFSLBETAALWIJZEN"(
   "CKASSAAFSLBETAALWIJZEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CKASSAAFSL_FK" INTEGER,
   "CBEDRAG" NUMERIC(10,2),
   "CBETAALWIJZE" CHARACTER VARYING(15),
   "CCASH" BOOLEAN,
   "CALGEMENEREKENING" CHARACTER VARYING(10),
   "CALGEMENEREKENINGEN_FK" INTEGER
);


CREATE TABLE "TKASSAAFSLOMZETTEN"(
   "CKASSAAFSLOMZETTEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CKASSAAFSL_FK" INTEGER,
   "CALGEMENEREKENING" CHARACTER VARYING(10),
   "CALGEMENEREKENINGEN_FK" INTEGER,
   "CBEDRAGEXCL" NUMERIC(10,2),
   "CBEDRAGINCL" NUMERIC(10,2),
   "CBTWCODE" CHARACTER VARYING(10),
   "CBTWPERCENTAGE" NUMERIC(5,2)
);


CREATE TABLE "TBETAALWIJZEN"(
   "CBETAALWIJZEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CALGEMENEREKENING" CHARACTER VARYING(10),
   "CALGEMENEREKENINGEN_FK" INTEGER,
   "CBETAALWIJZE" CHARACTER VARYING(10),
   "COMSCHRIJVING" CHARACTER VARYING(30),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CLOGO" BLOB,
   "CKAARTPERCENTAGE" NUMERIC(5,2) DEFAULT 0,
   "CISKASSA" BOOLEAN DEFAULT TRUE,
   "CLIJNNUMMER" INTEGER DEFAULT 0,
   "CBETAALWIJZETERMINAL" BOOLEAN
);


CREATE TABLE "TCONTACTSALDI"(
   "CCONTACTSALDI_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CCONTACTEN_FK" INTEGER,
   "CCONTACTROL" CHARACTER VARYING(10),
   "CSALDO" NUMERIC(12,2),
   "CKREDIETLIJN" NUMERIC(12,2),
   "CGEMAANTALDAGEN" INTEGER
);


CREATE TABLE "TBTWVAKKEN"(
   "CBTWVAKKEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CALGEMENEREKENING" CHARACTER VARYING(10),
   "CALGEMENEREKENINGEN_FK" INTEGER,
   "CBTWVAK" CHARACTER VARYING(10),
   "CLANDBTW" CHARACTER VARYING(2),
   "COMSCHRIJVING" CHARACTER VARYING(50)
);


CREATE TABLE "TBTWCODESPERVAK"(
   "CBTWCODESPERVAK_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CBTWVAK" CHARACTER VARYING(10),
   "CLANDBTW" CHARACTER VARYING(2),
   "CBTWCODE" CHARACTER VARYING(10),
   "CBTWCODES_FK" INTEGER,
   "CAANKOOP" BOOLEAN,
   "CAANKOOPBTW" BOOLEAN,
   "CAANKOOPCN" BOOLEAN,
   "CAANKOOPCNBTW" BOOLEAN,
   "CALGEMENEREKENING" CHARACTER VARYING(30),
   "CFINAANKOOP" BOOLEAN,
   "CFINAANKOOPBTW" BOOLEAN,
   "CFINVERKOOP" BOOLEAN,
   "CFINVERKOOPBTW" BOOLEAN,
   "CVERKOOP" BOOLEAN,
   "CVERKOOPBTW" BOOLEAN,
   "CVERKOOPCN" BOOLEAN,
   "CVERKOOPCNBTW" BOOLEAN
);


CREATE TABLE "TBOEKJAREN"(
   "CBOEKJAREN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CBOEKJAAR" CHARACTER VARYING(4),
   "CNOEMERPRORATA" INTEGER,
   "CSTATUS" INTEGER
);


CREATE TABLE "TKALENDERJAREN"(
   "CKALENDERJAREN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CKALENDERJAAR" CHARACTER VARYING(4),
   "CSOORT" INTEGER
);


CREATE TABLE "TBTWPERIODEN"(
   "CBTWPERIODEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CBTWPERIODE" CHARACTER VARYING(6),
   "CKALENDERJAAR" CHARACTER VARYING(4),
   "CKALENDERJAREN_FK" INTEGER,
   "CSOORT" INTEGER,
   "CSTATUS" INTEGER
);


CREATE TABLE "TBOEKPERIODEN"(
   "CBOEKPERIODEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CBOEKJAAR" CHARACTER VARYING(4),
   "CBOEKJAREN_FK" INTEGER,
   "CBOEKPERIODE" CHARACTER VARYING(6),
   "CBTWPERIODE" CHARACTER VARYING(6),
   "CBTWPERIODEN_FK" INTEGER,
   "CDATUMTOT" DATE,
   "CDATUMVAN" DATE,
   "CSTATUS" INTEGER
);


CREATE TABLE "TINTRASTATAANGEVER"(
   "CINTRASTATAANGEVER_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CAANGIFTEAANKOMST" BOOLEAN,
   "CAANGIFTEVERZENDING" BOOLEAN,
   "CADRES" CHARACTER VARYING(21),
   "CBTWNUMMER" CHARACTER VARYING(25),
   "CCONTACTPERSOON" CHARACTER VARYING(21),
   "CDAANGEVER" CHARACTER VARYING(21),
   "CDADRES" CHARACTER VARYING(21),
   "CDBTWNUMMER" CHARACTER VARYING(25),
   "CDCONTACTPERSOON" CHARACTER VARYING(21),
   "CDFAX" CHARACTER VARYING(21),
   "CDGEMEENTE" CHARACTER VARYING(21),
   "CDLAND" CHARACTER VARYING(4),
   "CDPOSTCODE" CHARACTER VARYING(4),
   "CDTELEFOON" CHARACTER VARYING(21),
   "CEMAILADRES" CHARACTER VARYING(128),
   "CFAX" CHARACTER VARYING(21),
   "CGEMEENTE" CHARACTER VARYING(21),
   "CPOSTCODE" CHARACTER VARYING(4),
   "CREGIOBESTEMMING" CHARACTER VARYING(1),
   "CREGIOOORSPRONG" CHARACTER VARYING(1),
   "CTELEFOON" CHARACTER VARYING(21),
   "CVOLGNUMMER" INTEGER,
   "CAANGEVER" CHARACTER VARYING(40)
);


CREATE TABLE "TDAGBOEKEN"(
   "CDAGBOEKEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CDAGBOEK" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CALGEMENEREKENING" CHARACTER VARYING(10),
   "CALGEMENEREKENINGEN_FK" INTEGER,
   "CAUTONUMMER" BOOLEAN,
   "CBANKCODE" CHARACTER VARYING(10),
   "CBUITENLANDS" BOOLEAN,
   "CDAGBOEKSOORT" INTEGER,
   "CMUNT" CHARACTER VARYING(3),
   "CMUNTEN_FK" INTEGER,
   "COMSCHRIJVING1" CHARACTER VARYING(30),
   "COMSCHRIJVING2" CHARACTER VARYING(30),
   "COMSCHRIJVING3" CHARACTER VARYING(30),
   "COMSCHRIJVING4" CHARACTER VARYING(30),
   "CSALDO" NUMERIC(12,2),
   "CNIETACTIEF" BOOLEAN DEFAULT FALSE,
   "CBANKREKENINGNUMMER" CHARACTER VARYING(42),
   "CBANKBIC" CHARACTER VARYING(11)
);


CREATE TABLE "TDAGBOEKVOLGNR"(
   "CDAGBOEKVOLGNR_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CBOEKJAAR" CHARACTER VARYING(4),
   "CBOEKJAREN_FK" INTEGER,
   "CDAGBOEK" CHARACTER VARYING(10),
   "CDAGBOEKEN_FK" INTEGER,
   "CVOLGNR" INTEGER,
   "CPREFIX" BOOLEAN
);


CREATE TABLE "TTEKSTENRAPPEL"(
   "CTEKSTENRAPPEL_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CINTRO1" CHARACTER VARYING(10000),
   "CINTRO2" CHARACTER VARYING(10000),
   "CINTRO3" CHARACTER VARYING(10000),
   "CINTRO4" CHARACTER VARYING(10000),
   "CSLOT1" CHARACTER VARYING(10000),
   "CSLOT2" CHARACTER VARYING(10000),
   "CSLOT3" CHARACTER VARYING(10000),
   "CSLOT4" CHARACTER VARYING(10000),
   "CTEKSTRAPPEL" INTEGER,
   "CONDERWERP1" CHARACTER VARYING(128),
   "CINFO1" CHARACTER VARYING(10000),
   "CONDERWERP2" CHARACTER VARYING(128),
   "CINFO2" CHARACTER VARYING(10000),
   "CONDERWERP3" CHARACTER VARYING(128),
   "CINFO3" CHARACTER VARYING(10000),
   "CONDERWERP4" CHARACTER VARYING(128),
   "CINFO4" CHARACTER VARYING(10000)
);


CREATE TABLE "TANALSLEUTELS"(
   "CANALSLEUTELS_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CALGEMENEREKENING" CHARACTER VARYING(10),
   "CALGEMENEREKENINGEN_FK" INTEGER,
   "CANALYTISCHEREKENINGEN_FK" INTEGER,
   "CPERCENTAGE" NUMERIC(10,3),
   "CANALYTISCHEREKENING" CHARACTER VARYING(25)
);


CREATE TABLE "TBOEKINGEN"(
   "CBOEKINGEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CDAGBOEK" CHARACTER VARYING(10),
   "CDAGBOEKEN_FK" INTEGER,
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CBEDRAGBTWREF" NUMERIC(12,2),
   "CBEDRAGEXCLREF" NUMERIC(12,2),
   "CBEDRAGINCL" NUMERIC(12,2),
   "CBEDRAGINCLREF" NUMERIC(12,2),
   "CBEGINSALDO" NUMERIC(12,2),
   "CBETALINGSVOORWAARDE" CHARACTER VARYING(10),
   "CBETALINGSVOORWAARDEN_FK" INTEGER,
   "CBOEKJAAR" CHARACTER VARYING(4),
   "CBOEKJAREN_FK" INTEGER,
   "CBOEKPERIODE" CHARACTER VARYING(6),
   "CBOEKPERIODEN_FK" INTEGER,
   "CCONTACT" CHARACTER VARYING(10),
   "CCONTACTEN_FK" INTEGER,
   "CDAGBOEKSOORT" INTEGER,
   "CDATUM" DATE,
   "CFINKORTING" NUMERIC(10,2),
   "CFINKORTINGPERCENTAGE" NUMERIC(5,2),
   "CFOUTBTWTOEGELATEN" BOOLEAN,
   "CKOERS" NUMERIC(12,6),
   "CMUNT" CHARACTER VARYING(3),
   "CMUNTEN_FK" INTEGER,
   "CNAAM1" CHARACTER VARYING(50),
   "CREEDSOVERGEBOEKT" BOOLEAN,
   "CVOLGNR" INTEGER,
   "CFACTNRLEV" CHARACTER VARYING(40),
   "CINFO" CHARACTER VARYING(10000)
);


CREATE TABLE "TBOEKINGHISTORIEK"(
   "CBOEKINGHISTORIEK_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CBOEKINGEN_FK" INTEGER,
   "CTYPE" INTEGER,
   "CSOORT" CHARACTER VARYING(1),
   "CAANTAL" FLOAT,
   "CAFGEPUNT" BOOLEAN,
   "CAFGEPUNTVOLGNR" INTEGER,
   "CALGEMENEREKENING" CHARACTER VARYING(10),
   "CALGEMENEREKENINGEN_FK" INTEGER,
   "CANALYTISCHEREKENING" CHARACTER VARYING(10),
   "CANALYTISCHEREKENINGEN_FK" INTEGER,
   "CBEDRAGBTWREF" NUMERIC(12,2),
   "CBEDRAGCREDIT" NUMERIC(12,2),
   "CBEDRAGCREDITREF" NUMERIC(12,2),
   "CBEDRAGDEBET" NUMERIC(12,2),
   "CBEDRAGDEBETREF" NUMERIC(12,2),
   "CBEDRAGNIETAFTR" NUMERIC(12,2),
   "CBTWCODE" CHARACTER VARYING(10),
   "CBTWPERCENTAGE" NUMERIC(5,2),
   "CCONTACT" CHARACTER VARYING(10),
   "CCONTACTEN_FK" INTEGER,
   "CDAGBOEK" CHARACTER VARYING(10),
   "CDATUM" DATE,
   "CDOMICILIERING" INTEGER,
   "CDOMICILIERINGBANK" CHARACTER VARYING(10),
   "CDOMICILIERINGDATUM" DATE,
   "CKOERS" NUMERIC(12,6),
   "CMUNT" CHARACTER VARYING(3),
   "CMUNTEN_FK" INTEGER,
   "CMVH" NUMERIC(12,2),
   "CNAAM1" CHARACTER VARYING(50),
   "COMSCHRIJVING" CHARACTER VARYING(100),
   "CPERCENTAGENIETAFTR" NUMERIC(5,2),
   "CREEDSBETAALD" BOOLEAN,
   "CTEKSTRAPPEL" INTEGER,
   "CVERVALDATUM" DATE,
   "CVOLGNR" INTEGER,
   "CFINKORTING" NUMERIC(10,2) DEFAULT 0,
   "CFACTNRLEV" CHARACTER VARYING(40),
   "CBANKREKENINGNUMMER" CHARACTER VARYING(42),
   "CBANKBIC" CHARACTER VARYING(11),
   "CDOMMANDATEN_FK" INTEGER
);


CREATE TABLE "TBOEKINGBTW"(
   "CBOEKINGBTW_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CBOEKINGEN_FK" INTEGER,
   "CBEDRAG" NUMERIC(12,2),
   "CBTWVAK" CHARACTER VARYING(10)
);


CREATE TABLE "TBOEKINGINTRASTAT"(
   "CBOEKINGINTRASTAT_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CBOEKINGEN_FK" INTEGER,
   "CSOORT" CHARACTER VARYING(2),
   "CAANTAL" NUMERIC(10,0),
   "CBEDRAG" NUMERIC(10,0),
   "CGEWICHT" NUMERIC(10,0),
   "CGNCODE" CHARACTER VARYING(8),
   "CGNCODES_FK" INTEGER,
   "CINTRASTATGEWEST" CHARACTER VARYING(10),
   "CINTRASTATTRANSACTIE" CHARACTER VARYING(10),
   "CLAND" CHARACTER VARYING(2),
   "CEXCNTORI" CHARACTER VARYING(2),
   "CPARTNERID" CHARACTER VARYING(25)
);


CREATE TABLE "TCENTRALISATIE"(
   "CCENTRALISATIE_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CDAGBOEK" CHARACTER VARYING(10),
   "CDAGBOEKEN_FK" INTEGER,
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CAANTAL" FLOAT,
   "CALGEMENEREKENING" CHARACTER VARYING(10),
   "CALGEMENEREKENINGEN_FK" INTEGER,
   "CBEDRAGCREDITREF" NUMERIC(12,2),
   "CBEDRAGDEBETREF" NUMERIC(12,2),
   "CBOEKJAAR" CHARACTER VARYING(4),
   "CBOEKJAREN_FK" INTEGER,
   "CBOEKPERIODE" CHARACTER VARYING(6),
   "CBOEKPERIODEN_FK" INTEGER
);


CREATE TABLE "TANALCENTRALISATIE"(
   "CANALCENTRALISATIE_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CDAGBOEK" CHARACTER VARYING(10),
   "CDAGBOEKEN_FK" INTEGER,
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CAANTAL" FLOAT,
   "CALGEMENEREKENING" CHARACTER VARYING(10),
   "CALGEMENEREKENINGEN_FK" INTEGER,
   "CANALYTISCHEREKENINGEN_FK" INTEGER,
   "CBEDRAGCREDITREF" NUMERIC(12,2),
   "CBEDRAGDEBETREF" NUMERIC(12,2),
   "CBOEKJAAR" CHARACTER VARYING(4),
   "CBOEKJAREN_FK" INTEGER,
   "CBOEKPERIODE" CHARACTER VARYING(6),
   "CBOEKPERIODEN_FK" INTEGER,
   "CANALYTISCHEREKENING" CHARACTER VARYING(25)
);


CREATE TABLE "TCENTRALISATIEOMZETTEN"(
   "CCENTRALISATIEOMZETTEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CTYPE" INTEGER,
   "CBEDRAG" NUMERIC(12,2),
   "CBEDRAGBTWREF" NUMERIC(12,2),
   "CBEDRAGCREDITREF" NUMERIC(12,2),
   "CBEDRAGDEBETREF" NUMERIC(12,2),
   "CBOEKJAAR" CHARACTER VARYING(4),
   "CBOEKJAREN_FK" INTEGER,
   "CBOEKPERIODE" CHARACTER VARYING(6),
   "CBOEKPERIODEN_FK" INTEGER,
   "CCONTACTEN_FK" INTEGER
);


CREATE TABLE "TAFSCHRIJVINGEN"(
   "CAFSCHRIJVINGEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CBOEKINGEN_FK" INTEGER,
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CAFSCHRIJVING" NUMERIC(10,2),
   "CAFSCHRIJVINGDEGRESSIEF" BOOLEAN,
   "CAFSCHRIJVINGSOORT" BOOLEAN,
   "CALGEMENEREKENINGAFSCHR" CHARACTER VARYING(10),
   "CALGEMENEREKENINGENAFSCHR_FK" INTEGER,
   "CALGEMENEREKENINGENINVEST_FK" INTEGER,
   "CALGEMENEREKENINGENKOST_FK" INTEGER,
   "CALGEMENEREKENINGINVEST" CHARACTER VARYING(10),
   "CALGEMENEREKENINGKOST" CHARACTER VARYING(10),
   "CBEDRAGAANKOOPREF" NUMERIC(10,2),
   "CBEDRAGAFGESCHREVEN" NUMERIC(10,2),
   "CBEDRAGAFTESCHRIJVEN" NUMERIC(10,2),
   "CBEDRAGBOEKWAARDE" NUMERIC(10,2),
   "CVERKOOPPRIJS" NUMERIC(10,2),
   "CBOEKJAAR" CHARACTER VARYING(4),
   "CBOEKJAARAANSCHAF" CHARACTER VARYING(4),
   "CBOEKJAREN_FK" INTEGER,
   "CNOEMERPRORATA" INTEGER,
   "COMSCHRIJVING" CHARACTER VARYING(100),
   "CTELLERPRORATA" INTEGER,
   "CVERWIJDERD" BOOLEAN,
   "CVERWIJDERDINFO" CHARACTER VARYING(50),
   "CVOLGNR" INTEGER,
   "CINFO" CHARACTER VARYING(1024)
);


CREATE TABLE "TFICHE28150"(
   "CFICHE28150_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CBOEKINGEN_FK" INTEGER,
   "CAARDVOORDEEL" CHARACTER VARYING(30),
   "CBEDRAGA" NUMERIC(10,2),
   "CBEDRAGB" NUMERIC(10,2),
   "CBEDRAGBETAALD" NUMERIC(10,2),
   "CBEDRAGC" NUMERIC(10,2),
   "CBEDRAGD" NUMERIC(10,2),
   "CCONTACT" CHARACTER VARYING(10),
   "CCONTACTEN_FK" INTEGER,
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CKALENDERJAAR" CHARACTER VARYING(4),
   "CKALENDERJAREN_FK" INTEGER,
   "CVOLGNR" INTEGER
);


CREATE TABLE "TBUDGETTEN"(
   "CBUDGETTEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CALGEMENEREKENING" CHARACTER VARYING(10),
   "CALGEMENEREKENINGEN_FK" INTEGER,
   "CBEDRAGCREDITREF" NUMERIC(12,2),
   "CBEDRAGDEBETREF" NUMERIC(12,2),
   "CBOEKJAAR" CHARACTER VARYING(4),
   "CBOEKJAREN_FK" INTEGER,
   "CBOEKPERIODE" CHARACTER VARYING(6),
   "CBOEKPERIODEN_FK" INTEGER
);


CREATE TABLE "TANALBUDGETTEN"(
   "CANALBUDGETTEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CALGEMENEREKENING" CHARACTER VARYING(10),
   "CALGEMENEREKENINGEN_FK" INTEGER,
   "CANALYTISCHEREKENINGEN_FK" INTEGER,
   "CBEDRAGCREDITREF" NUMERIC(12,2),
   "CBEDRAGDEBETREF" NUMERIC(12,2),
   "CBOEKJAAR" CHARACTER VARYING(4),
   "CBOEKJAREN_FK" INTEGER,
   "CBOEKPERIODE" CHARACTER VARYING(6),
   "CBOEKPERIODEN_FK" INTEGER,
   "CANALYTISCHEREKENING" CHARACTER VARYING(25)
);


CREATE TABLE "TBTWAANGIFTENBE"(
   "CBTWAANGIFTENBE_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CAANVRAAGBETAALFORM" BOOLEAN,
   "CAANVRAAGTERUGBETALING" BOOLEAN,
   "CBTWPERIODE" CHARACTER VARYING(6),
   "CBTWPERIODEN_FK" INTEGER,
   "CDATUM" DATE,
   "CDEC" CHARACTER VARYING(11),
   "CFUNCTIE" CHARACTER VARYING(30),
   "CJAN" NUMERIC(10,2),
   "CKALENDERJAAR" CHARACTER VARYING(4),
   "CKALENDERJAREN_FK" INTEGER,
   "CKWARTAAL" INTEGER,
   "CMAAND" CHARACTER VARYING(2),
   "CNAAM" CHARACTER VARYING(30),
   "CSALDOTEBETALEN" NUMERIC(10,2),
   "CSALDOVERSCHULDIGD" NUMERIC(10,2),
   "CSOORT" INTEGER,
   "CTELEFOON" CHARACTER VARYING(20),
   "CVAK00" NUMERIC(10,2),
   "CVAK01" NUMERIC(10,2),
   "CVAK02" NUMERIC(10,2),
   "CVAK03" NUMERIC(10,2),
   "CVAK45" NUMERIC(10,2),
   "CVAK46" NUMERIC(10,2),
   "CVAK47" NUMERIC(10,2),
   "CVAK48" NUMERIC(10,2),
   "CVAK49" NUMERIC(10,2),
   "CVAK54" NUMERIC(10,2),
   "CVAK55" NUMERIC(10,2),
   "CVAK56" NUMERIC(10,2),
   "CVAK57" NUMERIC(10,2),
   "CVAK59" NUMERIC(10,2),
   "CVAK61" NUMERIC(10,2),
   "CVAK62" NUMERIC(10,2),
   "CVAK63" NUMERIC(10,2),
   "CVAK64" NUMERIC(10,2),
   "CVAK65" NUMERIC(10,2),
   "CVAK66" NUMERIC(10,2),
   "CVAK71" NUMERIC(10,2),
   "CVAK72" NUMERIC(10,2),
   "CVAK81" NUMERIC(10,2),
   "CVAK82" NUMERIC(10,2),
   "CVAK83" NUMERIC(10,2),
   "CVAK84" NUMERIC(10,2),
   "CVAK85" NUMERIC(10,2),
   "CVAK86" NUMERIC(10,2),
   "CVAK87" NUMERIC(10,2),
   "CVOORSCHOT" NUMERIC(10,2),
   "CVAK44" NUMERIC(10,2) DEFAULT 0,
   "CVAK88" NUMERIC(10,2) DEFAULT 0,
   "CNIHILLISTING" BOOLEAN DEFAULT FALSE,
   "CVAK48BIS" NUMERIC(10,2) DEFAULT 0,
   "CEMAILADRES" CHARACTER VARYING(128)
);


CREATE TABLE "TSTRUCTUREN"(
   "CSTRUCTUREN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CSTRUCTUUR" CHARACTER VARYING(10),
   "CTAAL" CHARACTER VARYING(1),
   "COMSCHRIJVING" CHARACTER VARYING(50),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER
);


CREATE TABLE "TSTRUCTUURDETAILS"(
   "CSTRUCTUURDETAILS_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CSTRUCTUREN_FK" INTEGER,
   "CTITEL1" CHARACTER VARYING(100),
   "CTITEL2" CHARACTER VARYING(100),
   "CTITEL3" CHARACTER VARYING(100),
   "CTITEL4" CHARACTER VARYING(100),
   "CTITEL5" CHARACTER VARYING(100),
   "CTITEL6" CHARACTER VARYING(100),
   "CTITEL7" CHARACTER VARYING(100),
   "CTITEL8" CHARACTER VARYING(100),
   "CSOORT" CHARACTER VARYING(1),
   "CBEGINT_MET" CHARACTER VARYING(1000),
   "CSHOWEXPAND" INTEGER
);


CREATE TABLE "TSERVICE"(
   "CSERVICE_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CDOCUMENTTYPE" CHARACTER VARYING(20),
   "CDOCUMENTTYPES_FK" INTEGER,
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CINTERNEFIRMAVESTIGING" CHARACTER VARYING(10),
   "CINTERNEFIRMAVESTIGINGEN_FK" INTEGER,
   "CNUMMER" INTEGER,
   "CPREFIX" CHARACTER VARYING(10),
   "CVERSIE" INTEGER,
   "CAFGESLOTEN" BOOLEAN,
   "CAFGESLOTENDOOR" CHARACTER VARYING(10),
   "CARTIKEL" CHARACTER VARYING(25),
   "CARTIKELS_FK" INTEGER,
   "CBEDRAGBESTEK" NUMERIC(10,2),
   "CBEDRAGBTW" NUMERIC(10,2),
   "CBEDRAGEXCL" NUMERIC(10,2),
   "CBEDRAGINCL" NUMERIC(10,2),
   "CBETALINGSVOORWAARDE" CHARACTER VARYING(10),
   "CBETALINGSVOORWAARDEN_FK" INTEGER,
   "CBTWREGIME" SMALLINT,
   "CCOMMUNICATIESOORT" CHARACTER VARYING(15),
   "CCOMMUNICATIESOORTNR" INTEGER,
   "CCONTACTEN_FK" INTEGER,
   "CCONTACTPERSONEN_FK" INTEGER,
   "CDATUM" DATE,
   "CDATUMAFGESLOTEN" TIMESTAMP,
   "CDATUMGOEDGEKEURD" TIMESTAMP,
   "CDATUMVERSTUURD" TIMESTAMP,
   "CDOCUMENTGROEP" CHARACTER VARYING(10),
   "CFACTURATIEADRES" CHARACTER VARYING(1024),
   "CFINKORTING" NUMERIC(10,2),
   "CFINKORTINGPERCENTAGE" NUMERIC(5,2),
   "CGEPLAND" BOOLEAN,
   "CGEPRINT" BOOLEAN,
   "CGOEDGEKEURDDOOR" CHARACTER VARYING(10),
   "CINCLBTW" BOOLEAN,
   "CINFOARTIKEL" CHARACTER VARYING(1024),
   "CINFOHERSTELLING" CHARACTER VARYING(1024),
   "CINFOINTERN" CHARACTER VARYING(10000),
   "CINFOINTRO" CHARACTER VARYING(1024),
   "CINFOPROBLEEM" CHARACTER VARYING(1024),
   "CINFOSLOT" CHARACTER VARYING(1024),
   "CINHERSTELLINGLEVERANCIER" BOOLEAN,
   "CINTRASTATTRANSACTIE" CHARACTER VARYING(10),
   "CKLEUR" CHARACTER VARYING(10),
   "CKLEURENKAARTEN_FK" INTEGER,
   "CKOERS" NUMERIC(12,6),
   "CKORTING" NUMERIC(10,2),
   "CKORTINGGROEP" CHARACTER VARYING(10),
   "CKORTINGPERCENTAGE" NUMERIC(5,2),
   "CKREDIETBEPERKING" NUMERIC(10,2),
   "CKREDIETBEPERKINGPERC" NUMERIC(5,2),
   "CLEVERANCIERREFERENTIE" CHARACTER VARYING(20),
   "CLEVERANCIERS_FK" INTEGER,
   "CLEVERINGSADRES" CHARACTER VARYING(1024),
   "CLEVERINGSVOORWAARDE" CHARACTER VARYING(10),
   "CLEVERINGSVOORWAARDEN_FK" INTEGER,
   "CMAAT" CHARACTER VARYING(10),
   "CMATENBALKEN_FK" INTEGER,
   "CMEDEWERKER" CHARACTER VARYING(10),
   "CMEDEWERKERS_FK" INTEGER,
   "CMETCONTRACT" BOOLEAN,
   "CMETGARANTIE" BOOLEAN,
   "CMETLOTNUMMERS" BOOLEAN,
   "CMETSERIENUMMERS" BOOLEAN,
   "CMETVERVANGARTIKEL" BOOLEAN,
   "CMETVOORRAAD" BOOLEAN,
   "CMUNT" CHARACTER VARYING(3),
   "CMUNTEN_FK" INTEGER,
   "COMSCHRIJVING" CHARACTER VARYING(256),
   "CONZEREFERENTIE" CHARACTER VARYING(20),
   "CPLANNING_FK" INTEGER,
   "CPRIORITEIT" INTEGER,
   "CSTATUS" INTEGER,
   "CSTATUSPERCENTAGE" INTEGER,
   "CSTATUSSERVICE" CHARACTER VARYING(30),
   "CTAAL" CHARACTER VARYING(1),
   "CTARIEF" CHARACTER VARYING(10),
   "CTARIEVEN_FK" INTEGER,
   "CTERATTENTIEVAN" CHARACTER VARYING(60),
   "CTERPLAATSE" BOOLEAN,
   "CTRANSPORTEUR" CHARACTER VARYING(10),
   "CTRANSPORTEURS_FK" INTEGER,
   "CVERSTUURDDOOR" CHARACTER VARYING(10),
   "CVERTEGENWOORDIGER" CHARACTER VARYING(10),
   "CVERTEGENWOORDIGERS_FK" INTEGER,
   "CVERVALDATUM" DATE,
   "CVERVANGARTIKEL" CHARACTER VARYING(25),
   "CVERVANGARTIKELS_FK" INTEGER,
   "CVERVANGKLEUR" CHARACTER VARYING(10),
   "CVERVANGLOTNUMMER" CHARACTER VARYING(10),
   "CVERVANGMAAT" CHARACTER VARYING(10),
   "CVERVANGOMSCHRIJVING" CHARACTER VARYING(100),
   "CSERIENUMMER" CHARACTER VARYING(30) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "CKASSANUMMER" INTEGER,
   "CVERVANGSERIENUMMER" CHARACTER VARYING(30) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "CLOTNUMMER" CHARACTER VARYING(20),
   "CUWREFERENTIE" CHARACTER VARYING(40),
   "CCONTACTADRESSEN_FK" INTEGER,
   "CTERATTENTIEVANSERVICE" CHARACTER VARYING(60),
   "CCONTACTPERSONENSERVICE_FK" INTEGER
);


CREATE TABLE "TSERVICEBETALINGEN"(
   "CSERVICEBETALINGEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CLIJNNUMMER" INTEGER,
   "CSERVICE_FK" INTEGER,
   "CBEDRAG" NUMERIC(10,2),
   "CBETAALWIJZE" CHARACTER VARYING(15),
   "CCASH" BOOLEAN,
   "CDATUM" TIMESTAMP,
   "CKASSAAFSL_FK" INTEGER,
   "CMUNT" CHARACTER VARYING(3),
   "CMUNTEN_FK" INTEGER,
   "COMSCHRIJVING" CHARACTER VARYING(30),
   "CVERWERKT" BOOLEAN
);


CREATE TABLE "TSERVICEHISTORIEK"(
   "CSERVICEHISTORIEK_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CSERVICE_FK" INTEGER,
   "CDATUM" DATE,
   "CSTATUSSERVICE" CHARACTER VARYING(30)
);


CREATE TABLE "TSERVICELIJNEN"(
   "CSERVICELIJNEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CLIJNNUMMER" INTEGER,
   "CSERVICE_FK" INTEGER,
   "CAANKOOPPRIJS" NUMERIC(12,4),
   "CAANTAL" FLOAT,
   "CAANTALGEKOPPELD" FLOAT,
   "CAANTALTEKST" CHARACTER VARYING(30),
   "CAANTALTEVERWERKEN" FLOAT,
   "CAANTALVERWERKT" FLOAT,
   "CALGEMENEREKENING" CHARACTER VARYING(10),
   "CALGEMENEREKENINGEN_FK" INTEGER,
   "CANALYTISCHEREKENING" CHARACTER VARYING(10),
   "CANALYTISCHEREKENINGEN_FK" INTEGER,
   "CARTIKEL" CHARACTER VARYING(25),
   "CARTIKELS_FK" INTEGER,
   "CBEDRAG" NUMERIC(10,2),
   "CBTWCODE" CHARACTER VARYING(10),
   "CBTWPERCENTAGE" NUMERIC(5,2),
   "CEENHEIDVOORRAAD" CHARACTER VARYING(10),
   "CGEENKORTINGEN" BOOLEAN,
   "CGEWICHT" NUMERIC(10,3),
   "CGNCODE" CHARACTER VARYING(8),
   "CGNCODES_FK" INTEGER,
   "CINCLBTW" BOOLEAN,
   "CINFOINTERN" CHARACTER VARYING(10000),
   "CKLEUR" CHARACTER VARYING(10),
   "CKLEURENKAARTEN_FK" INTEGER,
   "CKORTINGGROEP" CHARACTER VARYING(10),
   "CLEVERINGSDATUM" DATE,
   "CLIJNFLOW_FK" INTEGER,
   "CLIJNGEKOPPELD_FK" INTEGER,
   "CLIJNKORTINGPERCENTAGE" NUMERIC(5,2),
   "CLIJNVORIGE_FK" INTEGER,
   "CLIJNVORIGETYPE" INTEGER,
   "CMAAT" CHARACTER VARYING(10),
   "CMATENBALKEN_FK" INTEGER,
   "CMETKOPPELARTIKELEN" BOOLEAN,
   "CMETLOTNUMMERS" BOOLEAN,
   "CMETSERIENUMMERS" BOOLEAN,
   "CMETTITEL" BOOLEAN,
   "CMETVOORRAAD" BOOLEAN,
   "CNUMMERVORIGE" CHARACTER VARYING(20),
   "COMSCHRIJVING" CHARACTER VARYING(256),
   "CSTATUS" INTEGER,
   "CTARIEF" CHARACTER VARYING(10),
   "CTARIEVEN_FK" INTEGER,
   "CVERKOOPPRIJS" NUMERIC(12,4),
   "CVESTIGINGMAGAZIJN" CHARACTER VARYING(10),
   "CLOTNUMMER" CHARACTER VARYING(20),
   "CINFO" CHARACTER VARYING(10000)
);


CREATE TABLE "TSERVICELIJNSERIENUMMERS"(
   "CSERVICELIJNSERIENUMMERS_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CSERVICELIJNEN_FK" INTEGER,
   "CSERIENUMMER" CHARACTER VARYING(30)
);


CREATE TABLE "TSERVICESTATUSSEN"(
   "CSERVICESTATUSSEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CDOCUMENTTYPE" CHARACTER VARYING(20),
   "CDOCUMENTTYPES_FK" INTEGER,
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CLIJNNUMMER" INTEGER,
   "CSTATUSSERVICE" CHARACTER VARYING(30)
);


CREATE TABLE "TKASSAUITGAVEN"(
   "CKASSAUITGAVEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP,
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10),
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CINTERNEFIRMAVESTIGING" CHARACTER VARYING(10),
   "CINTERNEFIRMAVESTIGINGEN_FK" INTEGER,
   "CBEDRAG" NUMERIC(10,2),
   "CCONTACTEN_FK" INTEGER,
   "CDATUM" TIMESTAMP,
   "CKASSAAFSL_FK" INTEGER,
   "CKASSANUMMER" INTEGER,
   "COMSCHRIJVING" CHARACTER VARYING(30),
   "CSOORT" CHARACTER VARYING(1),
   "CVERWERKT" BOOLEAN,
   "CALGEMENEREKENINGEN_FK" INTEGER
);


CREATE TABLE "TFACTUREN"(
   "CFACTUREN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CDAGBOEK" CHARACTER VARYING(10),
   "CDAGBOEKEN_FK" INTEGER,
   "CDAGBOEKSOORT" INTEGER,
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CNUMMER" INTEGER,
   "CAFGESLOTEN" BOOLEAN,
   "CBEDRAGBTW" NUMERIC(10,2),
   "CBEDRAGEXCL" NUMERIC(10,2),
   "CBEDRAGINCL" NUMERIC(10,2),
   "CBETALINGSVOORWAARDE" CHARACTER VARYING(10),
   "CBETALINGSVOORWAARDEN_FK" INTEGER,
   "CBOEKJAAR" CHARACTER VARYING(4),
   "CBOEKJAREN_FK" INTEGER,
   "CBTWREGIME" SMALLINT,
   "CCONTACT" CHARACTER VARYING(10),
   "CCONTACTEN_FK" INTEGER,
   "CDATUM" DATE,
   "CFACTURATIEADRES" CHARACTER VARYING(1024),
   "CFINKORTING" NUMERIC(10,2),
   "CFINKORTINGPERCENTAGE" NUMERIC(5,2),
   "CGEPRINT" BOOLEAN,
   "CINCLBTW" BOOLEAN,
   "CKOERS" NUMERIC(12,6),
   "CMUNT" CHARACTER VARYING(3),
   "CMUNTEN_FK" INTEGER,
   "CTAAL" CHARACTER VARYING(1),
   "CTERATTENTIEVAN" CHARACTER VARYING(60),
   "CUWREFERENTIE" CHARACTER VARYING(35),
   "CVERTEGENWOORDIGER" CHARACTER VARYING(10),
   "CVERTEGENWOORDIGERS_FK" INTEGER,
   "CVERVALDATUM" DATE,
   "CKREDIETBEPERKING" NUMERIC(10,2),
   "CKREDIETBEPERKINGPERC" NUMERIC(5,2),
   "CELEKTRONISCHVERSTUURD" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TFACTLIJNEN"(
   "CFACTLIJNEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CFACTUREN_FK" INTEGER,
   "CLIJNNUMMER" INTEGER,
   "CAANTAL" FLOAT,
   "CAANTALTEKST" CHARACTER VARYING(30),
   "CALGEMENEREKENING" CHARACTER VARYING(10),
   "CALGEMENEREKENINGEN_FK" INTEGER,
   "CANALYTISCHEREKENING" CHARACTER VARYING(10),
   "CANALYTISCHEREKENINGEN_FK" INTEGER,
   "CBEDRAG" NUMERIC(10,2),
   "CBTWCODE" CHARACTER VARYING(10),
   "CBTWPERCENTAGE" NUMERIC(5,2),
   "CFACTARTIKEL" CHARACTER VARYING(15),
   "CINFO" CHARACTER VARYING(10000),
   "CLIJNKORTINGPERCENTAGE" NUMERIC(5,2),
   "CLIJNKORTINGTEKST" CHARACTER VARYING(15),
   "COMSCHRIJVING" CHARACTER VARYING(256),
   "CREFERTE" CHARACTER VARYING(15),
   "CVERKOOPPRIJS" NUMERIC(12,4)
);


CREATE TABLE "TFACTARTIKELGROEPEN"(
   "CFACTARTIKELGROEPEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CFACTARTIKELGROEP" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "COMSCHRIJVING1" CHARACTER VARYING(80),
   "COMSCHRIJVING2" CHARACTER VARYING(80),
   "COMSCHRIJVING3" CHARACTER VARYING(80),
   "COMSCHRIJVING4" CHARACTER VARYING(80)
);


CREATE TABLE "TFACTARTIKELS"(
   "CFACTARTIKELS_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CFACTARTIKEL" CHARACTER VARYING(15),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CBTWCODE" CHARACTER VARYING(10),
   "CBTWCODES_FK" INTEGER,
   "CFACTARTIKELGROEPEN_FK" INTEGER,
   "CFACTARTIKELGROEP" CHARACTER VARYING(10),
   "CINFO1" CHARACTER VARYING(10000),
   "CINFO2" CHARACTER VARYING(10000),
   "CINFO3" CHARACTER VARYING(10000),
   "CINFO4" CHARACTER VARYING(10000),
   "COMSCHRIJVING1" CHARACTER VARYING(100) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "COMSCHRIJVING2" CHARACTER VARYING(100),
   "COMSCHRIJVING3" CHARACTER VARYING(100),
   "COMSCHRIJVING4" CHARACTER VARYING(100),
   "CVERKOOPPRIJS" NUMERIC(12,4),
   "CVERKOOPREKENING" CHARACTER VARYING(10),
   "CVERKOOPREKENINGEN_FK" INTEGER,
   "CISABONNEMENTARTIKEL" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TKASSANUMMERS"(
   "CKASSANUMMERS_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CDAGBOEK" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CINTERNEFIRMAVESTIGING" CHARACTER VARYING(10),
   "CINTERNEFIRMAVESTIGINGEN_FK" INTEGER,
   "CKASSANUMMER" INTEGER
);


CREATE TABLE "TVERWORPENUITGAVEN"(
   "CVERWORPENUITGAVEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CALGEMENEREKENING" CHARACTER VARYING(10),
   "CALGEMENEREKENINGEN_FK" INTEGER,
   "CPERCENTAGE" NUMERIC(10,2)
);


CREATE TABLE "TDAVE"(
   "CDAVE_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINDEX" CHARACTER VARYING(25),
   "CWAARDE" CHARACTER VARYING(1024),
   "CNUMMER" INTEGER DEFAULT 0
);


CREATE TABLE "TCRMMAILINGTEKSTEN"(
   "CCRMMAILINGTEKSTEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CDATUM" DATE,
   "CINFO" CLOB,
   "CONDERWERP" CHARACTER VARYING(128),
   "CNIETACTIEF" BOOLEAN DEFAULT FALSE,
   "CDOCUMENTBLOB" BLOB,
   "CDOCUMENTBLOBBYTES" INTEGER DEFAULT 0,
   "CINFOINTERN" CHARACTER VARYING(1024)
);


CREATE TABLE "TXCONTACTEN"(
   "CXCONTACTEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMACONTACTEN" CHARACTER VARYING(10),
   "CCONTACT" CHARACTER VARYING(10),
   "CNAAM1" CHARACTER VARYING(50),
   "CADRES1" CHARACTER VARYING(50),
   "CADRES2" CHARACTER VARYING(50),
   "CPOSTCODE" CHARACTER VARYING(10),
   "CGEMEENTE" CHARACTER VARYING(50),
   "CLAND" CHARACTER VARYING(2),
   "CBTWNUMMER" CHARACTER VARYING(25),
   "CTELEFOON" CHARACTER VARYING(20),
   "CFAX" CHARACTER VARYING(20),
   "CMOBILE" CHARACTER VARYING(20),
   "CEMAILADRES" CHARACTER VARYING(128),
   "CWEBSITE" CHARACTER VARYING(50),
   "CTAAL" CHARACTER VARYING(1),
   "CTARIEF" CHARACTER VARYING(10),
   "CBTWREGIME" CHARACTER VARYING(10),
   "CNAAM2" CHARACTER VARYING(50)
);


CREATE TABLE "TXCONTACTPERSONEN"(
   "CXCONTACTPERSONEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMACONTACTEN" CHARACTER VARYING(10),
   "CCONTACT" CHARACTER VARYING(10),
   "CNAAM" CHARACTER VARYING(30),
   "CVOORNAAM" CHARACTER VARYING(30),
   "CTAAL" CHARACTER VARYING(1),
   "CEMAILADRES" CHARACTER VARYING(128),
   "CAANSPREEKTITEL" CHARACTER VARYING(20),
   "CAANHEF" CHARACTER VARYING(20),
   "CAFDELING" CHARACTER VARYING(30),
   "CFAX" CHARACTER VARYING(20),
   "CFUNCTIE" CHARACTER VARYING(50),
   "CGEBOORTEDATUM" DATE,
   "CGESLACHT" INTEGER,
   "CINFO" CHARACTER VARYING(1024),
   "CMOBILE" CHARACTER VARYING(20),
   "CSELECTIECODE" CHARACTER VARYING(20),
   "CTELEFOON" CHARACTER VARYING(20),
   "CVERJAARDAG" CHARACTER VARYING(10),
   "CTELEFOONPRIVE" CHARACTER VARYING(20)
);


CREATE TABLE "TXCONTACTADRESSEN"(
   "CXCONTACTADRESSEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMACONTACTEN" CHARACTER VARYING(10),
   "CCONTACT" CHARACTER VARYING(10),
   "CADRESTYPE" CHARACTER VARYING(10),
   "CNAAM1" CHARACTER VARYING(50),
   "CADRES1" CHARACTER VARYING(50),
   "CADRES2" CHARACTER VARYING(50),
   "CPOSTCODE" CHARACTER VARYING(10),
   "CGEMEENTE" CHARACTER VARYING(50),
   "CLAND" CHARACTER VARYING(2),
   "CTELEFOON" CHARACTER VARYING(20),
   "CFAX" CHARACTER VARYING(20),
   "CMOBILE" CHARACTER VARYING(20),
   "CEMAILADRES" CHARACTER VARYING(128),
   "CTAAL" CHARACTER VARYING(1)
);


CREATE TABLE "TXVERKOPEN"(
   "CXVERKOPEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAVESTIGING" CHARACTER VARYING(10),
   "CCONTACT" CHARACTER VARYING(10),
   "CNUMMER" INTEGER,
   "CDATUM" DATE,
   "CBEDRAG" NUMERIC(10,2),
   "CKORTINGPERCENTAGE" NUMERIC(5,2),
   "CMUNT" CHARACTER VARYING(3),
   "CDOCUMENTTYPE" CHARACTER VARYING(20),
   "CTARIEF" CHARACTER VARYING(10),
   "CLEVERINGSADRES" CHARACTER VARYING(1024),
   "CPROBLEEM" CHARACTER VARYING(1024),
   "CUWREFERENTIE" CHARACTER VARYING(40),
   "CONZEREFERENTIE" CHARACTER VARYING(20),
   "CINFOINTERN" CHARACTER VARYING(1024),
   "CTERATTENTIEVAN" CHARACTER VARYING(60),
   "CLEVERINGSDATUMGEWENST" DATE
);


CREATE TABLE "TXVERKOOPLIJNEN"(
   "CXVERKOOPLIJNEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAVESTIGING" CHARACTER VARYING(10),
   "CNUMMER" INTEGER,
   "CLIJNNUMMER" INTEGER,
   "CARTIKEL" CHARACTER VARYING(25),
   "CKLEUR" CHARACTER VARYING(10),
   "CMAAT" CHARACTER VARYING(10),
   "COMSCHRIJVING" CHARACTER VARYING(256),
   "CVERKOOPPRIJS" NUMERIC(12,4),
   "CAANTAL" FLOAT,
   "CLIJNKORTINGPERCENTAGE" NUMERIC(5,2),
   "CBEDRAG" NUMERIC(10,2),
   "CEENHEIDVERKOOP" CHARACTER VARYING(10),
   "CAANTALFACTOR" FLOAT DEFAULT 0
);


CREATE TABLE "TXVERKOOPBETALINGEN"(
   "CXVERKOOPBETALINGEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAVESTIGING" CHARACTER VARYING(10),
   "CNUMMER" INTEGER,
   "CLIJNNUMMER" INTEGER,
   "CBEDRAG" NUMERIC(10,2),
   "CBETAALWIJZE" CHARACTER VARYING(15),
   "CCASH" BOOLEAN
);


CREATE TABLE "TMAGAZIJNLOCATIES"(
   "CMAGAZIJNLOCATIES_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CINTERNEFIRMAVESTIGING" CHARACTER VARYING(10),
   "CINTERNEFIRMAVESTIGINGEN_FK" INTEGER,
   "CVESTIGINGMAGAZIJN" CHARACTER VARYING(10),
   "CMAGAZIJNLOCATIE" CHARACTER VARYING(15),
   "CZONE" CHARACTER VARYING(15),
   "CNIETACTIEF" BOOLEAN,
   "CNUMMER" INTEGER,
   "CISONTVANGST" BOOLEAN,
   "CISPICKING" BOOLEAN,
   "CISPRODUCTIEUIT" BOOLEAN,
   "CISPRODUCTIEIN" BOOLEAN,
   "CISSERVICE" BOOLEAN,
   "COMSCHRIJVING" CHARACTER VARYING(128)
);


CREATE TABLE "TARTIKELBIJLAGEN"(
   "CARTIKELBIJLAGEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CARTIKELS_FK" INTEGER,
   "CTYPE" CHARACTER VARYING(10),
   "CTYPENUMMER" INTEGER,
   "CDOCUMENTBLOBBYTES" INTEGER,
   "CDOCUMENTBLOBNAAM" CHARACTER VARYING(512),
   "CDOCUMENTPAD" CHARACTER VARYING(512),
   "CONDERWERP" CHARACTER VARYING(50),
   "CDOCUMENTBLOB" BLOB,
   "CINFO" CLOB
);


CREATE TABLE "TARTIKELVOORRAADAANTALLEN"(
   "CARTIKELVOORRAADAANTALLEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CARTIKELVOORRAAD_FK" INTEGER,
   "CMAGAZIJNLOCATIE" CHARACTER VARYING(15),
   "CLOTNUMMER" CHARACTER VARYING(20),
   "CLOTDATUM" DATE,
   "CVOORRAAD" FLOAT,
   "CSERIENUMMER" CHARACTER VARYING(30) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE"
);


CREATE TABLE "TVERKOOPLIJNAANTALLEN"(
   "CVERKOOPLIJNAANTALLEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CVERKOOPLIJNEN_FK" INTEGER,
   "CMAGAZIJNLOCATIE" CHARACTER VARYING(15),
   "CLOTNUMMER" CHARACTER VARYING(20),
   "CAANTAL" FLOAT,
   "CLOTDATUM" DATE,
   "CSERIENUMMER" CHARACTER VARYING(30) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE"
);


CREATE TABLE "TAANKOOPLIJNAANTALLEN"(
   "CAANKOOPLIJNAANTALLEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CAANKOOPLIJNEN_FK" INTEGER,
   "CMAGAZIJNLOCATIE" CHARACTER VARYING(15),
   "CLOTNUMMER" CHARACTER VARYING(20),
   "CLOTDATUM" DATE,
   "CAANTAL" FLOAT,
   "CSERIENUMMER" CHARACTER VARYING(30) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE"
);


CREATE TABLE "TPRODUCTIEAANTALLEN"(
   "CPRODUCTIEAANTALLEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CPRODUCTIE_FK" INTEGER,
   "CMAGAZIJNLOCATIE" CHARACTER VARYING(15),
   "CLOTNUMMER" CHARACTER VARYING(20),
   "CLOTDATUM" DATE,
   "CAANTAL" FLOAT,
   "CSERIENUMMER" CHARACTER VARYING(30) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE"
);


CREATE TABLE "TPRODUCTIELIJNAANTALLEN"(
   "CPRODUCTIELIJNAANTALLEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CPRODUCTIELIJNEN_FK" INTEGER,
   "CMAGAZIJNLOCATIE" CHARACTER VARYING(15),
   "CLOTNUMMER" CHARACTER VARYING(20),
   "CAANTAL" FLOAT,
   "CSERIENUMMER" CHARACTER VARYING(30) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "CLOTDATUM" DATE
);


CREATE TABLE "TSERVICELIJNAANTALLEN"(
   "CSERVICELIJNAANTALLEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CSERVICELIJNEN_FK" INTEGER,
   "CMAGAZIJNLOCATIE" CHARACTER VARYING(15),
   "CLOTNUMMER" CHARACTER VARYING(20),
   "CAANTAL" FLOAT,
   "CSERIENUMMER" CHARACTER VARYING(30) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE"
);


CREATE TABLE "TXCONTACTGROEPEN"(
   "CXCONTACTGROEPEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMACONTACTEN" CHARACTER VARYING(10),
   "CCONTACT" CHARACTER VARYING(10),
   "CCONTACTGROEP" CHARACTER VARYING(10),
   "COPERATOR" CHARACTER VARYING(1)
);


CREATE TABLE "TEENHEDEN"(
   "CEENHEDEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CEENHEID1" CHARACTER VARYING(10),
   "CEENHEID2" CHARACTER VARYING(10),
   "CEENHEID3" CHARACTER VARYING(10),
   "CEENHEID4" CHARACTER VARYING(10)
);


CREATE TABLE "TMUNTWAARDEN"(
   "CMUNTWAARDEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CMUNTEN_FK" INTEGER,
   "CMUNTWAARDE" NUMERIC(5,2),
   "CLOGO" BLOB
);


CREATE TABLE "TDOCTEMPLATES"(
   "CDOCTEMPLATES_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CTYPE" CHARACTER VARYING(20),
   "CDOCUMENTBLOBBYTES" INTEGER,
   "CONDERWERP" CHARACTER VARYING(128),
   "CDOCUMENTBLOB" BLOB,
   "CTAAL" CHARACTER VARYING(1)
);


CREATE TABLE "TAGENDAGROEPEN"(
   "CAGENDAGROEPEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CAGENDAGROEP" CHARACTER VARYING(10),
   "COMSCHRIJVING" CHARACTER VARYING(128)
);


CREATE TABLE "TAGENDAGROEPMEDEWERKERS"(
   "CAGENDAGROEPMEDEWERKERS_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CAGENDAGROEP" CHARACTER VARYING(10),
   "CAGENDAGROEPEN_FK" INTEGER,
   "CMEDEWERKER" CHARACTER VARYING(10),
   "CMEDEWERKERS_FK" INTEGER
);


CREATE TABLE "TUURROOSTERS"(
   "CUURROOSTERS_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CMEDEWERKER" CHARACTER VARYING(10),
   "CMEDEWERKERS_FK" INTEGER,
   "CUURVAN" TIMESTAMP,
   "CUURTOT" TIMESTAMP,
   "CDUURTIJD" INTEGER
);


CREATE TABLE "TMEDEWERKERUURKOST"(
   "CMEDEWERKERUURKOST_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CMEDEWERKER" CHARACTER VARYING(10),
   "CMEDEWERKERS_FK" INTEGER,
   "CUURKOST" NUMERIC(10,2)
);


CREATE TABLE "TPRESTATIESOORTEN"(
   "CPRESTATIESOORTEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CAANKOOPPRIJS" NUMERIC(12,4) DEFAULT 0,
   "CALGEMENEREKENING" CHARACTER VARYING(10),
   "CALGEMENEREKENINGEN_FK" INTEGER,
   "CBEDRAG" NUMERIC(12,4) DEFAULT 0,
   "CEENHEID" CHARACTER VARYING(10),
   "CINREGIE" BOOLEAN DEFAULT FALSE,
   "COMSCHRIJVING1" CHARACTER VARYING(128),
   "COMSCHRIJVING2" CHARACTER VARYING(128),
   "COMSCHRIJVING3" CHARACTER VARYING(128),
   "COMSCHRIJVING4" CHARACTER VARYING(128),
   "CTYPE" INTEGER DEFAULT 0,
   "CUURKOST" NUMERIC(10,2) DEFAULT 0,
   "CUURTARIEF" NUMERIC(10,2) DEFAULT 0,
   "CUURTARIEFEXTRA" NUMERIC(10,2) DEFAULT 0,
   "CPRESTATIESOORT" CHARACTER VARYING(25),
   "CNIETACTIEF" BOOLEAN DEFAULT FALSE,
   "CISDIENST" BOOLEAN DEFAULT FALSE,
   "CPRESTATIESOORTGROEP" CHARACTER VARYING(25),
   "CPRESTATIESOORTGROEPEN_FK" INTEGER
);


CREATE TABLE "TPRESTATIES"(
   "CPRESTATIES_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CAANKOOPPRIJS" NUMERIC(12,4) DEFAULT 0,
   "CAANTAL" FLOAT DEFAULT 0,
   "CBEDRAG" NUMERIC(10,2) DEFAULT 0,
   "CBEDRAGGEFACTUREERD" NUMERIC(10,2) DEFAULT 0,
   "CCONTACTEN_FK" INTEGER,
   "CDATUM" DATE,
   "CDOCUMENT_FK" INTEGER,
   "CDOCUMENT2_FK" INTEGER,
   "CDOCUMENTTYPE" CHARACTER VARYING(20),
   "CDOCUMENTTYPES_FK" INTEGER,
   "CDUURTIJD" INTEGER DEFAULT 0,
   "CDUURTIJDEXTRA" INTEGER DEFAULT 0,
   "CEENHEID" CHARACTER VARYING(10),
   "CEXTRA" FLOAT DEFAULT 0,
   "CFACTNUMMER" INTEGER DEFAULT 0,
   "CGEFACTUREERD" BOOLEAN DEFAULT FALSE,
   "CGESTART" BOOLEAN DEFAULT FALSE,
   "CINREGIE" BOOLEAN DEFAULT FALSE,
   "CMEDEWERKER" CHARACTER VARYING(10),
   "CMEDEWERKERS_FK" INTEGER,
   "CNUMMER" CHARACTER VARYING(10),
   "CINFO" CHARACTER VARYING(10000),
   "CPRESTATIESOORTEN_FK" INTEGER,
   "CPRIJS" NUMERIC(12,4) DEFAULT 0,
   "CPRIJSEXTRA" NUMERIC(12,4) DEFAULT 0,
   "CTYPE" INTEGER DEFAULT 0,
   "CUURKOST" NUMERIC(10,2) DEFAULT 0,
   "CUURVAN" TIMESTAMP,
   "CUURTOT" TIMESTAMP,
   "CUURVAN2" TIMESTAMP,
   "CUURTOT2" TIMESTAMP,
   "CGEVERIFIEERD" BOOLEAN,
   "CFACTDATUM" DATE,
   "CFACTDUURTIJD" INTEGER,
   "CFACTDUURTIJDEXTRA" INTEGER,
   "CFACTAANTAL" FLOAT,
   "CPRESTATIESOORT" CHARACTER VARYING(25),
   "CINFOINTERN" CHARACTER VARYING(10000)
);


CREATE TABLE "TSERVICEARTIKELS"(
   "CSERVICEARTIKELS_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CSERVICE_FK" INTEGER,
   "CARTIKEL" CHARACTER VARYING(25),
   "CARTIKELS_FK" INTEGER,
   "CINFOARTIKEL" CHARACTER VARYING(1024),
   "CINFOHERSTELLING" CHARACTER VARYING(1024),
   "CINFOPROBLEEM" CHARACTER VARYING(1024),
   "CINHERSTELLINGLEVERANCIER" BOOLEAN,
   "CKLEUR" CHARACTER VARYING(10),
   "CKLEURENKAARTEN_FK" INTEGER,
   "CLEVERANCIERREFERENTIE" CHARACTER VARYING(20),
   "CLEVERANCIERS_FK" INTEGER,
   "CLOTNUMMER" CHARACTER VARYING(10),
   "CMAAT" CHARACTER VARYING(10),
   "CMATENBALKEN_FK" INTEGER,
   "CMETCONTRACT" BOOLEAN,
   "CMETGARANTIE" BOOLEAN,
   "CMETLOTNUMMERS" BOOLEAN,
   "CMETSERIENUMMERS" BOOLEAN,
   "CMETVERVANGARTIKEL" BOOLEAN,
   "CMETVOORRAAD" BOOLEAN,
   "COMSCHRIJVING" CHARACTER VARYING(256),
   "CSERIENUMMER" CHARACTER VARYING(30),
   "CTERPLAATSE" BOOLEAN,
   "CVERVANGARTIKEL" CHARACTER VARYING(25),
   "CVERVANGARTIKELS_FK" INTEGER,
   "CVERVANGKLEUR" CHARACTER VARYING(10),
   "CVERVANGLOTNUMMER" CHARACTER VARYING(10),
   "CVERVANGMAAT" CHARACTER VARYING(10),
   "CVERVANGOMSCHRIJVING" CHARACTER VARYING(100),
   "CVERVANGSERIENUMMER" CHARACTER VARYING(30),
   "CLIJNFLOW_FK" INTEGER
);


CREATE TABLE "TPROJECTTYPES"(
   "CPROJECTTYPES_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CPROJECTTYPE" CHARACTER VARYING(20),
   "CKLEUR" CHARACTER VARYING(20)
);


CREATE TABLE "TPROJECTEN"(
   "CPROJECTEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CINTERNEFIRMAVESTIGING" CHARACTER VARYING(10),
   "CINTERNEFIRMAVESTIGINGEN_FK" INTEGER,
   "CDOCUMENTTYPES_FK" INTEGER,
   "CPREFIX" CHARACTER VARYING(10),
   "CPROJECT" CHARACTER VARYING(10),
   "COMSCHRIJVING" CHARACTER VARYING(128) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "CANALYTISCHEREKENING" CHARACTER VARYING(10),
   "CANALYTISCHEREKENINGEN_FK" INTEGER,
   "CPROJECTTYPE" CHARACTER VARYING(20),
   "CPROJECTTYPES_FK" INTEGER,
   "CCONTACTEN_FK" INTEGER,
   "CTERATTENTIEVAN" CHARACTER VARYING(60),
   "CCONTACTPERSONEN_FK" INTEGER,
   "CUWREFERENTIE" CHARACTER VARYING(40),
   "CONZEREFERENTIE" CHARACTER VARYING(20),
   "CPRIORITEIT" INTEGER,
   "CDATUM" DATE,
   "CMEDEWERKER" CHARACTER VARYING(10),
   "CMEDEWERKERS_FK" INTEGER,
   "CINFO" CHARACTER VARYING(10000),
   "CGESCHATBEGINDATUM" DATE,
   "CGESCHATEINDDATUM" DATE,
   "CGESCHATDUURTIJDDAGEN" INTEGER,
   "CDEADLINE" DATE,
   "CGESCHATKOSTEN" NUMERIC(12,2) DEFAULT 0,
   "CGESCHATOPBRENGSTEN" NUMERIC(12,2) DEFAULT 0,
   "CGESCHATPRESTATIESUREN" NUMERIC(12,2) DEFAULT 0,
   "CGESCHATRESULTAAT" NUMERIC(12,2) DEFAULT 0,
   "CREEELBEGINDATUM" DATE,
   "CREEELEINDDATUM" DATE,
   "CREEELDUURTIJDDAGEN" INTEGER,
   "CREEELKOSTEN" NUMERIC(12,2) DEFAULT 0,
   "CREEELOPBRENGSTEN" NUMERIC(12,2) DEFAULT 0,
   "CREEELRESULTAAT" NUMERIC(12,2) DEFAULT 0,
   "CSTATUS" INTEGER,
   "CAFGESLOTEN" BOOLEAN DEFAULT FALSE,
   "CAFGESLOTENDOOR" CHARACTER VARYING(10),
   "CDATUMAFGESLOTEN" DATE,
   "CLAND" CHARACTER VARYING(2),
   "CPOSTCODE" CHARACTER VARYING(10),
   "CGEMEENTE" CHARACTER VARYING(50),
   "CFACTURATIETYPE" INTEGER,
   "CDOCUMENTTYPE" CHARACTER VARYING(20),
   "CADRES1" CHARACTER VARYING(50),
   "CPROJECTVC_FK" INTEGER,
   "CPROJECTOFFERTES_FK" INTEGER,
   "CPROJECTCAMPAGNE" CHARACTER VARYING(20),
   "CPROJECTCAMPAGNES_FK" INTEGER,
   "CGESCHATKOSTENFACTUREN" NUMERIC(12,2) DEFAULT 0,
   "CGESCHATKOSTENPRESTATIES" NUMERIC(12,2) DEFAULT 0,
   "CGESCHATKOSTENDIVERSEN" NUMERIC(12,2) DEFAULT 0,
   "CGESCHATKOSTENARTIKELS" NUMERIC(12,2) DEFAULT 0,
   "CVERTEGENWOORDIGER" CHARACTER VARYING(10),
   "CVERTEGENWOORDIGERS_FK" INTEGER,
   "CEXTRA1" CHARACTER VARYING(1024),
   "CEXTRA2" CHARACTER VARYING(1024),
   "CEXTRA3" CHARACTER VARYING(1024),
   "CEXTRA4" CHARACTER VARYING(1024),
   "CEXTRA5" CHARACTER VARYING(1024),
   "CFACTCONTACTEN_FK" INTEGER
);


CREATE TABLE "TPROJECTCONTACTEN"(
   "CPROJECTCONTACTEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CPROJECTEN_FK" INTEGER,
   "CCONTACTEN_FK" INTEGER,
   "CCONTACTPERSONEN_FK" INTEGER,
   "CTERATTENTIEVAN" CHARACTER VARYING(60),
   "CTELEFOON" CHARACTER VARYING(20)
);


CREATE TABLE "TPROJECTMEDEWERKERS"(
   "CPROJECTMEDEWERKERS_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CPROJECTEN_FK" INTEGER,
   "CMEDEWERKER" CHARACTER VARYING(10),
   "CMEDEWERKERS_FK" INTEGER,
   "CUURKOST" NUMERIC(10,2),
   "CAFSTAND" FLOAT DEFAULT 0
);


CREATE TABLE "TPROJECTMATERIALEN"(
   "CPROJECTMATERIALEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CPROJECTEN_FK" INTEGER,
   "CMATERIAAL" CHARACTER VARYING(50),
   "CMATERIALEN_FK" INTEGER
);


CREATE TABLE "TPROJECTFASEN"(
   "CPROJECTFASEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CPROJECTEN_FK" INTEGER,
   "CVOLGNUMMER" INTEGER,
   "COMSCHRIJVING" CHARACTER VARYING(128),
   "CMEDEWERKER" CHARACTER VARYING(10),
   "CMEDEWERKERS_FK" INTEGER,
   "CCONTACTEN_FK" INTEGER,
   "CCONTACTPERSONEN_FK" INTEGER,
   "CTERATTENTIEVAN" CHARACTER VARYING(60),
   "CGESCHATBEGINDATUM" TIMESTAMP,
   "CGESCHATEINDDATUM" TIMESTAMP,
   "CGESCHATDUURTIJDDAGEN" INTEGER,
   "CGESCHATDUURTIJD" INTEGER,
   "CDEADLINE" TIMESTAMP,
   "CAFGEWERKT" BOOLEAN DEFAULT FALSE,
   "CINFOINTERN" CHARACTER VARYING(10000),
   "CACTIEF" BOOLEAN DEFAULT FALSE,
   "CINREGIE" BOOLEAN DEFAULT FALSE,
   "CFACTBEDRAG" NUMERIC(12,2) DEFAULT 0,
   "CFACTPERCENTAGE" NUMERIC(12,2) DEFAULT 0,
   "CFACTOMSCHRIJVING" CHARACTER VARYING(256),
   "CGEFACTUREERD" BOOLEAN DEFAULT FALSE,
   "CFACTNUMMER" INTEGER DEFAULT 0,
   "CALGEMENEREKENING" CHARACTER VARYING(10),
   "CALGEMENEREKENINGEN_FK" INTEGER,
   "CPRESTATIESOORTEN_FK" INTEGER,
   "CPRESTATIESOORT" CHARACTER VARYING(25)
);


CREATE TABLE "TPROJECTFASEEXTRA"(
   "CPROJECTFASEEXTRA_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CPROJECTEN_FK" INTEGER,
   "CPROJECTFASEN_FK" INTEGER,
   "CTYPENR" INTEGER,
   "CMEDEWERKER" CHARACTER VARYING(10),
   "CMEDEWERKERS_FK" INTEGER,
   "CMATERIAAL" CHARACTER VARYING(50),
   "CMATERIALEN_FK" INTEGER
);


CREATE TABLE "TPROJECTARTIKELS"(
   "CPROJECTARTIKELS_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CPROJECTEN_FK" INTEGER,
   "CAANKOOPPRIJS" NUMERIC(12,4),
   "CARTIKEL" CHARACTER VARYING(25),
   "CARTIKELS_FK" INTEGER,
   "CDATUM" DATE,
   "COMSCHRIJVING" CHARACTER VARYING(256),
   "CAANTAL" FLOAT DEFAULT 1,
   "CEENHEID" CHARACTER VARYING(10),
   "CBEDRAG" NUMERIC(12,2) DEFAULT 0,
   "CFACTARTIKELS_FK" INTEGER
);


CREATE TABLE "TPROJECTVC"(
   "CPROJECTVC_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CINTERNEFIRMAVESTIGING" CHARACTER VARYING(10),
   "CINTERNEFIRMAVESTIGINGEN_FK" INTEGER,
   "CNUMMER" INTEGER,
   "CDATUM" DATE,
   "CCONTACTEN_FK" INTEGER,
   "CCONTACTPERSONEN_FK" INTEGER,
   "CTERATTENTIEVAN" CHARACTER VARYING(60),
   "CADRES1" CHARACTER VARYING(50),
   "CLAND" CHARACTER VARYING(2),
   "CPOSTCODE" CHARACTER VARYING(10),
   "CGEMEENTE" CHARACTER VARYING(50),
   "CPROJECTTYPE" CHARACTER VARYING(20),
   "CPROJECTTYPES_FK" INTEGER,
   "COMSCHRIJVING" CHARACTER VARYING(128),
   "CINFO" CHARACTER VARYING(10000),
   "CGESCHATKOSTEN" NUMERIC(12,2) DEFAULT 0,
   "CGESCHATKOSTENFACTUREN" NUMERIC(12,2) DEFAULT 0,
   "CGESCHATKOSTENPRESTATIES" NUMERIC(12,2) DEFAULT 0,
   "CGESCHATKOSTENDIVERSEN" NUMERIC(12,2) DEFAULT 0,
   "CGESCHATKOSTENARTIKELS" NUMERIC(12,2) DEFAULT 0,
   "CGESCHATOPBRENGSTEN" NUMERIC(12,2) DEFAULT 0,
   "CGESCHATRESULTAAT" NUMERIC(12,2) DEFAULT 0,
   "CGESCHATPRESTATIESUREN" NUMERIC(12,2) DEFAULT 0,
   "CAFGESLOTEN" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TPROJECTVCLIJNEN"(
   "CPROJECTVCLIJNEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CPROJECTVC_FK" INTEGER,
   "CLIJNNUMMER" INTEGER,
   "COMSCHRIJVING" CHARACTER VARYING(256),
   "CGESCHATKOSTEN" NUMERIC(12,2) DEFAULT 0,
   "CGESCHATKOSTENFACTUREN" NUMERIC(12,2) DEFAULT 0,
   "CGESCHATKOSTENPRESTATIES" NUMERIC(12,2) DEFAULT 0,
   "CGESCHATKOSTENDIVERSEN" NUMERIC(12,2) DEFAULT 0,
   "CGESCHATKOSTENARTIKELS" NUMERIC(12,2) DEFAULT 0,
   "CGESCHATOPBRENGSTEN" NUMERIC(12,2) DEFAULT 0,
   "CGESCHATRESULTAAT" NUMERIC(12,2) DEFAULT 0,
   "CGESCHATPRESTATIESUREN" NUMERIC(12,2) DEFAULT 0,
   "CPRESTATIESOORTEN_FK" INTEGER,
   "CTYPE" INTEGER DEFAULT 1,
   "CAANTAL" FLOAT DEFAULT 0,
   "CPRIJS" NUMERIC(10,2) DEFAULT 0,
   "CUURKOST" NUMERIC(10,2) DEFAULT 0,
   "CAANKOOPPRIJS" NUMERIC(10,2) DEFAULT 0,
   "CTITEL" CHARACTER VARYING(128),
   "CARTIKEL" CHARACTER VARYING(25),
   "CARTIKELS_FK" INTEGER,
   "CFACTARTIKELS_FK" INTEGER,
   "CPRESTATIESOORT" CHARACTER VARYING(25)
);


CREATE TABLE "TPROJECTVCBIJLAGEN"(
   "CPROJECTVCBIJLAGEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CPROJECTVC_FK" INTEGER,
   "CTYPE" CHARACTER VARYING(10),
   "CTYPENUMMER" INTEGER,
   "CDOCUMENT_FK" INTEGER,
   "CDOCUMENTBLOBBYTES" INTEGER,
   "CDOCUMENTBLOBNAAM" CHARACTER VARYING(512),
   "CDOCUMENTPAD" CHARACTER VARYING(512),
   "CDOCUMENTTYPE" CHARACTER VARYING(15),
   "CDOCUMENTTYPES_FK" INTEGER,
   "CONDERWERP" CHARACTER VARYING(128),
   "CDOCUMENTBLOB" BLOB,
   "CINFO" CLOB,
   "CNUMMER" CHARACTER VARYING(10)
);


CREATE TABLE "TPROJECTOFFERTES"(
   "CPROJECTOFFERTES_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CINTERNEFIRMAVESTIGING" CHARACTER VARYING(10),
   "CINTERNEFIRMAVESTIGINGEN_FK" INTEGER,
   "CDOCUMENTTYPE" CHARACTER VARYING(20),
   "CDOCUMENTTYPES_FK" INTEGER,
   "CPREFIX" CHARACTER VARYING(10),
   "CNUMMER" INTEGER,
   "CDATUM" DATE,
   "CCONTACTEN_FK" INTEGER,
   "CCONTACTPERSONEN_FK" INTEGER,
   "CTERATTENTIEVAN" CHARACTER VARYING(60),
   "CADRES1" CHARACTER VARYING(50),
   "CLAND" CHARACTER VARYING(2),
   "CPOSTCODE" CHARACTER VARYING(10),
   "CGEMEENTE" CHARACTER VARYING(50),
   "CPROJECTTYPE" CHARACTER VARYING(20),
   "CPROJECTTYPES_FK" INTEGER,
   "COMSCHRIJVING" CHARACTER VARYING(128),
   "CDOCUMENTBLOB" BLOB,
   "CDOCUMENTBLOBBYTES" INTEGER,
   "CPROJECTVC_FK" INTEGER,
   "CAFGESLOTEN" BOOLEAN DEFAULT FALSE,
   "CVERSTUURD" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TPROJECTCAMPAGNES"(
   "CPROJECTCAMPAGNES_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CPROJECTCAMPAGNE" CHARACTER VARYING(20),
   "COMSCHRIJVING" CHARACTER VARYING(128),
   "CDATUM" DATE,
   "CDATUMTOT" DATE,
   "CCONTACTEN_FK" INTEGER,
   "CAFGESLOTEN" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TPROJECTTYPEFASEN"(
   "CPROJECTTYPEFASEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CPROJECTTYPES_FK" INTEGER,
   "CVOLGNUMMER" INTEGER,
   "COMSCHRIJVING" CHARACTER VARYING(128),
   "CINREGIE" BOOLEAN DEFAULT FALSE,
   "CALGEMENEREKENING" CHARACTER VARYING(10),
   "CALGEMENEREKENINGEN_FK" INTEGER,
   "CPRESTATIESOORTEN_FK" INTEGER,
   "CPRESTATIESOORT" CHARACTER VARYING(25)
);


CREATE TABLE "TPROJECTFASERELATIES"(
   "CPROJECTFASERELATIES_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CPROJECTEN_FK" INTEGER,
   "CPROJECTFASEN_FK" INTEGER,
   "CPROJECTFASEN2_FK" INTEGER,
   "CFASERELATIE" CHARACTER VARYING(2),
   "CDUURTIJD" INTEGER DEFAULT 0,
   "CGEENDUURTIJD" BOOLEAN DEFAULT TRUE
);


CREATE TABLE "TVERKOOPBIJLAGEN"(
   "CVERKOOPBIJLAGEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CVERKOPEN_FK" INTEGER,
   "CTYPE" CHARACTER VARYING(10),
   "CTYPENUMMER" INTEGER,
   "CDOCUMENT_FK" INTEGER,
   "CDOCUMENTBLOBBYTES" INTEGER,
   "CDOCUMENTBLOBNAAM" CHARACTER VARYING(512),
   "CDOCUMENTPAD" CHARACTER VARYING(512),
   "CDOCUMENTTYPES_FK" INTEGER,
   "CONDERWERP" CHARACTER VARYING(128),
   "CDOCUMENTBLOB" BLOB,
   "CINFO" CLOB,
   "CNUMMER" CHARACTER VARYING(10),
   "CDOCUMENTTYPE" CHARACTER VARYING(20)
);


CREATE TABLE "TAANKOOPBIJLAGEN"(
   "CAANKOOPBIJLAGEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CAANKOPEN_FK" INTEGER,
   "CTYPE" CHARACTER VARYING(10),
   "CTYPENUMMER" INTEGER,
   "CDOCUMENT_FK" INTEGER,
   "CDOCUMENTBLOBBYTES" INTEGER,
   "CDOCUMENTBLOBNAAM" CHARACTER VARYING(512),
   "CDOCUMENTPAD" CHARACTER VARYING(512),
   "CDOCUMENTTYPES_FK" INTEGER,
   "CONDERWERP" CHARACTER VARYING(128),
   "CDOCUMENTBLOB" BLOB,
   "CINFO" CLOB,
   "CNUMMER" CHARACTER VARYING(10),
   "CDOCUMENTTYPE" CHARACTER VARYING(20)
);


CREATE TABLE "TSERVICEBIJLAGEN"(
   "CSERVICEBIJLAGEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CSERVICE_FK" INTEGER,
   "CTYPE" CHARACTER VARYING(10),
   "CTYPENUMMER" INTEGER,
   "CDOCUMENT_FK" INTEGER,
   "CDOCUMENTBLOBBYTES" INTEGER,
   "CDOCUMENTBLOBNAAM" CHARACTER VARYING(512),
   "CDOCUMENTPAD" CHARACTER VARYING(512),
   "CDOCUMENTTYPES_FK" INTEGER,
   "CONDERWERP" CHARACTER VARYING(128),
   "CDOCUMENTBLOB" BLOB,
   "CINFO" CLOB,
   "CNUMMER" CHARACTER VARYING(10),
   "CDOCUMENTTYPE" CHARACTER VARYING(20)
);


CREATE TABLE "TSERVICEINSTALLATIES"(
   "CSERVICEINSTALLATIES_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CINTERNEFIRMAVESTIGING" CHARACTER VARYING(10),
   "CINTERNEFIRMAVESTIGINGEN_FK" INTEGER,
   "CCONTACTEN_FK" INTEGER,
   "CADRES1" CHARACTER VARYING(50),
   "CADRES2" CHARACTER VARYING(50),
   "CPOSTCODE" CHARACTER VARYING(10),
   "CGEMEENTE" CHARACTER VARYING(50),
   "CLAND" CHARACTER VARYING(2),
   "CDATUM" DATE,
   "CARTIKELS_FK" INTEGER,
   "CARTIKEL" CHARACTER VARYING(25),
   "COMSCHRIJVING" CHARACTER VARYING(256),
   "CSERIENUMMER" CHARACTER VARYING(30),
   "CDATUMGARANTIETOT" DATE,
   "CMETONDERHOUD" BOOLEAN DEFAULT FALSE,
   "CDATUMONDERHOUDTOT" DATE,
   "COHOPGEZEGD" BOOLEAN DEFAULT FALSE,
   "COHOPGEZEGDDATUM" DATE,
   "CINFO" CHARACTER VARYING(10000)
);


CREATE TABLE "TAGENDAFEESTDAGEN"(
   "CAGENDAFEESTDAGEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CDATUM" DATE,
   "CKLEUR" INTEGER,
   "CKLEUROMSCHRIJVING" INTEGER,
   "COMSCHRIJVING" CHARACTER VARYING(128)
);


CREATE TABLE "TPROJECTTYPEFASERELATIES"(
   "CPROJECTTYPEFASERELATIES_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CPROJECTTYPES_FK" INTEGER,
   "CPROJECTTYPEFASEN_FK" INTEGER,
   "CPROJECTTYPEFASEN2_FK" INTEGER,
   "CFASERELATIE" CHARACTER VARYING(2),
   "CDUURTIJD" INTEGER DEFAULT 0,
   "CGEENDUURTIJD" BOOLEAN DEFAULT TRUE
);


CREATE TABLE "TXPRESTATIES"(
   "CXPRESTATIES_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAVESTIGING" CHARACTER VARYING(10),
   "CMEDEWERKER" CHARACTER VARYING(10),
   "CCONTACT" CHARACTER VARYING(10),
   "CDATUM" DATE,
   "CDOCUMENTTYPE" CHARACTER VARYING(20),
   "CNUMMER" CHARACTER VARYING(10),
   "CVOLGNUMMER" INTEGER,
   "CTYPE" INTEGER,
   "CUURVAN" TIMESTAMP,
   "CUURTOT" TIMESTAMP,
   "CDUURTIJD" INTEGER,
   "CDUURTIJDEXTRA" INTEGER,
   "CAANTAL" FLOAT,
   "CEENHEID" CHARACTER VARYING(10),
   "CINFO" CHARACTER VARYING(10000),
   "CPRESTATIESOORT" CHARACTER VARYING(25)
);


CREATE TABLE "TVERKOOPLIJNAFMETINGEN"(
   "CVERKOOPLIJNAFMETINGEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CVERKOOPLIJNEN_FK" INTEGER,
   "CAANTAL" FLOAT,
   "CLENGTE" FLOAT,
   "CBREEDTE" FLOAT,
   "CHOOGTE" FLOAT,
   "CTOTAAL" FLOAT
);


CREATE TABLE "TPROJECTBIJLAGEN"(
   "CPROJECTBIJLAGEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CPROJECTEN_FK" INTEGER,
   "CTYPE" CHARACTER VARYING(10),
   "CTYPENUMMER" INTEGER,
   "CDOCUMENT_FK" INTEGER,
   "CDOCUMENTBLOBBYTES" INTEGER,
   "CDOCUMENTBLOBNAAM" CHARACTER VARYING(512),
   "CDOCUMENTPAD" CHARACTER VARYING(512),
   "CDOCUMENTTYPE" CHARACTER VARYING(20),
   "CDOCUMENTTYPES_FK" INTEGER,
   "CONDERWERP" CHARACTER VARYING(128),
   "CDOCUMENTBLOB" BLOB,
   "CINFO" CLOB,
   "CNUMMER" CHARACTER VARYING(10)
);


CREATE TABLE "TCONTACTBIJLAGEN"(
   "CCONTACTBIJLAGEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CCONTACTEN_FK" INTEGER,
   "CTYPE" CHARACTER VARYING(10),
   "CTYPENUMMER" INTEGER,
   "CDOCUMENT_FK" INTEGER,
   "CDOCUMENTBLOBBYTES" INTEGER,
   "CDOCUMENTBLOBNAAM" CHARACTER VARYING(512),
   "CDOCUMENTPAD" CHARACTER VARYING(512),
   "CDOCUMENTTYPES_FK" INTEGER,
   "CONDERWERP" CHARACTER VARYING(128),
   "CDOCUMENTBLOB" BLOB,
   "CINFO" CLOB,
   "CNUMMER" CHARACTER VARYING(10),
   "CDOCUMENTTYPE" CHARACTER VARYING(20)
);


CREATE TABLE "TCOMMUNICATIESOORTEN"(
   "CCOMMUNICATIESOORTEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CCOMMUNICATIESOORT" CHARACTER VARYING(15),
   "CCOMMUNICATIESOORTNR" INTEGER,
   "COMSCHRIJVING1" CHARACTER VARYING(20),
   "COMSCHRIJVING2" CHARACTER VARYING(20),
   "COMSCHRIJVING3" CHARACTER VARYING(20),
   "COMSCHRIJVING4" CHARACTER VARYING(20)
);


CREATE TABLE "TMEDEWERKERHANDTEKENINGEN"(
   "CMEDEWERKERHANDTEKENINGEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CMEDEWERKER" CHARACTER VARYING(10),
   "CMEDEWERKERS_FK" INTEGER,
   "COMSCHRIJVING" CHARACTER VARYING(128),
   "CINFO" CLOB,
   "CDOCUMENTBLOB" BLOB,
   "CDOCUMENTBLOBBYTES" INTEGER,
   "CNIETACTIEF" BOOLEAN DEFAULT FALSE,
   "CISSTANDAARD" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TMEDEWERKERBIJLAGEN"(
   "CMEDEWERKERBIJLAGEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CMEDEWERKERS_FK" INTEGER,
   "CTYPE" CHARACTER VARYING(10),
   "CTYPENUMMER" INTEGER,
   "CDOCUMENTBLOBBYTES" INTEGER,
   "CDOCUMENTBLOBNAAM" CHARACTER VARYING(512),
   "CDOCUMENTPAD" CHARACTER VARYING(512),
   "CONDERWERP" CHARACTER VARYING(128),
   "CDOCUMENTBLOB" BLOB,
   "CINFO" CLOB
);


CREATE TABLE "TNACECODES"(
   "CNACECODES_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CNACECODE" CHARACTER VARYING(10),
   "COMSCHRIJVING1" CHARACTER VARYING(256),
   "COMSCHRIJVING2" CHARACTER VARYING(256),
   "COMSCHRIJVING3" CHARACTER VARYING(256),
   "COMSCHRIJVING4" CHARACTER VARYING(256)
);


CREATE TABLE "TAGENDACONTACTEN"(
   "CAGENDACONTACTEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CAGENDA_FK" INTEGER,
   "CCONTACTEN_FK" INTEGER,
   "CCONTACTPERSONEN_FK" INTEGER,
   "CNAAMCONTACTPERSOON" CHARACTER VARYING(60)
);


CREATE TABLE "TCRMCOMMUNICATIECONTACTEN"(
   "CCRMCOMMUNICATIECONTACTEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CCRMCOMMUNICATIES_FK" INTEGER,
   "CCONTACTEN_FK" INTEGER,
   "CCONTACTPERSONEN_FK" INTEGER,
   "CNAAMCONTACTPERSOON" CHARACTER VARYING(60)
);


CREATE TABLE "TCRMTAAKPRODUCTEN"(
   "CCRMTAAKPRODUCTEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CCRMTAKEN_FK" INTEGER,
   "CCRMPRODUCTFAMILIE" CHARACTER VARYING(10),
   "CCRMPRODUCT" CHARACTER VARYING(25),
   "COMSCHRIJVING" CHARACTER VARYING(1024),
   "CISGELEVERD" BOOLEAN DEFAULT FALSE,
   "CDATUMGELEVERD" DATE
);


CREATE TABLE "TCRMTAAKOMSCHRIJVINGEN"(
   "CCRMTAAKOMSCHRIJVINGEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CCRMTAAKOMSCHRIJVING" CHARACTER VARYING(10),
   "CVOLGNUMMER" INTEGER,
   "COMSCHRIJVING1" CHARACTER VARYING(128) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "COMSCHRIJVING2" CHARACTER VARYING(128),
   "COMSCHRIJVING3" CHARACTER VARYING(128),
   "COMSCHRIJVING4" CHARACTER VARYING(128),
   "CNIETACTIEF" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TCRMSUPPORTSOORTEN"(
   "CCRMSUPPORTSOORTEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CCRMSUPPORTSOORT" CHARACTER VARYING(10),
   "CVOLGNUMMER" INTEGER,
   "COMSCHRIJVING1" CHARACTER VARYING(128),
   "COMSCHRIJVING2" CHARACTER VARYING(128),
   "COMSCHRIJVING3" CHARACTER VARYING(128),
   "COMSCHRIJVING4" CHARACTER VARYING(128),
   "CMETOPVOLGING" BOOLEAN DEFAULT FALSE,
   "CNIETACTIEF" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TCRMWACHTRIJEN"(
   "CCRMWACHTRIJEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CCRMWACHTRIJ" CHARACTER VARYING(10),
   "CVOLGNUMMER" INTEGER,
   "CANTWOORD" CHARACTER VARYING(1024),
   "CEMAILADRES" CHARACTER VARYING(128),
   "CHANDTEKENING" CHARACTER VARYING(1024),
   "COMSCHRIJVING1" CHARACTER VARYING(128),
   "COMSCHRIJVING2" CHARACTER VARYING(128),
   "COMSCHRIJVING3" CHARACTER VARYING(128),
   "COMSCHRIJVING4" CHARACTER VARYING(128),
   "CNIETACTIEF" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TCRMWACHTRIJMEDEWERKERS"(
   "CCRMWACHTRIJMEDEWERKERS_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CCRMWACHTRIJ" CHARACTER VARYING(10),
   "CCRMWACHTRIJEN_FK" INTEGER,
   "CMEDEWERKER" CHARACTER VARYING(10),
   "CMEDEWERKERS_FK" INTEGER,
   "CTOEGANG" BOOLEAN DEFAULT TRUE,
   "CINSERT" BOOLEAN DEFAULT TRUE,
   "CUPDATE" BOOLEAN DEFAULT TRUE,
   "CDELETE" BOOLEAN DEFAULT TRUE,
   "CHEROPENEN" BOOLEAN DEFAULT TRUE,
   "CAFSLUITEN" BOOLEAN DEFAULT TRUE
);


CREATE TABLE "TCRMPRODUCTFAMILIES"(
   "CCRMPRODUCTFAMILIES_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CCRMPRODUCTFAMILIE" CHARACTER VARYING(10),
   "COMSCHRIJVING" CHARACTER VARYING(128),
   "CNIETACTIEF" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TCRMPRODUCTGROEPEN"(
   "CCRMPRODUCTGROEPEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CCRMPRODUCTGROEP" CHARACTER VARYING(10),
   "COMSCHRIJVING" CHARACTER VARYING(128),
   "CNIETACTIEF" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TCRMPRODUCTEN"(
   "CCRMPRODUCTEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CCRMPRODUCTFAMILIE" CHARACTER VARYING(10),
   "CCRMPRODUCTGROEP" CHARACTER VARYING(10),
   "CCRMPRODUCT" CHARACTER VARYING(25),
   "COMSCHRIJVING" CHARACTER VARYING(128),
   "CVOLGNUMMER" INTEGER,
   "CSUPPORTCALLS" BOOLEAN DEFAULT FALSE,
   "CLEVERINGEN" BOOLEAN DEFAULT FALSE,
   "CLEVERINGENCUMUL" BOOLEAN DEFAULT FALSE,
   "CFACTUREN" BOOLEAN DEFAULT FALSE,
   "CNIETACTIEF" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TCRMSUPPORTCALLS"(
   "CCRMSUPPORTCALLS_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CINTERNEFIRMAVESTIGING" CHARACTER VARYING(10),
   "CINTERNEFIRMAVESTIGINGEN_FK" INTEGER,
   "CDOCUMENTTYPE" CHARACTER VARYING(20),
   "CDOCUMENTTYPES_FK" INTEGER,
   "CNUMMER" INTEGER,
   "CCRMWACHTRIJ" CHARACTER VARYING(10),
   "CCRMWACHTRIJEN_FK" INTEGER,
   "CDATUM" TIMESTAMP,
   "CCONTACTEN_FK" INTEGER,
   "CCONTACTPERSONEN_FK" INTEGER,
   "CNAAMCONTACTPERSOON" CHARACTER VARYING(50),
   "CEMAILADRES" CHARACTER VARYING(128),
   "CMAILVERSTUURDNAARCC" CHARACTER VARYING(1024),
   "CPRIORITEIT" INTEGER,
   "CONDERWERP" CHARACTER VARYING(128),
   "CINFO" CLOB,
   "CDOCUMENTBLOB" BLOB,
   "CDOCUMENTBLOBBYTES" INTEGER,
   "CVERTEGENWOORDIGER" CHARACTER VARYING(10),
   "CVERTEGENWOORDIGERS_FK" INTEGER,
   "CMEDEWERKER" CHARACTER VARYING(10),
   "CMEDEWERKERS_FK" INTEGER,
   "CCRMSUPPORTSOORT" CHARACTER VARYING(10),
   "CCRMSUPPORTSOORTEN_FK" INTEGER,
   "CCOMMUNICATIESOORT" CHARACTER VARYING(15),
   "CCRMPRODUCTFAMILIE" CHARACTER VARYING(10),
   "CCRMPRODUCT" CHARACTER VARYING(25),
   "CMETSIGNAAL" BOOLEAN DEFAULT FALSE,
   "CMETALARM" BOOLEAN DEFAULT FALSE,
   "CINWACHT" BOOLEAN DEFAULT FALSE,
   "CINWACHTDATUM" TIMESTAMP,
   "CINWACHTINFO" CHARACTER VARYING(128),
   "CAFGESLOTEN" BOOLEAN DEFAULT FALSE,
   "CAFGESLOTENDOOR" CHARACTER VARYING(10),
   "CDATUMAFGESLOTEN" TIMESTAMP,
   "CDUURTIJD" INTEGER,
   "CVERWERKTINVERSIE" CHARACTER VARYING(20),
   "CVOORSTELVOLGENDEVERSIE" INTEGER,
   "CGEPLANDVOORVERSIE" CHARACTER VARYING(20),
   "CGEPLANDMEDEWERKER" CHARACTER VARYING(10),
   "CGEPLANDDBAANPASSING" BOOLEAN DEFAULT FALSE,
   "CGEPLANDDUURTIJD" INTEGER,
   "CDATUMUITGEVOERD" DATE,
   "CINFOHANDLEIDING" CHARACTER VARYING(10000),
   "CGETEST" BOOLEAN DEFAULT FALSE,
   "CGETESTOK" BOOLEAN DEFAULT FALSE,
   "CINFOOPVOLGING" CHARACTER VARYING(10000),
   "CREACTIETIJD" INTEGER,
   "CDEADLINE" TIMESTAMP,
   "CINFOVERSIE" CHARACTER VARYING(10000),
   "CSELECTIECODE" CHARACTER VARYING(10),
   "CVERSION" CHARACTER VARYING(128),
   "COS" CHARACTER VARYING(128)
);


CREATE TABLE "TCRMSUPPORTCALLLIJNEN"(
   "CCRMSUPPORTCALLLIJNEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CCRMSUPPORTCALLS_FK" INTEGER,
   "CCOMMUNICATIESOORT" CHARACTER VARYING(15),
   "CDATUMVERSTUURD" TIMESTAMP,
   "CDOCUMENT_FK" INTEGER,
   "CDOCUMENTBLOB" BLOB,
   "CDOCUMENTBLOBNAAM" CHARACTER VARYING(512),
   "CDOCUMENTBLOBBYTES" INTEGER,
   "CDOCUMENTPAD" CHARACTER VARYING(512),
   "CDOCUMENTTYPE" CHARACTER VARYING(15),
   "CDOCUMENTTYPES_FK" INTEGER,
   "CINFO" CLOB,
   "CMAILVERSTUURDDOOR" CHARACTER VARYING(10),
   "CMAILVERSTUURDNAAR" CHARACTER VARYING(1024),
   "CMAILVERSTUURDNAARCC" CHARACTER VARYING(1024),
   "CMEDEWERKER" CHARACTER VARYING(10),
   "CMEDEWERKERS_FK" INTEGER,
   "CONDERWERP" CHARACTER VARYING(128),
   "CNUMMER" CHARACTER VARYING(10),
   "CTYPE" CHARACTER VARYING(10)
);


CREATE TABLE "TCRMSUPPORTCALLOPVOLGING"(
   "CCRMSUPPORTCALLOPVOLGING_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CCRMSUPPORTCALLS_FK" INTEGER,
   "CMEDEWERKER" CHARACTER VARYING(10),
   "CMEDEWERKERS_FK" INTEGER,
   "CDATUM" DATE,
   "CINFOOPVOLGING" CHARACTER VARYING(10000),
   "CGETEST" BOOLEAN,
   "CGETESTOK" BOOLEAN
);


CREATE TABLE "TCRMCONTACTPRODUCTEN"(
   "CCRMCONTACTPRODUCTEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CCONTACTEN_FK" INTEGER,
   "CDATUM" DATE,
   "CCRMPRODUCTFAMILIE" CHARACTER VARYING(10),
   "CCRMPRODUCT" CHARACTER VARYING(25),
   "COMSCHRIJVING" CHARACTER VARYING(1024),
   "CAANTAL" FLOAT,
   "CBEDRAG" NUMERIC(10,2),
   "CINFO" CHARACTER VARYING(10000)
);


CREATE TABLE "TCRMCONTACTPRODUCTENHIST"(
   "CCRMCONTACTPRODUCTENHIST_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CCONTACTEN_FK" INTEGER,
   "CDATUM" DATE,
   "CCRMPRODUCTFAMILIE" CHARACTER VARYING(10),
   "CCRMPRODUCT" CHARACTER VARYING(25),
   "COMSCHRIJVING" CHARACTER VARYING(1024),
   "CAANTAL" FLOAT,
   "CBEDRAG" NUMERIC(10,2),
   "CINFO" CHARACTER VARYING(10000)
);


CREATE TABLE "TCRMABONNEMENTTYPES"(
   "CCRMABONNEMENTTYPES_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CCRMABONNEMENTTYPE" CHARACTER VARYING(10),
   "COMSCHRIJVING" CHARACTER VARYING(256),
   "CVERLENGINGSTERMIJN" INTEGER,
   "CVERLENGINGSINTERVAL" INTEGER,
   "CMETVERLENGING" BOOLEAN DEFAULT FALSE,
   "COPZEGTERMIJN" INTEGER,
   "COPZEGINTERVAL" INTEGER,
   "CINTERVAL" INTEGER,
   "CAANTAL" INTEGER,
   "CLOOPTIJD" INTEGER,
   "CLOOPTIJDAANTAL" INTEGER,
   "CISSUPPORTCONTRACT" BOOLEAN DEFAULT FALSE,
   "CMETFACTUURLIJNEN" BOOLEAN DEFAULT FALSE,
   "CBETALINGSVOORWAARDE" CHARACTER VARYING(10),
   "CBETALINGSVOORWAARDEN_FK" INTEGER,
   "CINFO" CHARACTER VARYING(10000),
   "CREACTIETIJD" INTEGER,
   "CCRMPRODUCTFAMILIE" CHARACTER VARYING(10),
   "CCRMPRODUCT" CHARACTER VARYING(25),
   "CTAAL" CHARACTER VARYING(1),
   "CNIETACTIEF" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TCRMABONNEMENTTYPELIJNEN"(
   "CCRMABONNEMENTTYPELIJNEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CCRMABONNEMENTTYPES_FK" INTEGER,
   "CLIJNNUMMER" INTEGER,
   "CARTIKEL" CHARACTER VARYING(25),
   "CARTIKELS_FK" INTEGER,
   "CFACTARTIKELS_FK" INTEGER,
   "COMSCHRIJVING" CHARACTER VARYING(256),
   "CTYPE" INTEGER,
   "CAANTAL" FLOAT,
   "CAANTALPERCENTAGE" FLOAT,
   "CVERKOOPPRIJS" NUMERIC(12,4),
   "CLIJNKORTINGPERCENTAGE" NUMERIC(5,2),
   "CBEDRAG" NUMERIC(10,2)
);


CREATE TABLE "TCRMABONNEMENTEN"(
   "CCRMABONNEMENTEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CINTERNEFIRMAVESTIGING" CHARACTER VARYING(10),
   "CINTERNEFIRMAVESTIGINGEN_FK" INTEGER,
   "CCRMABONNEMENTTYPE" CHARACTER VARYING(10),
   "CCRMABONNEMENTTYPES_FK" INTEGER,
   "CNUMMER" INTEGER,
   "CDATUM" DATE,
   "CVERVALDATUM" DATE,
   "CCONTACTEN_FK" INTEGER,
   "CTERATTENTIEVAN" CHARACTER VARYING(60),
   "CMETFACTUURLIJNEN" BOOLEAN DEFAULT FALSE,
   "CMETVERLENGING" BOOLEAN DEFAULT FALSE,
   "CNIETACTIEF" BOOLEAN DEFAULT FALSE,
   "CGEBLOKKEERD" BOOLEAN DEFAULT FALSE,
   "CISOPGEZEGD" BOOLEAN DEFAULT FALSE,
   "CISOPGEZEGDDATUM" DATE,
   "CFACTCONTACTEN_FK" INTEGER,
   "CLOOPTIJDAANTAL" INTEGER,
   "CBETALINGSVOORWAARDE" CHARACTER VARYING(10),
   "CBETALINGSVOORWAARDEN_FK" INTEGER,
   "CINFO" CHARACTER VARYING(10000),
   "CREACTIETIJD" INTEGER,
   "CDOCUMENTTYPE" CHARACTER VARYING(20),
   "CDOCUMENTTYPES_FK" INTEGER
);


CREATE TABLE "TCRMABONNEMENTLIJNEN"(
   "CCRMABONNEMENTLIJNEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CCRMABONNEMENTEN_FK" INTEGER,
   "CLIJNNUMMER" INTEGER,
   "CARTIKEL" CHARACTER VARYING(25),
   "CARTIKELS_FK" INTEGER,
   "CFACTARTIKELS_FK" INTEGER,
   "COMSCHRIJVING" CHARACTER VARYING(256),
   "CTYPE" INTEGER,
   "CAANTAL" FLOAT,
   "CAANTALPERCENTAGE" FLOAT,
   "CVERKOOPPRIJS" NUMERIC(12,4),
   "CLIJNKORTINGPERCENTAGE" NUMERIC(5,2),
   "CBEDRAG" NUMERIC(10,2)
);


CREATE TABLE "TCRMABONNEMENTFACTUREN"(
   "CCRMABONNEMENTFACTUREN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CCRMABONNEMENTEN_FK" INTEGER,
   "CVERKOPEN_FK" INTEGER,
   "CFACTUREN_FK" INTEGER,
   "CKALENDERJAAR" CHARACTER VARYING(4),
   "CVOLGNUMMER" INTEGER
);


CREATE TABLE "TCRMABONNEMENTCORRECTIES"(
   "CCRMABONNEMENTCORRECTIES_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CCRMABONNEMENTEN_FK" INTEGER,
   "CNUMMER" INTEGER,
   "CDATUM" DATE,
   "CCONTACTEN_FK" INTEGER,
   "CARTIKEL" CHARACTER VARYING(25),
   "COMSCHRIJVING" CHARACTER VARYING(256),
   "CAANTAL" FLOAT,
   "CBEDRAG" NUMERIC(10,2),
   "CINFO" CHARACTER VARYING(10000),
   "CPREFIX" CHARACTER VARYING(10)
);


CREATE TABLE "TPOP3EMAILS"(
   "CPOP3EMAILS_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CRETURNPATH" CHARACTER VARYING(256),
   "CDATE" CHARACTER VARYING(128),
   "CPRIORITY" CHARACTER VARYING(64),
   "CFROM" CHARACTER VARYING(128),
   "CSUBJECT" CHARACTER VARYING(256),
   "CBODY" CLOB,
   "CBODYHTML" CLOB,
   "CDOMAIN" CHARACTER VARYING(128),
   "CVERWERKT" BOOLEAN,
   "CCC" CHARACTER VARYING(1024),
   "CMAILER" CHARACTER VARYING(128)
);


CREATE TABLE "TPOP3EMAILBIJLAGEN"(
   "CPOP3EMAILBIJLAGEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CPOP3EMAILS_FK" INTEGER,
   "CDOCUMENTBLOBBYTES" INTEGER,
   "CDOCUMENTBLOBNAAM" CHARACTER VARYING(512),
   "CDOCUMENTBLOB" BLOB
);


CREATE TABLE "TPOP3EMAILACCOUNTS"(
   "CPOP3EMAILACCOUNTS_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CPOPACCOUNT" CHARACTER VARYING(30),
   "CPOPSERVER" CHARACTER VARYING(30),
   "CMEDEWERKER" CHARACTER VARYING(10),
   "CMEDEWERKERS_FK" INTEGER,
   "CACTIEF" BOOLEAN,
   "CDESTINATION" CHARACTER VARYING(128),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CINTERNEFIRMAVESTIGING" CHARACTER VARYING(10),
   "CINTERNEFIRMAVESTIGINGEN_FK" INTEGER,
   "CCRMWACHTRIJ" CHARACTER VARYING(10),
   "CCRMWACHTRIJEN_FK" INTEGER,
   "CCRMSUPPORTSOORT" CHARACTER VARYING(10),
   "CCRMSUPPORTSOORTEN_FK" INTEGER,
   "CPOPPASSWORD" CHARACTER VARYING(128)
);


CREATE TABLE "TCRMKEUZELIJSTEN"(
   "CCRMKEUZELIJSTEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CCRMKEUZE" CHARACTER VARYING(15),
   "CVOLGNUMMER" INTEGER,
   "COMSCHRIJVING" CHARACTER VARYING(128) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "CNIETACTIEF" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TCRMOORSPRONGEN"(
   "CCRMOORSPRONGEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CCRMOORSPRONG" CHARACTER VARYING(10),
   "COMSCHRIJVING" CHARACTER VARYING(128) COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE",
   "CNIETACTIEF" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TCRMSUBOORSPRONGEN"(
   "CCRMSUBOORSPRONGEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CCRMOORSPRONGEN_FK" INTEGER,
   "CCRMSUBOORSPRONG" CHARACTER VARYING(10),
   "COMSCHRIJVING" CHARACTER VARYING(128),
   "CNIETACTIEF" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TCRMAFGESLOTENSTATUSSEN"(
   "CCRMAFGESLOTENSTATUSSEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CCRMAFGESLOTENSTATUS" CHARACTER VARYING(10),
   "CVOLGNUMMER" INTEGER,
   "COMSCHRIJVING" CHARACTER VARYING(128),
   "CNIETACTIEF" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TCRMVERKOOPFASEN"(
   "CCRMVERKOOPFASEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CCRMVERKOOPFASE" CHARACTER VARYING(10),
   "CVOLGNUMMER" INTEGER,
   "COMSCHRIJVING" CHARACTER VARYING(128),
   "CNIETACTIEF" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TCRMVERKOOPKANSSOORTEN"(
   "CCRMVERKOOPKANSSOORTEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CCRMVERKOOPKANSSOORT" CHARACTER VARYING(10),
   "COMSCHRIJVING" CHARACTER VARYING(128),
   "CNIETACTIEF" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TCRMVERKOOPKANSSOORTFASEN"(
   "CCRMVERKOOPKANSSOORTFASEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CCRMVERKOOPKANSSOORTEN_FK" INTEGER,
   "CCRMVERKOOPFASEN_FK" INTEGER,
   "CVOLGNUMMER" INTEGER
);


CREATE TABLE "TCONTACTINTERESSES"(
   "CCONTACTINTERESSES_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CCONTACTEN_FK" INTEGER,
   "CINTERESSE" CHARACTER VARYING(128)
);


CREATE TABLE "TCONTACTHUIDIGEPRODUCTEN"(
   "CCONTACTHUIDIGEPRODUCTEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CCONTACTEN_FK" INTEGER,
   "CHUIDIGPRODUCT" CHARACTER VARYING(128),
   "CKALENDERJAAR" CHARACTER VARYING(4)
);


CREATE TABLE "TCRMOPLEIDINGTYPES"(
   "CCRMOPLEIDINGTYPES_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CCRMOPLEIDINGTYPE" CHARACTER VARYING(10),
   "COMSCHRIJVING" CHARACTER VARYING(128),
   "CNIETACTIEF" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TCRMOPLEIDINGEN"(
   "CCRMOPLEIDINGEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CCRMOPLEIDING" CHARACTER VARYING(25),
   "CCRMOPLEIDINGTYPE" CHARACTER VARYING(10),
   "CCRMOPLEIDINGTYPES_FK" INTEGER,
   "CAANTALMAXIMUM" INTEGER DEFAULT 0,
   "CADRES1" CHARACTER VARYING(50),
   "CAFGESLOTEN" BOOLEAN DEFAULT FALSE,
   "CBETALEND" BOOLEAN DEFAULT FALSE,
   "CDOCUMENTPAD" CHARACTER VARYING(512),
   "CDOCUMENTTYPE" CHARACTER VARYING(10),
   "CDOCUMENTTYPES_FK" INTEGER,
   "CGEMEENTE" CHARACTER VARYING(50),
   "CDATUM" DATE,
   "CDATUMTOT" DATE,
   "CUURVAN" TIMESTAMP,
   "CUURTOT" TIMESTAMP,
   "CUURVAN2" TIMESTAMP,
   "CUURTOT2" TIMESTAMP,
   "COMSCHRIJVING" CHARACTER VARYING(256),
   "CINFO" CHARACTER VARYING(10000),
   "CINFOINTERN" CHARACTER VARYING(10000),
   "CLAND" CHARACTER VARYING(2),
   "CMEDEWERKER" CHARACTER VARYING(10),
   "CMEDEWERKERS_FK" INTEGER,
   "CVERTEGENWOORDIGER" CHARACTER VARYING(10),
   "CVERTEGENWOORDIGERS_FK" INTEGER,
   "CMUNT" CHARACTER VARYING(3),
   "CMUNTEN_FK" INTEGER,
   "CNAAM1" CHARACTER VARYING(50),
   "CPOSTCODE" CHARACTER VARYING(10),
   "CBEDRAGEXCL" NUMERIC(10,2),
   "CBEDRAGINCL" NUMERIC(10,2),
   "CTAALOMSCHRIJVING" CHARACTER VARYING(50),
   "CPRIJS" NUMERIC(10,2) DEFAULT 0,
   "CINCLBTW" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TCRMOPLEIDINGDEELNEMERS"(
   "CCRMOPLEIDINGDEELNEMERS_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CCRMOPLEIDINGEN_FK" INTEGER,
   "CAANTAL" INTEGER DEFAULT 0,
   "CAFWEZIG" BOOLEAN DEFAULT FALSE,
   "CBEDRAG" NUMERIC(10,2),
   "CBETAALD" BOOLEAN DEFAULT FALSE,
   "CBEVESTIGD" BOOLEAN DEFAULT FALSE,
   "CCONTACT" CHARACTER VARYING(10),
   "CCONTACTEN_FK" INTEGER,
   "CCONTACTPERSONEN_FK" INTEGER,
   "CEMAILADRES" CHARACTER VARYING(128),
   "CDATUMBESTELD" DATE,
   "CDATUMVERSTUURD" DATE,
   "CDATUMBEVESTIGD" DATE,
   "CINFOINTERN" CHARACTER VARYING(1024),
   "CKOERS" NUMERIC(12,6),
   "CKORTINGPERCENTAGE" NUMERIC(5,2),
   "CMUNT" CHARACTER VARYING(3),
   "CMUNTEN_FK" INTEGER,
   "CNAAM1" CHARACTER VARYING(50),
   "CNAAMCONTACTPERSOON" CHARACTER VARYING(50),
   "CPRIJS" NUMERIC(10,2) DEFAULT 0,
   "CVERONTSCHULDIGD" BOOLEAN DEFAULT FALSE,
   "CVERSTUURD" BOOLEAN DEFAULT FALSE,
   "CBETALEND" BOOLEAN DEFAULT FALSE,
   "CINCLBTW" BOOLEAN DEFAULT FALSE,
   "CAANWEZIG" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TXCRMOPLEIDINGDEELNEMERS"(
   "CXCRMOPLEIDINGDEELNEMERS_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CCRMOPLEIDING" CHARACTER VARYING(10),
   "CAANTAL" INTEGER DEFAULT 0,
   "CBEDRAG" NUMERIC(10,2),
   "CBETAALD" BOOLEAN DEFAULT FALSE,
   "CCONTACT" CHARACTER VARYING(10),
   "CEMAILADRES" CHARACTER VARYING(128),
   "CDATUMBESTELD" DATE,
   "CKOERS" NUMERIC(12,6),
   "CKORTINGPERCENTAGE" NUMERIC(5,2),
   "CMUNT" CHARACTER VARYING(3),
   "CNAAM1" CHARACTER VARYING(50),
   "CNAAMCONTACTPERSOON" CHARACTER VARYING(50),
   "CPRIJS" NUMERIC(10,2) DEFAULT 0,
   "CBETALEND" BOOLEAN DEFAULT FALSE,
   "CINCLBTW" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TCRMVERKOOPKANSEN"(
   "CCRMVERKOOPKANSEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CINTERNEFIRMAVESTIGING" CHARACTER VARYING(10),
   "CINTERNEFIRMAVESTIGINGEN_FK" INTEGER,
   "CDOCUMENTTYPE" CHARACTER VARYING(20),
   "CDOCUMENTTYPES_FK" INTEGER,
   "CNUMMER" INTEGER,
   "CCONTACTEN_FK" INTEGER,
   "CCONTACTPERSONEN_FK" INTEGER,
   "CDATUM" DATE,
   "CNAAMCONTACTPERSOON" CHARACTER VARYING(50),
   "CCRMVERKOOPKANSSOORT" CHARACTER VARYING(10),
   "CCRMVERKOOPKANSSOORTEN_FK" INTEGER,
   "COMSCHRIJVING" CHARACTER VARYING(128),
   "CINFOINTERN" CHARACTER VARYING(10000),
   "CTERMIJN" INTEGER,
   "CPRIORITEIT" INTEGER,
   "CCRMOORSPRONG" CHARACTER VARYING(10),
   "CCRMOORSPRONGEN_FK" INTEGER,
   "CCRMSUBOORSPRONG" CHARACTER VARYING(10),
   "CCRMSUBOORSPRONGEN_FK" INTEGER,
   "CMEDEWERKER" CHARACTER VARYING(10),
   "CMEDEWERKERS_FK" INTEGER,
   "CCRMVERKOOPFASE" CHARACTER VARYING(10),
   "CCRMVERKOOPFASEN_FK" INTEGER,
   "CCRMAFGESLOTENSTATUS" CHARACTER VARYING(10),
   "CCRMAFGESLOTENSTATUSSEN_FK" INTEGER,
   "CDATUMAFGESLOTEN" DATE,
   "CAFGESLOTEN" BOOLEAN DEFAULT FALSE,
   "CINFOAFGESLOTEN" CHARACTER VARYING(10000),
   "CBEDRAGBUDGET" NUMERIC(12,2),
   "CBEDRAGVERWACHT" NUMERIC(12,2),
   "CBEDRAGGEREALISEERD" NUMERIC(12,2),
   "CCRMVERKOOPKANSPERCENTAGE" NUMERIC(5,2)
);


CREATE TABLE "TCRMVERKOOPKANSBIJLAGEN"(
   "CCRMVERKOOPKANSBIJLAGEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CCRMVERKOOPKANSEN_FK" INTEGER,
   "CTYPE" CHARACTER VARYING(10),
   "CTYPENUMMER" INTEGER,
   "CDOCUMENT_FK" INTEGER,
   "CDOCUMENTBLOBBYTES" INTEGER,
   "CDOCUMENTBLOBNAAM" CHARACTER VARYING(512),
   "CDOCUMENTPAD" CHARACTER VARYING(512),
   "CDOCUMENTTYPE" CHARACTER VARYING(20),
   "CDOCUMENTTYPES_FK" INTEGER,
   "CONDERWERP" CHARACTER VARYING(128),
   "CDOCUMENTBLOB" BLOB,
   "CINFO" CLOB,
   "CNUMMER" CHARACTER VARYING(10)
);


CREATE TABLE "TARTIKELINFIRMA"(
   "CARTIKELINFIRMA_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CARTIKELS_FK" INTEGER,
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CLAATSTEAANKOOPPRIJS" NUMERIC(12,4) DEFAULT 0,
   "CLAATSTEAANKOOPKOSTEN" NUMERIC(12,4) DEFAULT 0,
   "CGEMAANKOOPPRIJS" NUMERIC(10,2) DEFAULT 0,
   "CEERSTEAANKOOP" DATE,
   "CEERSTEVERKOOP" DATE,
   "CLAATSTEAANKOOP" DATE,
   "CLAATSTEVERKOOP" DATE,
   "CAANKOOPREKENING" CHARACTER VARYING(10),
   "CAANKOOPREKENINGEN_FK" INTEGER
);


CREATE TABLE "TFLOW"(
   "CFLOW_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10)
);


CREATE TABLE "TFLOWORDER"(
   "CFLOWORDER_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10)
);


CREATE TABLE "TCRMVERKOOPKANSFASEN"(
   "CCRMVERKOOPKANSFASEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CCRMVERKOOPKANSEN_FK" INTEGER,
   "CCRMVERKOOPFASEN_FK" INTEGER,
   "CCRMVERKOOPFASE" CHARACTER VARYING(10),
   "CDATUM" DATE
);


CREATE TABLE "TKLANTKAARTEN"(
   "CKLANTKAARTEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CCONTACTEN_FK" INTEGER,
   "CNUMMER" INTEGER,
   "CNUMMERBARCODE" CHARACTER VARYING(25),
   "CAFGESLOTEN" BOOLEAN DEFAULT FALSE,
   "CVERREKEND" BOOLEAN DEFAULT FALSE,
   "CDATUMAFGESLOTEN" TIMESTAMP,
   "CDATUMVERREKEND" TIMESTAMP,
   "CDATUM" DATE,
   "CAANTALVERKOPEN" INTEGER,
   "CBEDRAGOMZET" NUMERIC(12,2),
   "CBEDRAG" NUMERIC(12,2),
   "CBEDRAGVERREKEND" NUMERIC(12,2),
   "CAANTALARTIKELEN" FLOAT DEFAULT 0,
   "CVERVALDATUM" DATE
);


CREATE TABLE "TKLANTKAARTLIJNEN"(
   "CKLANTKAARTLIJNEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CKLANTKAARTEN_FK" INTEGER,
   "CDATUM" DATE,
   "CBEDRAGOMZET" NUMERIC(12,2),
   "CPERCENTAGE" NUMERIC(5,2),
   "CBEDRAG" NUMERIC(12,2),
   "CVERKOPEN_FK" INTEGER,
   "CNUMMER" CHARACTER VARYING(10),
   "CINFO" CHARACTER VARYING(1024),
   "CAANTALARTIKELEN" FLOAT DEFAULT 0
);


CREATE TABLE "TLICENTIEIPAD"(
   "CLICENTIEIPAD_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CREGISTRATIECODE" CHARACTER VARYING(128),
   "CREGISTRATIECONTROLECODE" CHARACTER VARYING(60)
);


CREATE TABLE "TLICENTIEIPADS"(
   "CLICENTIEIPADS_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CDEVICEID" CHARACTER VARYING(24),
   "CDEVICENAME" CHARACTER VARYING(128),
   "CNIETACTIEF" BOOLEAN
);


CREATE TABLE "TEMAILTEKSTEN"(
   "CEMAILTEKSTEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CDOCUMENTTYPE" CHARACTER VARYING(20),
   "CDOCUMENTTYPES_FK" INTEGER,
   "CDAGBOEKSOORT" INTEGER,
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CINTERNEFIRMAVESTIGING" CHARACTER VARYING(10),
   "CINTERNEFIRMAVESTIGINGEN_FK" INTEGER,
   "COMSCHRIJVING1" CHARACTER VARYING(128),
   "COMSCHRIJVING2" CHARACTER VARYING(128),
   "COMSCHRIJVING3" CHARACTER VARYING(128),
   "COMSCHRIJVING4" CHARACTER VARYING(128),
   "CINFO1" CHARACTER VARYING(1024),
   "CINFO2" CHARACTER VARYING(1024),
   "CINFO3" CHARACTER VARYING(1024),
   "CINFO4" CHARACTER VARYING(1024),
   "CONDERWERP1" CHARACTER VARYING(128),
   "CONDERWERP2" CHARACTER VARYING(128),
   "CONDERWERP3" CHARACTER VARYING(128),
   "CONDERWERP4" CHARACTER VARYING(128)
);


CREATE TABLE "TMEDEWERKERINFIRMA"(
   "CMEDEWERKERINFIRMA_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CMEDEWERKER" CHARACTER VARYING(10),
   "CMEDEWERKERS_FK" INTEGER,
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CEMAILADRES" CHARACTER VARYING(128)
);


CREATE TABLE "TLIBRARIES"(
   "CLIBRARIES_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CNAAM" CHARACTER VARYING(50),
   "CDOCUMENTBLOB" BLOB,
   "CDOCUMENTBLOBBYTES" INTEGER
);


CREATE TABLE "TVOLUMEMAPPING"(
   "CVOLUMEMAPPING_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CPADVOLUMEX" CHARACTER VARYING(32),
   "CPADVOLUMEN" CHARACTER VARYING(32)
);


CREATE TABLE "TBOEKINGBIJLAGEN"(
   "CBOEKINGBIJLAGEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CBOEKINGEN_FK" INTEGER,
   "CPADVOLUME" CHARACTER VARYING(32),
   "CPADFOLDERVAST" CHARACTER VARYING(128),
   "CPADFOLDERVARIABEL" CHARACTER VARYING(128),
   "CBESTAND" CHARACTER VARYING(128)
);


CREATE TABLE "TDOMMANDATEN"(
   "CDOMMANDATEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CCONTACTEN_FK" INTEGER,
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CREFERTE" CHARACTER VARYING(35),
   "CCONTRACTID" CHARACTER VARYING(35),
   "CCONTRACTOMSCHRIJVING" CHARACTER VARYING(256),
   "CTYPEBETALING" BOOLEAN DEFAULT TRUE,
   "CDATUM" DATE,
   "CBANKREKENINGNUMMER" CHARACTER VARYING(42),
   "CBANKBIC" CHARACTER VARYING(11),
   "CPLAATS" CHARACTER VARYING(50),
   "CNIETACTIEF" BOOLEAN DEFAULT FALSE,
   "CREFERTEORIGINEEL" CHARACTER VARYING(35),
   "CBANKREKENINGNUMMERORIGINEEL" CHARACTER VARYING(42),
   "CBANKBICORIGINEEL" CHARACTER VARYING(11),
   "CRCUR" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TMAILINGCODES"(
   "CMAILINGCODES_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CMAILINGCODE" CHARACTER VARYING(20),
   "COMSCHRIJVING" CHARACTER VARYING(256),
   "CNIETACTIEF" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TCONTACTPERSOONMAILINGCODES"(
   "CCONTACTPERSOONMAILINGCODES_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CMAILINGCODE" CHARACTER VARYING(20),
   "CMAILINGCODES_FK" INTEGER,
   "CCONTACTEN_FK" INTEGER,
   "CCONTACTPERSONEN_FK" INTEGER
);


CREATE TABLE "TFACTVERSTUURD"(
   "CFACTVERSTUURD_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CFACTUREN_FK" INTEGER,
   "CDATUM" DATE,
   "CEMAILADRES" CHARACTER VARYING(128),
   "CPADVOLUME" CHARACTER VARYING(32),
   "CPADFOLDERVAST" CHARACTER VARYING(128),
   "CPADFOLDERVARIABEL" CHARACTER VARYING(128),
   "CBESTAND" CHARACTER VARYING(128),
   "CBANKREKENINGNUMMER" CHARACTER VARYING(42)
);


CREATE TABLE "TARTIKELKLEURMAAT"(
   "CARTIKELKLEURMAAT_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CARTIKELS_FK" INTEGER,
   "CKLEUR" CHARACTER VARYING(10),
   "CMAAT" CHARACTER VARYING(10),
   "CARTIKELKLEURMAAT" CHARACTER VARYING(50)
);


CREATE TABLE "TARTIKELKLEURMAATPRIJZEN"(
   "CARTIKELKLEURMAATPRIJZEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CARTIKELS_FK" INTEGER,
   "CKLEUR" CHARACTER VARYING(10),
   "CMAAT" CHARACTER VARYING(10),
   "CARTIKELPRIJZEN_FK" INTEGER,
   "COPERATOR" CHARACTER VARYING(1),
   "CVERKOOPPRIJS" NUMERIC(12,4)
);


CREATE TABLE "TARTIKELKLEURMAATLEVERANCIERS"(
   "CARTIKELKLEURMAATLEVERANCIERS_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CARTIKELS_FK" INTEGER,
   "CKLEUR" CHARACTER VARYING(10),
   "CMAAT" CHARACTER VARYING(10),
   "CARTIKELLEVERANCIERS_FK" INTEGER,
   "COPERATOR" CHARACTER VARYING(1),
   "CAANKOOPPRIJS" NUMERIC(12,4)
);


CREATE TABLE "TVERKOOPVERSTUURD"(
   "CVERKOOPVERSTUURD_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CVERKOPEN_FK" INTEGER,
   "CDATUM" DATE,
   "CEMAILADRES" CHARACTER VARYING(128),
   "CPADVOLUME" CHARACTER VARYING(32),
   "CPADFOLDERVAST" CHARACTER VARYING(128),
   "CPADFOLDERVARIABEL" CHARACTER VARYING(128),
   "CBESTAND" CHARACTER VARYING(128),
   "CBANKREKENINGNUMMER" CHARACTER VARYING(42)
);


CREATE TABLE "TVERKOOPSTATUSSEN"(
   "CVERKOOPSTATUSSEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CDOCUMENTTYPE" CHARACTER VARYING(20),
   "CDOCUMENTTYPES_FK" INTEGER,
   "CLIJNNUMMER" INTEGER,
   "CVERKOOPSTATUS" CHARACTER VARYING(10),
   "COMSCHRIJVING1" CHARACTER VARYING(30),
   "COMSCHRIJVING2" CHARACTER VARYING(30),
   "COMSCHRIJVING3" CHARACTER VARYING(30),
   "COMSCHRIJVING4" CHARACTER VARYING(30)
);


CREATE TABLE "TAANKOOPLIJNAFMETINGEN"(
   "CAANKOOPLIJNAFMETINGEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CAANKOOPLIJNEN_FK" INTEGER,
   "CAANTAL" FLOAT,
   "CLENGTE" FLOAT,
   "CBREEDTE" FLOAT,
   "CHOOGTE" FLOAT,
   "CTOTAAL" FLOAT
);


CREATE TABLE "TPROJECTGROEPEN"(
   "CPROJECTGROEPEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CPROJECTGROEP" CHARACTER VARYING(10),
   "COMSCHRIJVING" CHARACTER VARYING(30),
   "CNIETACTIEF" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TPROJECTGROEPENPROJECT"(
   "CPROJECTGROEPENPROJECT_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CPROJECTEN_FK" INTEGER,
   "CPROJECTGROEPEN_FK" INTEGER,
   "CWAARDE" CHARACTER VARYING(10)
);


CREATE TABLE "TMEDEWERKEROFFICE365"(
   "CMEDEWERKEROFFICE365_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CMEDEWERKER" CHARACTER VARYING(10),
   "CMEDEWERKERS_FK" INTEGER,
   "CBEARERTOKEN" CHARACTER VARYING(8192),
   "CREFRESHTOKEN" CHARACTER VARYING(4096),
   "COFFICEID" CHARACTER VARYING(64),
   "CEVENTDELTAKEY" CHARACTER VARYING(512),
   "CEMAIL" CHARACTER VARYING(265),
   "CEVENTSYNCSTARTDATE" TIMESTAMP,
   "CEVENTSYNCENDDATE" TIMESTAMP
);


CREATE TABLE "TPRESTATIESOORTGROEPEN"(
   "CPRESTATIESOORTGROEPEN_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CPRESTATIESOORTGROEP" CHARACTER VARYING(25),
   "COMSCHRIJVING1" CHARACTER VARYING(128),
   "COMSCHRIJVING2" CHARACTER VARYING(128),
   "COMSCHRIJVING3" CHARACTER VARYING(128),
   "COMSCHRIJVING4" CHARACTER VARYING(128),
   "CNIETACTIEF" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TCONTACTARTIKELS"(
   "CCONTACTARTIKELS_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CCONTACTEN_FK" INTEGER,
   "CARTIKELS_FK" INTEGER,
   "CARTIKEL" CHARACTER VARYING(25),
   "CKLEUR" CHARACTER VARYING(10),
   "CMAAT" CHARACTER VARYING(10),
   "CLAATSTEVERKOOP" DATE
);


CREATE TABLE "TARTIKELLEEGGOED"(
   "CARTIKELLEEGGOED_PK" INTEGER,
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CARTIKELS_FK" INTEGER,
   "CARTIKELLEEGGOED_FK" INTEGER,
   "CARTIKELLEEGGOED" CHARACTER VARYING(25),
   "CAANTAL" NUMERIC(10,2) DEFAULT 0
);


CREATE TABLE "TEDIMSG"(
   "CEDIMSG_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CEDIMSG" CHARACTER VARYING(25),
   "COMSCHRIJVING" CHARACTER VARYING(128)
);


CREATE TABLE "TEDITEMPLATES"(
   "CEDITEMPLATES_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CEDIMSG" CHARACTER VARYING(25),
   "CEDIMSG_FK" INTEGER,
   "CINFOHEADER" CHARACTER VARYING(10000),
   "CINFOLINE" CHARACTER VARYING(2048),
   "CINFOLINECHARGE" CHARACTER VARYING(1024),
   "CINFOLINESN" CHARACTER VARYING(1024),
   "CINFOLINELOT" CHARACTER VARYING(1024),
   "CINFOSUMMARY" CHARACTER VARYING(1024),
   "CINFOSUMMARYVAT" CHARACTER VARYING(1024),
   "CINFOSUMMARYCHARGE" CHARACTER VARYING(1024)
);


CREATE TABLE "TCONTACTROLEDI"(
   "CCONTACTROLEDI_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CCONTACTROLLEN_FK" INTEGER,
   "CEDIMSG" CHARACTER VARYING(25),
   "CEDIMSG_FK" INTEGER,
   "CACTIEF" BOOLEAN DEFAULT FALSE
);


CREATE TABLE "TARTIKELKLANT"(
   "CARTIKELKLANT_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CINTERNEFIRMAARTIKELS" CHARACTER VARYING(10),
   "CARTIKEL" CHARACTER VARYING(25),
   "CARTIKELS_FK" INTEGER,
   "CCONTACT" CHARACTER VARYING(10),
   "CCONTACTEN_FK" INTEGER,
   "CARTIKELKLANT" CHARACTER VARYING(25),
   "COMSCHRIJVING" CHARACTER VARYING(256)
);


CREATE TABLE "TPEPOLTRACKING"(
   "CPEPOLTRACKING_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CPEPOL_ID" CHARACTER VARYING(100),
   "CVERKOPEN_FK" INTEGER,
   "CTRANSMISSION_ID" CHARACTER VARYING(100),
   "CSTATUS" CHARACTER VARYING(100),
   "CSTATUSREASON" CHARACTER VARYING(100),
   "CUSERCLOSURE" BOOLEAN DEFAULT FALSE,
   "CUBLREFERENCE" CHARACTER VARYING(100),
   "CSUPPLIERREFERENCE" CHARACTER VARYING(100),
   "CCUSTOMERREFERENCE" CHARACTER VARYING(100)
);

CREATE TABLE "TKAARTMERKIDENTIFIERS"(
   "CKAARTMERKIDENTIFIERS_PK" INTEGER,
   "CCREATIEDATUM" TIMESTAMP DEFAULT CAST(CURRENT_TIMESTAMP(6) AS TIMESTAMP(6)),
   "CCREATIEGEBRUIKER" CHARACTER VARYING(10) DEFAULT CURRENT_USER,
   "CWIJZIGDATUM" TIMESTAMP,
   "CWIJZIGGEBRUIKER" CHARACTER VARYING(10),
   "CMERKID" CHARACTER VARYING(10),
   "CMERKOMSCHRIJVING" CHARACTER VARYING(256),
   "CINTERNEFIRMA" CHARACTER VARYING(10),
   "CINTERNEFIRMAS_FK" INTEGER,
   "CBETAALWIJZEN_FK" INTEGER
);


CREATE VIEW "BI_TEST"(
   "CNAAM1"
) AS
  SELECT "CNAAM1" FROM "TCONTACTEN";

CREATE VIEW "VIEW_NEEDED_BY_FBODBC"(
   "COLUMN_PK",
   "TABLE_PK",
   "COLUMN_NAME",
   "IS_NULLABLE",
   "ORDINAL_POSITION",
   "COLUMN_DEFAULT"
) AS
  SELECT "COLUMN_PK", "TABLE_PK", "COLUMN_NAME", "IS_NULLABLE", "ORDINAL_POSITION", "COLUMN_DEFAULT" FROM "DEFINITION_SCHEMA"."COLUMNS";

CREATE VIEW "DATATYPES"(
   "TABLE_NAME",
   "COLUMN_NAME",
   "DATA_TYPE"
) AS
  SELECT "T3"."TABLE_NAME", "T2"."COLUMN_NAME", "T1"."DATA_TYPE" FROM "INFORMATION_SCHEMA"."DATA_TYPE_DESCRIPTOR" AS "T1","INFORMATION_SCHEMA"."COLUMNS" AS "T2","INFORMATION_SCHEMA"."TABLES" AS "T3","INFORMATION_SCHEMA"."SCHEMATA" AS "T4" WHERE ("T3"."SCHEMA_PK"="T4"."SCHEMA_PK") AND ("T4"."SCHEMA_NAME"='_SYSTEM') AND ("T1"."COLUMN_NAME_PK"="T2"."COLUMN_PK") AND ("T2"."TABLE_PK"="T3"."TABLE_PK");

CREATE VIEW "PRIM_KEYS"(
   "TABLE_NAME",
   "COLUMN_NAME",
   "CONSTRAINT_TYPE"
) AS
  SELECT "T4"."TABLE_NAME", "T1"."COLUMN_NAME", "T3"."CONSTRAINT_TYPE" FROM "INFORMATION_SCHEMA"."COLUMNS" AS "T1","INFORMATION_SCHEMA"."KEY_COLUMN_USAGE" AS "T2","INFORMATION_SCHEMA"."TABLE_CONSTRAINTS" AS "T3","INFORMATION_SCHEMA"."TABLES" AS "T4","INFORMATION_SCHEMA"."SCHEMATA" AS "T5" WHERE ("T4"."SCHEMA_PK"="T5"."SCHEMA_PK") AND ("T5"."SCHEMA_NAME"='_SYSTEM') AND ("T2"."COLUMN_PK"="T1"."COLUMN_PK") AND ("T2"."CONSTRAINT_NAME_PK"="T3"."CONSTRAINT_NAME_PK") AND ("T1"."TABLE_PK"="T4"."TABLE_PK") AND ("T3"."CONSTRAINT_TYPE"='PRIMARY KEY');

CREATE VIEW "TCONTACTPERSONEN_EXT"(
   "CCONTACTPERSONEN_PK",
   "CCREATIEDATUM",
   "CCREATIEGEBRUIKER",
   "CWIJZIGDATUM",
   "CWIJZIGGEBRUIKER",
   "CNAAM",
   "CAFDELING",
   "CCONTACTEN_FK",
   "CEMAILADRES",
   "CFAX",
   "CFUNCTIE",
   "CGEBOORTEDATUM",
   "CINFO",
   "CMOBILE",
   "CTELEFOON",
   "CVERJAARDAG",
   "CTAAL",
   "CAANSPREEKTITEL",
   "CAANHEF",
   "CGESLACHT",
   "CVOORNAAM",
   "CTELEFOONPRIVE",
   "CSELECTIECODE",
   "CNIETACTIEF",
   "CGEENMAILING",
   "CZOEKNAAM",
   "CAGE"
) AS
  SELECT "TCONTACTPERSONEN"."CCONTACTPERSONEN_PK", "TCONTACTPERSONEN"."CCREATIEDATUM", "TCONTACTPERSONEN"."CCREATIEGEBRUIKER", "TCONTACTPERSONEN"."CWIJZIGDATUM", "TCONTACTPERSONEN"."CWIJZIGGEBRUIKER", "TCONTACTPERSONEN"."CNAAM", "TCONTACTPERSONEN"."CAFDELING", "TCONTACTPERSONEN"."CCONTACTEN_FK", "TCONTACTPERSONEN"."CEMAILADRES", "TCONTACTPERSONEN"."CFAX", "TCONTACTPERSONEN"."CFUNCTIE", "TCONTACTPERSONEN"."CGEBOORTEDATUM", "TCONTACTPERSONEN"."CINFO", "TCONTACTPERSONEN"."CMOBILE", "TCONTACTPERSONEN"."CTELEFOON", "TCONTACTPERSONEN"."CVERJAARDAG", "TCONTACTPERSONEN"."CTAAL", "TCONTACTPERSONEN"."CAANSPREEKTITEL", "TCONTACTPERSONEN"."CAANHEF", "TCONTACTPERSONEN"."CGESLACHT", "TCONTACTPERSONEN"."CVOORNAAM", "TCONTACTPERSONEN"."CTELEFOONPRIVE", "TCONTACTPERSONEN"."CSELECTIECODE", "TCONTACTPERSONEN"."CNIETACTIEF", "TCONTACTPERSONEN"."CGEENMAILING", "TCONTACTPERSONEN"."CZOEKNAAM", CAST((CAST(CURRENT_DATE AS DATE)-CAST("CGEBOORTEDATUM" AS DATE))/365.25/24/60/60 AS DECIMAL(4,0)) AS "CAGE" FROM "TCONTACTPERSONEN";

CREATE PROCEDURE "SETSTATUSAANKOOP"( IN :"PK" INTEGER) 
BEGIN
DECLARE "CDOCUMENTTYPES_FK" INT;
DECLARE "CSTATUS" INT; 
DECLARE "CMINSTATUS" INT; 
DECLARE "CMAXSTATUS" INT; 
DECLARE "CAANTAL" FLOAT(19); 
DECLARE "CAANTALVERWERKT" FLOAT(19); 
DECLARE "CAANKOOPLIJNEN_PK" INT; 
DECLARE "CBEDRAG" NUMERIC(12,2); 
DECLARE "CNOEMER" NUMERIC(12,2); 
DECLARE "CTELLER" NUMERIC(12,2); 
DECLARE "CPERCENTAGE" NUMERIC(12,2); 
DECLARE "CAFGESLOTEN" BOOLEAN; 
DECLARE "CMETBEDRAGEN" BOOLEAN; 
DECLARE "C_CRSR" CURSOR FOR SELECT "CAANKOOPLIJNEN_PK", "CSTATUS", "CAANTAL", "CAANTALVERWERKT", "CBEDRAG" FROM "TAANKOOPLIJNEN" WHERE ("CAANKOPEN_FK"=:"PK") AND ("CBEDRAG" IS NOT NULL) FOR READ ONLY ; 
SET :"CDOCUMENTTYPES_FK"=(SELECT "CDOCUMENTTYPES_FK" FROM "TAANKOPEN" WHERE "CAANKOPEN_PK"=:"PK"); 
SET :"CNOEMER"=0; 
SET :"CTELLER"=0; 
SET :"CMINSTATUS"=100; 
SET :"CMAXSTATUS"=0; 
SET :"CMETBEDRAGEN"=TRUE; 
OPEN "C_CRSR"; 
SET :"CAANKOOPLIJNEN_PK"=CAST(NULL AS INT); 
FETCH NEXT  FROM "C_CRSR" INTO :"CAANKOOPLIJNEN_PK", :"CSTATUS", :"CAANTAL", :"CAANTALVERWERKT", :"CBEDRAG"; 
WHILE :"CAANKOOPLIJNEN_PK" IS NOT NULL  IF :"CAANTALVERWERKT"<>0 THEN SET :"CSTATUS"=99; END IF; IF :"CSTATUS"<:"CMINSTATUS" THEN SET :"CMINSTATUS"=:"CSTATUS"; END IF; IF :"CSTATUS">:"CMAXSTATUS" THEN SET :"CMAXSTATUS"=:"CSTATUS"; END IF; IF :"CBEDRAG"=0 THEN SET :"CMETBEDRAGEN"=FALSE; END IF; SET :"CAANKOOPLIJNEN_PK"=CAST(NULL AS INT); FETCH NEXT  FROM "C_CRSR" INTO :"CAANKOOPLIJNEN_PK", :"CSTATUS", :"CAANTAL", :"CAANTALVERWERKT", :"CBEDRAG"; END WHILE; 
CLOSE "C_CRSR"; 
OPEN "C_CRSR"; 
SET :"CAANKOOPLIJNEN_PK"=CAST(NULL AS INT); 
FETCH NEXT  FROM "C_CRSR" INTO :"CAANKOOPLIJNEN_PK", :"CSTATUS", :"CAANTAL", :"CAANTALVERWERKT", :"CBEDRAG"; 
WHILE :"CAANKOOPLIJNEN_PK" IS NOT NULL  IF :"CAANTALVERWERKT"<>0 THEN SET :"CSTATUS"=99; END IF; IF :"CAANTAL"=0 THEN SET :"CAANTAL"=1; END IF; IF :"CMETBEDRAGEN"=TRUE THEN SET :"CNOEMER"=(:"CNOEMER")+(ABS(:"CBEDRAG")); ELSE SET :"CNOEMER"=(:"CNOEMER")+(ABS(:"CAANTAL")); END IF; IF :"CMAXSTATUS"=:"CSTATUS" THEN IF :"CSTATUS"=99 THEN IF :"CAANTALVERWERKT">:"CAANTAL" THEN SET :"CAANTALVERWERKT"=:"CAANTAL"; END IF; IF :"CAANTALVERWERKT"=0 THEN SET :"CAANTALVERWERKT"=1; END IF; IF :"CMETBEDRAGEN"=TRUE THEN SET :"CTELLER"=(:"CTELLER")+(ABS(((:"CAANTALVERWERKT")/(:"CAANTAL"))*(:"CBEDRAG"))); ELSE SET :"CTELLER"=(:"CTELLER")+(ABS(:"CAANTALVERWERKT")); END IF; ELSE IF :"CMETBEDRAGEN"=TRUE THEN SET :"CTELLER"=(:"CTELLER")+(ABS(:"CBEDRAG")); ELSE SET :"CTELLER"=(:"CTELLER")+(ABS(:"CAANTAL")); END IF; END IF; END IF; SET :"CAANKOOPLIJNEN_PK"=CAST(NULL AS INT); FETCH NEXT  FROM "C_CRSR" INTO :"CAANKOOPLIJNEN_PK", :"CSTATUS", :"CAANTAL", :"CAANTALVERWERKT", :"CBEDRAG"; END WHILE; 
CLOSE "C_CRSR"; 
IF :"CTELLER"=:"CNOEMER" THEN SET :"CPERCENTAGE"=100; ELSE IF :"CNOEMER"=0 THEN SET :"CNOEMER"=1; END IF; SET :"CPERCENTAGE"=CAST(((:"CTELLER")/(:"CNOEMER"))*100 AS NUMERIC(10,2)); END IF; 
SET :"CAFGESLOTEN"=FALSE; 
IF :"CPERCENTAGE"=100 THEN IF :"CMINSTATUS"<>:"CMAXSTATUS" THEN SET :"CPERCENTAGE"=99; END IF; END IF; 
IF (:"CMAXSTATUS">=99) AND (:"CPERCENTAGE"=100) THEN SET :"CAFGESLOTEN"=TRUE; END IF; 
UPDATE "TAANKOPEN" SET "CSTATUS" = :"CMAXSTATUS", "CSTATUSPERCENTAGE" = :"CPERCENTAGE", "CAFGESLOTEN" = :"CAFGESLOTEN" WHERE "CAANKOPEN_PK"=:"PK";
END;

CREATE PROCEDURE "UPDATECENTRALISATIE"( IN :"PK" INTEGER, IN :"VERHOGEN" BOOLEAN, IN :"BIJWERKENSALDI" BOOLEAN) 
BEGIN 
DECLARE "CCONTACTEN_FK" INT;
DECLARE "CCONTACTENHISTORIEK_FK" INT; 
DECLARE "CDAGBOEK" VARCHAR(10); 
DECLARE "CDAGBOEKEN_FK" INT; 
DECLARE "CDAGBOEKSOORT" INT; 
DECLARE "CINTERNEFIRMA" VARCHAR(10); 
DECLARE "CINTERNEFIRMAS_FK" INT; 
DECLARE "CBOEKJAAR" VARCHAR(4); 
DECLARE "CBOEKJAREN_FK" INT; 
DECLARE "CBOEKPERIODE" VARCHAR(6); 
DECLARE "CBOEKPERIODEN_FK" INT; 
DECLARE "CAANTAL" FLOAT(19); 
DECLARE "CALGEMENEREKENING" VARCHAR(10); 
DECLARE "CALGEMENEREKENINGEN_FK" INT; 
DECLARE "CANALYTISCHEREKENING" VARCHAR(25); 
DECLARE "CANALYTISCHEREKENINGEN_FK" INT; 
DECLARE "CMVH" NUMERIC(12,2); 
DECLARE "CBEDRAG" NUMERIC(12,2); 
DECLARE "CBEDRAGBTWREF" NUMERIC(12,2); 
DECLARE "CBEDRAGCREDITREF" NUMERIC(12,2); 
DECLARE "CBEDRAGDEBETREF" NUMERIC(12,2); 
DECLARE "CCENTRALISATIE_PK" INT; 
DECLARE "CANALCENTRALISATIE_PK" INT; 
DECLARE "CCENTRALISATIEOMZETTEN_PK" INT; 
DECLARE "CBOEKINGEN_FK" INT; 
DECLARE "CBOEKINGEN_PK" INT; 
DECLARE "CFACTOR" INT; 
DECLARE "CTYPE" INT; 
DECLARE "CSOORT" VARCHAR(1); 
DECLARE "CTYPEOMZETTEN" INT; 
DECLARE "CCONTACTSALDI_PK" INT; 
DECLARE "CCONTACTROL" VARCHAR(1); 
DECLARE "C_CURSORBOEKINGEN" CURSOR FOR SELECT "CBOEKINGEN_PK", "CDAGBOEK", "CDAGBOEKEN_FK", "CDAGBOEKSOORT", "CINTERNEFIRMA", "CINTERNEFIRMAS_FK", "CBOEKJAAR", "CBOEKJAREN_FK", "CBOEKPERIODE", "CBOEKPERIODEN_FK", "CCONTACTEN_FK", "CBEDRAGBTWREF" FROM "TBOEKINGEN" WHERE "CBOEKINGEN_PK"=:"PK" FOR READ ONLY ; 
DECLARE "C_CURSORHISTORIEK" CURSOR FOR SELECT "CBOEKINGEN_FK", "CTYPE", "CSOORT", "CAANTAL", "CALGEMENEREKENING", "CALGEMENEREKENINGEN_FK", "CANALYTISCHEREKENING", "CANALYTISCHEREKENINGEN_FK", "CMVH", "CBEDRAGDEBETREF", "CBEDRAGCREDITREF", "CCONTACTEN_FK" FROM "TBOEKINGHISTORIEK" WHERE "CBOEKINGEN_FK"=:"PK" FOR READ ONLY ; 
IF :"VERHOGEN"=TRUE THEN SET :"CFACTOR"=1; ELSE SET :"CFACTOR"=-1; END IF; 
OPEN "C_CURSORBOEKINGEN"; 
SET :"CBOEKINGEN_PK"=CAST(NULL AS INT); 
FETCH NEXT  FROM "C_CURSORBOEKINGEN" INTO :"CBOEKINGEN_PK", :"CDAGBOEK", :"CDAGBOEKEN_FK", :"CDAGBOEKSOORT", :"CINTERNEFIRMA", :"CINTERNEFIRMAS_FK", :"CBOEKJAAR", :"CBOEKJAREN_FK", :"CBOEKPERIODE", :"CBOEKPERIODEN_FK", :"CCONTACTEN_FK", :"CBEDRAGBTWREF"; 
CLOSE "C_CURSORBOEKINGEN"; 
OPEN "C_CURSORHISTORIEK"; 
SET :"CBOEKINGEN_FK"=CAST(NULL AS INT); 
FETCH NEXT  FROM "C_CURSORHISTORIEK" INTO :"CBOEKINGEN_FK", :"CTYPE", :"CSOORT", :"CAANTAL", :"CALGEMENEREKENING", :"CALGEMENEREKENINGEN_FK", :"CANALYTISCHEREKENING", :"CANALYTISCHEREKENINGEN_FK", :"CMVH", :"CBEDRAGDEBETREF", :"CBEDRAGCREDITREF", :"CCONTACTENHISTORIEK_FK"; 
IF :"CAANTAL" IS NULL THEN SET :"CAANTAL"=0; END IF; 
IF :"CBEDRAGDEBETREF" IS NULL THEN SET :"CBEDRAGDEBETREF"=0; END IF; 
IF :"CBEDRAGCREDITREF" IS NULL THEN SET :"CBEDRAGCREDITREF"=0; END IF; 
WHILE :"CBOEKINGEN_FK" IS NOT NULL  IF :"CTYPE"<>19 THEN SET :"CCENTRALISATIE_PK"=(SELECT "CCENTRALISATIE_PK" FROM "TCENTRALISATIE" WHERE ("CDAGBOEKEN_FK"=:"CDAGBOEKEN_FK") AND ("CINTERNEFIRMAS_FK"=:"CINTERNEFIRMAS_FK") AND ("CALGEMENEREKENINGEN_FK"=:"CALGEMENEREKENINGEN_FK") AND ("CBOEKJAREN_FK"=:"CBOEKJAREN_FK") AND ("CBOEKPERIODEN_FK"=:"CBOEKPERIODEN_FK")); IF :"CCENTRALISATIE_PK" IS NULL THEN INSERT INTO "TCENTRALISATIE"("CCENTRALISATIE_PK","CCREATIEDATUM","CCREATIEGEBRUIKER","CDAGBOEK","CDAGBOEKEN_FK","CINTERNEFIRMA","CINTERNEFIRMAS_FK","CAANTAL","CALGEMENEREKENING","CALGEMENEREKENINGEN_FK","CBEDRAGCREDITREF","CBEDRAGDEBETREF","CBOEKJAAR","CBOEKJAREN_FK","CBOEKPERIODE","CBOEKPERIODEN_FK") VALUES(SELECT UNIQUE FROM "TCENTRALISATIE",CAST(CURRENT_TIMESTAMP(0) AS TIMESTAMP(6)),CURRENT_USER,:"CDAGBOEK",:"CDAGBOEKEN_FK",:"CINTERNEFIRMA",:"CINTERNEFIRMAS_FK",:"CAANTAL",:"CALGEMENEREKENING",:"CALGEMENEREKENINGEN_FK",:"CBEDRAGCREDITREF",:"CBEDRAGDEBETREF",:"CBOEKJAAR",:"CBOEKJAREN_FK",:"CBOEKPERIODE",:"CBOEKPERIODEN_FK"); ELSE UPDATE "TCENTRALISATIE" SET "CWIJZIGDATUM" = CAST(CURRENT_TIMESTAMP(0) AS TIMESTAMP(6)), "CWIJZIGGEBRUIKER" = CURRENT_USER, "CAANTAL" = "CAANTAL"+((:"CAANTAL")*(:"CFACTOR")), "CBEDRAGCREDITREF" = "CBEDRAGCREDITREF"+((:"CBEDRAGCREDITREF")*(:"CFACTOR")), "CBEDRAGDEBETREF" = "CBEDRAGDEBETREF"+((:"CBEDRAGDEBETREF")*(:"CFACTOR")) WHERE "CCENTRALISATIE_PK"=:"CCENTRALISATIE_PK"; END IF; END IF; IF :"CANALYTISCHEREKENINGEN_FK">0 THEN SET :"CANALCENTRALISATIE_PK"=(SELECT "CANALCENTRALISATIE_PK" FROM "TANALCENTRALISATIE" WHERE ("CDAGBOEKEN_FK"=:"CDAGBOEKEN_FK") AND ("CINTERNEFIRMAS_FK"=:"CINTERNEFIRMAS_FK") AND ("CALGEMENEREKENINGEN_FK"=:"CALGEMENEREKENINGEN_FK") AND ("CANALYTISCHEREKENINGEN_FK"=:"CANALYTISCHEREKENINGEN_FK") AND ("CBOEKJAREN_FK"=:"CBOEKJAREN_FK") AND ("CBOEKPERIODEN_FK"=:"CBOEKPERIODEN_FK")); IF :"CANALCENTRALISATIE_PK" IS NULL THEN INSERT INTO "TANALCENTRALISATIE"("CANALCENTRALISATIE_PK","CCREATIEDATUM","CCREATIEGEBRUIKER","CDAGBOEK","CDAGBOEKEN_FK","CINTERNEFIRMA","CINTERNEFIRMAS_FK","CAANTAL","CALGEMENEREKENING","CALGEMENEREKENINGEN_FK","CANALYTISCHEREKENING","CANALYTISCHEREKENINGEN_FK","CBEDRAGCREDITREF","CBEDRAGDEBETREF","CBOEKJAAR","CBOEKJAREN_FK","CBOEKPERIODE","CBOEKPERIODEN_FK") VALUES(SELECT UNIQUE FROM "TANALCENTRALISATIE",CAST(CURRENT_TIMESTAMP(0) AS TIMESTAMP(6)),CURRENT_USER,:"CDAGBOEK",:"CDAGBOEKEN_FK",:"CINTERNEFIRMA",:"CINTERNEFIRMAS_FK",:"CAANTAL",:"CALGEMENEREKENING",:"CALGEMENEREKENINGEN_FK",:"CANALYTISCHEREKENING",:"CANALYTISCHEREKENINGEN_FK",:"CBEDRAGCREDITREF",:"CBEDRAGDEBETREF",:"CBOEKJAAR",:"CBOEKJAREN_FK",:"CBOEKPERIODE",:"CBOEKPERIODEN_FK"); ELSE UPDATE "TANALCENTRALISATIE" SET "CWIJZIGDATUM" = CAST(CURRENT_TIMESTAMP(0) AS TIMESTAMP(6)), "CWIJZIGGEBRUIKER" = CURRENT_USER, "CAANTAL" = "CAANTAL"+((:"CAANTAL")*(:"CFACTOR")), "CBEDRAGCREDITREF" = "CBEDRAGCREDITREF"+((:"CBEDRAGCREDITREF")*(:"CFACTOR")), "CBEDRAGDEBETREF" = "CBEDRAGDEBETREF"+((:"CBEDRAGDEBETREF")*(:"CFACTOR")) WHERE "CANALCENTRALISATIE_PK"=:"CANALCENTRALISATIE_PK"; END IF; END IF; IF (:"CDAGBOEKSOORT">=1) AND (:"CDAGBOEKSOORT"<=4) THEN IF (:"CDAGBOEKSOORT">=1) AND (:"CDAGBOEKSOORT"<=2) THEN SET :"CTYPEOMZETTEN"=2; END IF; IF (:"CDAGBOEKSOORT">=3) AND (:"CDAGBOEKSOORT"<=4) THEN SET :"CTYPEOMZETTEN"=1; END IF; IF :"CTYPE">=20 THEN SET :"CBEDRAG"=(:"CMVH")*(:"CFACTOR"); IF (:"CDAGBOEKSOORT")=ANY (VALUES 2, 4) THEN SET :"CBEDRAG"=(:"CBEDRAG")*-1; END IF; SET :"CCENTRALISATIEOMZETTEN_PK"=(SELECT "CCENTRALISATIEOMZETTEN_PK" FROM "TCENTRALISATIEOMZETTEN" WHERE ("CCONTACTEN_FK"=:"CCONTACTEN_FK") AND ("CINTERNEFIRMAS_FK"=:"CINTERNEFIRMAS_FK") AND ("CBOEKJAREN_FK"=:"CBOEKJAREN_FK") AND ("CBOEKPERIODEN_FK"=:"CBOEKPERIODEN_FK") AND ("CTYPE"=:"CTYPEOMZETTEN")); IF :"CCENTRALISATIEOMZETTEN_PK" IS NULL THEN INSERT INTO "TCENTRALISATIEOMZETTEN"("CCENTRALISATIEOMZETTEN_PK","CCREATIEDATUM","CCREATIEGEBRUIKER","CINTERNEFIRMA","CINTERNEFIRMAS_FK","CTYPE","CBEDRAG","CBEDRAGBTWREF","CBEDRAGCREDITREF","CBEDRAGDEBETREF","CBOEKJAAR","CBOEKJAREN_FK","CBOEKPERIODE","CBOEKPERIODEN_FK","CCONTACTEN_FK") VALUES
(SELECT UNIQUE FROM "TCENTRALISATIEOMZETTEN",CAST(CURRENT_TIMESTAMP(0) AS TIMESTAMP(6)),CURRENT_USER,:"CINTERNEFIRMA",:"CINTERNEFIRMAS_FK",:"CTYPEOMZETTEN",:"CBEDRAG",0,0,0,:"CBOEKJAAR",:"CBOEKJAREN_FK",:"CBOEKPERIODE",:"CBOEKPERIODEN_FK",:"CCONTACTEN_FK"); ELSE UPDATE "TCENTRALISATIEOMZETTEN" SET "CWIJZIGDATUM" = CAST(CURRENT_TIMESTAMP(0) AS TIMESTAMP(6)), "CWIJZIGGEBRUIKER" = CURRENT_USER, "CBEDRAG" = "CBEDRAG"+(:"CBEDRAG") WHERE "CCENTRALISATIEOMZETTEN_PK"=:"CCENTRALISATIEOMZETTEN_PK"; END IF; END IF; END IF; IF (:"CSOORT")=ANY (VALUES 'K', 'L') THEN IF :"CSOORT"='K' THEN SET :"CTYPEOMZETTEN"=1; END IF; IF :"CSOORT"='L' THEN SET :"CTYPEOMZETTEN"=2; END IF; IF (:"CDAGBOEKSOORT")=ANY (VALUES 2, 4) THEN SET :"CBEDRAGBTWREF"=(:"CBEDRAGBTWREF")*-1; END IF; SET :"CCENTRALISATIEOMZETTEN_PK"=(SELECT "CCENTRALISATIEOMZETTEN_PK" FROM "TCENTRALISATIEOMZETTEN" WHERE ("CCONTACTEN_FK"=:"CCONTACTENHISTORIEK_FK") AND ("CINTERNEFIRMAS_FK"=:"CINTERNEFIRMAS_FK") AND ("CBOEKJAREN_FK"=:"CBOEKJAREN_FK") AND ("CBOEKPERIODEN_FK"=:"CBOEKPERIODEN_FK") AND ("CTYPE"=:"CTYPEOMZETTEN")); IF :"CCENTRALISATIEOMZETTEN_PK" IS NULL THEN INSERT INTO "TCENTRALISATIEOMZETTEN"("CCENTRALISATIEOMZETTEN_PK","CCREATIEDATUM","CCREATIEGEBRUIKER","CINTERNEFIRMA","CINTERNEFIRMAS_FK","CTYPE","CBEDRAG","CBEDRAGBTWREF","CBEDRAGCREDITREF","CBEDRAGDEBETREF","CBOEKJAAR","CBOEKJAREN_FK","CBOEKPERIODE","CBOEKPERIODEN_FK","CCONTACTEN_FK") VALUES(SELECT UNIQUE FROM "TCENTRALISATIEOMZETTEN",CAST(CURRENT_TIMESTAMP(0) AS TIMESTAMP(6)),CURRENT_USER,:"CINTERNEFIRMA",:"CINTERNEFIRMAS_FK",:"CTYPEOMZETTEN",0,:"CBEDRAGBTWREF",:"CBEDRAGCREDITREF",:"CBEDRAGDEBETREF",:"CBOEKJAAR",:"CBOEKJAREN_FK",:"CBOEKPERIODE",:"CBOEKPERIODEN_FK",:"CCONTACTENHISTORIEK_FK"); ELSE UPDATE "TCENTRALISATIEOMZETTEN" SET "CWIJZIGDATUM" = CAST(CURRENT_TIMESTAMP(0) AS TIMESTAMP(6)), "CWIJZIGGEBRUIKER" = CURRENT_USER, "CBEDRAGCREDITREF" = "CBEDRAGCREDITREF"+((:"CBEDRAGCREDITREF")*(:"CFACTOR")), "CBEDRAGDEBETREF" = "CBEDRAGDEBETREF"+((:"CBEDRAGDEBETREF")*(:"CFACTOR")), "CBEDRAGBTWREF" = "CBEDRAGBTWREF"+((:"CBEDRAGBTWREF")*(:"CFACTOR")) WHERE "CCENTRALISATIEOMZETTEN_PK"=:"CCENTRALISATIEOMZETTEN_PK"; END IF; END IF; IF :"BIJWERKENSALDI" THEN IF :"CSOORT"='K' OR :"CSOORT"='L' THEN IF :"CSOORT"='K' THEN SET :"CCONTACTROL"='D'; SET :"CBEDRAG"=(:"CBEDRAGDEBETREF")-(:"CBEDRAGCREDITREF"); END IF; IF :"CSOORT"='L' THEN SET :"CCONTACTROL"='C'; SET :"CBEDRAG"=(:"CBEDRAGCREDITREF")-(:"CBEDRAGDEBETREF"); END IF; SET :"CBEDRAG"=(:"CBEDRAG")*(:"CFACTOR"); SET :"CCONTACTSALDI_PK"=(SELECT "CCONTACTSALDI_PK" FROM "TCONTACTSALDI" WHERE ("CCONTACTEN_FK"=:"CCONTACTENHISTORIEK_FK") AND ("CINTERNEFIRMAS_FK"=:"CINTERNEFIRMAS_FK") AND ("CCONTACTROL"=:"CCONTACTROL")); IF :"CCONTACTSALDI_PK" IS NULL THEN INSERT INTO "TCONTACTSALDI"("CCONTACTSALDI_PK","CCREATIEDATUM","CCREATIEGEBRUIKER","CINTERNEFIRMA","CINTERNEFIRMAS_FK","CCONTACTEN_FK","CCONTACTROL","CKREDIETLIJN","CSALDO","CGEMAANTALDAGEN") VALUES(SELECT UNIQUE FROM "TCONTACTSALDI",CAST(CURRENT_TIMESTAMP(0) AS TIMESTAMP(6)),CURRENT_USER,:"CINTERNEFIRMA",:"CINTERNEFIRMAS_FK",:"CCONTACTENHISTORIEK_FK",:"CCONTACTROL",0,:"CBEDRAG",0); ELSE UPDATE "TCONTACTSALDI" SET "CWIJZIGDATUM" = CAST(CURRENT_TIMESTAMP(0) AS TIMESTAMP(6)), "CWIJZIGGEBRUIKER" = CURRENT_USER, "CSALDO" = "CSALDO"+(:"CBEDRAG") WHERE "CCONTACTSALDI_PK"=:"CCONTACTSALDI_PK"; END IF; END IF; END IF; SET :"CBOEKINGEN_FK"=CAST(NULL AS INT); FETCH NEXT  FROM "C_CURSORHISTORIEK" INTO :"CBOEKINGEN_FK", :"CTYPE", :"CSOORT", :"CAANTAL", :"CALGEMENEREKENING", :"CALGEMENEREKENINGEN_FK", :"CANALYTISCHEREKENING", :"CANALYTISCHEREKENINGEN_FK", :"CMVH", :"CBEDRAGDEBETREF", :"CBEDRAGCREDITREF", :"CCONTACTENHISTORIEK_FK"; END WHILE; 
CLOSE "C_CURSORHISTORIEK";
END;

CREATE FUNCTION "DATE_TO_STRING"( IN :"date_value" DATE, IN :"format_string" CHARACTER VARYING(10)) RETURNS CHARACTER VARYING(20)
BEGIN
DECLARE "format_length" INT; 
DECLARE "format_index" INT; 
DECLARE "format_char" CHARACTER(1); 
DECLARE "result" VARCHAR(20); 
IF :"date_value" IS NULL THEN RETURN CAST(NULL AS VARCHAR(20)); END IF; 
IF :"format_string" IS NULL THEN SET :"format_string"='y-m-d'; END IF; 
SET :"format_length"=CHARACTER_LENGTH(:"format_string"); 
SET :"format_index"=1; 
SET :"result"=''; 
WHILE :"format_index"<=:"format_length"  SET :"format_char"=SUBSTRING(:"format_string" FROM :"format_index" FOR 1); IF :"format_char"='d' THEN SET :"result"=(:"result") || CAST(EXTRACT(DAY FROM :"date_value") AS VARCHAR(2)); ELSE IF :"format_char"='m' THEN SET :"result"=(:"result") || CAST(EXTRACT(MONTH FROM :"date_value") AS VARCHAR(2)); ELSE IF :"format_char"='y' THEN SET :"result"=(:"result") || CAST(EXTRACT(YEAR FROM :"date_value") AS VARCHAR(4)); ELSE SET :"result"=(:"result") || (:"format_char"); END IF; END IF; END IF; SET :"format_index"=(:"format_index")+1; END WHILE; 
RETURN :"result";
END;

CREATE PROCEDURE "SETSTATUSVERKOOP"( IN :"PK" INTEGER) 
BEGIN
DECLARE "CDOCUMENTTYPES_FK" INT; 
DECLARE "CSTATUS" INT; 
DECLARE "CNEWSTATUS" INT; 
DECLARE "CMINSTATUS" INT; 
DECLARE "CMAXSTATUS" INT; 
DECLARE "CAANTAL" FLOAT(19); 
DECLARE "CAANTALVOORRAAD" FLOAT(19); 
DECLARE "CAANTALGERESERVEERD" FLOAT(19); 
DECLARE "CAANTALVERWERKT" FLOAT(19); 
DECLARE "CVERKOOPLIJNEN_PK" INT; 
DECLARE "CBEDRAG" NUMERIC(10,2); 
DECLARE "CMETVOORRAAD" BOOLEAN; 
DECLARE "CNOEMER" NUMERIC(10,2); 
DECLARE "CTELLER" NUMERIC(10,2); 
DECLARE "CPERCENTAGE" NUMERIC(10,2); 
DECLARE "CAFGESLOTEN" BOOLEAN; 
DECLARE "CMETBEDRAGEN" BOOLEAN; 
DECLARE "CHONDERD" NUMERIC(5,2); 
DECLARE "C_CRSR" CURSOR FOR SELECT "CVERKOOPLIJNEN_PK", "CSTATUS", "CAANTAL", "CAANTALVOORRAAD", "CAANTALGERESERVEERD", "CAANTALVERWERKT", "CBEDRAG", "CMETVOORRAAD" FROM "TVERKOOPLIJNEN" WHERE ("CVERKOPEN_FK"=:"PK") AND ("CBEDRAG" IS NOT NULL) FOR READ ONLY ;
SET :"CDOCUMENTTYPES_FK"=(SELECT "CDOCUMENTTYPES_FK" FROM "TVERKOPEN" WHERE "CVERKOPEN_PK"=:"PK"); 
SET :"CTELLER"=0; 
SET :"CNOEMER"=0; 
SET :"CMINSTATUS"=100; 
SET :"CMAXSTATUS"=0; 
SET :"CMETBEDRAGEN"=TRUE; 
SET :"CHONDERD"=100; 
OPEN "C_CRSR"; 
SET :"CVERKOOPLIJNEN_PK"=CAST(NULL AS INT); 
FETCH NEXT  FROM "C_CRSR" INTO :"CVERKOOPLIJNEN_PK", :"CSTATUS", :"CAANTAL", :"CAANTALVOORRAAD", :"CAANTALGERESERVEERD", :"CAANTALVERWERKT", :"CBEDRAG", :"CMETVOORRAAD"; 
WHILE :"CVERKOOPLIJNEN_PK" IS NOT NULL  IF :"CAANTALVERWERKT"<>0 THEN SET :"CSTATUS"=99; END IF; IF :"CSTATUS"<:"CMINSTATUS" THEN SET :"CMINSTATUS"=:"CSTATUS"; END IF; IF :"CSTATUS">:"CMAXSTATUS" THEN SET :"CMAXSTATUS"=:"CSTATUS"; END IF; IF :"CBEDRAG"=0 THEN SET :"CMETBEDRAGEN"=FALSE; END IF; SET :"CVERKOOPLIJNEN_PK"=CAST(NULL AS INT); FETCH NEXT  FROM "C_CRSR" INTO :"CVERKOOPLIJNEN_PK", :"CSTATUS", :"CAANTAL", :"CAANTALVOORRAAD", :"CAANTALGERESERVEERD", :"CAANTALVERWERKT", :"CBEDRAG", :"CMETVOORRAAD"; END WHILE; 
CLOSE "C_CRSR"; 
OPEN "C_CRSR"; 
SET :"CVERKOOPLIJNEN_PK"=CAST(NULL AS INT); 
FETCH NEXT  FROM "C_CRSR" INTO :"CVERKOOPLIJNEN_PK", :"CSTATUS", :"CAANTAL", :"CAANTALVOORRAAD", :"CAANTALGERESERVEERD", :"CAANTALVERWERKT", :"CBEDRAG", :"CMETVOORRAAD"; 
WHILE :"CVERKOOPLIJNEN_PK" IS NOT NULL  SET :"CNEWSTATUS"=:"CSTATUS"; IF :"CAANTALVERWERKT"<>0 THEN SET :"CNEWSTATUS"=99; END IF; IF :"CAANTAL"=0 THEN SET :"CAANTAL"=1; END IF; IF :"CMETBEDRAGEN"=TRUE THEN SET :"CNOEMER"=(:"CNOEMER")+(ABS(:"CBEDRAG")); ELSE SET :"CNOEMER"=(:"CNOEMER")+(ABS(:"CAANTAL")); END IF; IF :"CNEWSTATUS"=:"CMAXSTATUS" THEN IF (:"CDOCUMENTTYPES_FK"=2) AND (:"CSTATUS"=20) THEN IF NOT :"CMETVOORRAAD" THEN SET :"CAANTALGERESERVEERD"=:"CAANTALVOORRAAD"; END IF; IF :"CMETBEDRAGEN"=TRUE THEN SET :"CTELLER"=(:"CTELLER")+(((:"CAANTALGERESERVEERD")/(:"CAANTALVOORRAAD"))*(:"CBEDRAG")); ELSE SET :"CTELLER"=(:"CTELLER")+(:"CAANTALGERESERVEERD"); END IF; ELSE IF :"CNEWSTATUS"=99 THEN IF :"CAANTALVERWERKT">:"CAANTAL" THEN SET :"CAANTALVERWERKT"=:"CAANTAL"; END IF; IF (:"CNEWSTATUS"=99) AND (:"CAANTALVERWERKT">:"CAANTAL") THEN SET :"CAANTALVERWERKT"=:"CAANTAL"; END IF; IF :"CAANTALVERWERKT"=0 THEN SET :"CAANTALVERWERKT"=1; END IF; IF :"CMETBEDRAGEN"=TRUE THEN SET :"CTELLER"=(:"CTELLER")+(ABS(((:"CAANTALVERWERKT")/(:"CAANTAL"))*(:"CBEDRAG"))); ELSE SET :"CTELLER"=(:"CTELLER")+(ABS(:"CAANTALVERWERKT")); END IF; ELSE IF :"CMETBEDRAGEN"=TRUE THEN SET :"CTELLER"=(:"CTELLER")+(ABS(:"CBEDRAG")); ELSE SET :"CTELLER"=(:"CTELLER")+(ABS(:"CAANTAL")); END IF; END IF; END IF; END IF; SET :"CVERKOOPLIJNEN_PK"=CAST(NULL AS INT); FETCH NEXT  FROM "C_CRSR" INTO :"CVERKOOPLIJNEN_PK", :"CSTATUS", :"CAANTAL", :"CAANTALVOORRAAD", :"CAANTALGERESERVEERD", :"CAANTALVERWERKT", :"CBEDRAG", :"CMETVOORRAAD"; END WHILE; 
CLOSE "C_CRSR"; 
IF :"CTELLER"=:"CNOEMER" THEN SET :"CPERCENTAGE"=100; ELSE IF :"CNOEMER"=0 THEN SET :"CNOEMER"=1; END IF; SET :"CPERCENTAGE"=CAST(((:"CTELLER")/(:"CNOEMER"))*(:"CHONDERD") AS NUMERIC(10,2)); END IF; 
SET :"CAFGESLOTEN"=FALSE; 
IF :"CPERCENTAGE"=100 THEN IF :"CMINSTATUS"<>:"CMAXSTATUS" THEN SET :"CPERCENTAGE"=99; END IF; END IF; 
IF (:"CMAXSTATUS">=99) AND (:"CPERCENTAGE"=100) THEN SET :"CAFGESLOTEN"=TRUE; END IF; 
UPDATE "TVERKOPEN" SET "CSTATUS" = :"CMAXSTATUS", "CSTATUSPERCENTAGE" = :"CPERCENTAGE", "CAFGESLOTEN" = :"CAFGESLOTEN" WHERE "CVERKOPEN_PK"=:"PK";
END;

CREATE FUNCTION "TABLES_FUNCTION_NEEDED_BY_FBODBC"( IN :"X" CHARACTER VARYING(16)) RETURNS CHARACTER VARYING(16)
BEGIN
 IF :"X"='BASE TABLE' THEN RETURN 'TABLE'; ELSE RETURN :"X"; END IF;
END;

CREATE PROCEDURE "REBUILDCONTACTSALDI"( IN :"PFIRMAS_PK" INTEGER, IN :"PBOEKJAREN_PK" INTEGER, IN :"PSOORT" CHARACTER VARYING(1)) 
BEGIN
DECLARE "CINTERNEFIRMA" VARCHAR(10); 
DECLARE "CCONTACTROL" VARCHAR(1);
DECLARE "CCONTACT" VARCHAR(10); 
DECLARE "CCONTACTEN_FK" INT; 
DECLARE "CBEDRAG" NUMERIC(10,2); 
DECLARE "CBEDRAGDEBETREF" NUMERIC(10,2); 
DECLARE "CBEDRAGCREDITREF" NUMERIC(10,2); 
DECLARE "CCONTACTSALDI_PK" INT; 
DECLARE "C_CRSR" CURSOR FOR SELECT "TBOEKINGHISTORIEK"."CCONTACT", "TBOEKINGHISTORIEK"."CCONTACTEN_FK", CAST(SUM(ALL "CBEDRAGDEBETREF") AS NUMERIC(10,2)), CAST(SUM(ALL "CBEDRAGCREDITREF") AS NUMERIC(10,2)) FROM "TBOEKINGEN","TBOEKINGHISTORIEK" WHERE ("CBOEKINGEN_PK"="CBOEKINGEN_FK") AND ("TBOEKINGEN"."CINTERNEFIRMAS_FK"=:"PFIRMAS_PK") AND ("TBOEKINGEN"."CBOEKJAREN_FK"=:"PBOEKJAREN_PK") AND ("TBOEKINGHISTORIEK"."CSOORT"=:"PSOORT") AND ("CAFGEPUNT"=FALSE) GROUP BY "TBOEKINGHISTORIEK"."CCONTACT","TBOEKINGHISTORIEK"."CCONTACTEN_FK" FOR READ ONLY ; 
SET :"CINTERNEFIRMA"=(SELECT "CINTERNEFIRMA" FROM "TINTERNEFIRMAS" WHERE "CINTERNEFIRMAS_PK"=:"PFIRMAS_PK"); 
OPEN "C_CRSR"; 
SET :"CCONTACTEN_FK"=CAST(NULL AS INT); 
FETCH NEXT  FROM "C_CRSR" INTO :"CCONTACT", :"CCONTACTEN_FK", :"CBEDRAGDEBETREF", :"CBEDRAGCREDITREF"; 
WHILE :"CCONTACTEN_FK" IS NOT NULL  IF :"PSOORT"='K' THEN SET :"CCONTACTROL"='D'; SET :"CBEDRAG"=(:"CBEDRAGDEBETREF")-(:"CBEDRAGCREDITREF"); END IF; IF :"PSOORT"='L' THEN SET :"CCONTACTROL"='C'; SET :"CBEDRAG"=(:"CBEDRAGCREDITREF")-(:"CBEDRAGDEBETREF"); END IF; SET :"CCONTACTSALDI_PK"=(SELECT "CCONTACTSALDI_PK" FROM "TCONTACTSALDI" WHERE ("CCONTACTEN_FK"=:"CCONTACTEN_FK") AND ("CINTERNEFIRMAS_FK"=:"PFIRMAS_PK") AND ("CCONTACTROL"=:"CCONTACTROL")); IF :"CCONTACTSALDI_PK" IS NULL THEN INSERT INTO "TCONTACTSALDI"("CCONTACTSALDI_PK","CINTERNEFIRMA","CINTERNEFIRMAS_FK","CCONTACTEN_FK","CCONTACTROL","CKREDIETLIJN","CSALDO","CGEMAANTALDAGEN") VALUES(SELECT UNIQUE FROM "TCONTACTSALDI",:"CINTERNEFIRMA",:"PFIRMAS_PK",:"CCONTACTEN_FK",:"CCONTACTROL",0,:"CBEDRAG",0); ELSE UPDATE "TCONTACTSALDI" SET "CWIJZIGDATUM" = CAST(CURRENT_TIMESTAMP(0) AS TIMESTAMP(6)), "CWIJZIGGEBRUIKER" = CURRENT_USER, "CSALDO" = "CSALDO"+(:"CBEDRAG") WHERE "CCONTACTSALDI_PK"=:"CCONTACTSALDI_PK"; END IF; SET :"CCONTACTEN_FK"=CAST(NULL AS INT); FETCH NEXT  FROM "C_CRSR" INTO :"CCONTACT", :"CCONTACTEN_FK", :"CBEDRAGDEBETREF", :"CBEDRAGCREDITREF"; END WHILE; 
CLOSE "C_CRSR";
END;

CREATE PROCEDURE "AFSLBOEKJAAR0"( IN :"PFIRMA" INTEGER, IN :"PBOEKJAARHUIDIG" INTEGER, IN :"PBOEKJAARVOLGEND" INTEGER, IN :"PDAGBOEK" INTEGER, IN :"PBOEKPERIODE" INTEGER, IN :"PDATUM" DATE) 
BEGIN
DECLARE "CINTERNEFIRMA" VARCHAR(10); 
DECLARE "CBOEKJAARHUIDIG" VARCHAR(10); 
DECLARE "CBOEKJAARVOLGEND" VARCHAR(10); 
DECLARE "CDAGBOEK" VARCHAR(10); 
DECLARE "CBOEKPERIODE" VARCHAR(10); 
DECLARE "CBOEKINGEN_PK" INT; 
DECLARE "CALGEMENEREKENING" VARCHAR(10); 
DECLARE "CALGEMENEREKENINGEN_FK" INT; 
DECLARE "COMSCHRIJVING1" VARCHAR(50); 
DECLARE "CSALDO" NUMERIC(10,2);
DECLARE "CBEDRAGDEBETREF" NUMERIC(10,2); 
DECLARE "CBEDRAGCREDITREF" NUMERIC(10,2); 
DECLARE "CVOLGNR" INT; 
DECLARE "CAUTONUMMER" BOOLEAN; 
DECLARE "CBOEKPERIODE12" VARCHAR(10); 
DECLARE "CBOEKPERIODE99" VARCHAR(10); 
DECLARE "CBOEKPERIODEN_PK" INT; 
DECLARE "CTAAL" VARCHAR(1); 
DECLARE "COMSCHRIJVING" VARCHAR(100); 
DECLARE "C_CRSR" CURSOR FOR SELECT "TBOEKINGHISTORIEK"."CALGEMENEREKENING", "CALGEMENEREKENINGEN_FK", "TALGEMENEREKENINGEN"."COMSCHRIJVING1", CAST(SUM(ALL "CBEDRAGDEBETREF"-"CBEDRAGCREDITREF") AS NUMERIC(10,2)) FROM "TBOEKINGHISTORIEK","TALGEMENEREKENINGEN" WHERE ("CBOEKINGEN_FK"=:"CBOEKINGEN_PK") AND ("CALGEMENEREKENINGEN_FK"="CALGEMENEREKENINGEN_PK") GROUP BY "TBOEKINGHISTORIEK"."CALGEMENEREKENING","CALGEMENEREKENINGEN_FK","TALGEMENEREKENINGEN"."COMSCHRIJVING1" FOR READ ONLY ; 
SET :"CINTERNEFIRMA"=(SELECT "CINTERNEFIRMA" FROM "TINTERNEFIRMAS" WHERE "CINTERNEFIRMAS_PK"=:"PFIRMA"); 
SET :"CBOEKJAARHUIDIG"=(SELECT "CBOEKJAAR" FROM "TBOEKJAREN" WHERE "CBOEKJAREN_PK"=:"PBOEKJAARHUIDIG"); 
SET :"CBOEKJAARVOLGEND"=(SELECT "CBOEKJAAR" FROM "TBOEKJAREN" WHERE "CBOEKJAREN_PK"=:"PBOEKJAARVOLGEND"); 
SET :"CDAGBOEK"=(SELECT "CDAGBOEK" FROM "TDAGBOEKEN" WHERE "CDAGBOEKEN_PK"=:"PDAGBOEK"); 
SET :"CAUTONUMMER"=(SELECT "CAUTONUMMER" FROM "TDAGBOEKEN" WHERE "CDAGBOEKEN_PK"=:"PDAGBOEK"); 
SET :"CBOEKPERIODE"=(SELECT "CBOEKPERIODE" FROM "TBOEKPERIODEN" WHERE "CBOEKPERIODEN_PK"=:"PBOEKPERIODE"); 
SET :"CTAAL"=(SELECT "CTAAL" FROM "TTALEN" WHERE "CTALEN_PK"=1); 
IF :"CTAAL"='N' THEN SET :"COMSCHRIJVING"='Heropening boekjaar'; END IF; 
IF :"CTAAL"='F' THEN SET :"COMSCHRIJVING"='Rouverture exercice'; END IF; 
IF :"CTAAL"='E' THEN SET :"COMSCHRIJVING"='Reopening exercise'; END IF; 
IF :"CTAAL"='D' THEN SET :"COMSCHRIJVING"='Wiedererrffnung'; END IF; 
SET :"CBOEKINGEN_PK"=SELECT UNIQUE FROM "_SYSTEM"."TBOEKINGEN"; 
IF :"CAUTONUMMER" THEN SET :"CVOLGNR"=(SELECT "CVOLGNR" FROM "TDAGBOEKVOLGNR" WHERE ("CINTERNEFIRMAS_FK"=:"PFIRMA") AND ("CDAGBOEKEN_FK"=:"PDAGBOEK") AND ("CBOEKJAREN_FK"=:"PBOEKJAARVOLGEND")); UPDATE "TDAGBOEKVOLGNR" SET "CVOLGNR" = "CVOLGNR"+1 WHERE ("CINTERNEFIRMAS_FK"=:"PFIRMA") AND ("CDAGBOEKEN_FK"=:"PDAGBOEK") AND ("CBOEKJAREN_FK"=:"PBOEKJAARVOLGEND"); ELSE SET :"CVOLGNR"=CAST(NULL AS INT); SET :"CVOLGNR"=(SELECT MAX(ALL "CVOLGNR") FROM "TBOEKINGEN" WHERE ("CINTERNEFIRMAS_FK"=:"PFIRMA") AND ("CDAGBOEKEN_FK"=:"PDAGBOEK") AND ("CBOEKJAREN_FK"=:"PBOEKJAARVOLGEND")); IF :"CVOLGNR" IS NULL THEN SET :"CVOLGNR"=0; END IF; SET :"CVOLGNR"=(:"CVOLGNR")+1; END IF; 
INSERT INTO "TBOEKINGEN"("CBOEKINGEN_PK","CDAGBOEK","CDAGBOEKEN_FK","CINTERNEFIRMA","CINTERNEFIRMAS_FK","CBEDRAGBTWREF","CBEDRAGEXCLREF","CBEDRAGINCL","CBEDRAGINCLREF","CBEGINSALDO","CBETALINGSVOORWAARDE","CBOEKJAAR","CBOEKJAREN_FK","CBOEKPERIODE","CBOEKPERIODEN_FK","CCONTACT","CDAGBOEKSOORT","CDATUM","CFACTNRLEV","CFINKORTING","CFINKORTINGPERCENTAGE","CFOUTBTWTOEGELATEN","CKOERS","CMUNT","CMUNTEN_FK","CNAAM1","CREEDSOVERGEBOEKT","CVOLGNR") VALUES(:"CBOEKINGEN_PK",:"CDAGBOEK",:"PDAGBOEK",:"CINTERNEFIRMA",:"PFIRMA",0,0,0,0,0,'',:"CBOEKJAARVOLGEND",:"PBOEKJAARVOLGEND",:"CBOEKPERIODE",:"PBOEKPERIODE",'',10,:"PDATUM",'',0,0,FALSE,1,'EUR',1,'',FALSE,:"CVOLGNR"); 
INSERT INTO "TBOEKINGHISTORIEK"("CBOEKINGHISTORIEK_PK","CBOEKINGEN_FK","CTYPE","CSOORT","CAANTAL","CAFGEPUNT","CAFGEPUNTVOLGNR","CALGEMENEREKENING","CALGEMENEREKENINGEN_FK","CANALYTISCHEREKENING","CANALYTISCHEREKENINGEN_FK","CBEDRAGBTWREF","CBEDRAGCREDIT","CBEDRAGCREDITREF","CBEDRAGDEBET","CBEDRAGDEBETREF","CBEDRAGNIETAFTR","CBTWCODE","CBTWPERCENTAGE","CCONTACT","CCONTACTEN_FK","CDOMICILIERING","CDOMICILIERINGBANK","CDOMICILIERINGDATUM","CDOMMANDATEN_FK","CFACTNRLEV","CMUNT","CMUNTEN_FK","CNAAM1","CPERCENTAGENIETAFTR","CREEDSBETAALD","CTEKSTRAPPEL","CVERVALDATUM","COMSCHRIJVING","CKOERS","CDATUM","CMVH","CDAGBOEK","CVOLGNR","CFINKORTING") SELECT SELECT UNIQUE FROM "TBOEKINGHISTORIEK", :"CBOEKINGEN_PK", "CTYPE", "CSOORT", "CAANTAL", "CAFGEPUNT", "CAFGEPUNTVOLGNR", "CALGEMENEREKENING", "CALGEMENEREKENINGEN_FK", "CANALYTISCHEREKENING", "CANALYTISCHEREKENINGEN_FK", "TBOEKINGHISTORIEK"."CBEDRAGBTWREF", "CBEDRAGCREDIT", "CBEDRAGCREDITREF", "CBEDRAGDEBET", "CBEDRAGDEBETREF", "CBEDRAGNIETAFTR", "CBTWCODE", "CBTWPERCENTAGE", "TBOEKINGHISTORIEK"."CCONTACT", "TBOEKINGHISTORIEK"."CCONTACTEN_FK", "CDOMICILIERING", "CDOMICILIERINGBANK", "CDOMICILIERINGDATUM", "CDOMMANDATEN_FK", "TBOEKINGHISTORIEK"."CFACTNRLEV", "TBOEKINGHISTORIEK"."CMUNT", "TBOEKINGHISTORIEK"."CMUNTEN_FK", "TBOEKINGHISTORIEK"."CNAAM1", "CPERCENTAGENIETAFTR", "CREEDSBETAALD", "CTEKSTRAPPEL", "CVERVALDATUM", "TBOEKINGHISTORIEK"."COMSCHRIJVING", "TBOEKINGHISTORIEK"."CKOERS", "TBOEKINGHISTORIEK"."CDATUM", "CMVH", "TBOEKINGHISTORIEK"."CDAGBOEK", "TBOEKINGHISTORIEK"."CVOLGNR", "TBOEKINGHISTORIEK"."CFINKORTING" FROM "TBOEKINGHISTORIEK","TBOEKINGEN" WHERE ("CBOEKINGEN_PK"="CBOEKINGEN_FK") AND ("CINTERNEFIRMAS_FK"=:"PFIRMA") AND ("CBOEKJAREN_FK"=:"PBOEKJAARHUIDIG") AND ("CSOORT"='K') AND ("CAFGEPUNT"=FALSE); 
OPEN "C_CRSR"; 
SET :"CALGEMENEREKENINGEN_FK"=CAST(NULL AS INT); 
FETCH NEXT  FROM "C_CRSR" INTO :"CALGEMENEREKENING", :"CALGEMENEREKENINGEN_FK", :"COMSCHRIJVING1", :"CSALDO"; 
WHILE :"CALGEMENEREKENINGEN_FK" IS NOT NULL  SET :"CSALDO"=(:"CSALDO")*-1; SET :"CBEDRAGDEBETREF"=0; SET :"CBEDRAGCREDITREF"=0; IF :"CSALDO">0 THEN SET :"CBEDRAGDEBETREF"=:"CSALDO"; ELSE SET :"CBEDRAGCREDITREF"=ABS(:"CSALDO"); END IF; INSERT INTO "TBOEKINGHISTORIEK"("CBOEKINGHISTORIEK_PK","CBOEKINGEN_FK","CTYPE","CSOORT","CAANTAL","CAFGEPUNT","CAFGEPUNTVOLGNR","CALGEMENEREKENING","CALGEMENEREKENINGEN_FK","CANALYTISCHEREKENING","CBEDRAGBTWREF","CBEDRAGCREDIT","CBEDRAGCREDITREF","CBEDRAGDEBET","CBEDRAGDEBETREF","CBEDRAGNIETAFTR","CBTWCODE","CBTWPERCENTAGE","CCONTACT","CDOMICILIERING","CDOMICILIERINGBANK","CMUNT","CMUNTEN_FK","CNAAM1","CPERCENTAGENIETAFTR","CREEDSBETAALD","CTEKSTRAPPEL","CVERVALDATUM","COMSCHRIJVING","CKOERS","CDATUM","CMVH","CDAGBOEK","CVOLGNR") VALUES(SELECT UNIQUE FROM "TBOEKINGHISTORIEK",:"CBOEKINGEN_PK",0,'A',0,FALSE,0,:"CALGEMENEREKENING",:"CALGEMENEREKENINGEN_FK",'',0,:"CBEDRAGCREDITREF",:"CBEDRAGCREDITREF",:"CBEDRAGDEBETREF",:"CBEDRAGDEBETREF",0,'',0,'',0,'','EUR',1,:"COMSCHRIJVING1",0,FALSE,0,:"PDATUM",:"COMSCHRIJVING",1,:"PDATUM",0,:"CDAGBOEK",:"CVOLGNR"); SET :"CALGEMENEREKENINGEN_FK"=CAST(NULL AS INT); FETCH NEXT  FROM "C_CRSR" INTO :"CALGEMENEREKENING", :"CALGEMENEREKENINGEN_FK", :"COMSCHRIJVING1", :"CSALDO"; END WHILE; 
CLOSE "C_CRSR"; 
CALL "UPDATECENTRALISATIE"(:"CBOEKINGEN_PK", TRUE, FALSE); 
SET :"CBOEKINGEN_PK"=SELECT UNIQUE FROM "_SYSTEM"."TBOEKINGEN"; 
IF :"CAUTONUMMER" THEN SET :"CVOLGNR"=(SELECT "CVOLGNR" FROM "TDAGBOEKVOLGNR" WHERE ("CINTERNEFIRMAS_FK"=:"PFIRMA") AND ("CDAGBOEKEN_FK"=:"PDAGBOEK") AND ("CBOEKJAREN_FK"=:"PBOEKJAARVOLGEND")); UPDATE "TDAGBOEKVOLGNR" SET "CVOLGNR" = "CVOLGNR"+1 WHERE ("CINTERNEFIRMAS_FK"=:"PFIRMA") AND ("CDAGBOEKEN_FK"=:"PDAGBOEK") AND ("CBOEKJAREN_FK"=:"PBOEKJAARVOLGEND"); ELSE SET :"CVOLGNR"=(:"CVOLGNR")+1; END IF; 
INSERT INTO "TBOEKINGEN"("CBOEKINGEN_PK","CDAGBOEK","CDAGBOEKEN_FK","CINTERNEFIRMA","CINTERNEFIRMAS_FK","CBEDRAGBTWREF","CBEDRAGEXCLREF","CBEDRAGINCL","CBEDRAGINCLREF","CBEGINSALDO","CBETALINGSVOORWAARDE","CBOEKJAAR","CBOEKJAREN_FK","CBOEKPERIODE","CBOEKPERIODEN_FK","CCONTACT","CDAGBOEKSOORT","CDATUM","CFACTNRLEV","CFINKORTING","CFINKORTINGPERCENTAGE","CFOUTBTWTOEGELATEN","CKOERS","CMUNT","CMUNTEN_FK","CNAAM1","CREEDSOVERGEBOEKT","CVOLGNR") VALUES(:"CBOEKINGEN_PK",:"CDAGBOEK",:"PDAGBOEK",:"CINTERNEFIRMA",:"PFIRMA",0,0,0,0,0,'',:"CBOEKJAARVOLGEND",:"PBOEKJAARVOLGEND",:"CBOEKPERIODE",:"PBOEKPERIODE",'',10,:"PDATUM",'',0,0,FALSE,1,'EUR',1,'',FALSE,:"CVOLGNR"); 
INSERT INTO "TBOEKINGHISTORIEK"("CBOEKINGHISTORIEK_PK","CBOEKINGEN_FK","CTYPE","CSOORT","CAANTAL","CAFGEPUNT","CAFGEPUNTVOLGNR","CALGEMENEREKENING","CALGEMENEREKENINGEN_FK","CANALYTISCHEREKENING","CANALYTISCHEREKENINGEN_FK","CBEDRAGBTWREF","CBEDRAGCREDIT","CBEDRAGCREDITREF","CBEDRAGDEBET","CBEDRAGDEBETREF","CBEDRAGNIETAFTR","CBTWCODE","CBTWPERCENTAGE","CCONTACT","CCONTACTEN_FK","CDOMICILIERING","CDOMICILIERINGBANK","CDOMICILIERINGDATUM","CDOMMANDATEN_FK","CFACTNRLEV","CMUNT","CMUNTEN_FK","CNAAM1","CPERCENTAGENIETAFTR","CREEDSBETAALD","CTEKSTRAPPEL","CVERVALDATUM","COMSCHRIJVING","CKOERS","CDATUM","CMVH","CDAGBOEK","CVOLGNR","CFINKORTING","CBANKREKENINGNUMMER","CBANKBIC") SELECT SELECT UNIQUE FROM "TBOEKINGHISTORIEK", :"CBOEKINGEN_PK", "CTYPE", "CSOORT", "CAANTAL", "CAFGEPUNT", "CAFGEPUNTVOLGNR", "CALGEMENEREKENING", "CALGEMENEREKENINGEN_FK", "CANALYTISCHEREKENING", "CANALYTISCHEREKENINGEN_FK", "TBOEKINGHISTORIEK"."CBEDRAGBTWREF", "CBEDRAGCREDIT", "CBEDRAGCREDITREF", "CBEDRAGDEBET", "CBEDRAGDEBETREF", "CBEDRAGNIETAFTR", "CBTWCODE", "CBTWPERCENTAGE", "TBOEKINGHISTORIEK"."CCONTACT", "TBOEKINGHISTORIEK"."CCONTACTEN_FK", "CDOMICILIERING", "CDOMICILIERINGBANK", "CDOMICILIERINGDATUM", "CDOMMANDATEN_FK", "TBOEKINGHISTORIEK"."CFACTNRLEV", "TBOEKINGHISTORIEK"."CMUNT", "TBOEKINGHISTORIEK"."CMUNTEN_FK", "TBOEKINGHISTORIEK"."CNAAM1", "CPERCENTAGENIETAFTR", "CREEDSBETAALD", "CTEKSTRAPPEL", "CVERVALDATUM", "TBOEKINGHISTORIEK"."COMSCHRIJVING", "TBOEKINGHISTORIEK"."CKOERS", "TBOEKINGHISTORIEK"."CDATUM", "CMVH", "TBOEKINGHISTORIEK"."CDAGBOEK", "TBOEKINGHISTORIEK"."CVOLGNR", "TBOEKINGHISTORIEK"."CFINKORTING", "TBOEKINGHISTORIEK"."CBANKREKENINGNUMMER", "TBOEKINGHISTORIEK"."CBANKBIC" FROM "TBOEKINGHISTORIEK","TBOEKINGEN" WHERE ("CBOEKINGEN_PK"="CBOEKINGEN_FK") AND ("CINTERNEFIRMAS_FK"=:"PFIRMA") AND ("CBOEKJAREN_FK"=:"PBOEKJAARHUIDIG") AND ("CSOORT"='L') AND ("CAFGEPUNT"=FALSE); 
OPEN "C_CRSR"; 
SET :"CALGEMENEREKENINGEN_FK"=CAST(NULL AS INT); 
FETCH NEXT  FROM "C_CRSR" INTO :"CALGEMENEREKENING", :"CALGEMENEREKENINGEN_FK", :"COMSCHRIJVING1", :"CSALDO"; 
WHILE :"CALGEMENEREKENINGEN_FK" IS NOT NULL  SET :"CSALDO"=(:"CSALDO")*-1; SET :"CBEDRAGDEBETREF"=0; SET :"CBEDRAGCREDITREF"=0; IF :"CSALDO">0 THEN SET :"CBEDRAGDEBETREF"=:"CSALDO"; ELSE SET :"CBEDRAGCREDITREF"=ABS(:"CSALDO"); END IF; INSERT INTO "TBOEKINGHISTORIEK"("CBOEKINGHISTORIEK_PK","CBOEKINGEN_FK","CTYPE","CSOORT","CAANTAL","CAFGEPUNT","CAFGEPUNTVOLGNR","CALGEMENEREKENING","CALGEMENEREKENINGEN_FK","CANALYTISCHEREKENING","CBEDRAGBTWREF","CBEDRAGCREDIT","CBEDRAGCREDITREF","CBEDRAGDEBET","CBEDRAGDEBETREF","CBEDRAGNIETAFTR","CBTWCODE","CBTWPERCENTAGE","CCONTACT","CDOMICILIERING","CDOMICILIERINGBANK","CMUNT","CMUNTEN_FK","CNAAM1","CPERCENTAGENIETAFTR","CREEDSBETAALD","CTEKSTRAPPEL","CVERVALDATUM","COMSCHRIJVING","CKOERS","CDATUM","CMVH","CDAGBOEK","CVOLGNR") VALUES(SELECT UNIQUE FROM "TBOEKINGHISTORIEK",:"CBOEKINGEN_PK",0,'A',0,FALSE,0,:"CALGEMENEREKENING",:"CALGEMENEREKENINGEN_FK",'',0,:"CBEDRAGCREDITREF",:"CBEDRAGCREDITREF",:"CBEDRAGDEBETREF",:"CBEDRAGDEBETREF",0,'',0,'',0,'','EUR',1,:"COMSCHRIJVING1",0,FALSE,0,:"PDATUM",:"COMSCHRIJVING",1,:"PDATUM",0,:"CDAGBOEK",:"CVOLGNR"); SET :"CALGEMENEREKENINGEN_FK"=CAST(NULL AS INT); FETCH NEXT  FROM "C_CRSR" INTO :"CALGEMENEREKENING", :"CALGEMENEREKENINGEN_FK", :"COMSCHRIJVING1", :"CSALDO"; END WHILE; 
CLOSE "C_CRSR"; 
CALL "UPDATECENTRALISATIE"(:"CBOEKINGEN_PK", TRUE, FALSE); 
SET :"CBOEKPERIODE99"=(:"CBOEKJAARHUIDIG") || '99'; 
UPDATE "TBOEKPERIODEN" SET "CSTATUS" = 1 WHERE ("CINTERNEFIRMAS_FK"=:"PFIRMA") AND ("CBOEKJAREN_FK"=:"PBOEKJAARHUIDIG") AND ("CBOEKPERIODE"<>:"CBOEKPERIODE99"); 
SET :"CBOEKPERIODE12"=(SELECT MAX(ALL "CBOEKPERIODE") FROM "TBOEKPERIODEN" WHERE ("CINTERNEFIRMAS_FK"=:"PFIRMA") AND ("CBOEKJAREN_FK"=:"PBOEKJAARHUIDIG") AND ("CBOEKPERIODE"<>:"CBOEKPERIODE99")); 
SET :"CBOEKPERIODEN_PK"=(SELECT "CBOEKPERIODEN_PK" FROM "TBOEKPERIODEN" WHERE ("CINTERNEFIRMAS_FK"=:"PFIRMA") AND ("CBOEKJAREN_FK"=:"PBOEKJAARHUIDIG") AND ("CBOEKPERIODE"=:"CBOEKPERIODE99")); 
IF :"CBOEKPERIODEN_PK" IS NULL THEN INSERT INTO "TBOEKPERIODEN"("CBOEKPERIODEN_PK","CINTERNEFIRMA","CINTERNEFIRMAS_FK","CBOEKJAAR","CBOEKJAREN_FK","CBOEKPERIODE","CBTWPERIODE","CBTWPERIODEN_FK","CDATUMTOT","CDATUMVAN","CSTATUS") SELECT SELECT UNIQUE FROM "TBOEKPERIODEN", "CINTERNEFIRMA", "CINTERNEFIRMAS_FK", "CBOEKJAAR", "CBOEKJAREN_FK", :"CBOEKPERIODE99", "CBTWPERIODE", "CBTWPERIODEN_FK", "CDATUMTOT", "CDATUMVAN", 0 FROM "TBOEKPERIODEN" WHERE ("CINTERNEFIRMAS_FK"=:"PFIRMA") AND ("CBOEKJAREN_FK"=:"PBOEKJAARHUIDIG") AND ("CBOEKPERIODE"=:"CBOEKPERIODE12"); END IF; 
UPDATE "TBOEKJAREN" SET "CSTATUS" = 1 WHERE ("CINTERNEFIRMAS_FK"=:"PFIRMA") AND ("CBOEKJAREN_PK"=:"PBOEKJAARHUIDIG");
END;

CREATE PROCEDURE "AFSLBOEKJAAR1"( IN :"PFIRMA" INTEGER, IN :"PBOEKJAARHUIDIG" INTEGER, IN :"PBOEKJAARVOLGEND" INTEGER, IN :"PDAGBOEK" INTEGER, IN :"PBOEKPERIODE" INTEGER, IN :"PDATUM" DATE) 
BEGIN
DECLARE "CINTERNEFIRMA" VARCHAR(10);
DECLARE "CBOEKJAARHUIDIG" VARCHAR(10);
DECLARE "CBOEKJAARVOLGEND" VARCHAR(10);
DECLARE "CDAGBOEK" VARCHAR(10);
DECLARE "CBOEKPERIODE" VARCHAR(10);
DECLARE "CBOEKINGEN_PK" INT;
DECLARE "CALGEMENEREKENING" VARCHAR(10);
DECLARE "CALGEMENEREKENINGEN_FK" INT;
DECLARE "COMSCHRIJVING1" VARCHAR(50);
DECLARE "CSALDO" NUMERIC(10,2);
DECLARE "CBEDRAGDEBETREF" NUMERIC(10,2);
DECLARE "CBEDRAGCREDITREF" NUMERIC(10,2);
DECLARE "CVOLGNR" INT;
DECLARE "CAUTONUMMER" BOOLEAN;
DECLARE "CAANTAL" INT;
DECLARE "CBOEKPERIODE12" VARCHAR(10);
DECLARE "CBOEKPERIODE99" VARCHAR(10);
DECLARE "CBOEKPERIODEN_PK" INT;
DECLARE "CTAAL" VARCHAR(1);
DECLARE "COMSCHRIJVING" VARCHAR(100);
DECLARE "C_CRSR" CURSOR FOR SELECT "TBOEKINGHISTORIEK"."CALGEMENEREKENING", "CALGEMENEREKENINGEN_FK", "TALGEMENEREKENINGEN"."COMSCHRIJVING1", CAST(SUM(ALL "CBEDRAGDEBETREF"-"CBEDRAGCREDITREF") AS NUMERIC(10,2)) FROM "TBOEKINGHISTORIEK","TALGEMENEREKENINGEN" WHERE ("CBOEKINGEN_FK"=:"CBOEKINGEN_PK") AND ("CALGEMENEREKENINGEN_FK"="CALGEMENEREKENINGEN_PK") GROUP BY "TBOEKINGHISTORIEK"."CALGEMENEREKENING","CALGEMENEREKENINGEN_FK","TALGEMENEREKENINGEN"."COMSCHRIJVING1" FOR READ ONLY ;
SET :"CINTERNEFIRMA"=(SELECT "CINTERNEFIRMA" FROM "TINTERNEFIRMAS" WHERE "CINTERNEFIRMAS_PK"=:"PFIRMA");
SET :"CBOEKJAARHUIDIG"=(SELECT "CBOEKJAAR" FROM "TBOEKJAREN" WHERE "CBOEKJAREN_PK"=:"PBOEKJAARHUIDIG");
SET :"CBOEKJAARVOLGEND"=(SELECT "CBOEKJAAR" FROM "TBOEKJAREN" WHERE "CBOEKJAREN_PK"=:"PBOEKJAARVOLGEND");
SET :"CDAGBOEK"=(SELECT "CDAGBOEK" FROM "TDAGBOEKEN" WHERE "CDAGBOEKEN_PK"=:"PDAGBOEK");
SET :"CAUTONUMMER"=(SELECT "CAUTONUMMER" FROM "TDAGBOEKEN" WHERE "CDAGBOEKEN_PK"=:"PDAGBOEK");
SET :"CBOEKPERIODE"=(SELECT "CBOEKPERIODE" FROM "TBOEKPERIODEN" WHERE "CBOEKPERIODEN_PK"=:"PBOEKPERIODE");
SET :"CTAAL"=(SELECT "CTAAL" FROM "TTALEN" WHERE "CTALEN_PK"=1);
IF :"CTAAL"='N' THEN SET :"COMSCHRIJVING"='Heropening boekjaar'; END IF;
IF :"CTAAL"='F' THEN SET :"COMSCHRIJVING"='Rouverture exercice'; END IF;
IF :"CTAAL"='E' THEN SET :"COMSCHRIJVING"='Reopening exercise'; END IF;
IF :"CTAAL"='D' THEN SET :"COMSCHRIJVING"='Wiedererrffnung'; END IF;
SET :"CBOEKPERIODE99"=(:"CBOEKJAARHUIDIG") || '99';
SET :"CBOEKPERIODEN_PK"=(SELECT "CBOEKPERIODEN_PK" FROM "TBOEKPERIODEN" WHERE ("CINTERNEFIRMAS_FK"=:"PFIRMA") AND ("CBOEKJAREN_FK"=:"PBOEKJAARHUIDIG") AND ("CBOEKPERIODE"=:"CBOEKPERIODE99"));
SET :"CAANTAL"=(SELECT COUNT(ALL "CBOEKINGEN_PK") FROM "TBOEKINGHISTORIEK","TBOEKINGEN" WHERE ("CBOEKINGEN_PK"="CBOEKINGEN_FK") AND ("CINTERNEFIRMAS_FK"=:"PFIRMA") AND ("CBOEKJAREN_FK"=:"PBOEKJAARHUIDIG") AND ("CSOORT"='K') AND ("CREEDSOVERGEBOEKT"=FALSE) AND ("CBOEKPERIODEN_FK"=:"CBOEKPERIODEN_PK"));
IF :"CAANTAL">0 THEN SET :"CBOEKINGEN_PK"=SELECT UNIQUE FROM "_SYSTEM"."TBOEKINGEN"; IF :"CAUTONUMMER" THEN SET :"CVOLGNR"=(SELECT "CVOLGNR" FROM "TDAGBOEKVOLGNR" WHERE ("CINTERNEFIRMAS_FK"=:"PFIRMA") AND ("CDAGBOEKEN_FK"=:"PDAGBOEK") AND ("CBOEKJAREN_FK"=:"PBOEKJAARVOLGEND")); UPDATE "TDAGBOEKVOLGNR" SET "CVOLGNR" = "CVOLGNR"+1 WHERE ("CINTERNEFIRMAS_FK"=:"PFIRMA") AND ("CDAGBOEKEN_FK"=:"PDAGBOEK") AND ("CBOEKJAREN_FK"=:"PBOEKJAARVOLGEND"); ELSE SET :"CVOLGNR"=CAST(NULL AS INT); SET :"CVOLGNR"=(SELECT MAX(ALL "CVOLGNR") FROM "TBOEKINGEN" WHERE ("CINTERNEFIRMAS_FK"=:"PFIRMA") AND ("CDAGBOEKEN_FK"=:"PDAGBOEK") AND ("CBOEKJAREN_FK"=:"PBOEKJAARVOLGEND")); IF :"CVOLGNR" IS NULL THEN SET :"CVOLGNR"=0; END IF; SET :"CVOLGNR"=(:"CVOLGNR")+1; END IF; INSERT INTO "TBOEKINGEN"("CBOEKINGEN_PK","CDAGBOEK","CDAGBOEKEN_FK","CINTERNEFIRMA","CINTERNEFIRMAS_FK","CBEDRAGBTWREF","CBEDRAGEXCLREF","CBEDRAGINCL","CBEDRAGINCLREF","CBEGINSALDO","CBETALINGSVOORWAARDE","CBOEKJAAR","CBOEKJAREN_FK","CBOEKPERIODE","CBOEKPERIODEN_FK","CCONTACT","CDAGBOEKSOORT","CDATUM","CFACTNRLEV","CFINKORTING","CFINKORTINGPERCENTAGE","CFOUTBTWTOEGELATEN","CKOERS","CMUNT","CMUNTEN_FK","CNAAM1","CREEDSOVERGEBOEKT","CVOLGNR") VALUES(:"CBOEKINGEN_PK",:"CDAGBOEK",:"PDAGBOEK",:"CINTERNEFIRMA",:"PFIRMA",0,0,0,0,0,'',:"CBOEKJAARVOLGEND",:"PBOEKJAARVOLGEND",:"CBOEKPERIODE",:"PBOEKPERIODE",'',10,:"PDATUM",'',0,0,FALSE,1,'EUR',1,'',FALSE,:"CVOLGNR"); INSERT INTO "TBOEKINGHISTORIEK"("CBOEKINGHISTORIEK_PK","CBOEKINGEN_FK","CTYPE","CSOORT","CAANTAL","CAFGEPUNT","CAFGEPUNTVOLGNR","CALGEMENEREKENING","CALGEMENEREKENINGEN_FK","CANALYTISCHEREKENING","CANALYTISCHEREKENINGEN_FK","CBEDRAGBTWREF","CBEDRAGCREDIT","CBEDRAGCREDITREF","CBEDRAGDEBET","CBEDRAGDEBETREF","CBEDRAGNIETAFTR","CBTWCODE","CBTWPERCENTAGE","CCONTACT","CCONTACTEN_FK","CDOMICILIERING","CDOMICILIERINGBANK","CDOMICILIERINGDATUM","CDOMMANDATEN_FK","CFACTNRLEV","CMUNT","CMUNTEN_FK","CNAAM1","CPERCENTAGENIETAFTR","CREEDSBETAALD","CTEKSTRAPPEL","CVERVALDATUM","COMSCHRIJVING","CKOERS","CDATUM","CMVH","CDAGBOEK","CVOLGNR","CFINKORTING") SELECT SELECT UNIQUE FROM "TBOEKINGHISTORIEK", :"CBOEKINGEN_PK", "CTYPE", "CSOORT", "CAANTAL", FALSE, 0, "CALGEMENEREKENING", "CALGEMENEREKENINGEN_FK", "CANALYTISCHEREKENING", "CANALYTISCHEREKENINGEN_FK", "TBOEKINGHISTORIEK"."CBEDRAGBTWREF", "CBEDRAGCREDIT", "CBEDRAGCREDITREF", "CBEDRAGDEBET", "CBEDRAGDEBETREF", "CBEDRAGNIETAFTR", "CBTWCODE", "CBTWPERCENTAGE", "TBOEKINGHISTORIEK"."CCONTACT", "TBOEKINGHISTORIEK"."CCONTACTEN_FK", "CDOMICILIERING", "CDOMICILIERINGBANK", "CDOMICILIERINGDATUM", "CDOMMANDATEN_FK", "TBOEKINGHISTORIEK"."CFACTNRLEV", "TBOEKINGHISTORIEK"."CMUNT", "TBOEKINGHISTORIEK"."CMUNTEN_FK", "TBOEKINGHISTORIEK"."CNAAM1", "CPERCENTAGENIETAFTR", "CREEDSBETAALD", "CTEKSTRAPPEL", "CVERVALDATUM", "TBOEKINGHISTORIEK"."COMSCHRIJVING", "TBOEKINGHISTORIEK"."CKOERS", "TBOEKINGHISTORIEK"."CDATUM", "CMVH", "TBOEKINGHISTORIEK"."CDAGBOEK", "TBOEKINGHISTORIEK"."CVOLGNR", "TBOEKINGHISTORIEK"."CFINKORTING" FROM "TBOEKINGHISTORIEK","TBOEKINGEN" WHERE ("CBOEKINGEN_PK"="CBOEKINGEN_FK") AND ("CINTERNEFIRMAS_FK"=:"PFIRMA") AND ("CBOEKJAREN_FK"=:"PBOEKJAARHUIDIG") AND ("CSOORT"='K') AND ("CREEDSOVERGEBOEKT"=FALSE) AND ("CBOEKPERIODEN_FK"=:"CBOEKPERIODEN_PK"); OPEN "C_CRSR"; SET :"CALGEMENEREKENINGEN_FK"=CAST(NULL AS INT); FETCH NEXT  FROM "C_CRSR" INTO :"CALGEMENEREKENING", :"CALGEMENEREKENINGEN_FK", :"COMSCHRIJVING1", :"CSALDO"; WHILE :"CALGEMENEREKENINGEN_FK" IS NOT NULL  SET :"CSALDO"=(:"CSALDO")*-1; SET :"CBEDRAGDEBETREF"=0; SET :"CBEDRAGCREDITREF"=0; IF :"CSALDO">0 THEN SET :"CBEDRAGDEBETREF"=:"CSALDO"; ELSE SET :"CBEDRAGCREDITREF"=ABS(:"CSALDO"); END IF; INSERT INTO "TBOEKINGHISTORIEK"("CBOEKINGHISTORIEK_PK","CBOEKINGEN_FK","CTYPE","CSOORT","CAANTAL","CAFGEPUNT","CAFGEPUNTVOLGNR","CALGEMENEREKENING","CALGEMENEREKENINGEN_FK","CANALYTISCHEREKENING","CBEDRAGBTWREF","CBEDRAGCREDIT","CBEDRAGCREDITREF","CBEDRAGDEBET","CBEDRAGDEBETREF","CBEDRAGNIETAFTR","CBTWCODE","CBTWPERCENTAGE","CCONTACT","CDOMICILIERING","CDOMICILIERINGBANK","CMUNT","CMUNTEN_FK","CNAAM1","CPERCENTAGENIETAFTR","CREEDSBETAALD",
"CTEKSTRAPPEL","CVERVALDATUM","COMSCHRIJVING","CKOERS","CDATUM","CMVH","CDAGBOEK","CVOLGNR") VALUES(SELECT UNIQUE FROM "TBOEKINGHISTORIEK",:"CBOEKINGEN_PK",0,'A',0,FALSE,0,:"CALGEMENEREKENING",:"CALGEMENEREKENINGEN_FK",'',0,:"CBEDRAGCREDITREF",:"CBEDRAGCREDITREF",:"CBEDRAGDEBETREF",:"CBEDRAGDEBETREF",0,'',0,'',0,'','EUR',1,:"COMSCHRIJVING1",0,FALSE,0,:"PDATUM",:"COMSCHRIJVING",1,:"PDATUM",0,:"CDAGBOEK",:"CVOLGNR"); SET :"CALGEMENEREKENINGEN_FK"=CAST(NULL AS INT); FETCH NEXT  FROM "C_CRSR" INTO :"CALGEMENEREKENING", :"CALGEMENEREKENINGEN_FK", :"COMSCHRIJVING1", :"CSALDO"; END WHILE; CLOSE "C_CRSR"; CALL "UPDATECENTRALISATIE"(:"CBOEKINGEN_PK", TRUE, FALSE); END IF;
SET :"CAANTAL"=(SELECT COUNT(ALL "CBOEKINGEN_PK") FROM "TBOEKINGHISTORIEK","TBOEKINGEN" WHERE ("CBOEKINGEN_PK"="CBOEKINGEN_FK") AND ("CINTERNEFIRMAS_FK"=:"PFIRMA") AND ("CBOEKJAREN_FK"=:"PBOEKJAARHUIDIG") AND ("CSOORT"='L') AND ("CREEDSOVERGEBOEKT"=FALSE) AND ("CBOEKPERIODEN_FK"=:"CBOEKPERIODEN_PK"));
IF :"CAANTAL">0 THEN SET :"CBOEKINGEN_PK"=SELECT UNIQUE FROM "_SYSTEM"."TBOEKINGEN"; IF :"CAUTONUMMER" THEN SET :"CVOLGNR"=(SELECT "CVOLGNR" FROM "TDAGBOEKVOLGNR" WHERE ("CINTERNEFIRMAS_FK"=:"PFIRMA") AND ("CDAGBOEKEN_FK"=:"PDAGBOEK") AND ("CBOEKJAREN_FK"=:"PBOEKJAARVOLGEND")); UPDATE "TDAGBOEKVOLGNR" SET "CVOLGNR" = "CVOLGNR"+1 WHERE ("CINTERNEFIRMAS_FK"=:"PFIRMA") AND ("CDAGBOEKEN_FK"=:"PDAGBOEK") AND ("CBOEKJAREN_FK"=:"PBOEKJAARVOLGEND"); ELSE SET :"CVOLGNR"=CAST(NULL AS INT); SET :"CVOLGNR"=(SELECT MAX(ALL "CVOLGNR") FROM "TBOEKINGEN" WHERE ("CINTERNEFIRMAS_FK"=:"PFIRMA") AND ("CDAGBOEKEN_FK"=:"PDAGBOEK") AND ("CBOEKJAREN_FK"=:"PBOEKJAARVOLGEND")); IF :"CVOLGNR" IS NULL THEN SET :"CVOLGNR"=0; END IF; SET :"CVOLGNR"=(:"CVOLGNR")+1; END IF; INSERT INTO "TBOEKINGEN"("CBOEKINGEN_PK","CDAGBOEK","CDAGBOEKEN_FK","CINTERNEFIRMA","CINTERNEFIRMAS_FK","CBEDRAGBTWREF","CBEDRAGEXCLREF","CBEDRAGINCL","CBEDRAGINCLREF","CBEGINSALDO","CBETALINGSVOORWAARDE","CBOEKJAAR","CBOEKJAREN_FK","CBOEKPERIODE","CBOEKPERIODEN_FK","CCONTACT","CDAGBOEKSOORT","CDATUM","CFACTNRLEV","CFINKORTING","CFINKORTINGPERCENTAGE","CFOUTBTWTOEGELATEN","CKOERS","CMUNT","CMUNTEN_FK","CNAAM1","CREEDSOVERGEBOEKT","CVOLGNR") VALUES(:"CBOEKINGEN_PK",:"CDAGBOEK",:"PDAGBOEK",:"CINTERNEFIRMA",:"PFIRMA",0,0,0,0,0,'',:"CBOEKJAARVOLGEND",:"PBOEKJAARVOLGEND",:"CBOEKPERIODE",:"PBOEKPERIODE",'',10,:"PDATUM",'',0,0,FALSE,1,'EUR',1,'',FALSE,:"CVOLGNR"); INSERT INTO "TBOEKINGHISTORIEK"("CBOEKINGHISTORIEK_PK","CBOEKINGEN_FK","CTYPE","CSOORT","CAANTAL","CAFGEPUNT","CAFGEPUNTVOLGNR","CALGEMENEREKENING","CALGEMENEREKENINGEN_FK","CANALYTISCHEREKENING","CANALYTISCHEREKENINGEN_FK","CBEDRAGBTWREF","CBEDRAGCREDIT","CBEDRAGCREDITREF","CBEDRAGDEBET","CBEDRAGDEBETREF","CBEDRAGNIETAFTR","CBTWCODE","CBTWPERCENTAGE","CCONTACT","CCONTACTEN_FK","CDOMICILIERING","CDOMICILIERINGBANK","CDOMICILIERINGDATUM","CDOMMANDATEN_FK","CFACTNRLEV","CMUNT","CMUNTEN_FK","CNAAM1","CPERCENTAGENIETAFTR","CREEDSBETAALD","CTEKSTRAPPEL","CVERVALDATUM","COMSCHRIJVING","CKOERS","CDATUM","CMVH","CDAGBOEK","CVOLGNR","CFINKORTING","CBANKREKENINGNUMMER","CBANKBIC") SELECT SELECT UNIQUE FROM "TBOEKINGHISTORIEK", :"CBOEKINGEN_PK", "CTYPE", "CSOORT", "CAANTAL", FALSE, 0, "CALGEMENEREKENING", "CALGEMENEREKENINGEN_FK", "CANALYTISCHEREKENING", "CANALYTISCHEREKENINGEN_FK", "TBOEKINGHISTORIEK"."CBEDRAGBTWREF", "CBEDRAGCREDIT", "CBEDRAGCREDITREF", "CBEDRAGDEBET", "CBEDRAGDEBETREF", "CBEDRAGNIETAFTR", "CBTWCODE", "CBTWPERCENTAGE", "TBOEKINGHISTORIEK"."CCONTACT", "TBOEKINGHISTORIEK"."CCONTACTEN_FK", "CDOMICILIERING", "CDOMICILIERINGBANK", "CDOMICILIERINGDATUM", "CDOMMANDATEN_FK", "TBOEKINGHISTORIEK"."CFACTNRLEV", "TBOEKINGHISTORIEK"."CMUNT", "TBOEKINGHISTORIEK"."CMUNTEN_FK", "TBOEKINGHISTORIEK"."CNAAM1", "CPERCENTAGENIETAFTR", "CREEDSBETAALD", "CTEKSTRAPPEL", "CVERVALDATUM", "TBOEKINGHISTORIEK"."COMSCHRIJVING", "TBOEKINGHISTORIEK"."CKOERS", "TBOEKINGHISTORIEK"."CDATUM", "CMVH", "TBOEKINGHISTORIEK"."CDAGBOEK", "TBOEKINGHISTORIEK"."CVOLGNR", "TBOEKINGHISTORIEK"."CFINKORTING", "TBOEKINGHISTORIEK"."CBANKREKENINGNUMMER", "TBOEKINGHISTORIEK"."CBANKBIC" FROM "TBOEKINGHISTORIEK","TBOEKINGEN" WHERE ("CBOEKINGEN_PK"="CBOEKINGEN_FK") AND ("CINTERNEFIRMAS_FK"=:"PFIRMA") AND ("CBOEKJAREN_FK"=:"PBOEKJAARHUIDIG") AND ("CSOORT"='L') AND ("CREEDSOVERGEBOEKT"=FALSE) AND ("CBOEKPERIODEN_FK"=:"CBOEKPERIODEN_PK"); OPEN "C_CRSR"; SET :"CALGEMENEREKENINGEN_FK"=CAST(NULL AS INT); FETCH NEXT  FROM "C_CRSR" INTO :"CALGEMENEREKENING", :"CALGEMENEREKENINGEN_FK", :"COMSCHRIJVING1", :"CSALDO"; WHILE :"CALGEMENEREKENINGEN_FK" IS NOT NULL  SET :"CSALDO"=(:"CSALDO")*-1; SET :"CBEDRAGDEBETREF"=0; SET :"CBEDRAGCREDITREF"=0; IF :"CSALDO">0 THEN SET :"CBEDRAGDEBETREF"=:"CSALDO"; ELSE SET :"CBEDRAGCREDITREF"=ABS(:"CSALDO"); END IF; INSERT INTO "TBOEKINGHISTORIEK"("CBOEKINGHISTORIEK_PK","CBOEKINGEN_FK","CTYPE","CSOORT","CAANTAL","CAFGEPUNT","CAFGEPUNTVOLGNR","CALGEMENEREKENING","CALGEMENEREKENINGEN_FK","CANALYTISCHEREKENING","CBEDRAGBTWREF","CBEDRAGCREDIT","CBEDRAGCREDITREF","CBEDRAGDEBET","CBEDRAGDEBETREF","CBEDRAGNIETAFTR","CBTWCODE","CBTWPERCENTAGE","CCONTACT","CDOMICILIERING","CDOMICILIERINGBANK","CMUNT","CMUNTEN_FK","CNAAM1","CPERCENTAGENIETAFTR","CREEDSBETAALD","CTEKSTRAPPEL","CVERVALDATUM","COMSCHRIJVING","CKOERS","CDATUM","CMVH","CDAGBOEK","CVOLGNR") VALUES(SELECT UNIQUE FROM "TBOEKINGHISTORIEK",:"CBOEKINGEN_PK",0,'A',0,FALSE,0,:"CALGEMENEREKENING",:"CALGEMENEREKENINGEN_FK",'',0,:"CBEDRAGCREDITREF",:"CBEDRAGCREDITREF",:"CBEDRAGDEBETREF",:"CBEDRAGDEBETREF",0,'',0,'',0,'','EUR',1,:"COMSCHRIJVING1",0,FALSE,0,:"PDATUM",:"COMSCHRIJVING",1,:"PDATUM",0,:"CDAGBOEK",:"CVOLGNR"); SET :"CALGEMENEREKENINGEN_FK"=CAST(NULL AS INT); FETCH NEXT  FROM "C_CRSR" INTO :"CALGEMENEREKENING", :"CALGEMENEREKENINGEN_FK", :"COMSCHRIJVING1", :"CSALDO"; END WHILE; CLOSE "C_CRSR"; CALL "UPDATECENTRALISATIE"(:"CBOEKINGEN_PK", TRUE, FALSE); END IF;
UPDATE "TBOEKINGEN" SET "CREEDSOVERGEBOEKT" = TRUE WHERE ("CINTERNEFIRMAS_FK"=:"PFIRMA") AND ("CBOEKJAREN_FK"=:"PBOEKJAARHUIDIG") AND ("CBOEKPERIODEN_FK"=:"CBOEKPERIODEN_PK") AND ("CREEDSOVERGEBOEKT"=FALSE);
END;

CREATE PROCEDURE "SETSTATUSSERVICE"( IN :"PK" INTEGER) 
BEGIN
DECLARE "CDOCUMENTTYPES_FK" INT;
DECLARE "CSTATUS" INT;
DECLARE "CNEWSTATUS" INT;
DECLARE "CMINSTATUS" INT;
DECLARE "CMAXSTATUS" INT;
DECLARE "CAANTAL" FLOAT(19);
DECLARE "CAANTALVERWERKT" FLOAT(19);
DECLARE "CSERVICELIJNEN_PK" INT;
DECLARE "CBEDRAG" NUMERIC(10,2);
DECLARE "CNOEMER" NUMERIC(10,2);
DECLARE "CTELLER" NUMERIC(10,2);
DECLARE "CPERCENTAGE" NUMERIC(10,2);
DECLARE "CAFGESLOTEN" BOOLEAN;
DECLARE "CMETBEDRAGEN" BOOLEAN;
DECLARE "C_CRSR" CURSOR FOR SELECT "CSERVICELIJNEN_PK", "CSTATUS", "CAANTAL", "CAANTALVERWERKT", "CBEDRAG" FROM "TSERVICELIJNEN" WHERE ("CSERVICE_FK"=:"PK") AND ("CBEDRAG" IS NOT NULL) FOR READ ONLY ;
SET :"CDOCUMENTTYPES_FK"=(SELECT "CDOCUMENTTYPES_FK" FROM "TSERVICE" WHERE "CSERVICE_PK"=:"PK");
SET :"CTELLER"=0;
SET :"CNOEMER"=0;
SET :"CMINSTATUS"=100;
SET :"CMAXSTATUS"=0;
SET :"CMETBEDRAGEN"=TRUE;
OPEN "C_CRSR";
SET :"CSERVICELIJNEN_PK"=CAST(NULL AS INT);
FETCH NEXT  FROM "C_CRSR" INTO :"CSERVICELIJNEN_PK", :"CSTATUS", :"CAANTAL", :"CAANTALVERWERKT", :"CBEDRAG";
WHILE :"CSERVICELIJNEN_PK" IS NOT NULL  IF :"CAANTALVERWERKT"<>0 THEN SET :"CSTATUS"=99; END IF; IF :"CSTATUS"<:"CMINSTATUS" THEN SET :"CMINSTATUS"=:"CSTATUS"; END IF; IF :"CSTATUS">:"CMAXSTATUS" THEN SET :"CMAXSTATUS"=:"CSTATUS"; END IF; IF :"CBEDRAG"=0 THEN SET :"CMETBEDRAGEN"=FALSE; END IF; SET :"CSERVICELIJNEN_PK"=CAST(NULL AS INT); FETCH NEXT  FROM "C_CRSR" INTO :"CSERVICELIJNEN_PK", :"CSTATUS", :"CAANTAL", :"CAANTALVERWERKT", :"CBEDRAG"; END WHILE;
CLOSE "C_CRSR";
OPEN "C_CRSR";
SET :"CSERVICELIJNEN_PK"=CAST(NULL AS INT);
FETCH NEXT  FROM "C_CRSR" INTO :"CSERVICELIJNEN_PK", :"CSTATUS", :"CAANTAL", :"CAANTALVERWERKT", :"CBEDRAG";
WHILE :"CSERVICELIJNEN_PK" IS NOT NULL  SET :"CNEWSTATUS"=:"CSTATUS"; IF :"CAANTALVERWERKT"<>0 THEN SET :"CSTATUS"=99; END IF; IF :"CAANTAL"=0 THEN SET :"CAANTAL"=1; END IF; IF :"CMETBEDRAGEN"=TRUE THEN SET :"CNOEMER"=(:"CNOEMER")+(ABS(:"CBEDRAG")); ELSE SET :"CNOEMER"=(:"CNOEMER")+(ABS(:"CAANTAL")); END IF; IF :"CNEWSTATUS"=:"CMAXSTATUS" THEN IF :"CSTATUS"=99 THEN IF ABS(:"CAANTALVERWERKT")>ABS(:"CAANTAL") THEN SET :"CAANTALVERWERKT"=:"CAANTAL"; END IF; IF :"CSTATUS"=99 THEN SET :"CAANTALVERWERKT"=:"CAANTAL"; END IF; IF :"CAANTALVERWERKT"=0 THEN SET :"CAANTALVERWERKT"=1; END IF; IF :"CMETBEDRAGEN"=TRUE THEN SET :"CTELLER"=(:"CTELLER")+(ABS(((:"CAANTALVERWERKT")/(:"CAANTAL"))*(:"CBEDRAG"))); ELSE SET :"CTELLER"=(:"CTELLER")+(ABS(:"CAANTALVERWERKT")); END IF; ELSE IF :"CMETBEDRAGEN"=TRUE THEN SET :"CTELLER"=(:"CTELLER")+(ABS(:"CBEDRAG")); ELSE SET :"CTELLER"=(:"CTELLER")+(ABS(:"CAANTAL")); END IF; END IF; END IF; SET :"CSERVICELIJNEN_PK"=CAST(NULL AS INT); FETCH NEXT  FROM "C_CRSR" INTO :"CSERVICELIJNEN_PK", :"CSTATUS", :"CAANTAL", :"CAANTALVERWERKT", :"CBEDRAG"; END WHILE;
CLOSE "C_CRSR";
IF :"CTELLER"=:"CNOEMER" THEN SET :"CPERCENTAGE"=100; ELSE IF :"CNOEMER"=0 THEN SET :"CNOEMER"=1; END IF; SET :"CPERCENTAGE"=CAST(((:"CTELLER")/(:"CNOEMER"))*100 AS NUMERIC(10,2)); END IF;
SET :"CAFGESLOTEN"=FALSE;
IF :"CPERCENTAGE"=100 THEN IF :"CMINSTATUS"<>:"CMAXSTATUS" THEN SET :"CPERCENTAGE"=99; END IF; END IF;
IF (:"CMAXSTATUS">=99) AND (:"CPERCENTAGE"=100) THEN SET :"CAFGESLOTEN"=TRUE; END IF;
UPDATE "TSERVICE" SET "CSTATUS" = :"CMAXSTATUS", "CSTATUSPERCENTAGE" = :"CPERCENTAGE", "CAFGESLOTEN" = :"CAFGESLOTEN" WHERE "CSERVICE_PK"=:"PK";
END;

CREATE PROCEDURE "AANTALINBESTELLINGKLANT"( IN :"partikel" INTEGER, IN :"pkleur" CHARACTER VARYING(10), IN :"pmaat" CHARACTER VARYING(10), IN :"paantal" FLOAT, IN :"pfirmapk" INTEGER, IN :"pfirma" CHARACTER VARYING(10), IN :"pvestigingpk" INTEGER, IN :"pvestiging" CHARACTER VARYING(10)) 
BEGIN
DECLARE "PK" INT;
SELECT "CARTIKELINVESTIGING_PK" INTO :"PK" FROM "TARTIKELINVESTIGING" WHERE ("CINTERNEFIRMAS_FK"=:"pfirmapk") AND ("CINTERNEFIRMAVESTIGINGEN_FK"=:"pvestigingpk") AND ("CARTIKELS_FK"=:"partikel") AND ("CKLEUR"=:"pkleur") AND ("CMAAT"=:"pmaat");
IF :"PK" IS NULL THEN INSERT INTO "TARTIKELINVESTIGING"("CARTIKELINVESTIGING_PK","CINTERNEFIRMAS_FK","CINTERNEFIRMA","CINTERNEFIRMAVESTIGINGEN_FK","CINTERNEFIRMAVESTIGING","CARTIKELS_FK","CKLEUR","CMAAT","CINBESTELLINGKLANT","CINBESTELLINGLEVERANCIER","CINCONSIGNATIEKLANT","CINCONSIGNATIELEVERANCIER","CINRESERVATIE","CINPRODUCTIE","CVOORPRODUCTIE") VALUES(SELECT UNIQUE FROM "TARTIKELINVESTIGING",:"pfirmapk",:"pfirma",:"pvestigingpk",:"pvestiging",:"partikel",:"pkleur",:"pmaat",:"paantal",0,0,0,0,0,0); ELSE UPDATE "TARTIKELINVESTIGING" SET "CINBESTELLINGKLANT" = "CINBESTELLINGKLANT"+(:"paantal"), "CWIJZIGDATUM" = CAST(CURRENT_TIMESTAMP(0) AS TIMESTAMP(6)), "CWIJZIGGEBRUIKER" = CURRENT_USER WHERE "CARTIKELINVESTIGING_PK"=:"PK"; END IF;
END;

CREATE PROCEDURE "PRO_VERKOOPLIJNEN"( IN :"PK" INTEGER, IN :"PARTIKELS_FK" INTEGER, IN :"PKLEUR" CHARACTER VARYING(10), IN :"PMAAT" CHARACTER VARYING(10), IN :"PAANTAL" FLOAT) 
BEGIN
DECLARE "CDOCUMENTTYPES_FK" INT;
DECLARE "CINTERNEFIRMA" VARCHAR(10);
DECLARE "CINTERNEFIRMAS_FK" INT;
DECLARE "CINTERNEFIRMAVESTIGING" VARCHAR(10);
DECLARE "CINTERNEFIRMAVESTIGINGEN_FK" INT;
DECLARE "C_CRSR" CURSOR FOR SELECT "CDOCUMENTTYPES_FK", "CINTERNEFIRMA", "CINTERNEFIRMAS_FK", "CINTERNEFIRMAVESTIGING", "CINTERNEFIRMAVESTIGINGEN_FK" FROM "TVERKOPEN" WHERE "CVERKOPEN_PK"=:"PK" FOR READ ONLY ;
OPEN "C_CRSR";
FETCH NEXT  FROM "C_CRSR" INTO :"CDOCUMENTTYPES_FK", :"CINTERNEFIRMA", :"CINTERNEFIRMAS_FK", :"CINTERNEFIRMAVESTIGING", :"CINTERNEFIRMAVESTIGINGEN_FK";
CLOSE "C_CRSR";
IF :"CDOCUMENTTYPES_FK"=2 THEN CALL "AANTALINBESTELLINGKLANT"(:"PARTIKELS_FK", :"PKLEUR", :"PMAAT", :"PAANTAL", :"CINTERNEFIRMAS_FK", :"CINTERNEFIRMA", :"CINTERNEFIRMAVESTIGINGEN_FK", :"CINTERNEFIRMAVESTIGING"); END IF;
DROP VARIABLES;
END;

CREATE PROCEDURE "AANTALINBESTELLINGLEVERANCIER"( IN :"partikel" INTEGER, IN :"pkleur" CHARACTER VARYING(10), IN :"pmaat" CHARACTER VARYING(10), IN :"paantal" FLOAT, IN :"pfirmapk" INTEGER, IN :"pfirma" CHARACTER VARYING(10), IN :"pvestigingpk" INTEGER, IN :"pvestiging" CHARACTER VARYING(10)) 
BEGIN
DECLARE "PK" INT;
SELECT "CARTIKELINVESTIGING_PK" INTO :"PK" FROM "TARTIKELINVESTIGING" WHERE ("CINTERNEFIRMAS_FK"=:"pfirmapk") AND ("CINTERNEFIRMAVESTIGINGEN_FK"=:"pvestigingpk") AND ("CARTIKELS_FK"=:"partikel") AND ("CKLEUR"=:"pkleur") AND ("CMAAT"=:"pmaat");
IF :"PK" IS NULL THEN INSERT INTO "TARTIKELINVESTIGING"("CARTIKELINVESTIGING_PK","CINTERNEFIRMAS_FK","CINTERNEFIRMA","CINTERNEFIRMAVESTIGINGEN_FK","CINTERNEFIRMAVESTIGING","CARTIKELS_FK","CKLEUR","CMAAT","CINBESTELLINGKLANT","CINBESTELLINGLEVERANCIER","CINCONSIGNATIEKLANT","CINCONSIGNATIELEVERANCIER","CINRESERVATIE","CINPRODUCTIE","CVOORPRODUCTIE") VALUES(SELECT UNIQUE FROM "TARTIKELINVESTIGING",:"pfirmapk",:"pfirma",:"pvestigingpk",:"pvestiging",:"partikel",:"pkleur",:"pmaat",0,:"paantal",0,0,0,0,0); ELSE UPDATE "TARTIKELINVESTIGING" SET "CINBESTELLINGLEVERANCIER" = "CINBESTELLINGLEVERANCIER"+(:"paantal"), "CWIJZIGDATUM" = CAST(CURRENT_TIMESTAMP(0) AS TIMESTAMP(6)), "CWIJZIGGEBRUIKER" = CURRENT_USER WHERE "CARTIKELINVESTIGING_PK"=:"PK"; END IF;
END;

CREATE PROCEDURE "AANTALINCONSIGNATIEKLANT"( IN :"partikel" INTEGER, IN :"pkleur" CHARACTER VARYING(10), IN :"pmaat" CHARACTER VARYING(10), IN :"paantal" FLOAT, IN :"pfirmapk" INTEGER, IN :"pfirma" CHARACTER VARYING(10), IN :"pvestigingpk" INTEGER, IN :"pvestiging" CHARACTER VARYING(10)) 
BEGIN
DECLARE "PK" INT;
SELECT "CARTIKELINVESTIGING_PK" INTO :"PK" FROM "TARTIKELINVESTIGING" WHERE ("CINTERNEFIRMAS_FK"=:"pfirmapk") AND ("CINTERNEFIRMAVESTIGINGEN_FK"=:"pvestigingpk") AND ("CARTIKELS_FK"=:"partikel") AND ("CKLEUR"=:"pkleur") AND ("CMAAT"=:"pmaat");
IF :"PK" IS NULL THEN INSERT INTO "TARTIKELINVESTIGING"("CARTIKELINVESTIGING_PK","CINTERNEFIRMAS_FK","CINTERNEFIRMA","CINTERNEFIRMAVESTIGINGEN_FK","CINTERNEFIRMAVESTIGING","CARTIKELS_FK","CKLEUR","CMAAT","CINBESTELLINGKLANT","CINBESTELLINGLEVERANCIER","CINCONSIGNATIEKLANT","CINCONSIGNATIELEVERANCIER","CINRESERVATIE","CINPRODUCTIE","CVOORPRODUCTIE") VALUES(SELECT UNIQUE FROM "TARTIKELINVESTIGING",:"pfirmapk",:"pfirma",:"pvestigingpk",:"pvestiging",:"partikel",:"pkleur",:"pmaat",0,0,:"paantal",0,0,0,0); ELSE UPDATE "TARTIKELINVESTIGING" SET "CINCONSIGNATIEKLANT" = "CINCONSIGNATIEKLANT"+(:"paantal"), "CWIJZIGDATUM" = CAST(CURRENT_TIMESTAMP(0) AS TIMESTAMP(6)), "CWIJZIGGEBRUIKER" = CURRENT_USER WHERE "CARTIKELINVESTIGING_PK"=:"PK"; END IF;
END;

CREATE PROCEDURE "AANTALINCONSIGNATIELEVERANCIER"( IN :"partikel" INTEGER, IN :"pkleur" CHARACTER VARYING(10), IN :"pmaat" CHARACTER VARYING(10), IN :"paantal" FLOAT, IN :"pfirmapk" INTEGER, IN :"pfirma" CHARACTER VARYING(10), IN :"pvestigingpk" INTEGER, IN :"pvestiging" CHARACTER VARYING(10)) 
BEGIN
DECLARE "PK" INT;
SELECT "CARTIKELINVESTIGING_PK" INTO :"PK" FROM "TARTIKELINVESTIGING" WHERE ("CINTERNEFIRMAS_FK"=:"pfirmapk") AND ("CINTERNEFIRMAVESTIGINGEN_FK"=:"pvestigingpk") AND ("CARTIKELS_FK"=:"partikel") AND ("CKLEUR"=:"pkleur") AND ("CMAAT"=:"pmaat");
IF :"PK" IS NULL THEN INSERT INTO "TARTIKELINVESTIGING"("CARTIKELINVESTIGING_PK","CINTERNEFIRMAS_FK","CINTERNEFIRMA","CINTERNEFIRMAVESTIGINGEN_FK","CINTERNEFIRMAVESTIGING","CARTIKELS_FK","CKLEUR","CMAAT","CINBESTELLINGKLANT","CINBESTELLINGLEVERANCIER","CINCONSIGNATIEKLANT","CINCONSIGNATIELEVERANCIER","CINRESERVATIE","CINPRODUCTIE","CVOORPRODUCTIE") VALUES(SELECT UNIQUE FROM "TARTIKELINVESTIGING",:"pfirmapk",:"pfirma",:"pvestigingpk",:"pvestiging",:"partikel",:"pkleur",:"pmaat",0,0,0,:"paantal",0,0,0); ELSE UPDATE "TARTIKELINVESTIGING" SET "CINCONSIGNATIELEVERANCIER" = "CINCONSIGNATIELEVERANCIER"+(:"paantal"), "CWIJZIGDATUM" = CAST(CURRENT_TIMESTAMP(0) AS TIMESTAMP(6)), "CWIJZIGGEBRUIKER" = CURRENT_USER WHERE "CARTIKELINVESTIGING_PK"=:"PK"; END IF;
END;

CREATE PROCEDURE "AANTALINRESERVATIE"( IN :"partikel" INTEGER, IN :"pkleur" CHARACTER VARYING(10), IN :"pmaat" CHARACTER VARYING(10), IN :"paantal" FLOAT, IN :"pfirmapk" INTEGER, IN :"pfirma" CHARACTER VARYING(10), IN :"pvestigingpk" INTEGER, IN :"pvestiging" CHARACTER VARYING(10)) 
BEGIN
DECLARE "PK" INT;
SELECT "CARTIKELINVESTIGING_PK" INTO :"PK" FROM "TARTIKELINVESTIGING" WHERE ("CINTERNEFIRMAS_FK"=:"pfirmapk") AND ("CINTERNEFIRMAVESTIGINGEN_FK"=:"pvestigingpk") AND ("CARTIKELS_FK"=:"partikel") AND ("CKLEUR"=:"pkleur") AND ("CMAAT"=:"pmaat");
IF :"PK" IS NULL THEN INSERT INTO "TARTIKELINVESTIGING"("CARTIKELINVESTIGING_PK","CINTERNEFIRMAS_FK","CINTERNEFIRMA","CINTERNEFIRMAVESTIGINGEN_FK","CINTERNEFIRMAVESTIGING","CARTIKELS_FK","CKLEUR","CMAAT","CINBESTELLINGKLANT","CINBESTELLINGLEVERANCIER","CINCONSIGNATIEKLANT","CINCONSIGNATIELEVERANCIER","CINRESERVATIE","CINPRODUCTIE","CVOORPRODUCTIE") VALUES(SELECT UNIQUE FROM "TARTIKELINVESTIGING",:"pfirmapk",:"pfirma",:"pvestigingpk",:"pvestiging",:"partikel",:"pkleur",:"pmaat",0,0,0,0,:"paantal",0,0); ELSE UPDATE "TARTIKELINVESTIGING" SET "CINRESERVATIE" = "CINRESERVATIE"+(:"paantal"), "CWIJZIGDATUM" = CAST(CURRENT_TIMESTAMP(0) AS TIMESTAMP(6)), "CWIJZIGGEBRUIKER" = CURRENT_USER WHERE "CARTIKELINVESTIGING_PK"=:"PK"; END IF;
END;

CREATE PROCEDURE "AANTALVOORPRODUCTIE"( IN :"partikel" INTEGER, IN :"pkleur" CHARACTER VARYING(10), IN :"pmaat" CHARACTER VARYING(10), IN :"paantal" FLOAT, IN :"pfirmapk" INTEGER, IN :"pfirma" CHARACTER VARYING(10), IN :"pvestigingpk" INTEGER, IN :"pvestiging" CHARACTER VARYING(10)) 
BEGIN
DECLARE "PK" INT;
SELECT "CARTIKELINVESTIGING_PK" INTO :"PK" FROM "TARTIKELINVESTIGING" WHERE ("CINTERNEFIRMAS_FK"=:"pfirmapk") AND ("CINTERNEFIRMAVESTIGINGEN_FK"=:"pvestigingpk") AND ("CARTIKELS_FK"=:"partikel") AND ("CKLEUR"=:"pkleur") AND ("CMAAT"=:"pmaat");
IF :"PK" IS NULL THEN INSERT INTO "TARTIKELINVESTIGING"("CARTIKELINVESTIGING_PK","CINTERNEFIRMAS_FK","CINTERNEFIRMA","CINTERNEFIRMAVESTIGINGEN_FK","CINTERNEFIRMAVESTIGING","CARTIKELS_FK","CKLEUR","CMAAT","CINBESTELLINGKLANT","CINBESTELLINGLEVERANCIER","CINCONSIGNATIEKLANT","CINCONSIGNATIELEVERANCIER","CINRESERVATIE","CINPRODUCTIE","CVOORPRODUCTIE") VALUES(SELECT UNIQUE FROM "TARTIKELINVESTIGING",:"pfirmapk",:"pfirma",:"pvestigingpk",:"pvestiging",:"partikel",:"pkleur",:"pmaat",0,0,0,0,0,0,:"paantal"); ELSE UPDATE "TARTIKELINVESTIGING" SET "CVOORPRODUCTIE" = "CVOORPRODUCTIE"+(:"paantal"), "CWIJZIGDATUM" = CAST(CURRENT_TIMESTAMP(0) AS TIMESTAMP(6)), "CWIJZIGGEBRUIKER" = CURRENT_USER WHERE "CARTIKELINVESTIGING_PK"=:"PK"; END IF;
END;

CREATE PROCEDURE "AANTALINPRODUCTIE"( IN :"partikel" INTEGER, IN :"pkleur" CHARACTER VARYING(10), IN :"pmaat" CHARACTER VARYING(10), IN :"paantal" FLOAT, IN :"pfirmapk" INTEGER, IN :"pfirma" CHARACTER VARYING(10), IN :"pvestigingpk" INTEGER, IN :"pvestiging" CHARACTER VARYING(10)) 
BEGIN
DECLARE "PK" INT;
SELECT "CARTIKELINVESTIGING_PK" INTO :"PK" FROM "TARTIKELINVESTIGING" WHERE ("CINTERNEFIRMAS_FK"=:"pfirmapk") AND ("CINTERNEFIRMAVESTIGINGEN_FK"=:"pvestigingpk") AND ("CARTIKELS_FK"=:"partikel") AND ("CKLEUR"=:"pkleur") AND ("CMAAT"=:"pmaat");
IF :"PK" IS NULL THEN INSERT INTO "TARTIKELINVESTIGING"("CARTIKELINVESTIGING_PK","CINTERNEFIRMAS_FK","CINTERNEFIRMA","CINTERNEFIRMAVESTIGINGEN_FK","CINTERNEFIRMAVESTIGING","CARTIKELS_FK","CKLEUR","CMAAT","CINBESTELLINGKLANT","CINBESTELLINGLEVERANCIER","CINCONSIGNATIEKLANT","CINCONSIGNATIELEVERANCIER","CINRESERVATIE","CINPRODUCTIE","CVOORPRODUCTIE") VALUES(SELECT UNIQUE FROM "TARTIKELINVESTIGING",:"pfirmapk",:"pfirma",:"pvestigingpk",:"pvestiging",:"partikel",:"pkleur",:"pmaat",0,0,0,0,0,:"paantal",0); ELSE UPDATE "TARTIKELINVESTIGING" SET "CINPRODUCTIE" = "CINPRODUCTIE"+(:"paantal"), "CWIJZIGDATUM" = CAST(CURRENT_TIMESTAMP(0) AS TIMESTAMP(6)), "CWIJZIGGEBRUIKER" = CURRENT_USER WHERE "CARTIKELINVESTIGING_PK"=:"PK"; END IF;
END;

CREATE PROCEDURE "PRO_ARTIKELVOORRAAD"( IN :"partikel" INTEGER, IN :"pkleur" CHARACTER VARYING(10), IN :"pmaat" CHARACTER VARYING(10), IN :"paantal" FLOAT, IN :"paantalbeschikbaar" FLOAT, IN :"pinpicking" FLOAT, IN :"pfirmapk" INTEGER, IN :"pfirma" CHARACTER VARYING(10), IN :"pvestigingpk" INTEGER, IN :"pvestiging" CHARACTER VARYING(10), IN :"pmagazijn" CHARACTER VARYING(10)) 
BEGIN
DECLARE "PK" INT;
SELECT "CARTIKELVOORRAAD_PK" INTO :"PK" FROM "TARTIKELVOORRAAD" WHERE ("CINTERNEFIRMAS_FK"=:"pfirmapk") AND ("CINTERNEFIRMAVESTIGINGEN_FK"=:"pvestigingpk") AND ("CVESTIGINGMAGAZIJN"=:"pmagazijn") AND ("CARTIKELS_FK"=:"partikel") AND ("CKLEUR"=:"pkleur") AND ("CMAAT"=:"pmaat") AND ("CLOTNUMMER"='');
IF :"PK" IS NULL THEN INSERT INTO "TARTIKELVOORRAAD"("CARTIKELVOORRAAD_PK","CINTERNEFIRMAS_FK","CINTERNEFIRMA","CINTERNEFIRMAVESTIGINGEN_FK","CINTERNEFIRMAVESTIGING","CVESTIGINGMAGAZIJN","CARTIKELS_FK","CKLEUR","CMAAT","CLOTNUMMER","CLOTDATUM","CVOORRAAD","CVOORRAADBESCHIKBAAR","CINPICKING") VALUES(SELECT UNIQUE FROM "TARTIKELVOORRAAD",:"pfirmapk",:"pfirma",:"pvestigingpk",:"pvestiging",:"pmagazijn",:"partikel",:"pkleur",:"pmaat",'',NULL,:"paantal",:"paantalbeschikbaar",:"pinpicking"); ELSE UPDATE "TARTIKELVOORRAAD" SET "CVOORRAAD" = "CVOORRAAD"+(:"paantal"), "CVOORRAADBESCHIKBAAR" = "CVOORRAADBESCHIKBAAR"+(:"paantalbeschikbaar"), "CINPICKING" = "CINPICKING"+(:"pinpicking"), "CWIJZIGDATUM" = CAST(CURRENT_TIMESTAMP(0) AS TIMESTAMP(6)), "CWIJZIGGEBRUIKER" = CURRENT_USER WHERE "CARTIKELVOORRAAD_PK"=:"PK"; END IF;
END;

CREATE PROCEDURE "PRO_AANKOOPLIJNEN"( IN :"PK" INTEGER, IN :"PARTIKELS_FK" INTEGER, IN :"PKLEUR" CHARACTER VARYING(10), IN :"PMAAT" CHARACTER VARYING(10), IN :"PAANTAL" FLOAT) 
BEGIN
DECLARE "CDOCUMENTTYPES_FK" INT;
DECLARE "CINTERNEFIRMA" VARCHAR(10);
DECLARE "CINTERNEFIRMAS_FK" INT;
DECLARE "CINTERNEFIRMAVESTIGING" VARCHAR(10);
DECLARE "CINTERNEFIRMAVESTIGINGEN_FK" INT;
DECLARE "C_CRSR" CURSOR FOR SELECT "CDOCUMENTTYPES_FK", "CINTERNEFIRMA", "CINTERNEFIRMAS_FK", "CINTERNEFIRMAVESTIGING", "CINTERNEFIRMAVESTIGINGEN_FK" FROM "TAANKOPEN" WHERE "CAANKOPEN_PK"=:"PK" FOR READ ONLY ;
OPEN "C_CRSR";
FETCH NEXT  FROM "C_CRSR" INTO :"CDOCUMENTTYPES_FK", :"CINTERNEFIRMA", :"CINTERNEFIRMAS_FK", :"CINTERNEFIRMAVESTIGING", :"CINTERNEFIRMAVESTIGINGEN_FK";
CLOSE "C_CRSR";
IF :"CDOCUMENTTYPES_FK"=22 THEN CALL "AANTALINBESTELLINGLEVERANCIER"(:"PARTIKELS_FK", :"PKLEUR", :"PMAAT", :"PAANTAL", :"CINTERNEFIRMAS_FK", :"CINTERNEFIRMA", :"CINTERNEFIRMAVESTIGINGEN_FK", :"CINTERNEFIRMAVESTIGING"); END IF;
DROP VARIABLES;
END;

CREATE PROCEDURE "SETLIJNNUMMERVERKOOP"( IN :"PK" INTEGER) 
BEGIN
DECLARE "CVERKOOPLIJNEN_PK" INT;
DECLARE "CNUMMERVORIGE" VARCHAR(20);
DECLARE "CLIJNNUMMER" INT;
DECLARE "CTELLER" INT;
DECLARE "C_CRSR" CURSOR FOR SELECT "CVERKOOPLIJNEN_PK", "CNUMMERVORIGE", "CLIJNNUMMER" FROM "TVERKOOPLIJNEN" WHERE "CVERKOPEN_FK"=:"PK" ORDER BY "CNUMMERVORIGE","CLIJNNUMMER" FOR READ ONLY ;
SET :"CTELLER"=0;
OPEN "C_CRSR";
SET :"CVERKOOPLIJNEN_PK"=CAST(NULL AS INT);
FETCH NEXT  FROM "C_CRSR" INTO :"CVERKOOPLIJNEN_PK", :"CNUMMERVORIGE", :"CLIJNNUMMER";
WHILE :"CVERKOOPLIJNEN_PK" IS NOT NULL  SET :"CTELLER"=(:"CTELLER")+1; UPDATE "TVERKOOPLIJNEN" SET "CLIJNNUMMER" = :"CTELLER" WHERE "CVERKOOPLIJNEN_PK"=:"CVERKOOPLIJNEN_PK"; SET :"CVERKOOPLIJNEN_PK"=CAST(NULL AS INT); FETCH NEXT  FROM "C_CRSR" INTO :"CVERKOOPLIJNEN_PK", :"CNUMMERVORIGE", :"CLIJNNUMMER"; END WHILE;
CLOSE "C_CRSR";
END;

CREATE PROCEDURE "SETLIJNNUMMERAANKOOP"( IN :"PK" INTEGER) 
BEGIN
DECLARE "CAANKOOPLIJNEN_PK" INT;
DECLARE "CNUMMERVORIGE" VARCHAR(20);
DECLARE "CLIJNNUMMER" INT;
DECLARE "CTELLER" INT;
DECLARE "C_CRSR" CURSOR FOR SELECT "CAANKOOPLIJNEN_PK", "CNUMMERVORIGE", "CLIJNNUMMER" FROM "TAANKOOPLIJNEN" WHERE "CVERKOPEN_FK"=:"PK" ORDER BY "CNUMMERVORIGE","CLIJNNUMMER" FOR READ ONLY ;
SET :"CTELLER"=0;
OPEN "C_CRSR";
SET :"CAANKOOPLIJNEN_PK"=CAST(NULL AS INT);
FETCH NEXT  FROM "C_CRSR" INTO :"CAANKOOPLIJNEN_PK", :"CNUMMERVORIGE", :"CLIJNNUMMER";
WHILE :"CAANKOOPLIJNEN_PK" IS NOT NULL  SET :"CTELLER"=(:"CTELLER")+1; UPDATE "TAANKOOPLIJNEN" SET "CLIJNNUMMER" = :"CTELLER" WHERE "CAANKOOPLIJNEN_PK"=:"CAANKOOPLIJNEN_PK"; SET :"CAANKOOPLIJNEN_PK"=CAST(NULL AS INT); FETCH NEXT  FROM "C_CRSR" INTO :"CAANKOOPLIJNEN_PK", :"CNUMMERVORIGE", :"CLIJNNUMMER"; END WHILE;
CLOSE "C_CRSR";
END;

CREATE PROCEDURE "PRO_ARTIKELINVESTIGING"( IN :"partikel" INTEGER) 
BEGIN
DECLARE "PK" INT;
SELECT "CARTIKELINVESTIGING_PK" INTO :"PK" FROM "TARTIKELINVESTIGING" WHERE "CARTIKELS_FK"=:"partikel";
IF :"PK" IS NULL THEN INSERT INTO "TARTIKELINVESTIGING"("CARTIKELINVESTIGING_PK","CARTIKELS_FK","CINTERNEFIRMA","CINTERNEFIRMAS_FK","CINTERNEFIRMAVESTIGING","CINTERNEFIRMAVESTIGINGEN_FK","CINBESTELLINGKLANT","CINBESTELLINGLEVERANCIER","CINCONSIGNATIEKLANT","CINCONSIGNATIELEVERANCIER","CINRESERVATIE","CKLEUR","CMAAT","CMAXVOORRAAD","CMINVOORRAAD","CINPRODUCTIE","CVOORPRODUCTIE") SELECT SELECT UNIQUE FROM "TARTIKELINVESTIGING", "TARTIKELS"."CARTIKELS_PK", "TINTERNEFIRMAS"."CINTERNEFIRMA", "TINTERNEFIRMAS"."CINTERNEFIRMAS_PK", "TINTERNEFIRMAVESTIGINGEN"."CINTERNEFIRMAVESTIGING", "TINTERNEFIRMAVESTIGINGEN"."CINTERNEFIRMAVESTIGINGEN_PK", 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0 FROM "TARTIKELS","TINTERNEFIRMAS","TINTERNEFIRMAVESTIGINGEN" WHERE ("TARTIKELS"."CARTIKELS_PK"=:"partikel") AND ("TARTIKELS"."CINTERNEFIRMAARTIKELS"="TINTERNEFIRMAS"."CINTERNEFIRMAARTIKELS") AND ("TINTERNEFIRMAS"."CINTERNEFIRMAS_PK"="TINTERNEFIRMAVESTIGINGEN"."CINTERNEFIRMAS_FK"); END IF;
END;

CREATE PROCEDURE "RECALCPROJECT"( IN :"PK" INTEGER, INOUT :"PUPDATED" BOOLEAN) 
BEGIN
DECLARE "CPROJECTEN_PK" INT;
DECLARE "CVERKOPEN_PK" INT;
DECLARE "CAANKOPEN_PK" INT;
DECLARE "CDOCUMENTTYPES_FK" INT;
DECLARE "CKORTINGPERCENTAGE" NUMERIC(5,2);
DECLARE "CBTWPERCENTAGE" NUMERIC(5,2);
DECLARE "CBEDRAG" NUMERIC(12,2);
DECLARE "CBEDRAGVERKOOP" NUMERIC(12,2);
DECLARE "CBEDRAGAANKOOP" NUMERIC(12,2);
DECLARE "CINCLBTW" BOOLEAN;
DECLARE "CREEELKOSTEN" NUMERIC(12,2);
DECLARE "CREEELOPBRENGSTEN" NUMERIC(12,2);
DECLARE "CREEELRESULTAAT" NUMERIC(12,2);
DECLARE "TOTAALKOSTEN" NUMERIC(12,2);
DECLARE "TOTAALARTIKELS" NUMERIC(12,2);
DECLARE "UURKOSTEN" NUMERIC(12,2);
DECLARE "TOTAALAANKOPEN" NUMERIC(12,2);
DECLARE "TOTAALVERKOPEN" NUMERIC(12,2);
DECLARE "CINTERNEFIRMAS_FK" INT;
DECLARE "CINTERNEFIRMAVESTIGINGEN_FK" INT;
DECLARE "CANALYTISCHEREKENINGEN_FK" INT;
DECLARE "CWAARDE" VARCHAR(1024);
DECLARE "CKOERS" NUMERIC(12,6);
DECLARE "C_CURSOR" CURSOR FOR SELECT "CPROJECTEN_PK", "CINTERNEFIRMAS_FK", "CINTERNEFIRMAVESTIGINGEN_FK", "CANALYTISCHEREKENINGEN_FK", "CREEELKOSTEN", "CREEELOPBRENGSTEN", "CREEELRESULTAAT" FROM "TPROJECTEN" WHERE "CPROJECTEN_PK"=:"PK" FOR READ ONLY ;
DECLARE "C_CURSORVERKOPEN" CURSOR FOR SELECT "CVERKOPEN_PK", "CDOCUMENTTYPES_FK", "CKORTINGPERCENTAGE", "TVERKOOPLIJNEN"."CBEDRAG", "TVERKOPEN"."CKOERS", "TVERKOOPLIJNEN"."CINCLBTW", "TVERKOOPLIJNEN"."CBTWPERCENTAGE" FROM "TVERKOPEN","TVERKOOPLIJNEN" WHERE ("CINTERNEFIRMAS_FK"=:"CINTERNEFIRMAS_FK") AND ("CINTERNEFIRMAVESTIGINGEN_FK"=:"CINTERNEFIRMAVESTIGINGEN_FK") AND ("CVERKOPEN_PK"="CVERKOPEN_FK") AND (("CDOCUMENTTYPES_FK"+0)=ANY (VALUES 5, 6)) AND ("CANALYTISCHEREKENINGEN_FK"=:"CANALYTISCHEREKENINGEN_FK") FOR READ ONLY ;
DECLARE "C_CURSORAANKOPEN25" CURSOR FOR SELECT "CAANKOPEN_PK", "CDOCUMENTTYPES_FK", "CKORTINGPERCENTAGE", "TAANKOOPLIJNEN"."CBEDRAG", "TAANKOPEN"."CKOERS" FROM "TAANKOPEN","TAANKOOPLIJNEN" WHERE ("CINTERNEFIRMAS_FK"=:"CINTERNEFIRMAS_FK") AND ("CINTERNEFIRMAVESTIGINGEN_FK"=:"CINTERNEFIRMAVESTIGINGEN_FK") AND ("CAANKOPEN_PK"="CAANKOPEN_FK") AND (("CDOCUMENTTYPES_FK"+0)=ANY (VALUES 25, 26)) AND ("CANALYTISCHEREKENINGEN_FK"=:"CANALYTISCHEREKENINGEN_FK") FOR READ ONLY ;
DECLARE "C_CURSORAANKOPEN23" CURSOR FOR SELECT "CAANKOPEN_PK", "CDOCUMENTTYPES_FK", "CKORTINGPERCENTAGE", "TAANKOOPLIJNEN"."CBEDRAG", "TAANKOPEN"."CKOERS" FROM "TAANKOPEN","TAANKOOPLIJNEN" WHERE ("CINTERNEFIRMAS_FK"=:"CINTERNEFIRMAS_FK") AND ("CINTERNEFIRMAVESTIGINGEN_FK"=:"CINTERNEFIRMAVESTIGINGEN_FK") AND ("CAANKOPEN_PK"="CAANKOPEN_FK") AND (("CDOCUMENTTYPES_FK"+0)=ANY (VALUES 23, 24)) AND ("CANALYTISCHEREKENINGEN_FK"=:"CANALYTISCHEREKENINGEN_FK") AND ("TAANKOOPLIJNEN"."CSTATUS"<99) FOR READ ONLY ;
OPEN "C_CURSOR";
FETCH NEXT  FROM "C_CURSOR" INTO :"CPROJECTEN_PK", :"CINTERNEFIRMAS_FK", :"CINTERNEFIRMAVESTIGINGEN_FK", :"CANALYTISCHEREKENINGEN_FK", :"CREEELKOSTEN", :"CREEELOPBRENGSTEN", :"CREEELRESULTAAT";
CLOSE "C_CURSOR";
SET :"CWAARDE"=(SELECT "CWAARDE" FROM "TINSTELLINGEN" WHERE ("CINTERNEFIRMAS_FK"=:"CINTERNEFIRMAS_FK") AND ("CINTERNEFIRMAVESTIGINGEN_FK"=:"CINTERNEFIRMAVESTIGINGEN_FK") AND ("CINDEX"='projlinkfactuur'));
SET :"TOTAALKOSTEN"=0;
SET :"TOTAALARTIKELS"=0;
SET :"TOTAALAANKOPEN"=0;
SET :"TOTAALVERKOPEN"=0;
SET :"UURKOSTEN"=0;
SET :"PUPDATED"=FALSE;
SET :"TOTAALKOSTEN"=(SELECT SUM(ALL "CAANKOOPPRIJS"*"CAANTAL") FROM "TPRESTATIES" WHERE ("CINTERNEFIRMAS_FK"=:"CINTERNEFIRMAS_FK") AND ("CDOCUMENTTYPES_FK"=52) AND ("CDOCUMENT_FK"=:"PK") AND ("CTYPE"=1));
IF :"TOTAALKOSTEN" IS NULL THEN SET :"TOTAALKOSTEN"=0; END IF;
SET :"UURKOSTEN"=(SELECT SUM(ALL (("CDUURTIJD"+"CDUURTIJDEXTRA")*"CUURKOST")/3600) FROM "TPRESTATIES" WHERE ("CINTERNEFIRMAS_FK"=:"CINTERNEFIRMAS_FK") AND ("CDOCUMENTTYPES_FK"=52) AND ("CDOCUMENT_FK"=:"PK") AND ("CTYPE"=0));
IF :"UURKOSTEN" IS NULL THEN SET :"UURKOSTEN"=0; END IF;
SET :"TOTAALKOSTEN"=(:"TOTAALKOSTEN")+(:"UURKOSTEN");
IF (:"CANALYTISCHEREKENINGEN_FK">0) AND (:"CWAARDE"='1') THEN SET :"TOTAALAANKOPEN"=(SELECT SUM(ALL "TBOEKINGHISTORIEK"."CBEDRAGDEBETREF"-"TBOEKINGHISTORIEK"."CBEDRAGCREDITREF") FROM "TBOEKINGEN","TBOEKINGHISTORIEK" WHERE ("CINTERNEFIRMAS_FK"=:"CINTERNEFIRMAS_FK") AND ("CBOEKINGEN_PK"="CBOEKINGEN_FK") AND (("CDAGBOEKSOORT")=ANY (VALUES 1, 2)) AND ("TBOEKINGHISTORIEK"."CSOORT"='A') AND ("CANALYTISCHEREKENINGEN_FK"=:"CANALYTISCHEREKENINGEN_FK")); IF :"TOTAALAANKOPEN" IS NULL THEN SET :"TOTAALAANKOPEN"=0; END IF; SET :"TOTAALVERKOPEN"=(SELECT SUM(ALL CASE WHEN "CDAGBOEKSOORT"=3 THEN "CBEDRAG" ELSE "CBEDRAG"*-1 END) FROM "TFACTUREN","TFACTLIJNEN" WHERE ("CINTERNEFIRMAS_FK"=:"CINTERNEFIRMAS_FK") AND ("CFACTUREN_PK"="CFACTUREN_FK") AND (("CDAGBOEKSOORT")=ANY (VALUES 3, 4)) AND ("CANALYTISCHEREKENINGEN_FK"=:"CANALYTISCHEREKENINGEN_FK")); IF :"TOTAALVERKOPEN" IS NULL THEN SET :"TOTAALVERKOPEN"=0; END IF; END IF;
IF (:"CANALYTISCHEREKENINGEN_FK">0) AND (:"CWAARDE"='2') THEN OPEN "C_CURSORAANKOPEN23"; SET :"CAANKOPEN_PK"=CAST(NULL AS INT); FETCH NEXT  FROM "C_CURSORAANKOPEN23" INTO :"CAANKOPEN_PK", :"CDOCUMENTTYPES_FK", :"CKORTINGPERCENTAGE", :"CBEDRAG", :"CKOERS"; WHILE :"CAANKOPEN_PK" IS NOT NULL  SET :"CBEDRAGAANKOOP"=CAST((:"CBEDRAG")/(:"CKOERS") AS NUMERIC(12,2)); IF :"CDOCUMENTTYPES_FK"=26 THEN SET :"CBEDRAGAANKOOP"=(:"CBEDRAG")*-1; END IF; IF :"CKORTINGPERCENTAGE">0 THEN SET :"CBEDRAGAANKOOP"=CAST((:"CBEDRAGAANKOOP")-(((:"CBEDRAGAANKOOP")*(:"CKORTINGPERCENTAGE"))/100) AS NUMERIC(12,2)); END IF; IF :"CBEDRAGAANKOOP" IS NULL THEN SET :"CBEDRAGAANKOOP"=0; END IF; SET :"TOTAALAANKOPEN"=(:"TOTAALAANKOPEN")+(:"CBEDRAGAANKOOP"); SET :"CAANKOPEN_PK"=CAST(NULL AS INT); FETCH NEXT  FROM "C_CURSORAANKOPEN23" INTO :"CAANKOPEN_PK", :"CDOCUMENTTYPES_FK", :"CKORTINGPERCENTAGE", :"CBEDRAG", :"CKOERS"; END WHILE; CLOSE "C_CURSORAANKOPEN23"; OPEN "C_CURSORAANKOPEN25"; SET :"CAANKOPEN_PK"=CAST(NULL AS INT); FETCH NEXT  FROM "C_CURSORAANKOPEN25" INTO :"CAANKOPEN_PK", :"CDOCUMENTTYPES_FK", :"CKORTINGPERCENTAGE", :"CBEDRAG", :"CKOERS"; WHILE :"CAANKOPEN_PK" IS NOT NULL  SET :"CBEDRAGAANKOOP"=CAST((:"CBEDRAG")/(:"CKOERS") AS NUMERIC(12,2)); IF :"CDOCUMENTTYPES_FK"=26 THEN SET :"CBEDRAGAANKOOP"=(:"CBEDRAG")*-1; END IF; IF :"CKORTINGPERCENTAGE">0 THEN SET :"CBEDRAGAANKOOP"=CAST((:"CBEDRAGAANKOOP")-(((:"CBEDRAGAANKOOP")*(:"CKORTINGPERCENTAGE"))/100) AS NUMERIC(12,2)); END IF; IF :"CBEDRAGAANKOOP" IS NULL THEN SET :"CBEDRAGAANKOOP"=0; END IF; SET :"TOTAALAANKOPEN"=(:"TOTAALAANKOPEN")+(:"CBEDRAGAANKOOP"); SET :"CAANKOPEN_PK"=CAST(NULL AS INT); FETCH NEXT  FROM "C_CURSORAANKOPEN25" INTO :"CAANKOPEN_PK", :"CDOCUMENTTYPES_FK", :"CKORTINGPERCENTAGE", :"CBEDRAG", :"CKOERS"; END WHILE; CLOSE "C_CURSORAANKOPEN25"; OPEN "C_CURSORVERKOPEN"; SET :"CVERKOPEN_PK"=CAST(NULL AS INT); FETCH NEXT  FROM "C_CURSORVERKOPEN" INTO :"CVERKOPEN_PK", :"CDOCUMENTTYPES_FK", :"CKORTINGPERCENTAGE", :"CBEDRAG", :"CKOERS", :"CINCLBTW", :"CBTWPERCENTAGE"; WHILE :"CVERKOPEN_PK" IS NOT NULL  SET :"CBEDRAGVERKOOP"=CAST((:"CBEDRAG")/(:"CKOERS") AS NUMERIC(12,2)); IF :"CDOCUMENTTYPES_FK"=6 THEN SET :"CBEDRAGVERKOOP"=(:"CBEDRAG")*-1; END IF; IF :"CINCLBTW"=TRUE THEN SET :"CBEDRAGVERKOOP"=CAST((:"CBEDRAGVERKOOP")/(1+((:"CBTWPERCENTAGE")/100)) AS NUMERIC(12,2)); END IF; IF :"CKORTINGPERCENTAGE">0 THEN SET :"CBEDRAGVERKOOP"=CAST((:"CBEDRAGVERKOOP")-(((:"CBEDRAGVERKOOP")*(:"CKORTINGPERCENTAGE"))/100) AS NUMERIC(12,2)); END IF; IF :"CBEDRAGVERKOOP" IS NULL THEN SET :"CBEDRAGVERKOOP"=0; END IF; SET :"TOTAALVERKOPEN"=(:"TOTAALVERKOPEN")+(:"CBEDRAGVERKOOP"); SET :"CVERKOPEN_PK"=CAST(NULL AS INT); FETCH NEXT  FROM "C_CURSORVERKOPEN" INTO :"CVERKOPEN_PK", :"CDOCUMENTTYPES_FK", :"CKORTINGPERCENTAGE", :"CBEDRAG", :"CKOERS", :"CINCLBTW", :"CBTWPERCENTAGE"; END WHILE; CLOSE "C_CURSORVERKOPEN"; END IF;
SET :"TOTAALARTIKELS"=(SELECT SUM(ALL "CBEDRAG") FROM "TPROJECTARTIKELS" WHERE "CPROJECTEN_FK"=:"PK");
IF :"TOTAALARTIKELS" IS NULL THEN SET :"TOTAALARTIKELS"=0; END IF;
IF (:"TOTAALKOSTEN")+(:"TOTAALAANKOPEN")+(:"TOTAALARTIKELS")<>:"CREEELKOSTEN" THEN SET :"PUPDATED"=TRUE; END IF;
IF :"TOTAALVERKOPEN"<>:"CREEELOPBRENGSTEN" THEN SET :"PUPDATED"=TRUE; END IF;
IF :"PUPDATED" THEN SET :"CREEELKOSTEN"=(:"TOTAALKOSTEN")+(:"TOTAALAANKOPEN")+(:"TOTAALARTIKELS"); SET :"CREEELOPBRENGSTEN"=:"TOTAALVERKOPEN"; SET :"CREEELRESULTAAT"=(:"CREEELOPBRENGSTEN")-(:"CREEELKOSTEN"); UPDATE "TPROJECTEN" SET "CREEELKOSTEN" = :"CREEELKOSTEN", "CREEELOPBRENGSTEN" = :"CREEELOPBRENGSTEN", "CREEELRESULTAAT" = :"CREEELRESULTAAT" WHERE "CPROJECTEN_PK"=:"PK"; END IF;
END;

CREATE PROCEDURE "COPYARTIKEL"( IN :"PK" INTEGER, IN :"PARTIKEL" CHARACTER VARYING(25), IN :"POMSCHRIJVING1" CHARACTER VARYING(256), IN :"PVERKOOPPRIJZEN" BOOLEAN, IN :"PLEVERANCIERS" BOOLEAN, IN :"PLEVERANCIERSINFO" BOOLEAN, IN :"PONDERDELEN" BOOLEAN, IN :"PGEKOPPELDE" BOOLEAN, IN :"PLOCATIES" BOOLEAN, IN :"PVERPAKKINGEN" BOOLEAN, IN :"PKORTINGEN" BOOLEAN, INOUT :"PNEWPK" INTEGER) 
BEGIN
DECLARE "NEWPK" INT;
SET :"NEWPK"=SELECT UNIQUE FROM "TARTIKELS";
INSERT INTO "TARTIKELS"("CARTIKELS_PK","CARTIKEL","CINTERNEFIRMAARTIKELS","CARTIKELBARCODE","CARTIKELGROEPEN_FK","CBREEDTE","CBTWCODE","CBTWCODES_FK","CEENHEIDVOORRAAD","CGEENKORTINGEN","CGEWICHT","CGNCODE","CGNCODES_FK","CHOOGTE","CINFO1","CINFO2","CINFO3","CINFO4","CINFOINTERN","CKORTINGGROEP","CLENGTE","CMETLOTNUMMERS","CMETSERIENUMMERS","CMETVOORRAAD","CMETMONTAGE","CNIETACTIEF","COMSCHRIJVING1","COMSCHRIJVING2","COMSCHRIJVING3","COMSCHRIJVING4","CSELECTIECODE","CVERKOOPREKENING","CVERKOOPREKENINGEN_FK","CVERVANGARTIKEL","CMETKOPPELARTIKELEN","CVOLUME","CMATENBALKEN_FK","CKLEURENKAARTEN_FK","CEXTRA1","CEXTRA2","CEXTRA3","CEXTRA4","CEXTRA5","CEXTRA6","CEXTRA7","CEXTRA8","CEXTRADATUM1","CEXTRADATUM2","CLAND","CINFOINSTRUCTIE","CARTIKELGROEP","CGEENHERBEREKENING","CEINDEREEKS","CEENHEID","CEENHEIDVOLUME","CLENGTE2","CBREEDTE2","CHOOGTE2","CEENHEID2","CVOLUME2","CEENHEIDVOLUME2","CISDIENST","CISABONNEMENTARTIKEL","CWAARSCHUWING","CMERK","CCONTACT","CARTIKELFABRIKANT","CISWEBSITE","CISBESTELARTIKEL","CWAARSCHUWINGAANKOOP","CISGEWOGEN","CISLEEGGOED","CEXTRACHECKBOX1","CEXTRACHECKBOX2","CEXTRACHECKBOX3","CEXTRACHECKBOX4") SELECT :"NEWPK", :"PARTIKEL", "CINTERNEFIRMAARTIKELS", '', "CARTIKELGROEPEN_FK", "CBREEDTE", "CBTWCODE", "CBTWCODES_FK", "CEENHEIDVOORRAAD", "CGEENKORTINGEN", "CGEWICHT", "CGNCODE", "CGNCODES_FK", "CHOOGTE", "CINFO1", "CINFO2", "CINFO3", "CINFO4", "CINFOINTERN", "CKORTINGGROEP", "CLENGTE", "CMETLOTNUMMERS", "CMETSERIENUMMERS", "CMETVOORRAAD", "CMETMONTAGE", "CNIETACTIEF", :"POMSCHRIJVING1", "COMSCHRIJVING2", "COMSCHRIJVING3", "COMSCHRIJVING4", "CSELECTIECODE", "CVERKOOPREKENING", "CVERKOOPREKENINGEN_FK", "CVERVANGARTIKEL", "CMETKOPPELARTIKELEN", "CVOLUME", "CMATENBALKEN_FK", "CKLEURENKAARTEN_FK", "CEXTRA1", "CEXTRA2", "CEXTRA3", "CEXTRA4", "CEXTRA5", "CEXTRA6", "CEXTRA7", "CEXTRA8", "CEXTRADATUM1", "CEXTRADATUM2", "CLAND", "CINFOINSTRUCTIE", "CARTIKELGROEP", "CGEENHERBEREKENING", "CEINDEREEKS", "CEENHEID", "CEENHEIDVOLUME", "CLENGTE2", "CBREEDTE2", "CHOOGTE2", "CEENHEID2", "CVOLUME2", "CEENHEIDVOLUME2", "CISDIENST", "CISABONNEMENTARTIKEL", "CWAARSCHUWING", "CMERK", "CCONTACT", '', "CISWEBSITE", "CISBESTELARTIKEL", "CWAARSCHUWINGAANKOOP", "CISGEWOGEN", "CISLEEGGOED", "CEXTRACHECKBOX1", "CEXTRACHECKBOX2", "CEXTRACHECKBOX3", "CEXTRACHECKBOX4" FROM "TARTIKELS" WHERE "CARTIKELS_PK"=:"PK";
IF :"PGEKOPPELDE" IS FALSE THEN UPDATE "TARTIKELS" SET "CMETKOPPELARTIKELEN" = FALSE WHERE "CARTIKELS_PK"=:"NEWPK"; END IF;
IF :"PONDERDELEN" IS FALSE THEN UPDATE "TARTIKELS" SET "CMETMONTAGE" = FALSE WHERE "CARTIKELS_PK"=:"NEWPK"; END IF;
INSERT INTO "TARTIKELINFIRMA"("CARTIKELINFIRMA_PK","CARTIKELS_FK","CINTERNEFIRMA","CINTERNEFIRMAS_FK","CLAATSTEAANKOOPPRIJS","CLAATSTEAANKOOPKOSTEN","CGEMAANKOOPPRIJS","CAANKOOPREKENING","CAANKOOPREKENINGEN_FK") SELECT SELECT UNIQUE FROM "TARTIKELINFIRMA", :"NEWPK", "CINTERNEFIRMA", "CINTERNEFIRMAS_FK", "CLAATSTEAANKOOPPRIJS", "CLAATSTEAANKOOPKOSTEN", "CGEMAANKOOPPRIJS", "CAANKOOPREKENING", "CAANKOOPREKENINGEN_FK" FROM "TARTIKELINFIRMA" WHERE "CARTIKELS_FK"=:"PK";
UPDATE "TARTIKELINFIRMA" SET "CEERSTEAANKOOP" = NULL, "CEERSTEVERKOOP" = NULL, "CLAATSTEAANKOOP" = NULL, "CLAATSTEVERKOOP" = NULL, "CLAATSTEAANKOOPPRIJS" = 0, "CLAATSTEAANKOOPKOSTEN" = 0, "CGEMAANKOOPPRIJS" = 0 WHERE "CARTIKELS_FK"=:"NEWPK";
DECLARE "CNT" INT;
SET :"CNT"=(SELECT COUNT(ALL "CARTIKELINVESTIGING_PK") FROM "TARTIKELINVESTIGING" WHERE "CARTIKELS_FK"=:"PK");
IF :"CNT">0 THEN INSERT INTO "TARTIKELINVESTIGING"("CARTIKELINVESTIGING_PK","CARTIKELS_FK","CINTERNEFIRMA","CINTERNEFIRMAS_FK","CINTERNEFIRMAVESTIGING","CINTERNEFIRMAVESTIGINGEN_FK","CKLEUR","CMAAT","CMAXVOORRAAD","CMINVOORRAAD","CINBESTELLINGKLANT","CINBESTELLINGLEVERANCIER","CINCONSIGNATIEKLANT","CINCONSIGNATIELEVERANCIER","CINRESERVATIE","CINPRODUCTIE","CVOORPRODUCTIE") SELECT SELECT UNIQUE FROM "TARTIKELINVESTIGING", :"NEWPK", "CINTERNEFIRMA", "CINTERNEFIRMAS_FK", "CINTERNEFIRMAVESTIGING", "CINTERNEFIRMAVESTIGINGEN_FK", "CKLEUR", "CMAAT", 0, 0, 0, 0, 0, 0, 0, 0, 0 FROM "TARTIKELINVESTIGING" WHERE "CARTIKELS_FK"=:"PK"; END IF;
DECLARE "RCOUNT" INT;
SET :"RCOUNT"=(SELECT COUNT(ALL "CARTIKELS_FK") FROM "TARTIKELKLEURMAAT" WHERE "CARTIKELS_FK"=:"PK");
DECLARE "CKLEUR" VARCHAR(10);
DECLARE "CMAAT" VARCHAR(10);
DECLARE "CARTIKELKLEURMAAT" VARCHAR(50);
DECLARE "CARTIKELS_FK" INT;
DECLARE "M_CRSR" CURSOR FOR SELECT "CARTIKELS_FK", "CKLEUR", "CMAAT", "CARTIKELKLEURMAAT" FROM "TARTIKELKLEURMAAT" WHERE "CARTIKELS_FK"=:"PK" FOR READ ONLY ;
OPEN "M_CRSR";
WHILE :"RCOUNT">0  FETCH NEXT  FROM "M_CRSR" INTO :"CARTIKELS_FK", :"CKLEUR", :"CMAAT", :"CARTIKELKLEURMAAT"; SET :"RCOUNT"=(:"RCOUNT")-1; INSERT INTO "TARTIKELKLEURMAAT"("CARTIKELKLEURMAAT_PK","CARTIKELS_FK","CKLEUR","CMAAT","CARTIKELKLEURMAAT") VALUES(SELECT UNIQUE FROM "TARTIKELKLEURMAAT",:"NEWPK",:"CKLEUR",:"CMAAT",:"CARTIKELKLEURMAAT"); END WHILE;
CLOSE "M_CRSR";
IF :"PVERKOOPPRIJZEN"=TRUE THEN INSERT INTO "TARTIKELPRIJZEN"("CARTIKELPRIJZEN_PK","CARTIKELS_FK","CINTERNEFIRMA","CINTERNEFIRMAS_FK","CTARIEVEN_FK","CEENHEIDSPRIJS","CEENHEIDSPRIJSFACTOR","CEENHEIDSPRIJSEENHEID","CMINIMUMVERKOOPPRIJS","CTARIEF","CVERKOOPPRIJS","CMARGE","CAANTALFACTOR","CEENHEIDVERKOOP") SELECT SELECT UNIQUE FROM "TARTIKELPRIJZEN", :"NEWPK", "CINTERNEFIRMA", "CINTERNEFIRMAS_FK", "CTARIEVEN_FK", "CEENHEIDSPRIJS", "CEENHEIDSPRIJSFACTOR", "CEENHEIDSPRIJSEENHEID", "CMINIMUMVERKOOPPRIJS", "CTARIEF", "CVERKOOPPRIJS", "CMARGE", "CAANTALFACTOR", "CEENHEIDVERKOOP" FROM "TARTIKELPRIJZEN" WHERE "CARTIKELS_FK"=:"PK"; END IF;
IF (:"PLEVERANCIERS"=TRUE) AND (:"PLEVERANCIERSINFO"=TRUE) THEN INSERT INTO "TARTIKELLEVERANCIERS"("CARTIKELLEVERANCIERS_PK","CAANKOOPPRIJS","CAANKOOPPRIJSDATUM","CARTIKELLEVERANCIER","CARTIKELS_FK","CINTERNEFIRMA","CINTERNEFIRMAS_FK","CBEDRAG","CCONTACTEN_FK","CEENHEIDAANKOOP","CKORTINGPERCENTAGE","CMUNT","CMUNTEN_FK","COMSCHRIJVING","CAANKOOPKOSTEN","CHOOFDLEVERANCIER","CMINIMUMAANTAL","CAANKOOPPRIJSFACTOR","CVERPAKTPER") SELECT SELECT UNIQUE FROM "TARTIKELLEVERANCIERS", "CAANKOOPPRIJS", "CAANKOOPPRIJSDATUM", "CARTIKELLEVERANCIER", :"NEWPK", "CINTERNEFIRMA", "CINTERNEFIRMAS_FK", "CBEDRAG", "CCONTACTEN_FK", "CEENHEIDAANKOOP", "CKORTINGPERCENTAGE", "CMUNT", "CMUNTEN_FK", "COMSCHRIJVING", "CAANKOOPKOSTEN", "CHOOFDLEVERANCIER", "CMINIMUMAANTAL", "CAANKOOPPRIJSFACTOR", "CVERPAKTPER" FROM "TARTIKELLEVERANCIERS" WHERE "CARTIKELS_FK"=:"PK"; END IF;
IF (:"PLEVERANCIERS"=TRUE) AND (:"PLEVERANCIERSINFO"=FALSE) THEN INSERT INTO "TARTIKELLEVERANCIERS"("CARTIKELLEVERANCIERS_PK","CAANKOOPPRIJS","CARTIKELLEVERANCIER","CARTIKELS_FK","CINTERNEFIRMA","CINTERNEFIRMAS_FK","CBEDRAG","CCONTACTEN_FK","CEENHEIDAANKOOP","CKORTINGPERCENTAGE","CMUNT","CMUNTEN_FK","COMSCHRIJVING","CAANKOOPKOSTEN","CHOOFDLEVERANCIER","CMINIMUMAANTAL","CAANKOOPPRIJSFACTOR","CVERPAKTPER") SELECT SELECT UNIQUE FROM "TARTIKELLEVERANCIERS", 0, '', :"NEWPK", "CINTERNEFIRMA", "CINTERNEFIRMAS_FK", 0, "CCONTACTEN_FK", "CEENHEIDAANKOOP", 0, "CMUNT", "CMUNTEN_FK", '', 0, "CHOOFDLEVERANCIER", 0, "CAANKOOPPRIJSFACTOR", "CVERPAKTPER" FROM "TARTIKELLEVERANCIERS" WHERE "CARTIKELS_FK"=:"PK"; END IF;
IF :"PONDERDELEN" IS TRUE THEN INSERT INTO "TARTIKELONDERDELEN"("CARTIKELONDERDELEN_PK","CINTERNEFIRMA","CINTERNEFIRMAS_FK","CARTIKELS_FK","CONDERDELEN_FK","CAANTAL","COMSCHRIJVING") SELECT SELECT UNIQUE FROM "TARTIKELONDERDELEN", "CINTERNEFIRMA", "CINTERNEFIRMAS_FK", :"NEWPK", "CONDERDELEN_FK", "CAANTAL", "COMSCHRIJVING" FROM "TARTIKELONDERDELEN" WHERE "CARTIKELS_FK"=:"PK"; END IF;
IF :"PGEKOPPELDE" IS TRUE THEN INSERT INTO "TARTIKELGEKOPPELD"("CARTIKELGEKOPPELD_PK","CINTERNEFIRMA","CINTERNEFIRMAS_FK","CARTIKELS_FK","CGEKOPPELD_FK","CLIJNNUMMER","CAANTAL","COMSCHRIJVING","CVERPLICHT","CTAKSEN","CMETPRIJZEN") SELECT SELECT UNIQUE FROM "TARTIKELGEKOPPELD", "CINTERNEFIRMA", "CINTERNEFIRMAS_FK", :"NEWPK", "CGEKOPPELD_FK", "CLIJNNUMMER", "CAANTAL", "COMSCHRIJVING", "CVERPLICHT", "CTAKSEN", "CMETPRIJZEN" FROM "TARTIKELGEKOPPELD" WHERE "CARTIKELS_FK"=:"PK"; END IF;
IF :"PLOCATIES" IS TRUE THEN INSERT INTO "TARTIKELLOCATIES"("CARTIKELLOCATIES_PK","CINTERNEFIRMA","CINTERNEFIRMAS_FK","CINTERNEFIRMAVESTIGING","CINTERNEFIRMAVESTIGINGEN_FK","CARTIKELS_FK","CVESTIGINGMAGAZIJN","CLOCATIE") SELECT SELECT UNIQUE FROM "TARTIKELLOCATIES", "CINTERNEFIRMA", "CINTERNEFIRMAS_FK", "CINTERNEFIRMAVESTIGING", "CINTERNEFIRMAVESTIGINGEN_FK", :"NEWPK", "CVESTIGINGMAGAZIJN", "CLOCATIE" FROM "TARTIKELLOCATIES" WHERE "CARTIKELS_FK"=:"PK"; END IF;
IF :"PVERPAKKINGEN" IS TRUE THEN INSERT INTO "TARTIKELVERPAKKINGEN"("CARTIKELVERPAKKINGEN_PK","CINTERNEFIRMA","CINTERNEFIRMAS_FK","CARTIKELS_FK","CVERPAKKING","CAANTAL","CBREEDTE","CHOOGTE","CEENHEID","CEENHEIDVOLUME1","CEENHEIDVOLUME2","CGEWICHT","CLENGTE","CVOLUME1","CVOLUME2") SELECT SELECT UNIQUE FROM "TARTIKELVERPAKKINGEN", "CINTERNEFIRMA", "CINTERNEFIRMAS_FK", :"NEWPK", "CVERPAKKING", "CAANTAL", "CBREEDTE", "CHOOGTE", "CEENHEID", "CEENHEIDVOLUME1", "CEENHEIDVOLUME2", "CGEWICHT", "CLENGTE", "CVOLUME1", "CVOLUME2" FROM "TARTIKELVERPAKKINGEN" WHERE "CARTIKELS_FK"=:"PK"; END IF;
IF :"PKORTINGEN" IS TRUE THEN INSERT INTO "TARTIKELKORTINGEN"("CARTIKELKORTINGEN_PK","CINTERNEFIRMA","CINTERNEFIRMAS_FK","CARTIKELS_FK","CARTIKELKORTINGGROEP","CCONTACTEN_FK","CKLANTKORTINGGROEP","CKORTINGPERCENTAGE","COPERATOR","CVERKOOPPRIJS","CMUNT","CMUNTEN_FK","CDATUMVAN","CDATUMTOT","CMINIMUMAANTAL","CTARIEF","CTARIEVEN_FK","CKORTINGPERCENTAGETEKST","CEENHEIDVERKOOP","CAANTALFACTOR") SELECT SELECT UNIQUE FROM "TARTIKELKORTINGEN", "CINTERNEFIRMA", "CINTERNEFIRMAS_FK", :"NEWPK", "CARTIKELKORTINGGROEP", "CCONTACTEN_FK", "CKLANTKORTINGGROEP", "CKORTINGPERCENTAGE", "COPERATOR", "CVERKOOPPRIJS", "CMUNT", "CMUNTEN_FK", "CDATUMVAN", "CDATUMTOT", "CMINIMUMAANTAL", "CTARIEF", "CTARIEVEN_FK", "CKORTINGPERCENTAGETEKST", "CEENHEIDVERKOOP", "CAANTALFACTOR" FROM "TARTIKELKORTINGEN" WHERE "CARTIKELS_FK"=:"PK"; END IF;
SET :"PNEWPK"=:"NEWPK";
END;
COMMIT;

SET SCHEMA "_SYSTEM";
SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TALGEMENEREKENINGEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TALGEMENEREKENINGEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TALGEMENEREKENINGEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TALGEMENEREKENINGEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TALGEMENEREKENINGEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TALGEMENEREKENINGEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TBETALINGSVOORWAARDEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TBETALINGSVOORWAARDEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TBETALINGSVOORWAARDEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TBETALINGSVOORWAARDEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TBETALINGSVOORWAARDEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TBETALINGSVOORWAARDEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TBTWREGIMES" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TBTWREGIMES" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TBTWREGIMES" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TBTWREGIMES" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TBTWREGIMES" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TBTWREGIMES" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCOLINFO" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCOLINFO" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCOLINFO" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCOLINFO" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCOLINFO" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCOLINFO" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCONTACTEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCONTACTEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCONTACTEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCONTACTEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCONTACTEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCONTACTEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCONTACTGROEPEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCONTACTGROEPEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCONTACTGROEPEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCONTACTGROEPEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCONTACTGROEPEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCONTACTGROEPEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCONTACTGROEPENCONTACT" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCONTACTGROEPENCONTACT" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCONTACTGROEPENCONTACT" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCONTACTGROEPENCONTACT" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCONTACTGROEPENCONTACT" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCONTACTGROEPENCONTACT" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCONTACTPERSONEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCONTACTPERSONEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCONTACTPERSONEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCONTACTPERSONEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCONTACTPERSONEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCONTACTPERSONEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCONTACTROLLEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCONTACTROLLEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCONTACTROLLEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCONTACTROLLEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCONTACTROLLEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCONTACTROLLEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCONTACTROLLENBB" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCONTACTROLLENBB" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCONTACTROLLENBB" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCONTACTROLLENBB" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCONTACTROLLENBB" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCONTACTROLLENBB" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TINTERNEFIRMAMEDEWERKERS" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TINTERNEFIRMAMEDEWERKERS" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TINTERNEFIRMAMEDEWERKERS" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TINTERNEFIRMAMEDEWERKERS" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TINTERNEFIRMAMEDEWERKERS" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TINTERNEFIRMAMEDEWERKERS" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TINTERNEFIRMAS" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TINTERNEFIRMAS" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TINTERNEFIRMAS" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TINTERNEFIRMAS" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TINTERNEFIRMAS" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TINTERNEFIRMAS" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TLANDEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TLANDEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TLANDEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TLANDEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TLANDEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TLANDEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TDOCUMENTSTATUSSEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TDOCUMENTSTATUSSEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TDOCUMENTSTATUSSEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TDOCUMENTSTATUSSEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TDOCUMENTSTATUSSEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TDOCUMENTSTATUSSEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TLEVERINGSVOORWAARDEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TLEVERINGSVOORWAARDEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TLEVERINGSVOORWAARDEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TLEVERINGSVOORWAARDEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TLEVERINGSVOORWAARDEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TLEVERINGSVOORWAARDEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TMEDEWERKERGROEPEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TMEDEWERKERGROEPEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TMEDEWERKERGROEPEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TMEDEWERKERGROEPEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TMEDEWERKERGROEPEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TMEDEWERKERGROEPEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TMEDEWERKERS" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TMEDEWERKERS" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TMEDEWERKERS" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TMEDEWERKERS" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TMEDEWERKERS" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TMEDEWERKERS" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TMUNTEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TMUNTEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TMUNTEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TMUNTEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TMUNTEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TMUNTEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TNOACCESS" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TNOACCESS" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TNOACCESS" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TNOACCESS" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TNOACCESS" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TNOACCESS" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TPOSTCODES" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TPOSTCODES" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TPOSTCODES" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TPOSTCODES" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TPOSTCODES" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TPOSTCODES" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TROLGROEPEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TROLGROEPEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TROLGROEPEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TROLGROEPEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TROLGROEPEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TROLGROEPEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TTALEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TTALEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TTALEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TTALEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TTALEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TTALEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TTRANSPORTEURS" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TTRANSPORTEURS" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TTRANSPORTEURS" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TTRANSPORTEURS" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TTRANSPORTEURS" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TTRANSPORTEURS" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TVOORSTELREKENINGEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TVOORSTELREKENINGEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TVOORSTELREKENINGEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TVOORSTELREKENINGEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TVOORSTELREKENINGEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TVOORSTELREKENINGEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TWINPOSITIES" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TWINPOSITIES" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TWINPOSITIES" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TWINPOSITIES" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TWINPOSITIES" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TWINPOSITIES" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TROLLEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TROLLEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TROLLEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TROLLEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TROLLEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TROLLEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCODELIJSTEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCODELIJSTEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCODELIJSTEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCODELIJSTEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCODELIJSTEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCODELIJSTEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCOLSELECT" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCOLSELECT" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCOLSELECT" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCOLSELECT" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCOLSELECT" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCOLSELECT" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCATEGORIEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCATEGORIEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCATEGORIEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCATEGORIEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCATEGORIEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCATEGORIEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TARTIKELKORTINGENLEVERANCIERS" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TARTIKELKORTINGENLEVERANCIERS" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TARTIKELKORTINGENLEVERANCIERS" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TARTIKELKORTINGENLEVERANCIERS" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TARTIKELKORTINGENLEVERANCIERS" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TARTIKELKORTINGENLEVERANCIERS" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TSUBCATEGORIEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TSUBCATEGORIEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TSUBCATEGORIEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TSUBCATEGORIEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TSUBCATEGORIEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TSUBCATEGORIEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TREPORTS" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TREPORTS" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TREPORTS" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TREPORTS" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TREPORTS" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TREPORTS" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TREPTEMPLATES" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TREPTEMPLATES" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TREPTEMPLATES" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TREPTEMPLATES" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TREPTEMPLATES" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TREPTEMPLATES" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TMODULES" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TMODULES" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TMODULES" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TMODULES" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TMODULES" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TMODULES" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TINSTELLINGEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TINSTELLINGEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TINSTELLINGEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TINSTELLINGEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TINSTELLINGEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TINSTELLINGEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TDOCUMENTTYPES" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TDOCUMENTTYPES" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TDOCUMENTTYPES" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TDOCUMENTTYPES" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TDOCUMENTTYPES" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TDOCUMENTTYPES" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TRUIMTEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TRUIMTEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TRUIMTEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TRUIMTEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TRUIMTEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TRUIMTEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TANALYTISCHEREKENINGEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TANALYTISCHEREKENINGEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TANALYTISCHEREKENINGEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TANALYTISCHEREKENINGEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TANALYTISCHEREKENINGEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TANALYTISCHEREKENINGEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TBTWCODES" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TBTWCODES" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TBTWCODES" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TBTWCODES" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TBTWCODES" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TBTWCODES" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TGNCODES" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TGNCODES" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TGNCODES" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TGNCODES" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TGNCODES" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TGNCODES" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TARTIKELGROEPEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TARTIKELGROEPEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TARTIKELGROEPEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TARTIKELGROEPEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TARTIKELGROEPEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TARTIKELGROEPEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TDOCUMENTACTIES" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TDOCUMENTACTIES" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TDOCUMENTACTIES" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TDOCUMENTACTIES" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TDOCUMENTACTIES" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TDOCUMENTACTIES" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TINCOTERMS" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TINCOTERMS" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TINCOTERMS" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TINCOTERMS" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TINCOTERMS" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TINCOTERMS" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TINTRASTATGEWESTEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TINTRASTATGEWESTEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TINTRASTATGEWESTEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TINTRASTATGEWESTEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TINTRASTATGEWESTEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TINTRASTATGEWESTEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TINTRASTATTRANSACTIES" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TINTRASTATTRANSACTIES" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TINTRASTATTRANSACTIES" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TINTRASTATTRANSACTIES" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TINTRASTATTRANSACTIES" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TINTRASTATTRANSACTIES" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TINTRASTATVERVOER" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TINTRASTATVERVOER" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TINTRASTATVERVOER" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TINTRASTATVERVOER" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TINTRASTATVERVOER" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TINTRASTATVERVOER" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TVESTIGINGMAGAZIJNEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TVESTIGINGMAGAZIJNEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TVESTIGINGMAGAZIJNEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TVESTIGINGMAGAZIJNEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TVESTIGINGMAGAZIJNEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TVESTIGINGMAGAZIJNEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TARTIKELS" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TARTIKELS" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TARTIKELS" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TARTIKELS" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TARTIKELS" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TARTIKELS" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TARTIKELLEVERANCIERS" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TARTIKELLEVERANCIERS" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TARTIKELLEVERANCIERS" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TARTIKELLEVERANCIERS" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TARTIKELLEVERANCIERS" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TARTIKELLEVERANCIERS" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TARTIKELVOORRAAD" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TARTIKELVOORRAAD" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TARTIKELVOORRAAD" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TARTIKELVOORRAAD" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TARTIKELVOORRAAD" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TARTIKELVOORRAAD" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TKLEURENKAARTEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TKLEURENKAARTEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TKLEURENKAARTEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TKLEURENKAARTEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TKLEURENKAARTEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TKLEURENKAARTEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TKLEUREN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TKLEUREN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TKLEUREN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TKLEUREN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TKLEUREN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TKLEUREN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TMATENBALKEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TMATENBALKEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TMATENBALKEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TMATENBALKEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TMATENBALKEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TMATENBALKEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TMATEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TMATEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TMATEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TMATEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TMATEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TMATEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TARTIKELINVESTIGING" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TARTIKELINVESTIGING" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TARTIKELINVESTIGING" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TARTIKELINVESTIGING" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TARTIKELINVESTIGING" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TARTIKELINVESTIGING" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TARTIKELKORTINGEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TARTIKELKORTINGEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TARTIKELKORTINGEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TARTIKELKORTINGEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TARTIKELKORTINGEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TARTIKELKORTINGEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TARTIKELONDERDELEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TARTIKELONDERDELEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TARTIKELONDERDELEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TARTIKELONDERDELEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TARTIKELONDERDELEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TARTIKELONDERDELEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TARTIKELGEKOPPELD" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TARTIKELGEKOPPELD" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TARTIKELGEKOPPELD" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TARTIKELGEKOPPELD" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TARTIKELGEKOPPELD" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TARTIKELGEKOPPELD" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TADRESTYPES" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TADRESTYPES" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TADRESTYPES" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TADRESTYPES" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TADRESTYPES" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TADRESTYPES" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCONTACTADRESSEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCONTACTADRESSEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCONTACTADRESSEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCONTACTADRESSEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCONTACTADRESSEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCONTACTADRESSEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TTARIEVEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TTARIEVEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TTARIEVEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TTARIEVEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TTARIEVEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TTARIEVEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TARTIKELPRIJZEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TARTIKELPRIJZEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TARTIKELPRIJZEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TARTIKELPRIJZEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TARTIKELPRIJZEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TARTIKELPRIJZEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TVERKOPEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TVERKOPEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TVERKOPEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TVERKOPEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TVERKOPEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TVERKOPEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TVERKOOPCOLLI" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TVERKOOPCOLLI" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TVERKOOPCOLLI" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TVERKOOPCOLLI" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TVERKOOPCOLLI" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TVERKOOPCOLLI" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TVERKOOPBETALINGEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TVERKOOPBETALINGEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TVERKOOPBETALINGEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TVERKOOPBETALINGEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TVERKOOPBETALINGEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TVERKOOPBETALINGEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TVERKOOPLIJNEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TVERKOOPLIJNEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TVERKOOPLIJNEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TVERKOOPLIJNEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TVERKOOPLIJNEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TVERKOOPLIJNEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TMATERIALEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TMATERIALEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TMATERIALEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TMATERIALEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TMATERIALEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TMATERIALEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TAGENDALABELS" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TAGENDALABELS" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TAGENDALABELS" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TAGENDALABELS" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TAGENDALABELS" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TAGENDALABELS" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TAANKOPEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TAANKOPEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TAANKOPEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TAANKOPEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TAANKOPEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TAANKOPEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TAANKOOPLIJNEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TAANKOOPLIJNEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TAANKOOPLIJNEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TAANKOOPLIJNEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TAANKOOPLIJNEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TAANKOOPLIJNEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TAGENDA" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TAGENDA" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TAGENDA" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TAGENDA" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TAGENDA" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TAGENDA" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TVOORRAADWIJZIGINGEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TVOORRAADWIJZIGINGEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TVOORRAADWIJZIGINGEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TVOORRAADWIJZIGINGEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TVOORRAADWIJZIGINGEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TVOORRAADWIJZIGINGEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TVOORRAADTRANSFERSERIENUMMERS" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TVOORRAADTRANSFERSERIENUMMERS" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TVOORRAADTRANSFERSERIENUMMERS" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TVOORRAADTRANSFERSERIENUMMERS" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TVOORRAADTRANSFERSERIENUMMERS" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TVOORRAADTRANSFERSERIENUMMERS" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TVOORRAADWIJZIGINGSERIENUMMERS" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TVOORRAADWIJZIGINGSERIENUMMERS" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TVOORRAADWIJZIGINGSERIENUMMERS" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TVOORRAADWIJZIGINGSERIENUMMERS" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TVOORRAADWIJZIGINGSERIENUMMERS" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TVOORRAADWIJZIGINGSERIENUMMERS" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TVOORRAADTRANSFERS" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TVOORRAADTRANSFERS" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TVOORRAADTRANSFERS" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TVOORRAADTRANSFERS" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TVOORRAADTRANSFERS" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TVOORRAADTRANSFERS" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TLICENTIE" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TLICENTIE" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TLICENTIE" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TLICENTIE" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TLICENTIE" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TLICENTIE" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TSESSIES" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TSESSIES" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TSESSIES" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TSESSIES" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TSESSIES" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TSESSIES" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TARTIKELLOCATIES" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TARTIKELLOCATIES" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TARTIKELLOCATIES" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TARTIKELLOCATIES" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TARTIKELLOCATIES" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TARTIKELLOCATIES" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TPRODUCTIE" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TPRODUCTIE" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TPRODUCTIE" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TPRODUCTIE" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TPRODUCTIE" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TPRODUCTIE" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TARTIKELVERPAKKINGEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TARTIKELVERPAKKINGEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TARTIKELVERPAKKINGEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TARTIKELVERPAKKINGEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TARTIKELVERPAKKINGEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TARTIKELVERPAKKINGEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCRMCOMMUNICATIES" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCRMCOMMUNICATIES" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCRMCOMMUNICATIES" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCRMCOMMUNICATIES" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCRMCOMMUNICATIES" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCRMCOMMUNICATIES" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCRMCOMMUNICATIEBIJLAGEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCRMCOMMUNICATIEBIJLAGEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCRMCOMMUNICATIEBIJLAGEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCRMCOMMUNICATIEBIJLAGEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCRMCOMMUNICATIEBIJLAGEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCRMCOMMUNICATIEBIJLAGEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCRMTAKEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCRMTAKEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCRMTAKEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCRMTAKEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCRMTAKEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCRMTAKEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCRMTAAKBIJLAGEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCRMTAAKBIJLAGEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCRMTAAKBIJLAGEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCRMTAAKBIJLAGEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCRMTAAKBIJLAGEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCRMTAAKBIJLAGEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TPRODUCTIELIJNEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TPRODUCTIELIJNEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TPRODUCTIELIJNEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TPRODUCTIELIJNEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TPRODUCTIELIJNEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TPRODUCTIELIJNEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TAGENDAEXTRA" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TAGENDAEXTRA" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TAGENDAEXTRA" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TAGENDAEXTRA" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TAGENDAEXTRA" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TAGENDAEXTRA" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TAGENDAPREFS" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TAGENDAPREFS" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TAGENDAPREFS" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TAGENDAPREFS" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TAGENDAPREFS" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TAGENDAPREFS" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TKASSAAFSL" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TKASSAAFSL" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TKASSAAFSL" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TKASSAAFSL" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TKASSAAFSL" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TKASSAAFSL" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TKASSAAFSLBETAALWIJZEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TKASSAAFSLBETAALWIJZEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TKASSAAFSLBETAALWIJZEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TKASSAAFSLBETAALWIJZEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TKASSAAFSLBETAALWIJZEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TKASSAAFSLBETAALWIJZEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TKASSAAFSLOMZETTEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TKASSAAFSLOMZETTEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TKASSAAFSLOMZETTEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TKASSAAFSLOMZETTEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TKASSAAFSLOMZETTEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TKASSAAFSLOMZETTEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TBETAALWIJZEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TBETAALWIJZEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TBETAALWIJZEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TBETAALWIJZEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TBETAALWIJZEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TBETAALWIJZEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCONTACTSALDI" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCONTACTSALDI" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCONTACTSALDI" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCONTACTSALDI" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCONTACTSALDI" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCONTACTSALDI" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TBTWVAKKEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TBTWVAKKEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TBTWVAKKEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TBTWVAKKEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TBTWVAKKEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TBTWVAKKEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TBTWCODESPERVAK" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TBTWCODESPERVAK" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TBTWCODESPERVAK" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TBTWCODESPERVAK" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TBTWCODESPERVAK" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TBTWCODESPERVAK" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TBOEKJAREN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TBOEKJAREN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TBOEKJAREN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TBOEKJAREN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TBOEKJAREN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TBOEKJAREN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TKALENDERJAREN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TKALENDERJAREN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TKALENDERJAREN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TKALENDERJAREN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TKALENDERJAREN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TKALENDERJAREN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TBTWPERIODEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TBTWPERIODEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TBTWPERIODEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TBTWPERIODEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TBTWPERIODEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TBTWPERIODEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TBOEKPERIODEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TBOEKPERIODEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TBOEKPERIODEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TBOEKPERIODEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TBOEKPERIODEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TBOEKPERIODEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TINTRASTATAANGEVER" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TINTRASTATAANGEVER" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TINTRASTATAANGEVER" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TINTRASTATAANGEVER" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TINTRASTATAANGEVER" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TINTRASTATAANGEVER" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TDAGBOEKEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TDAGBOEKEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TDAGBOEKEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TDAGBOEKEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TDAGBOEKEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TDAGBOEKEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TDAGBOEKVOLGNR" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TDAGBOEKVOLGNR" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TDAGBOEKVOLGNR" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TDAGBOEKVOLGNR" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TDAGBOEKVOLGNR" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TDAGBOEKVOLGNR" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TTEKSTENRAPPEL" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TTEKSTENRAPPEL" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TTEKSTENRAPPEL" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TTEKSTENRAPPEL" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TTEKSTENRAPPEL" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TTEKSTENRAPPEL" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TANALSLEUTELS" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TANALSLEUTELS" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TANALSLEUTELS" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TANALSLEUTELS" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TANALSLEUTELS" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TANALSLEUTELS" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TBOEKINGEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TBOEKINGEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TBOEKINGEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TBOEKINGEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TBOEKINGEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TBOEKINGEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TBOEKINGHISTORIEK" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TBOEKINGHISTORIEK" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TBOEKINGHISTORIEK" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TBOEKINGHISTORIEK" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TBOEKINGHISTORIEK" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TBOEKINGHISTORIEK" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TBOEKINGBTW" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TBOEKINGBTW" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TBOEKINGBTW" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TBOEKINGBTW" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TBOEKINGBTW" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TBOEKINGBTW" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TBOEKINGINTRASTAT" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TBOEKINGINTRASTAT" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TBOEKINGINTRASTAT" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TBOEKINGINTRASTAT" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TBOEKINGINTRASTAT" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TBOEKINGINTRASTAT" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCENTRALISATIE" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCENTRALISATIE" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCENTRALISATIE" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCENTRALISATIE" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCENTRALISATIE" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCENTRALISATIE" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TANALCENTRALISATIE" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TANALCENTRALISATIE" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TANALCENTRALISATIE" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TANALCENTRALISATIE" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TANALCENTRALISATIE" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TANALCENTRALISATIE" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCENTRALISATIEOMZETTEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCENTRALISATIEOMZETTEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCENTRALISATIEOMZETTEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCENTRALISATIEOMZETTEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCENTRALISATIEOMZETTEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCENTRALISATIEOMZETTEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TAFSCHRIJVINGEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TAFSCHRIJVINGEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TAFSCHRIJVINGEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TAFSCHRIJVINGEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TAFSCHRIJVINGEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TAFSCHRIJVINGEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TFICHE28150" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TFICHE28150" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TFICHE28150" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TFICHE28150" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TFICHE28150" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TFICHE28150" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TBUDGETTEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TBUDGETTEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TBUDGETTEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TBUDGETTEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TBUDGETTEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TBUDGETTEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TANALBUDGETTEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TANALBUDGETTEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TANALBUDGETTEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TANALBUDGETTEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TANALBUDGETTEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TANALBUDGETTEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TBTWAANGIFTENBE" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TBTWAANGIFTENBE" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TBTWAANGIFTENBE" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TBTWAANGIFTENBE" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TBTWAANGIFTENBE" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TBTWAANGIFTENBE" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TSTRUCTUREN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TSTRUCTUREN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TSTRUCTUREN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TSTRUCTUREN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TSTRUCTUREN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TSTRUCTUREN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TSTRUCTUURDETAILS" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TSTRUCTUURDETAILS" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TSTRUCTUURDETAILS" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TSTRUCTUURDETAILS" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TSTRUCTUURDETAILS" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TSTRUCTUURDETAILS" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TSERVICE" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TSERVICE" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TSERVICE" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TSERVICE" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TSERVICE" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TSERVICE" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TSERVICEBETALINGEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TSERVICEBETALINGEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TSERVICEBETALINGEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TSERVICEBETALINGEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TSERVICEBETALINGEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TSERVICEBETALINGEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TSERVICEHISTORIEK" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TSERVICEHISTORIEK" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TSERVICEHISTORIEK" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TSERVICEHISTORIEK" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TSERVICEHISTORIEK" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TSERVICEHISTORIEK" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TSERVICELIJNEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TSERVICELIJNEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TSERVICELIJNEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TSERVICELIJNEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TSERVICELIJNEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TSERVICELIJNEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TSERVICELIJNSERIENUMMERS" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TSERVICELIJNSERIENUMMERS" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TSERVICELIJNSERIENUMMERS" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TSERVICELIJNSERIENUMMERS" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TSERVICELIJNSERIENUMMERS" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TSERVICELIJNSERIENUMMERS" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TSERVICESTATUSSEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TSERVICESTATUSSEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TSERVICESTATUSSEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TSERVICESTATUSSEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TSERVICESTATUSSEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TSERVICESTATUSSEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TKASSAUITGAVEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TKASSAUITGAVEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TKASSAUITGAVEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TKASSAUITGAVEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TKASSAUITGAVEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TKASSAUITGAVEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TFACTUREN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TFACTUREN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TFACTUREN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TFACTUREN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TFACTUREN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TFACTUREN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TFACTLIJNEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TFACTLIJNEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TFACTLIJNEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TFACTLIJNEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TFACTLIJNEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TFACTLIJNEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TFACTARTIKELGROEPEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TFACTARTIKELGROEPEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TFACTARTIKELGROEPEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TFACTARTIKELGROEPEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TFACTARTIKELGROEPEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TFACTARTIKELGROEPEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TFACTARTIKELS" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TFACTARTIKELS" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TFACTARTIKELS" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TFACTARTIKELS" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TFACTARTIKELS" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TFACTARTIKELS" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TKASSANUMMERS" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TKASSANUMMERS" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TKASSANUMMERS" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TKASSANUMMERS" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TKASSANUMMERS" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TKASSANUMMERS" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TVERWORPENUITGAVEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TVERWORPENUITGAVEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TVERWORPENUITGAVEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TVERWORPENUITGAVEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TVERWORPENUITGAVEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TVERWORPENUITGAVEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TDAVE" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TDAVE" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TDAVE" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TDAVE" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TDAVE" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TDAVE" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCRMMAILINGTEKSTEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCRMMAILINGTEKSTEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCRMMAILINGTEKSTEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCRMMAILINGTEKSTEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCRMMAILINGTEKSTEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCRMMAILINGTEKSTEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TXCONTACTEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TXCONTACTEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TXCONTACTEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TXCONTACTEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TXCONTACTEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TXCONTACTEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TXCONTACTPERSONEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TXCONTACTPERSONEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TXCONTACTPERSONEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TXCONTACTPERSONEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TXCONTACTPERSONEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TXCONTACTPERSONEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TXCONTACTADRESSEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TXCONTACTADRESSEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TXCONTACTADRESSEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TXCONTACTADRESSEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TXCONTACTADRESSEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TXCONTACTADRESSEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TXVERKOPEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TXVERKOPEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TXVERKOPEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TXVERKOPEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TXVERKOPEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TXVERKOPEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TXVERKOOPLIJNEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TXVERKOOPLIJNEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TXVERKOOPLIJNEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TXVERKOOPLIJNEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TXVERKOOPLIJNEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TXVERKOOPLIJNEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TXVERKOOPBETALINGEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TXVERKOOPBETALINGEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TXVERKOOPBETALINGEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TXVERKOOPBETALINGEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TXVERKOOPBETALINGEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TXVERKOOPBETALINGEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TMAGAZIJNLOCATIES" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TMAGAZIJNLOCATIES" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TMAGAZIJNLOCATIES" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TMAGAZIJNLOCATIES" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TMAGAZIJNLOCATIES" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TMAGAZIJNLOCATIES" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TARTIKELBIJLAGEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TARTIKELBIJLAGEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TARTIKELBIJLAGEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TARTIKELBIJLAGEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TARTIKELBIJLAGEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TARTIKELBIJLAGEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TARTIKELVOORRAADAANTALLEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TARTIKELVOORRAADAANTALLEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TARTIKELVOORRAADAANTALLEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TARTIKELVOORRAADAANTALLEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TARTIKELVOORRAADAANTALLEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TARTIKELVOORRAADAANTALLEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TVERKOOPLIJNAANTALLEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TVERKOOPLIJNAANTALLEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TVERKOOPLIJNAANTALLEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TVERKOOPLIJNAANTALLEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TVERKOOPLIJNAANTALLEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TVERKOOPLIJNAANTALLEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TAANKOOPLIJNAANTALLEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TAANKOOPLIJNAANTALLEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TAANKOOPLIJNAANTALLEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TAANKOOPLIJNAANTALLEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TAANKOOPLIJNAANTALLEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TAANKOOPLIJNAANTALLEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TPRODUCTIEAANTALLEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TPRODUCTIEAANTALLEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TPRODUCTIEAANTALLEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TPRODUCTIEAANTALLEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TPRODUCTIEAANTALLEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TPRODUCTIEAANTALLEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TPRODUCTIELIJNAANTALLEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TPRODUCTIELIJNAANTALLEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TPRODUCTIELIJNAANTALLEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TPRODUCTIELIJNAANTALLEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TPRODUCTIELIJNAANTALLEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TPRODUCTIELIJNAANTALLEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TSERVICELIJNAANTALLEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TSERVICELIJNAANTALLEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TSERVICELIJNAANTALLEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TSERVICELIJNAANTALLEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TSERVICELIJNAANTALLEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TSERVICELIJNAANTALLEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TXCONTACTGROEPEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TXCONTACTGROEPEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TXCONTACTGROEPEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TXCONTACTGROEPEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TXCONTACTGROEPEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TXCONTACTGROEPEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TEENHEDEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TEENHEDEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TEENHEDEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TEENHEDEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TEENHEDEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TEENHEDEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TMUNTWAARDEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TMUNTWAARDEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TMUNTWAARDEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TMUNTWAARDEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TMUNTWAARDEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TMUNTWAARDEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TDOCTEMPLATES" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TDOCTEMPLATES" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TDOCTEMPLATES" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TDOCTEMPLATES" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TDOCTEMPLATES" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TDOCTEMPLATES" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TAGENDAGROEPEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TAGENDAGROEPEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TAGENDAGROEPEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TAGENDAGROEPEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TAGENDAGROEPEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TAGENDAGROEPEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TAGENDAGROEPMEDEWERKERS" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TAGENDAGROEPMEDEWERKERS" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TAGENDAGROEPMEDEWERKERS" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TAGENDAGROEPMEDEWERKERS" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TAGENDAGROEPMEDEWERKERS" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TAGENDAGROEPMEDEWERKERS" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TUURROOSTERS" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TUURROOSTERS" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TUURROOSTERS" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TUURROOSTERS" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TUURROOSTERS" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TUURROOSTERS" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TMEDEWERKERUURKOST" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TMEDEWERKERUURKOST" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TMEDEWERKERUURKOST" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TMEDEWERKERUURKOST" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TMEDEWERKERUURKOST" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TMEDEWERKERUURKOST" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TPRESTATIESOORTEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TPRESTATIESOORTEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TPRESTATIESOORTEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TPRESTATIESOORTEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TPRESTATIESOORTEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TPRESTATIESOORTEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TPRESTATIES" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TPRESTATIES" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TPRESTATIES" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TPRESTATIES" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TPRESTATIES" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TPRESTATIES" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TSERVICEARTIKELS" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TSERVICEARTIKELS" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TSERVICEARTIKELS" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TSERVICEARTIKELS" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TSERVICEARTIKELS" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TSERVICEARTIKELS" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TPROJECTTYPES" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TPROJECTTYPES" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TPROJECTTYPES" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TPROJECTTYPES" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TPROJECTTYPES" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TPROJECTTYPES" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TPROJECTEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TPROJECTEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TPROJECTEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TPROJECTEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TPROJECTEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TPROJECTEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TPROJECTCONTACTEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TPROJECTCONTACTEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TPROJECTCONTACTEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TPROJECTCONTACTEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TPROJECTCONTACTEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TPROJECTCONTACTEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TPROJECTMEDEWERKERS" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TPROJECTMEDEWERKERS" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TPROJECTMEDEWERKERS" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TPROJECTMEDEWERKERS" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TPROJECTMEDEWERKERS" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TPROJECTMEDEWERKERS" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TPROJECTMATERIALEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TPROJECTMATERIALEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TPROJECTMATERIALEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TPROJECTMATERIALEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TPROJECTMATERIALEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TPROJECTMATERIALEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TPROJECTFASEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TPROJECTFASEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TPROJECTFASEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TPROJECTFASEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TPROJECTFASEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TPROJECTFASEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TPROJECTFASEEXTRA" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TPROJECTFASEEXTRA" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TPROJECTFASEEXTRA" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TPROJECTFASEEXTRA" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TPROJECTFASEEXTRA" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TPROJECTFASEEXTRA" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TPROJECTARTIKELS" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TPROJECTARTIKELS" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TPROJECTARTIKELS" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TPROJECTARTIKELS" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TPROJECTARTIKELS" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TPROJECTARTIKELS" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TPROJECTVC" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TPROJECTVC" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TPROJECTVC" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TPROJECTVC" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TPROJECTVC" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TPROJECTVC" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TPROJECTVCLIJNEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TPROJECTVCLIJNEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TPROJECTVCLIJNEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TPROJECTVCLIJNEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TPROJECTVCLIJNEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TPROJECTVCLIJNEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TPROJECTVCBIJLAGEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TPROJECTVCBIJLAGEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TPROJECTVCBIJLAGEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TPROJECTVCBIJLAGEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TPROJECTVCBIJLAGEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TPROJECTVCBIJLAGEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TPROJECTOFFERTES" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TPROJECTOFFERTES" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TPROJECTOFFERTES" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TPROJECTOFFERTES" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TPROJECTOFFERTES" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TPROJECTOFFERTES" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TPROJECTCAMPAGNES" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TPROJECTCAMPAGNES" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TPROJECTCAMPAGNES" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TPROJECTCAMPAGNES" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TPROJECTCAMPAGNES" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TPROJECTCAMPAGNES" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TPROJECTTYPEFASEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TPROJECTTYPEFASEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TPROJECTTYPEFASEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TPROJECTTYPEFASEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TPROJECTTYPEFASEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TPROJECTTYPEFASEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TPROJECTFASERELATIES" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TPROJECTFASERELATIES" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TPROJECTFASERELATIES" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TPROJECTFASERELATIES" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TPROJECTFASERELATIES" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TPROJECTFASERELATIES" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TVERKOOPBIJLAGEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TVERKOOPBIJLAGEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TVERKOOPBIJLAGEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TVERKOOPBIJLAGEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TVERKOOPBIJLAGEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TVERKOOPBIJLAGEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TAANKOOPBIJLAGEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TAANKOOPBIJLAGEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TAANKOOPBIJLAGEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TAANKOOPBIJLAGEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TAANKOOPBIJLAGEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TAANKOOPBIJLAGEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TSERVICEBIJLAGEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TSERVICEBIJLAGEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TSERVICEBIJLAGEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TSERVICEBIJLAGEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TSERVICEBIJLAGEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TSERVICEBIJLAGEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TSERVICEINSTALLATIES" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TSERVICEINSTALLATIES" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TSERVICEINSTALLATIES" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TSERVICEINSTALLATIES" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TSERVICEINSTALLATIES" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TSERVICEINSTALLATIES" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TAGENDAFEESTDAGEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TAGENDAFEESTDAGEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TAGENDAFEESTDAGEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TAGENDAFEESTDAGEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TAGENDAFEESTDAGEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TAGENDAFEESTDAGEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TPROJECTTYPEFASERELATIES" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TPROJECTTYPEFASERELATIES" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TPROJECTTYPEFASERELATIES" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TPROJECTTYPEFASERELATIES" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TPROJECTTYPEFASERELATIES" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TPROJECTTYPEFASERELATIES" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TXPRESTATIES" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TXPRESTATIES" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TXPRESTATIES" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TXPRESTATIES" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TXPRESTATIES" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TXPRESTATIES" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TVERKOOPLIJNAFMETINGEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TVERKOOPLIJNAFMETINGEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TVERKOOPLIJNAFMETINGEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TVERKOOPLIJNAFMETINGEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TVERKOOPLIJNAFMETINGEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TVERKOOPLIJNAFMETINGEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TPROJECTBIJLAGEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TPROJECTBIJLAGEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TPROJECTBIJLAGEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TPROJECTBIJLAGEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TPROJECTBIJLAGEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TPROJECTBIJLAGEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCONTACTBIJLAGEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCONTACTBIJLAGEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCONTACTBIJLAGEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCONTACTBIJLAGEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCONTACTBIJLAGEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCONTACTBIJLAGEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCOMMUNICATIESOORTEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCOMMUNICATIESOORTEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCOMMUNICATIESOORTEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCOMMUNICATIESOORTEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCOMMUNICATIESOORTEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCOMMUNICATIESOORTEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TMEDEWERKERHANDTEKENINGEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TMEDEWERKERHANDTEKENINGEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TMEDEWERKERHANDTEKENINGEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TMEDEWERKERHANDTEKENINGEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TMEDEWERKERHANDTEKENINGEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TMEDEWERKERHANDTEKENINGEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TMEDEWERKERBIJLAGEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TMEDEWERKERBIJLAGEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TMEDEWERKERBIJLAGEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TMEDEWERKERBIJLAGEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TMEDEWERKERBIJLAGEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TMEDEWERKERBIJLAGEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TNACECODES" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TNACECODES" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TNACECODES" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TNACECODES" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TNACECODES" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TNACECODES" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TAGENDACONTACTEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TAGENDACONTACTEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TAGENDACONTACTEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TAGENDACONTACTEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TAGENDACONTACTEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TAGENDACONTACTEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCRMCOMMUNICATIECONTACTEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCRMCOMMUNICATIECONTACTEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCRMCOMMUNICATIECONTACTEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCRMCOMMUNICATIECONTACTEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCRMCOMMUNICATIECONTACTEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCRMCOMMUNICATIECONTACTEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCRMTAAKPRODUCTEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCRMTAAKPRODUCTEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCRMTAAKPRODUCTEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCRMTAAKPRODUCTEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCRMTAAKPRODUCTEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCRMTAAKPRODUCTEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCRMTAAKOMSCHRIJVINGEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCRMTAAKOMSCHRIJVINGEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCRMTAAKOMSCHRIJVINGEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCRMTAAKOMSCHRIJVINGEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCRMTAAKOMSCHRIJVINGEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCRMTAAKOMSCHRIJVINGEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCRMSUPPORTSOORTEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCRMSUPPORTSOORTEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCRMSUPPORTSOORTEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCRMSUPPORTSOORTEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCRMSUPPORTSOORTEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCRMSUPPORTSOORTEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCRMWACHTRIJEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCRMWACHTRIJEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCRMWACHTRIJEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCRMWACHTRIJEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCRMWACHTRIJEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCRMWACHTRIJEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCRMWACHTRIJMEDEWERKERS" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCRMWACHTRIJMEDEWERKERS" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCRMWACHTRIJMEDEWERKERS" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCRMWACHTRIJMEDEWERKERS" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCRMWACHTRIJMEDEWERKERS" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCRMWACHTRIJMEDEWERKERS" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCRMPRODUCTFAMILIES" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCRMPRODUCTFAMILIES" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCRMPRODUCTFAMILIES" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCRMPRODUCTFAMILIES" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCRMPRODUCTFAMILIES" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCRMPRODUCTFAMILIES" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCRMPRODUCTGROEPEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCRMPRODUCTGROEPEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCRMPRODUCTGROEPEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCRMPRODUCTGROEPEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCRMPRODUCTGROEPEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCRMPRODUCTGROEPEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCRMPRODUCTEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCRMPRODUCTEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCRMPRODUCTEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCRMPRODUCTEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCRMPRODUCTEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCRMPRODUCTEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCRMSUPPORTCALLS" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCRMSUPPORTCALLS" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCRMSUPPORTCALLS" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCRMSUPPORTCALLS" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCRMSUPPORTCALLS" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCRMSUPPORTCALLS" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCRMSUPPORTCALLLIJNEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCRMSUPPORTCALLLIJNEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCRMSUPPORTCALLLIJNEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCRMSUPPORTCALLLIJNEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCRMSUPPORTCALLLIJNEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCRMSUPPORTCALLLIJNEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCRMSUPPORTCALLOPVOLGING" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCRMSUPPORTCALLOPVOLGING" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCRMSUPPORTCALLOPVOLGING" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCRMSUPPORTCALLOPVOLGING" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCRMSUPPORTCALLOPVOLGING" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCRMSUPPORTCALLOPVOLGING" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCRMCONTACTPRODUCTEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCRMCONTACTPRODUCTEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCRMCONTACTPRODUCTEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCRMCONTACTPRODUCTEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCRMCONTACTPRODUCTEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCRMCONTACTPRODUCTEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCRMCONTACTPRODUCTENHIST" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCRMCONTACTPRODUCTENHIST" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCRMCONTACTPRODUCTENHIST" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCRMCONTACTPRODUCTENHIST" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCRMCONTACTPRODUCTENHIST" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCRMCONTACTPRODUCTENHIST" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCRMABONNEMENTTYPES" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCRMABONNEMENTTYPES" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCRMABONNEMENTTYPES" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCRMABONNEMENTTYPES" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCRMABONNEMENTTYPES" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCRMABONNEMENTTYPES" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCRMABONNEMENTTYPELIJNEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCRMABONNEMENTTYPELIJNEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCRMABONNEMENTTYPELIJNEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCRMABONNEMENTTYPELIJNEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCRMABONNEMENTTYPELIJNEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCRMABONNEMENTTYPELIJNEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCRMABONNEMENTEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCRMABONNEMENTEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCRMABONNEMENTEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCRMABONNEMENTEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCRMABONNEMENTEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCRMABONNEMENTEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCRMABONNEMENTLIJNEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCRMABONNEMENTLIJNEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCRMABONNEMENTLIJNEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCRMABONNEMENTLIJNEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCRMABONNEMENTLIJNEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCRMABONNEMENTLIJNEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCRMABONNEMENTFACTUREN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCRMABONNEMENTFACTUREN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCRMABONNEMENTFACTUREN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCRMABONNEMENTFACTUREN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCRMABONNEMENTFACTUREN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCRMABONNEMENTFACTUREN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCRMABONNEMENTCORRECTIES" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCRMABONNEMENTCORRECTIES" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCRMABONNEMENTCORRECTIES" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCRMABONNEMENTCORRECTIES" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCRMABONNEMENTCORRECTIES" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCRMABONNEMENTCORRECTIES" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TPOP3EMAILS" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TPOP3EMAILS" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TPOP3EMAILS" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TPOP3EMAILS" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TPOP3EMAILS" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TPOP3EMAILS" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TPOP3EMAILBIJLAGEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TPOP3EMAILBIJLAGEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TPOP3EMAILBIJLAGEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TPOP3EMAILBIJLAGEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TPOP3EMAILBIJLAGEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TPOP3EMAILBIJLAGEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TPOP3EMAILACCOUNTS" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TPOP3EMAILACCOUNTS" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TPOP3EMAILACCOUNTS" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TPOP3EMAILACCOUNTS" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TPOP3EMAILACCOUNTS" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TPOP3EMAILACCOUNTS" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCRMKEUZELIJSTEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCRMKEUZELIJSTEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCRMKEUZELIJSTEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCRMKEUZELIJSTEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCRMKEUZELIJSTEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCRMKEUZELIJSTEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCRMOORSPRONGEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCRMOORSPRONGEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCRMOORSPRONGEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCRMOORSPRONGEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCRMOORSPRONGEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCRMOORSPRONGEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCRMSUBOORSPRONGEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCRMSUBOORSPRONGEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCRMSUBOORSPRONGEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCRMSUBOORSPRONGEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCRMSUBOORSPRONGEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCRMSUBOORSPRONGEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCRMAFGESLOTENSTATUSSEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCRMAFGESLOTENSTATUSSEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCRMAFGESLOTENSTATUSSEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCRMAFGESLOTENSTATUSSEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCRMAFGESLOTENSTATUSSEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCRMAFGESLOTENSTATUSSEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCRMVERKOOPFASEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCRMVERKOOPFASEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCRMVERKOOPFASEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCRMVERKOOPFASEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCRMVERKOOPFASEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCRMVERKOOPFASEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCRMVERKOOPKANSSOORTEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCRMVERKOOPKANSSOORTEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCRMVERKOOPKANSSOORTEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCRMVERKOOPKANSSOORTEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCRMVERKOOPKANSSOORTEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCRMVERKOOPKANSSOORTEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCRMVERKOOPKANSSOORTFASEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCRMVERKOOPKANSSOORTFASEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCRMVERKOOPKANSSOORTFASEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCRMVERKOOPKANSSOORTFASEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCRMVERKOOPKANSSOORTFASEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCRMVERKOOPKANSSOORTFASEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCONTACTINTERESSES" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCONTACTINTERESSES" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCONTACTINTERESSES" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCONTACTINTERESSES" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCONTACTINTERESSES" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCONTACTINTERESSES" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCONTACTHUIDIGEPRODUCTEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCONTACTHUIDIGEPRODUCTEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCONTACTHUIDIGEPRODUCTEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCONTACTHUIDIGEPRODUCTEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCONTACTHUIDIGEPRODUCTEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCONTACTHUIDIGEPRODUCTEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCRMOPLEIDINGTYPES" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCRMOPLEIDINGTYPES" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCRMOPLEIDINGTYPES" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCRMOPLEIDINGTYPES" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCRMOPLEIDINGTYPES" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCRMOPLEIDINGTYPES" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCRMOPLEIDINGEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCRMOPLEIDINGEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCRMOPLEIDINGEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCRMOPLEIDINGEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCRMOPLEIDINGEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCRMOPLEIDINGEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCRMOPLEIDINGDEELNEMERS" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCRMOPLEIDINGDEELNEMERS" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCRMOPLEIDINGDEELNEMERS" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCRMOPLEIDINGDEELNEMERS" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCRMOPLEIDINGDEELNEMERS" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCRMOPLEIDINGDEELNEMERS" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TXCRMOPLEIDINGDEELNEMERS" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TXCRMOPLEIDINGDEELNEMERS" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TXCRMOPLEIDINGDEELNEMERS" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TXCRMOPLEIDINGDEELNEMERS" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TXCRMOPLEIDINGDEELNEMERS" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TXCRMOPLEIDINGDEELNEMERS" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCRMVERKOOPKANSEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCRMVERKOOPKANSEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCRMVERKOOPKANSEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCRMVERKOOPKANSEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCRMVERKOOPKANSEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCRMVERKOOPKANSEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCRMVERKOOPKANSBIJLAGEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCRMVERKOOPKANSBIJLAGEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCRMVERKOOPKANSBIJLAGEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCRMVERKOOPKANSBIJLAGEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCRMVERKOOPKANSBIJLAGEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCRMVERKOOPKANSBIJLAGEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TARTIKELINFIRMA" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TARTIKELINFIRMA" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TARTIKELINFIRMA" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TARTIKELINFIRMA" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TARTIKELINFIRMA" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TARTIKELINFIRMA" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TFLOW" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TFLOW" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TFLOW" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TFLOW" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TFLOW" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TFLOW" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TFLOWORDER" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TFLOWORDER" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TFLOWORDER" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TFLOWORDER" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TFLOWORDER" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TFLOWORDER" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCRMVERKOOPKANSFASEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCRMVERKOOPKANSFASEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCRMVERKOOPKANSFASEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCRMVERKOOPKANSFASEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCRMVERKOOPKANSFASEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCRMVERKOOPKANSFASEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TKLANTKAARTEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TKLANTKAARTEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TKLANTKAARTEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TKLANTKAARTEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TKLANTKAARTEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TKLANTKAARTEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TKLANTKAARTLIJNEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TKLANTKAARTLIJNEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TKLANTKAARTLIJNEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TKLANTKAARTLIJNEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TKLANTKAARTLIJNEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TKLANTKAARTLIJNEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TLICENTIEIPAD" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TLICENTIEIPAD" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TLICENTIEIPAD" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TLICENTIEIPAD" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TLICENTIEIPAD" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TLICENTIEIPAD" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TLICENTIEIPADS" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TLICENTIEIPADS" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TLICENTIEIPADS" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TLICENTIEIPADS" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TLICENTIEIPADS" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TLICENTIEIPADS" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TEMAILTEKSTEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TEMAILTEKSTEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TEMAILTEKSTEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TEMAILTEKSTEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TEMAILTEKSTEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TEMAILTEKSTEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TMEDEWERKERINFIRMA" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TMEDEWERKERINFIRMA" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TMEDEWERKERINFIRMA" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TMEDEWERKERINFIRMA" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TMEDEWERKERINFIRMA" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TMEDEWERKERINFIRMA" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TLIBRARIES" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TLIBRARIES" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TLIBRARIES" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TLIBRARIES" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TLIBRARIES" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TLIBRARIES" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TVOLUMEMAPPING" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TVOLUMEMAPPING" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TVOLUMEMAPPING" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TVOLUMEMAPPING" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TVOLUMEMAPPING" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TVOLUMEMAPPING" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TBOEKINGBIJLAGEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TBOEKINGBIJLAGEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TBOEKINGBIJLAGEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TBOEKINGBIJLAGEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TBOEKINGBIJLAGEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TBOEKINGBIJLAGEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TDOMMANDATEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TDOMMANDATEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TDOMMANDATEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TDOMMANDATEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TDOMMANDATEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TDOMMANDATEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TMAILINGCODES" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TMAILINGCODES" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TMAILINGCODES" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TMAILINGCODES" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TMAILINGCODES" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TMAILINGCODES" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCONTACTPERSOONMAILINGCODES" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCONTACTPERSOONMAILINGCODES" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCONTACTPERSOONMAILINGCODES" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCONTACTPERSOONMAILINGCODES" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCONTACTPERSOONMAILINGCODES" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCONTACTPERSOONMAILINGCODES" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TFACTVERSTUURD" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TFACTVERSTUURD" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TFACTVERSTUURD" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TFACTVERSTUURD" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TFACTVERSTUURD" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TFACTVERSTUURD" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TARTIKELKLEURMAAT" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TARTIKELKLEURMAAT" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TARTIKELKLEURMAAT" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TARTIKELKLEURMAAT" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TARTIKELKLEURMAAT" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TARTIKELKLEURMAAT" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TARTIKELKLEURMAATPRIJZEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TARTIKELKLEURMAATPRIJZEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TARTIKELKLEURMAATPRIJZEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TARTIKELKLEURMAATPRIJZEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TARTIKELKLEURMAATPRIJZEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TARTIKELKLEURMAATPRIJZEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TARTIKELKLEURMAATLEVERANCIERS" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TARTIKELKLEURMAATLEVERANCIERS" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TARTIKELKLEURMAATLEVERANCIERS" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TARTIKELKLEURMAATLEVERANCIERS" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TARTIKELKLEURMAATLEVERANCIERS" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TARTIKELKLEURMAATLEVERANCIERS" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TVERKOOPVERSTUURD" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TVERKOOPVERSTUURD" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TVERKOOPVERSTUURD" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TVERKOOPVERSTUURD" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TVERKOOPVERSTUURD" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TVERKOOPVERSTUURD" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TVERKOOPSTATUSSEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TVERKOOPSTATUSSEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TVERKOOPSTATUSSEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TVERKOOPSTATUSSEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TVERKOOPSTATUSSEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TVERKOOPSTATUSSEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TAANKOOPLIJNAFMETINGEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TAANKOOPLIJNAFMETINGEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TAANKOOPLIJNAFMETINGEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TAANKOOPLIJNAFMETINGEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TAANKOOPLIJNAFMETINGEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TAANKOOPLIJNAFMETINGEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TPROJECTGROEPEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TPROJECTGROEPEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TPROJECTGROEPEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TPROJECTGROEPEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TPROJECTGROEPEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TPROJECTGROEPEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TPROJECTGROEPENPROJECT" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TPROJECTGROEPENPROJECT" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TPROJECTGROEPENPROJECT" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TPROJECTGROEPENPROJECT" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TPROJECTGROEPENPROJECT" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TPROJECTGROEPENPROJECT" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TMEDEWERKEROFFICE365" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TMEDEWERKEROFFICE365" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TMEDEWERKEROFFICE365" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TMEDEWERKEROFFICE365" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TMEDEWERKEROFFICE365" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TMEDEWERKEROFFICE365" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TPRESTATIESOORTGROEPEN" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TPRESTATIESOORTGROEPEN" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TPRESTATIESOORTGROEPEN" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TPRESTATIESOORTGROEPEN" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TPRESTATIESOORTGROEPEN" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TPRESTATIESOORTGROEPEN" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCONTACTARTIKELS" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCONTACTARTIKELS" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCONTACTARTIKELS" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCONTACTARTIKELS" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCONTACTARTIKELS" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCONTACTARTIKELS" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TARTIKELLEEGGOED" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TARTIKELLEEGGOED" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TARTIKELLEEGGOED" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TARTIKELLEEGGOED" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TARTIKELLEEGGOED" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TARTIKELLEEGGOED" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TEDIMSG" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TEDIMSG" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TEDIMSG" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TEDIMSG" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TEDIMSG" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TEDIMSG" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TEDITEMPLATES" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TEDITEMPLATES" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TEDITEMPLATES" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TEDITEMPLATES" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TEDITEMPLATES" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TEDITEMPLATES" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCONTACTROLEDI" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TCONTACTROLEDI" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TCONTACTROLEDI" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TCONTACTROLEDI" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCONTACTROLEDI" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TCONTACTROLEDI" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TARTIKELKLANT" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TARTIKELKLANT" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TARTIKELKLANT" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TARTIKELKLANT" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TARTIKELKLANT" TO PUBLIC;
GRANT TRIGGER ON "_SYSTEM"."TARTIKELKLANT" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TPEPOLTRACKING" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TPEPOLTRACKING" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TPEPOLTRACKING" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TPEPOLTRACKING" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TPEPOLTRACKING" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TKAARTMERKIDENTIFIERS" TO PUBLIC;
GRANT DELETE ON "_SYSTEM"."TKAARTMERKIDENTIFIERS" TO PUBLIC;
GRANT INSERT ON "_SYSTEM"."TKAARTMERKIDENTIFIERS" TO PUBLIC;
GRANT UPDATE ON "_SYSTEM"."TKAARTMERKIDENTIFIERS" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TKAARTMERKIDENTIFIERS" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."TCONTACTPERSONEN_EXT" TO PUBLIC;
GRANT REFERENCES ON "_SYSTEM"."TCONTACTPERSONEN_EXT" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."DATATYPES" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT SELECT ON "_SYSTEM"."VIEW_NEEDED_BY_FBODBC" TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
ALTER TABLE "_SYSTEM"."TALGEMENEREKENINGEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TALGEMENEREKENINGEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TBETALINGSVOORWAARDEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TBETALINGSVOORWAARDEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TBTWREGIMES" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCOLINFO" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCOLINFO" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCONTACTEN" SET CACHE(0,0,0);
ALTER TABLE "_SYSTEM"."TCONTACTEN" SET PRESERVE TRUE;
ALTER TABLE "_SYSTEM"."TCONTACTEN" SET PREPARE TRUE;
ALTER TABLE "_SYSTEM"."TCONTACTEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCONTACTEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCONTACTGROEPEN" SET CACHE(0,0,0);
ALTER TABLE "_SYSTEM"."TCONTACTGROEPEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCONTACTGROEPENCONTACT" SET CACHE(0,0,0);
ALTER TABLE "_SYSTEM"."TCONTACTGROEPENCONTACT" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCONTACTPERSONEN" SET CACHE(0,0,0);
ALTER TABLE "_SYSTEM"."TCONTACTPERSONEN" SET PRESERVE TRUE;
ALTER TABLE "_SYSTEM"."TCONTACTPERSONEN" SET PREPARE TRUE;
ALTER TABLE "_SYSTEM"."TCONTACTPERSONEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCONTACTPERSONEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCONTACTROLLEN" SET CACHE(0,0,0);
ALTER TABLE "_SYSTEM"."TCONTACTROLLEN" SET PRESERVE TRUE;
ALTER TABLE "_SYSTEM"."TCONTACTROLLEN" SET PREPARE TRUE;
ALTER TABLE "_SYSTEM"."TCONTACTROLLEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCONTACTROLLEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCONTACTROLLENBB" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCONTACTROLLENBB" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TINTERNEFIRMAMEDEWERKERS" SET CACHE(0,0,0);
ALTER TABLE "_SYSTEM"."TINTERNEFIRMAMEDEWERKERS" SET PREPARE TRUE;
ALTER TABLE "_SYSTEM"."TINTERNEFIRMAMEDEWERKERS" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TINTERNEFIRMAS" SET CACHE(0,0,0);
ALTER TABLE "_SYSTEM"."TINTERNEFIRMAS" SET PREPARE TRUE;
ALTER TABLE "_SYSTEM"."TINTERNEFIRMAS" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TINTERNEFIRMAS" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TLANDEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TDOCUMENTSTATUSSEN" SET CACHE(0,0,0);
ALTER TABLE "_SYSTEM"."TDOCUMENTSTATUSSEN" SET PREPARE TRUE;
ALTER TABLE "_SYSTEM"."TDOCUMENTSTATUSSEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TLEVERINGSVOORWAARDEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TLEVERINGSVOORWAARDEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TMEDEWERKERGROEPEN" SET CACHE(0,0,0);
ALTER TABLE "_SYSTEM"."TMEDEWERKERGROEPEN" SET PREPARE TRUE;
ALTER TABLE "_SYSTEM"."TMEDEWERKERGROEPEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TMEDEWERKERGROEPEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TMEDEWERKERS" SET CACHE(0,0,0);
ALTER TABLE "_SYSTEM"."TMEDEWERKERS" SET PREPARE TRUE;
ALTER TABLE "_SYSTEM"."TMEDEWERKERS" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TMEDEWERKERS" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TMUNTEN" SET CACHE(0,0,0);
ALTER TABLE "_SYSTEM"."TMUNTEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TNOACCESS" SET CACHE(0,0,0);
ALTER TABLE "_SYSTEM"."TNOACCESS" SET PREPARE TRUE;
ALTER TABLE "_SYSTEM"."TNOACCESS" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TNOACCESS" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TPOSTCODES" SET CACHE(0,0,0);
ALTER TABLE "_SYSTEM"."TPOSTCODES" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TPOSTCODES" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TROLGROEPEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TTALEN" SET CACHE(0,0,0);
ALTER TABLE "_SYSTEM"."TTALEN" SET PREPARE TRUE;
ALTER TABLE "_SYSTEM"."TTALEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TTRANSPORTEURS" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TVOORSTELREKENINGEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TWINPOSITIES" SET CACHE(0,0,0);
ALTER TABLE "_SYSTEM"."TWINPOSITIES" SET PREPARE TRUE;
ALTER TABLE "_SYSTEM"."TWINPOSITIES" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TWINPOSITIES" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TROLLEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCODELIJSTEN" SET CACHE(0,0,0);
ALTER TABLE "_SYSTEM"."TCODELIJSTEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCODELIJSTEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCOLSELECT" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCOLSELECT" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCATEGORIEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TARTIKELKORTINGENLEVERANCIERS" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TARTIKELKORTINGENLEVERANCIERS" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TSUBCATEGORIEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TREPORTS" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TREPORTS" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TREPTEMPLATES" SET CACHE(0,0,0);
ALTER TABLE "_SYSTEM"."TREPTEMPLATES" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TREPTEMPLATES" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TMODULES" SET CACHE(0,0,0);
ALTER TABLE "_SYSTEM"."TMODULES" SET PREPARE TRUE;
ALTER TABLE "_SYSTEM"."TMODULES" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TINSTELLINGEN" SET CACHE(0,0,0);
ALTER TABLE "_SYSTEM"."TINSTELLINGEN" SET PREPARE TRUE;
ALTER TABLE "_SYSTEM"."TINSTELLINGEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TINSTELLINGEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TDOCUMENTTYPES" SET CACHE(0,0,0);
ALTER TABLE "_SYSTEM"."TDOCUMENTTYPES" SET PREPARE TRUE;
ALTER TABLE "_SYSTEM"."TDOCUMENTTYPES" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TDOCUMENTTYPES" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN" SET CACHE(0,0,0);
ALTER TABLE "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN" SET PREPARE TRUE;
ALTER TABLE "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TRUIMTEN" SET CACHE(0,0,0);
ALTER TABLE "_SYSTEM"."TRUIMTEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TANALYTISCHEREKENINGEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TANALYTISCHEREKENINGEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TBTWCODES" SET CACHE(0,0,0);
ALTER TABLE "_SYSTEM"."TBTWCODES" SET PREPARE TRUE;
ALTER TABLE "_SYSTEM"."TBTWCODES" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TGNCODES" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TGNCODES" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TARTIKELGROEPEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TDOCUMENTACTIES" SET CACHE(0,0,0);
ALTER TABLE "_SYSTEM"."TDOCUMENTACTIES" SET PREPARE TRUE;
ALTER TABLE "_SYSTEM"."TDOCUMENTACTIES" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TDOCUMENTACTIES" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TINCOTERMS" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TINCOTERMS" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TINTRASTATGEWESTEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TINTRASTATGEWESTEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TINTRASTATTRANSACTIES" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TINTRASTATTRANSACTIES" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TINTRASTATVERVOER" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TINTRASTATVERVOER" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TVESTIGINGMAGAZIJNEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TARTIKELS" SET CACHE(0,0,0);
ALTER TABLE "_SYSTEM"."TARTIKELS" SET PRESERVE TRUE;
ALTER TABLE "_SYSTEM"."TARTIKELS" SET PREPARE TRUE;
ALTER TABLE "_SYSTEM"."TARTIKELS" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TARTIKELS" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TARTIKELLEVERANCIERS" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TARTIKELLEVERANCIERS" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TARTIKELVOORRAAD" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TKLEURENKAARTEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TKLEUREN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TMATENBALKEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TMATEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TARTIKELINVESTIGING" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TARTIKELKORTINGEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TARTIKELKORTINGEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TARTIKELONDERDELEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TARTIKELONDERDELEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TARTIKELGEKOPPELD" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TADRESTYPES" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCONTACTADRESSEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCONTACTADRESSEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TTARIEVEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TARTIKELPRIJZEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TVERKOPEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TVERKOPEN" SET COLUMN MATCH ("CFACTURATIEADRES");
ALTER TABLE "_SYSTEM"."TVERKOPEN" SET COLUMN MATCH ("CLEVERINGSADRES");
ALTER TABLE "_SYSTEM"."TVERKOPEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TVERKOOPCOLLI" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TVERKOOPBETALINGEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TVERKOOPLIJNEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TVERKOOPLIJNEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TMATERIALEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TMATERIALEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TAGENDALABELS" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TAANKOPEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TAANKOPEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TAANKOOPLIJNEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TAANKOOPLIJNEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TAGENDA" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TAGENDA" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TVOORRAADWIJZIGINGEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TVOORRAADWIJZIGINGEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TVOORRAADTRANSFERSERIENUMMERS" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TVOORRAADWIJZIGINGSERIENUMMERS" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TVOORRAADTRANSFERS" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TLICENTIE" SET CACHE(0,0,0);
ALTER TABLE "_SYSTEM"."TLICENTIE" SET PREPARE TRUE;
ALTER TABLE "_SYSTEM"."TLICENTIE" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TLICENTIE" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TSESSIES" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TARTIKELLOCATIES" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TPRODUCTIE" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TPRODUCTIE" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TARTIKELVERPAKKINGEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCRMCOMMUNICATIES" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCRMCOMMUNICATIES" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCRMCOMMUNICATIEBIJLAGEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCRMCOMMUNICATIEBIJLAGEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCRMTAKEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCRMTAKEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCRMTAAKBIJLAGEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCRMTAAKBIJLAGEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TPRODUCTIELIJNEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TPRODUCTIELIJNEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TAGENDAEXTRA" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TAGENDAEXTRA" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TAGENDAPREFS" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TKASSAAFSL" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TKASSAAFSL" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TKASSAAFSLBETAALWIJZEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TKASSAAFSLOMZETTEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TBETAALWIJZEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCONTACTSALDI" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TBTWVAKKEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TBTWVAKKEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TBTWCODESPERVAK" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TBOEKJAREN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TKALENDERJAREN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TBTWPERIODEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TBOEKPERIODEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TINTRASTATAANGEVER" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TINTRASTATAANGEVER" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TDAGBOEKEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TDAGBOEKEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TDAGBOEKVOLGNR" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TTEKSTENRAPPEL" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TTEKSTENRAPPEL" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TANALSLEUTELS" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TBOEKINGEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TBOEKINGEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TBOEKINGHISTORIEK" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TBOEKINGHISTORIEK" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TBOEKINGBTW" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TBOEKINGINTRASTAT" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCENTRALISATIE" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TANALCENTRALISATIE" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCENTRALISATIEOMZETTEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TAFSCHRIJVINGEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TAFSCHRIJVINGEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TFICHE28150" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TBUDGETTEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TANALBUDGETTEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TBTWAANGIFTENBE" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TBTWAANGIFTENBE" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TSTRUCTUREN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TSTRUCTUREN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TSTRUCTUURDETAILS" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TSTRUCTUURDETAILS" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TSERVICE" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TSERVICE" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TSERVICEBETALINGEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TSERVICEHISTORIEK" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TSERVICELIJNEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TSERVICELIJNEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TSERVICELIJNSERIENUMMERS" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TSERVICESTATUSSEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TKASSAUITGAVEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TFACTUREN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TFACTUREN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TFACTLIJNEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TFACTLIJNEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TFACTARTIKELGROEPEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TFACTARTIKELGROEPEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TFACTARTIKELS" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TFACTARTIKELS" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TKASSANUMMERS" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TVERWORPENUITGAVEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TDAVE" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TDAVE" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCRMMAILINGTEKSTEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCRMMAILINGTEKSTEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TXCONTACTEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TXCONTACTEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TXCONTACTPERSONEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TXCONTACTPERSONEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TXCONTACTADRESSEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TXCONTACTADRESSEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TXVERKOPEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TXVERKOPEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TXVERKOOPLIJNEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TXVERKOOPLIJNEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TXVERKOOPBETALINGEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TMAGAZIJNLOCATIES" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TMAGAZIJNLOCATIES" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TARTIKELBIJLAGEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TARTIKELBIJLAGEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TARTIKELVOORRAADAANTALLEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TVERKOOPLIJNAANTALLEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TAANKOOPLIJNAANTALLEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TPRODUCTIEAANTALLEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TPRODUCTIELIJNAANTALLEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TSERVICELIJNAANTALLEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TXCONTACTGROEPEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TEENHEDEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TMUNTWAARDEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TDOCTEMPLATES" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TDOCTEMPLATES" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TAGENDAGROEPEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TAGENDAGROEPEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TAGENDAGROEPMEDEWERKERS" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TUURROOSTERS" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TMEDEWERKERUURKOST" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TPRESTATIESOORTEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TPRESTATIESOORTEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TPRESTATIES" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TPRESTATIES" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TSERVICEARTIKELS" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TSERVICEARTIKELS" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TPROJECTTYPES" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TPROJECTEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TPROJECTEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TPROJECTCONTACTEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TPROJECTCONTACTEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TPROJECTMEDEWERKERS" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TPROJECTMATERIALEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TPROJECTMATERIALEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TPROJECTFASEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TPROJECTFASEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TPROJECTFASEEXTRA" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TPROJECTFASEEXTRA" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TPROJECTARTIKELS" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TPROJECTARTIKELS" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TPROJECTVC" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TPROJECTVC" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TPROJECTVCLIJNEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TPROJECTVCLIJNEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TPROJECTVCBIJLAGEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TPROJECTVCBIJLAGEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TPROJECTOFFERTES" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TPROJECTOFFERTES" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TPROJECTCAMPAGNES" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TPROJECTCAMPAGNES" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TPROJECTTYPEFASEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TPROJECTTYPEFASEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TPROJECTFASERELATIES" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TVERKOOPBIJLAGEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TVERKOOPBIJLAGEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TAANKOOPBIJLAGEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TAANKOOPBIJLAGEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TSERVICEBIJLAGEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TSERVICEBIJLAGEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TSERVICEINSTALLATIES" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TSERVICEINSTALLATIES" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TAGENDAFEESTDAGEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TAGENDAFEESTDAGEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TPROJECTTYPEFASERELATIES" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TXPRESTATIES" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TXPRESTATIES" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TVERKOOPLIJNAFMETINGEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TPROJECTBIJLAGEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TPROJECTBIJLAGEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCONTACTBIJLAGEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCONTACTBIJLAGEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCOMMUNICATIESOORTEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TMEDEWERKERHANDTEKENINGEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TMEDEWERKERHANDTEKENINGEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TMEDEWERKERBIJLAGEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TMEDEWERKERBIJLAGEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TNACECODES" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TNACECODES" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TAGENDACONTACTEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TAGENDACONTACTEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCRMCOMMUNICATIECONTACTEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCRMCOMMUNICATIECONTACTEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCRMTAAKPRODUCTEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCRMTAAKPRODUCTEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCRMTAAKOMSCHRIJVINGEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCRMTAAKOMSCHRIJVINGEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCRMSUPPORTSOORTEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCRMSUPPORTSOORTEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCRMWACHTRIJEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCRMWACHTRIJEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCRMWACHTRIJMEDEWERKERS" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCRMPRODUCTFAMILIES" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCRMPRODUCTFAMILIES" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCRMPRODUCTGROEPEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCRMPRODUCTGROEPEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCRMPRODUCTEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCRMPRODUCTEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCRMSUPPORTCALLS" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCRMSUPPORTCALLS" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCRMSUPPORTCALLLIJNEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCRMSUPPORTCALLLIJNEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCRMSUPPORTCALLOPVOLGING" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCRMSUPPORTCALLOPVOLGING" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCRMCONTACTPRODUCTEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCRMCONTACTPRODUCTEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCRMCONTACTPRODUCTENHIST" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCRMCONTACTPRODUCTENHIST" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCRMABONNEMENTTYPES" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCRMABONNEMENTTYPES" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCRMABONNEMENTTYPELIJNEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCRMABONNEMENTTYPELIJNEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCRMABONNEMENTEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCRMABONNEMENTEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCRMABONNEMENTLIJNEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCRMABONNEMENTLIJNEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCRMABONNEMENTFACTUREN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCRMABONNEMENTCORRECTIES" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCRMABONNEMENTCORRECTIES" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TPOP3EMAILS" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TPOP3EMAILS" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TPOP3EMAILBIJLAGEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TPOP3EMAILBIJLAGEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TPOP3EMAILACCOUNTS" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TPOP3EMAILACCOUNTS" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCRMKEUZELIJSTEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCRMKEUZELIJSTEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCRMOORSPRONGEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCRMOORSPRONGEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCRMSUBOORSPRONGEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCRMSUBOORSPRONGEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCRMAFGESLOTENSTATUSSEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCRMAFGESLOTENSTATUSSEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCRMVERKOOPFASEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCRMVERKOOPFASEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCRMVERKOOPKANSSOORTEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCRMVERKOOPKANSSOORTEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCRMVERKOOPKANSSOORTFASEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCONTACTINTERESSES" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCONTACTINTERESSES" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCONTACTHUIDIGEPRODUCTEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCONTACTHUIDIGEPRODUCTEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCRMOPLEIDINGTYPES" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCRMOPLEIDINGTYPES" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCRMOPLEIDINGEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCRMOPLEIDINGEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCRMOPLEIDINGDEELNEMERS" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCRMOPLEIDINGDEELNEMERS" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TXCRMOPLEIDINGDEELNEMERS" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TXCRMOPLEIDINGDEELNEMERS" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCRMVERKOOPKANSEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCRMVERKOOPKANSEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCRMVERKOOPKANSBIJLAGEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TCRMVERKOOPKANSBIJLAGEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TARTIKELINFIRMA" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TFLOW" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TFLOWORDER" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCRMVERKOOPKANSFASEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TKLANTKAARTEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TKLANTKAARTLIJNEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TKLANTKAARTLIJNEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TLICENTIEIPAD" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TLICENTIEIPAD" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TLICENTIEIPADS" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TLICENTIEIPADS" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TEMAILTEKSTEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TEMAILTEKSTEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TMEDEWERKERINFIRMA" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TMEDEWERKERINFIRMA" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TLIBRARIES" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TLIBRARIES" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TVOLUMEMAPPING" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TBOEKINGBIJLAGEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TBOEKINGBIJLAGEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TDOMMANDATEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TDOMMANDATEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TMAILINGCODES" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TMAILINGCODES" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCONTACTPERSOONMAILINGCODES" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TFACTVERSTUURD" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TFACTVERSTUURD" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TARTIKELKLEURMAAT" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TARTIKELKLEURMAAT" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TARTIKELKLEURMAATPRIJZEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TARTIKELKLEURMAATLEVERANCIERS" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TVERKOOPVERSTUURD" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TVERKOOPVERSTUURD" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TVERKOOPSTATUSSEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TAANKOOPLIJNAFMETINGEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TPROJECTGROEPEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TPROJECTGROEPENPROJECT" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TMEDEWERKEROFFICE365" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TMEDEWERKEROFFICE365" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TPRESTATIESOORTGROEPEN" SET CHAR CACHE(2000, 20000, 80);
ALTER TABLE "_SYSTEM"."TPRESTATIESOORTGROEPEN" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCONTACTARTIKELS" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TARTIKELLEEGGOED" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TEDIMSG" SET CHAR CACHE(2000, 20000, 20);
ALTER TABLE "_SYSTEM"."TEDIMSG" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TEDITEMPLATES" SET CHAR CACHE(2000, 20000, 20);
ALTER TABLE "_SYSTEM"."TEDITEMPLATES" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TCONTACTROLEDI" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TARTIKELKLANT" SET CHAR CACHE(2000, 20000, 20);
ALTER TABLE "_SYSTEM"."TARTIKELKLANT" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TPEPOLTRACKING" SET CHAR CACHE(2000, 20000, 20);
ALTER TABLE "_SYSTEM"."TPEPOLTRACKING" SET INDEX PRESERVE TIME;
ALTER TABLE "_SYSTEM"."TKAARTMERKIDENTIFIERS" SET CHAR CACHE(2000, 20000, 20);
ALTER TABLE "_SYSTEM"."TKAARTMERKIDENTIFIERS" SET INDEX PRESERVE TIME;
COMMIT;
ALTER TABLE "_SYSTEM"."TALGEMENEREKENINGEN" ADD CONSTRAINT "_SYSTEM"."_C4" PRIMARY KEY("CALGEMENEREKENINGEN_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TALGEMENEREKENINGEN" ADD CONSTRAINT "_SYSTEM"."_C5" UNIQUE("CINTERNEFIRMAALGEMENEREKENINGEN","CALGEMENEREKENING") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TBETALINGSVOORWAARDEN" ADD CONSTRAINT "_SYSTEM"."_C6" PRIMARY KEY("CBETALINGSVOORWAARDEN_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TBETALINGSVOORWAARDEN" ADD CONSTRAINT "_SYSTEM"."_C7" UNIQUE("CBETALINGSVOORWAARDE") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TBTWREGIMES" ADD CONSTRAINT "_SYSTEM"."_C8" PRIMARY KEY("CBTWREGIMES_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TBTWREGIMES" ADD CONSTRAINT "_SYSTEM"."_C9" UNIQUE("CBTWREGIME") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TCOLINFO" ADD CONSTRAINT "_SYSTEM"."_C10" PRIMARY KEY("CCOLINFO_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TCONTACTEN" ADD CONSTRAINT "_SYSTEM"."_C11" PRIMARY KEY("CCONTACTEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TCONTACTEN" ADD CONSTRAINT "_SYSTEM"."_C12" UNIQUE("CINTERNEFIRMACONTACTEN","CCONTACT") INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TCONTACTGROEPEN" ADD CONSTRAINT "_SYSTEM"."_C13" PRIMARY KEY("CCONTACTGROEPEN_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TCONTACTGROEPEN" ADD CONSTRAINT "_SYSTEM"."_C14" UNIQUE("CCONTACTGROEP") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TCONTACTGROEPENCONTACT" ADD CONSTRAINT "_SYSTEM"."_C15" PRIMARY KEY("CCONTACTGROEPENCONTACT_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TCONTACTPERSONEN" ADD CONSTRAINT "_SYSTEM"."_C16" PRIMARY KEY("CCONTACTPERSONEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TCONTACTROLLEN" ADD CONSTRAINT "_SYSTEM"."_C17" PRIMARY KEY("CCONTACTROLLEN_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TCONTACTROLLEN" ADD CONSTRAINT "_SYSTEM"."_C18" UNIQUE("CCONTACTEN_FK","CCONTACTROL") INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TCONTACTROLLENBB" ADD CONSTRAINT "_SYSTEM"."_C19" PRIMARY KEY("CCONTACTROLLENBB_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TINTERNEFIRMAMEDEWERKERS" ADD CONSTRAINT "_SYSTEM"."_C20" PRIMARY KEY("CINTERNEFIRMAMEDEWERKERS_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TINTERNEFIRMAMEDEWERKERS" ADD CONSTRAINT "_SYSTEM"."_C21" UNIQUE("CINTERNEFIRMAS_FK","CINTERNEFIRMAVESTIGINGEN_FK","CMEDEWERKERS_FK") INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TINTERNEFIRMAS" ADD CONSTRAINT "_SYSTEM"."_C22" PRIMARY KEY("CINTERNEFIRMAS_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TINTERNEFIRMAS" ADD CONSTRAINT "_SYSTEM"."_C23" UNIQUE("CINTERNEFIRMA") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TLANDEN" ADD CONSTRAINT "_SYSTEM"."_C24" PRIMARY KEY("CLANDEN_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TLANDEN" ADD CONSTRAINT "_SYSTEM"."_C25" UNIQUE("CLAND") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TDOCUMENTSTATUSSEN" ADD CONSTRAINT "_SYSTEM"."_C26" PRIMARY KEY("CDOCUMENTSTATUSSEN_PK") CACHE(16,20000,100);
ALTER TABLE "_SYSTEM"."TLEVERINGSVOORWAARDEN" ADD CONSTRAINT "_SYSTEM"."_C27" PRIMARY KEY("CLEVERINGSVOORWAARDEN_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TLEVERINGSVOORWAARDEN" ADD CONSTRAINT "_SYSTEM"."_C28" UNIQUE("CLEVERINGSVOORWAARDE") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TMEDEWERKERGROEPEN" ADD CONSTRAINT "_SYSTEM"."_C29" PRIMARY KEY("CMEDEWERKERGROEPEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TMEDEWERKERGROEPEN" ADD CONSTRAINT "_SYSTEM"."_C30" UNIQUE("CMEDEWERKERGROEP") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TMEDEWERKERS" ADD CONSTRAINT "_SYSTEM"."_C31" PRIMARY KEY("CMEDEWERKERS_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TMEDEWERKERS" ADD CONSTRAINT "_SYSTEM"."_C32" UNIQUE("CMEDEWERKER") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TMUNTEN" ADD CONSTRAINT "_SYSTEM"."_C33" PRIMARY KEY("CMUNTEN_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TMUNTEN" ADD CONSTRAINT "_SYSTEM"."_C34" UNIQUE("CMUNT") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TNOACCESS" ADD CONSTRAINT "_SYSTEM"."_C35" PRIMARY KEY("CNOACCESS_PK") CACHE(16,20000,100);
ALTER TABLE "_SYSTEM"."TNOACCESS" ADD CONSTRAINT "_SYSTEM"."_C36" UNIQUE("CMEDEWERKERGROEPEN_FK","CLIBRARY","COBJECT") CACHE(16,20000,100);
ALTER TABLE "_SYSTEM"."TPOSTCODES" ADD CONSTRAINT "_SYSTEM"."_C37" PRIMARY KEY("CPOSTCODES_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TROLGROEPEN" ADD CONSTRAINT "_SYSTEM"."_C39" PRIMARY KEY("CROLGROEPEN_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TROLGROEPEN" ADD CONSTRAINT "_SYSTEM"."_C40" UNIQUE("CROLGROEP") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TTALEN" ADD CONSTRAINT "_SYSTEM"."_C41" PRIMARY KEY("CTALEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TTALEN" ADD CONSTRAINT "_SYSTEM"."_C42" UNIQUE("CTAAL") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TTRANSPORTEURS" ADD CONSTRAINT "_SYSTEM"."_C43" PRIMARY KEY("CTRANSPORTEURS_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TTRANSPORTEURS" ADD CONSTRAINT "_SYSTEM"."_C44" UNIQUE("CTRANSPORTEUR") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TVOORSTELREKENINGEN" ADD CONSTRAINT "_SYSTEM"."_C45" PRIMARY KEY("CVOORSTELREKENINGEN_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TVOORSTELREKENINGEN" ADD CONSTRAINT "_SYSTEM"."_C46" UNIQUE("CALGEMENEREKENINGEN_FK","CCONTACTROLLEN_FK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TWINPOSITIES" ADD CONSTRAINT "_SYSTEM"."_C47" PRIMARY KEY("CWINPOSITIES_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TWINPOSITIES" ADD CONSTRAINT "_SYSTEM"."_C48" UNIQUE("CMEDEWERKERS_FK","CLIBRARY","COBJECT") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TROLLEN" ADD CONSTRAINT "_SYSTEM"."_C49" PRIMARY KEY("CROLLEN_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TCODELIJSTEN" ADD CONSTRAINT "_SYSTEM"."_C50" PRIMARY KEY("CCODELIJSTEN_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TCOLSELECT" ADD CONSTRAINT "_SYSTEM"."_C51" PRIMARY KEY("CCOLSELECT_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TCATEGORIEN" ADD CONSTRAINT "_SYSTEM"."_C52" PRIMARY KEY("CCATEGORIEN_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TARTIKELKORTINGENLEVERANCIERS" ADD CONSTRAINT "_SYSTEM"."_C53" PRIMARY KEY("CARTIKELKORTINGENLEVERANCIERS_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSUBCATEGORIEN" ADD CONSTRAINT "_SYSTEM"."_C54" PRIMARY KEY("CSUBCATEGORIEN_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TREPORTS" ADD CONSTRAINT "_SYSTEM"."_C55" PRIMARY KEY("CREPORTS_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TREPTEMPLATES" ADD CONSTRAINT "_SYSTEM"."_C56" PRIMARY KEY("CREPTEMPLATES_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TMODULES" ADD CONSTRAINT "_SYSTEM"."_C57" PRIMARY KEY("CMODULES_PK") CACHE(16,20000,100);
ALTER TABLE "_SYSTEM"."TINSTELLINGEN" ADD CONSTRAINT "_SYSTEM"."_C58" UNIQUE("CINTERNEFIRMA","CINTERNEFIRMAVESTIGING","CINDEX") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TINSTELLINGEN" ADD CONSTRAINT "_SYSTEM"."_C59" PRIMARY KEY("CINSTELLINGEN_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TDOCUMENTTYPES" ADD CONSTRAINT "_SYSTEM"."_C60" PRIMARY KEY("CDOCUMENTTYPES_PK") CACHE(16,20000,100);
ALTER TABLE "_SYSTEM"."TDOCUMENTTYPES" ADD CONSTRAINT "_SYSTEM"."_C61" UNIQUE("CDOCUMENTTYPE") CACHE(16,20000,100);
ALTER TABLE "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN" ADD CONSTRAINT "_SYSTEM"."_C62" PRIMARY KEY("CINTERNEFIRMAVESTIGINGEN_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TRUIMTEN" ADD CONSTRAINT "_SYSTEM"."_C63" PRIMARY KEY("CRUIMTEN_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TANALYTISCHEREKENINGEN" ADD CONSTRAINT "_SYSTEM"."_C64" PRIMARY KEY("CANALYTISCHEREKENINGEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TANALYTISCHEREKENINGEN" ADD CONSTRAINT "_SYSTEM"."_C8708" UNIQUE("CINTERNEFIRMAALGEMENEREKENINGEN","CANALYTISCHEREKENING","CNIVEAU") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TBTWCODES" ADD CONSTRAINT "_SYSTEM"."_C66" PRIMARY KEY("CBTWCODES_PK") CACHE(16,20000,100);
ALTER TABLE "_SYSTEM"."TBTWCODES" ADD CONSTRAINT "_SYSTEM"."_C67" UNIQUE("CLANDBTW","CBTWCODE") INITIALLY DEFERRED DEFERRABLE CACHE(16,20000,100);
ALTER TABLE "_SYSTEM"."TGNCODES" ADD CONSTRAINT "_SYSTEM"."_C68" UNIQUE("CGNCODE") INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TGNCODES" ADD CONSTRAINT "_SYSTEM"."_C69" PRIMARY KEY("CGNCODES_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TARTIKELGROEPEN" ADD CONSTRAINT "_SYSTEM"."_C70" PRIMARY KEY("CARTIKELGROEPEN_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TDOCUMENTACTIES" ADD CONSTRAINT "_SYSTEM"."_C71" PRIMARY KEY("CDOCUMENTACTIES_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TINCOTERMS" ADD CONSTRAINT "_SYSTEM"."_C72" PRIMARY KEY("CINCOTERMS_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TINTRASTATGEWESTEN" ADD CONSTRAINT "_SYSTEM"."_C73" PRIMARY KEY("CINTRASTATGEWESTEN_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TINTRASTATTRANSACTIES" ADD CONSTRAINT "_SYSTEM"."_C74" PRIMARY KEY("CINTRASTATTRANSACTIES_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TINTRASTATVERVOER" ADD CONSTRAINT "_SYSTEM"."_C75" PRIMARY KEY("CINTRASTATVERVOER_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TVESTIGINGMAGAZIJNEN" ADD CONSTRAINT "_SYSTEM"."_C76" PRIMARY KEY("CVESTIGINGMAGAZIJNEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C77" PRIMARY KEY("CARTIKELS_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C78" UNIQUE("CINTERNEFIRMAARTIKELS","CARTIKEL") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TARTIKELLEVERANCIERS" ADD CONSTRAINT "_SYSTEM"."_C79" PRIMARY KEY("CARTIKELLEVERANCIERS_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TARTIKELVOORRAAD" ADD CONSTRAINT "_SYSTEM"."_C80" PRIMARY KEY("CARTIKELVOORRAAD_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TARTIKELVOORRAAD" ADD CONSTRAINT "_SYSTEM"."_C81" UNIQUE("CINTERNEFIRMAS_FK","CINTERNEFIRMAVESTIGINGEN_FK","CVESTIGINGMAGAZIJN","CARTIKELS_FK","CKLEUR","CMAAT","CLOTNUMMER") INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TKLEURENKAARTEN" ADD CONSTRAINT "_SYSTEM"."_C82" PRIMARY KEY("CKLEURENKAARTEN_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TKLEUREN" ADD CONSTRAINT "_SYSTEM"."_C83" PRIMARY KEY("CKLEUREN_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TMATENBALKEN" ADD CONSTRAINT "_SYSTEM"."_C84" PRIMARY KEY("CMATENBALKEN_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TMATEN" ADD CONSTRAINT "_SYSTEM"."_C85" PRIMARY KEY("CMATEN_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TARTIKELINVESTIGING" ADD CONSTRAINT "_SYSTEM"."_C86" PRIMARY KEY("CARTIKELINVESTIGING_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TARTIKELINVESTIGING" ADD CONSTRAINT "_SYSTEM"."_C87" UNIQUE("CINTERNEFIRMAS_FK","CINTERNEFIRMAVESTIGINGEN_FK","CARTIKELS_FK","CKLEUR","CMAAT") INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TARTIKELKORTINGEN" ADD CONSTRAINT "_SYSTEM"."_C89" PRIMARY KEY("CARTIKELKORTINGEN_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TARTIKELONDERDELEN" ADD CONSTRAINT "_SYSTEM"."_C90" PRIMARY KEY("CARTIKELONDERDELEN_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TARTIKELGEKOPPELD" ADD CONSTRAINT "_SYSTEM"."_C91" PRIMARY KEY("CARTIKELGEKOPPELD_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TADRESTYPES" ADD CONSTRAINT "_SYSTEM"."_C92" PRIMARY KEY("CADRESTYPES_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TCONTACTADRESSEN" ADD CONSTRAINT "_SYSTEM"."_C93" PRIMARY KEY("CCONTACTADRESSEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TTARIEVEN" ADD CONSTRAINT "_SYSTEM"."_C94" PRIMARY KEY("CTARIEVEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TTARIEVEN" ADD CONSTRAINT "_SYSTEM"."_C95" UNIQUE("CINTERNEFIRMAS_FK","CTARIEF") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TARTIKELPRIJZEN" ADD CONSTRAINT "_SYSTEM"."_C96" PRIMARY KEY("CARTIKELPRIJZEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TARTIKELPRIJZEN" ADD CONSTRAINT "_SYSTEM"."_C97" UNIQUE("CINTERNEFIRMAS_FK","CARTIKELS_FK","CTARIEVEN_FK","CEENHEIDVERKOOP","CAANTALFACTOR") INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVERKOPEN" ADD CONSTRAINT "_SYSTEM"."_C98" PRIMARY KEY("CVERKOPEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVERKOPEN" ADD CONSTRAINT "_SYSTEM"."_C99" UNIQUE("CINTERNEFIRMAS_FK","CINTERNEFIRMAVESTIGINGEN_FK","CDOCUMENTTYPES_FK","CNUMMER","CVERSIE") INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVERKOOPCOLLI" ADD CONSTRAINT "_SYSTEM"."_C100" PRIMARY KEY("CVERKOOPCOLLI_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVERKOOPBETALINGEN" ADD CONSTRAINT "_SYSTEM"."_C101" PRIMARY KEY("CVERKOOPBETALINGEN_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TVERKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C102" PRIMARY KEY("CVERKOOPLIJNEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TMATERIALEN" ADD CONSTRAINT "_SYSTEM"."_C103" PRIMARY KEY("CMATERIALEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TAGENDALABELS" ADD CONSTRAINT "_SYSTEM"."_C4312" PRIMARY KEY("CAGENDALABELS_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TAANKOPEN" ADD CONSTRAINT "_SYSTEM"."_C105" PRIMARY KEY("CAANKOPEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TAANKOPEN" ADD CONSTRAINT "_SYSTEM"."_C106" UNIQUE("CINTERNEFIRMAS_FK","CINTERNEFIRMAVESTIGINGEN_FK","CDOCUMENTTYPES_FK","CNUMMER") INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TAANKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C107" PRIMARY KEY("CAANKOOPLIJNEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TAGENDA" ADD CONSTRAINT "_SYSTEM"."_C4439" PRIMARY KEY("CAGENDA_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVOORRAADWIJZIGINGEN" ADD CONSTRAINT "_SYSTEM"."_C109" PRIMARY KEY("CVOORRAADWIJZIGINGEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVOORRAADTRANSFERSERIENUMMERS" ADD CONSTRAINT "_SYSTEM"."_C110" PRIMARY KEY("CVOORRAADTRANSFERSERIENUMMERS_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVOORRAADWIJZIGINGSERIENUMMERS" ADD CONSTRAINT "_SYSTEM"."_C111" UNIQUE("CVOORRAADWIJZIGINGEN_FK","CSERIENUMMER") INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVOORRAADWIJZIGINGSERIENUMMERS" ADD CONSTRAINT "_SYSTEM"."_C112" PRIMARY KEY("CVOORRAADWIJZIGINGSERIENUMMERS_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVOORRAADTRANSFERS" ADD CONSTRAINT "_SYSTEM"."_C113" PRIMARY KEY("CVOORRAADTRANSFERS_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TLICENTIE" ADD CONSTRAINT "_SYSTEM"."_C114" PRIMARY KEY("CLICENTIE_PK") CACHE(16,20000,100);
ALTER TABLE "_SYSTEM"."TSESSIES" ADD CONSTRAINT "_SYSTEM"."_C115" PRIMARY KEY("CSESSIES_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TARTIKELLOCATIES" ADD CONSTRAINT "_SYSTEM"."_C116" PRIMARY KEY("CARTIKELLOCATIES_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TARTIKELLOCATIES" ADD CONSTRAINT "_SYSTEM"."_C117" UNIQUE("CINTERNEFIRMAS_FK","CINTERNEFIRMAVESTIGINGEN_FK","CVESTIGINGMAGAZIJN","CARTIKELS_FK") INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPRODUCTIE" ADD CONSTRAINT "_SYSTEM"."_C118" PRIMARY KEY("CPRODUCTIE_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TARTIKELVERPAKKINGEN" ADD CONSTRAINT "_SYSTEM"."_C119" PRIMARY KEY("CARTIKELVERPAKKINGEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TARTIKELVERPAKKINGEN" ADD CONSTRAINT "_SYSTEM"."_C120" UNIQUE("CINTERNEFIRMAS_FK","CARTIKELS_FK","CVERPAKKING","CAANTAL") INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TCRMCOMMUNICATIES" ADD CONSTRAINT "_SYSTEM"."_C121" PRIMARY KEY("CCRMCOMMUNICATIES_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TCRMCOMMUNICATIEBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C122" PRIMARY KEY("CCRMCOMMUNICATIEBIJLAGEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TCRMTAKEN" ADD CONSTRAINT "_SYSTEM"."_C123" PRIMARY KEY("CCRMTAKEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TCRMTAAKBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C124" PRIMARY KEY("CCRMTAAKBIJLAGEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPRODUCTIELIJNEN" ADD CONSTRAINT "_SYSTEM"."_C125" PRIMARY KEY("CPRODUCTIELIJNEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TAGENDAEXTRA" ADD CONSTRAINT "_SYSTEM"."_C126" PRIMARY KEY("CAGENDAEXTRA_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TAGENDAPREFS" ADD CONSTRAINT "_SYSTEM"."_C127" PRIMARY KEY("CAGENDAPREFS_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TKASSAAFSL" ADD CONSTRAINT "_SYSTEM"."_C128" PRIMARY KEY("CKASSAAFSL_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TKASSAAFSLBETAALWIJZEN" ADD CONSTRAINT "_SYSTEM"."_C129" PRIMARY KEY("CKASSAAFSLBETAALWIJZEN_PK") CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TKASSAAFSLOMZETTEN" ADD CONSTRAINT "_SYSTEM"."_C8719" PRIMARY KEY("CKASSAAFSLOMZETTEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TBETAALWIJZEN" ADD CONSTRAINT "_SYSTEM"."_C131" PRIMARY KEY("CBETAALWIJZEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TCONTACTSALDI" ADD CONSTRAINT "_SYSTEM"."_C132" PRIMARY KEY("CCONTACTSALDI_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TCONTACTSALDI" ADD CONSTRAINT "_SYSTEM"."_C133" UNIQUE("CINTERNEFIRMAS_FK","CCONTACTEN_FK","CCONTACTROL") INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TBTWVAKKEN" ADD CONSTRAINT "_SYSTEM"."_C134" PRIMARY KEY("CBTWVAKKEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TBTWVAKKEN" ADD CONSTRAINT "_SYSTEM"."_C135" UNIQUE("CLANDBTW","CBTWVAK","CINTERNEFIRMAS_FK") INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TBTWCODESPERVAK" ADD CONSTRAINT "_SYSTEM"."_C136" PRIMARY KEY("CBTWCODESPERVAK_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TBOEKJAREN" ADD CONSTRAINT "_SYSTEM"."_C137" PRIMARY KEY("CBOEKJAREN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TBOEKJAREN" ADD CONSTRAINT "_SYSTEM"."_C138" UNIQUE("CINTERNEFIRMAS_FK","CBOEKJAAR") INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TKALENDERJAREN" ADD CONSTRAINT "_SYSTEM"."_C139" PRIMARY KEY("CKALENDERJAREN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TKALENDERJAREN" ADD CONSTRAINT "_SYSTEM"."_C140" UNIQUE("CINTERNEFIRMAS_FK","CKALENDERJAAR") INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TBTWPERIODEN" ADD CONSTRAINT "_SYSTEM"."_C141" PRIMARY KEY("CBTWPERIODEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TBTWPERIODEN" ADD CONSTRAINT "_SYSTEM"."_C142" UNIQUE("CINTERNEFIRMAS_FK","CBTWPERIODE") INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TBOEKPERIODEN" ADD CONSTRAINT "_SYSTEM"."_C143" PRIMARY KEY("CBOEKPERIODEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TBOEKPERIODEN" ADD CONSTRAINT "_SYSTEM"."_C144" UNIQUE("CINTERNEFIRMAS_FK","CBOEKJAREN_FK","CBOEKPERIODE") INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TINTRASTATAANGEVER" ADD CONSTRAINT "_SYSTEM"."_C145" PRIMARY KEY("CINTRASTATAANGEVER_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TINTRASTATAANGEVER" ADD CONSTRAINT "_SYSTEM"."_C146" UNIQUE("CINTERNEFIRMAS_FK") INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TDAGBOEKEN" ADD CONSTRAINT "_SYSTEM"."_C147" PRIMARY KEY("CDAGBOEKEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TDAGBOEKEN" ADD CONSTRAINT "_SYSTEM"."_C148" UNIQUE("CINTERNEFIRMAS_FK","CDAGBOEK") INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TDAGBOEKVOLGNR" ADD CONSTRAINT "_SYSTEM"."_C149" PRIMARY KEY("CDAGBOEKVOLGNR_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TDAGBOEKVOLGNR" ADD CONSTRAINT "_SYSTEM"."_C150" UNIQUE("CINTERNEFIRMAS_FK","CBOEKJAREN_FK","CDAGBOEKEN_FK") INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TTEKSTENRAPPEL" ADD CONSTRAINT "_SYSTEM"."_C151" PRIMARY KEY("CTEKSTENRAPPEL_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TTEKSTENRAPPEL" ADD CONSTRAINT "_SYSTEM"."_C152" UNIQUE("CINTERNEFIRMAS_FK","CTEKSTRAPPEL") INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TANALSLEUTELS" ADD CONSTRAINT "_SYSTEM"."_C153" PRIMARY KEY("CANALSLEUTELS_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TANALSLEUTELS" ADD CONSTRAINT "_SYSTEM"."_C8710" UNIQUE("CALGEMENEREKENINGEN_FK","CANALYTISCHEREKENING") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TBOEKINGEN" ADD CONSTRAINT "_SYSTEM"."_C155" PRIMARY KEY("CBOEKINGEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TBOEKINGEN" ADD CONSTRAINT "_SYSTEM"."_C156" UNIQUE("CINTERNEFIRMAS_FK","CDAGBOEKEN_FK","CBOEKJAREN_FK","CVOLGNR") INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TBOEKINGHISTORIEK" ADD CONSTRAINT "_SYSTEM"."_C157" PRIMARY KEY("CBOEKINGHISTORIEK_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TBOEKINGBTW" ADD CONSTRAINT "_SYSTEM"."_C158" PRIMARY KEY("CBOEKINGBTW_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TBOEKINGBTW" ADD CONSTRAINT "_SYSTEM"."_C159" UNIQUE("CBOEKINGEN_FK","CBTWVAK") INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TBOEKINGINTRASTAT" ADD CONSTRAINT "_SYSTEM"."_C160" PRIMARY KEY("CBOEKINGINTRASTAT_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C161" PRIMARY KEY("CCENTRALISATIE_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C162" UNIQUE("CINTERNEFIRMAS_FK","CDAGBOEKEN_FK","CBOEKJAREN_FK","CBOEKPERIODEN_FK","CALGEMENEREKENINGEN_FK") INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TANALCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C163" PRIMARY KEY("CANALCENTRALISATIE_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TANALCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C8714" UNIQUE("CINTERNEFIRMAS_FK","CDAGBOEKEN_FK","CBOEKPERIODEN_FK","CALGEMENEREKENINGEN_FK","CANALYTISCHEREKENING") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TCENTRALISATIEOMZETTEN" ADD CONSTRAINT "_SYSTEM"."_C165" PRIMARY KEY("CCENTRALISATIEOMZETTEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCENTRALISATIEOMZETTEN" ADD CONSTRAINT "_SYSTEM"."_C166" UNIQUE("CINTERNEFIRMAS_FK","CBOEKJAREN_FK","CBOEKPERIODEN_FK","CCONTACTEN_FK","CTYPE") INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TAFSCHRIJVINGEN" ADD CONSTRAINT "_SYSTEM"."_C167" PRIMARY KEY("CAFSCHRIJVINGEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TFICHE28150" ADD CONSTRAINT "_SYSTEM"."_C168" PRIMARY KEY("CFICHE28150_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TBUDGETTEN" ADD CONSTRAINT "_SYSTEM"."_C169" PRIMARY KEY("CBUDGETTEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TBUDGETTEN" ADD CONSTRAINT "_SYSTEM"."_C170" UNIQUE("CBOEKPERIODEN_FK","CALGEMENEREKENINGEN_FK") INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TANALBUDGETTEN" ADD CONSTRAINT "_SYSTEM"."_C171" PRIMARY KEY("CANALBUDGETTEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TANALBUDGETTEN" ADD CONSTRAINT "_SYSTEM"."_C8712" UNIQUE("CBOEKPERIODEN_FK","CALGEMENEREKENINGEN_FK","CANALYTISCHEREKENING") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TBTWAANGIFTENBE" ADD CONSTRAINT "_SYSTEM"."_C173" PRIMARY KEY("CBTWAANGIFTENBE_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TBTWAANGIFTENBE" ADD CONSTRAINT "_SYSTEM"."_C174" UNIQUE("CINTERNEFIRMAS_FK","CKALENDERJAREN_FK","CBTWPERIODEN_FK") INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TSTRUCTUREN" ADD CONSTRAINT "_SYSTEM"."_C175" PRIMARY KEY("CSTRUCTUREN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSTRUCTUREN" ADD CONSTRAINT "_SYSTEM"."_C176" UNIQUE("CINTERNEFIRMAS_FK","CSTRUCTUUR","CTAAL") INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSTRUCTUURDETAILS" ADD CONSTRAINT "_SYSTEM"."_C177" PRIMARY KEY("CSTRUCTUURDETAILS_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICE" ADD CONSTRAINT "_SYSTEM"."_C178" PRIMARY KEY("CSERVICE_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICE" ADD CONSTRAINT "_SYSTEM"."_C179" UNIQUE("CINTERNEFIRMAS_FK","CINTERNEFIRMAVESTIGINGEN_FK","CDOCUMENTTYPES_FK","CNUMMER","CVERSIE") INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICEBETALINGEN" ADD CONSTRAINT "_SYSTEM"."_C180" PRIMARY KEY("CSERVICEBETALINGEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICEHISTORIEK" ADD CONSTRAINT "_SYSTEM"."_C181" PRIMARY KEY("CSERVICEHISTORIEK_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TSERVICELIJNEN" ADD CONSTRAINT "_SYSTEM"."_C182" PRIMARY KEY("CSERVICELIJNEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICELIJNSERIENUMMERS" ADD CONSTRAINT "_SYSTEM"."_C183" PRIMARY KEY("CSERVICELIJNSERIENUMMERS_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICESTATUSSEN" ADD CONSTRAINT "_SYSTEM"."_C184" PRIMARY KEY("CSERVICESTATUSSEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TKASSAUITGAVEN" ADD CONSTRAINT "_SYSTEM"."_C185" PRIMARY KEY("CKASSAUITGAVEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TFACTUREN" ADD CONSTRAINT "_SYSTEM"."_C186" UNIQUE("CINTERNEFIRMAS_FK","CDAGBOEKEN_FK","CBOEKJAREN_FK","CNUMMER") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TFACTUREN" ADD CONSTRAINT "_SYSTEM"."_C187" PRIMARY KEY("CFACTUREN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TFACTLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C188" PRIMARY KEY("CFACTLIJNEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TFACTARTIKELGROEPEN" ADD CONSTRAINT "_SYSTEM"."_C189" PRIMARY KEY("CFACTARTIKELGROEPEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TFACTARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C190" UNIQUE("CINTERNEFIRMAS_FK","CFACTARTIKEL") INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TFACTARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C191" PRIMARY KEY("CFACTARTIKELS_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TKASSANUMMERS" ADD CONSTRAINT "_SYSTEM"."_C192" PRIMARY KEY("CKASSANUMMERS_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TKASSANUMMERS" ADD CONSTRAINT "_SYSTEM"."_C193" UNIQUE("CINTERNEFIRMAS_FK","CINTERNEFIRMAVESTIGINGEN_FK","CKASSANUMMER") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVERWORPENUITGAVEN" ADD CONSTRAINT "_SYSTEM"."_C194" UNIQUE("CINTERNEFIRMAS_FK","CALGEMENEREKENINGEN_FK") INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVERWORPENUITGAVEN" ADD CONSTRAINT "_SYSTEM"."_C195" PRIMARY KEY("CVERWORPENUITGAVEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TDAVE" ADD CONSTRAINT "_SYSTEM"."_C196" PRIMARY KEY("CDAVE_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TDAVE" ADD CONSTRAINT "_SYSTEM"."_C197" UNIQUE("CINDEX") INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TCRMMAILINGTEKSTEN" ADD CONSTRAINT "_SYSTEM"."_C198" PRIMARY KEY("CCRMMAILINGTEKSTEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TXCONTACTEN" ADD CONSTRAINT "_SYSTEM"."_C199" UNIQUE("CINTERNEFIRMACONTACTEN","CCONTACT") INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TXCONTACTEN" ADD CONSTRAINT "_SYSTEM"."_C200" PRIMARY KEY("CXCONTACTEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TXCONTACTPERSONEN" ADD CONSTRAINT "_SYSTEM"."_C201" PRIMARY KEY("CXCONTACTPERSONEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TXCONTACTADRESSEN" ADD CONSTRAINT "_SYSTEM"."_C202" UNIQUE("CINTERNEFIRMACONTACTEN","CCONTACT","CADRESTYPE","CNAAM1") INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TXCONTACTADRESSEN" ADD CONSTRAINT "_SYSTEM"."_C203" PRIMARY KEY("CXCONTACTADRESSEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TXVERKOPEN" ADD CONSTRAINT "_SYSTEM"."_C204" UNIQUE("CINTERNEFIRMA","CINTERNEFIRMAVESTIGING","CNUMMER","CDOCUMENTTYPE") INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TXVERKOPEN" ADD CONSTRAINT "_SYSTEM"."_C205" PRIMARY KEY("CXVERKOPEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TXVERKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C206" UNIQUE("CINTERNEFIRMA","CINTERNEFIRMAVESTIGING","CNUMMER","CLIJNNUMMER") INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TXVERKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C207" PRIMARY KEY("CXVERKOOPLIJNEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TXVERKOOPBETALINGEN" ADD CONSTRAINT "_SYSTEM"."_C208" UNIQUE("CINTERNEFIRMA","CINTERNEFIRMAVESTIGING","CNUMMER","CLIJNNUMMER") INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TXVERKOOPBETALINGEN" ADD CONSTRAINT "_SYSTEM"."_C209" PRIMARY KEY("CXVERKOOPBETALINGEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TMAGAZIJNLOCATIES" ADD CONSTRAINT "_SYSTEM"."_C210" PRIMARY KEY("CMAGAZIJNLOCATIES_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TMAGAZIJNLOCATIES" ADD CONSTRAINT "_SYSTEM"."_C211" UNIQUE("CINTERNEFIRMAS_FK","CINTERNEFIRMAVESTIGINGEN_FK","CVESTIGINGMAGAZIJN","CMAGAZIJNLOCATIE") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TARTIKELBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C212" PRIMARY KEY("CARTIKELBIJLAGEN_PK") INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TARTIKELVOORRAADAANTALLEN" ADD CONSTRAINT "_SYSTEM"."_C213" PRIMARY KEY("CARTIKELVOORRAADAANTALLEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TARTIKELVOORRAADAANTALLEN" ADD CONSTRAINT "_SYSTEM"."_C214" UNIQUE("CARTIKELVOORRAAD_FK","CMAGAZIJNLOCATIE","CSERIENUMMER","CLOTNUMMER") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVERKOOPLIJNAANTALLEN" ADD CONSTRAINT "_SYSTEM"."_C215" PRIMARY KEY("CVERKOOPLIJNAANTALLEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVERKOOPLIJNAANTALLEN" ADD CONSTRAINT "_SYSTEM"."_C216" UNIQUE("CVERKOOPLIJNEN_FK","CMAGAZIJNLOCATIE","CSERIENUMMER","CLOTNUMMER") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TAANKOOPLIJNAANTALLEN" ADD CONSTRAINT "_SYSTEM"."_C217" PRIMARY KEY("CAANKOOPLIJNAANTALLEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TAANKOOPLIJNAANTALLEN" ADD CONSTRAINT "_SYSTEM"."_C218" UNIQUE("CAANKOOPLIJNEN_FK","CMAGAZIJNLOCATIE","CSERIENUMMER","CLOTNUMMER") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPRODUCTIEAANTALLEN" ADD CONSTRAINT "_SYSTEM"."_C219" PRIMARY KEY("CPRODUCTIEAANTALLEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPRODUCTIEAANTALLEN" ADD CONSTRAINT "_SYSTEM"."_C220" UNIQUE("CPRODUCTIE_FK","CMAGAZIJNLOCATIE","CSERIENUMMER","CLOTNUMMER") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPRODUCTIELIJNAANTALLEN" ADD CONSTRAINT "_SYSTEM"."_C221" PRIMARY KEY("CPRODUCTIELIJNAANTALLEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPRODUCTIELIJNAANTALLEN" ADD CONSTRAINT "_SYSTEM"."_C222" UNIQUE("CPRODUCTIELIJNEN_FK","CMAGAZIJNLOCATIE","CSERIENUMMER","CLOTNUMMER") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICELIJNAANTALLEN" ADD CONSTRAINT "_SYSTEM"."_C223" PRIMARY KEY("CSERVICELIJNAANTALLEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICELIJNAANTALLEN" ADD CONSTRAINT "_SYSTEM"."_C224" UNIQUE("CSERVICELIJNEN_FK","CMAGAZIJNLOCATIE","CSERIENUMMER","CLOTNUMMER") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TXCONTACTGROEPEN" ADD CONSTRAINT "_SYSTEM"."_C225" PRIMARY KEY("CXCONTACTGROEPEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TEENHEDEN" ADD CONSTRAINT "_SYSTEM"."_C226" PRIMARY KEY("CEENHEDEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TEENHEDEN" ADD CONSTRAINT "_SYSTEM"."_C227" UNIQUE("CEENHEID1") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TMUNTWAARDEN" ADD CONSTRAINT "_SYSTEM"."_C228" PRIMARY KEY("CMUNTWAARDEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TDOCTEMPLATES" ADD CONSTRAINT "_SYSTEM"."_C229" PRIMARY KEY("CDOCTEMPLATES_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TAGENDAGROEPEN" ADD CONSTRAINT "_SYSTEM"."_C230" PRIMARY KEY("CAGENDAGROEPEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TAGENDAGROEPEN" ADD CONSTRAINT "_SYSTEM"."_C231" UNIQUE("CAGENDAGROEP") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TAGENDAGROEPMEDEWERKERS" ADD CONSTRAINT "_SYSTEM"."_C232" PRIMARY KEY("CAGENDAGROEPMEDEWERKERS_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TAGENDAGROEPMEDEWERKERS" ADD CONSTRAINT "_SYSTEM"."_C233" UNIQUE("CAGENDAGROEPEN_FK","CMEDEWERKERS_FK") INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TUURROOSTERS" ADD CONSTRAINT "_SYSTEM"."_C234" PRIMARY KEY("CUURROOSTERS_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TMEDEWERKERUURKOST" ADD CONSTRAINT "_SYSTEM"."_C235" PRIMARY KEY("CMEDEWERKERUURKOST_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPRESTATIESOORTEN" ADD CONSTRAINT "_SYSTEM"."_C236" PRIMARY KEY("CPRESTATIESOORTEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPRESTATIESOORTEN" ADD CONSTRAINT "_SYSTEM"."_C5932" UNIQUE("CINTERNEFIRMAS_FK","CPRESTATIESOORT") INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPRESTATIES" ADD CONSTRAINT "_SYSTEM"."_C238" PRIMARY KEY("CPRESTATIES_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICEARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C239" PRIMARY KEY("CSERVICEARTIKELS_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTTYPES" ADD CONSTRAINT "_SYSTEM"."_C240" PRIMARY KEY("CPROJECTTYPES_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTEN" ADD CONSTRAINT "_SYSTEM"."_C241" PRIMARY KEY("CPROJECTEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTEN" ADD CONSTRAINT "_SYSTEM"."_C242" UNIQUE("CINTERNEFIRMAS_FK","CINTERNEFIRMAVESTIGINGEN_FK","CDOCUMENTTYPES_FK","CPROJECT") INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTCONTACTEN" ADD CONSTRAINT "_SYSTEM"."_C243" PRIMARY KEY("CPROJECTCONTACTEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTMEDEWERKERS" ADD CONSTRAINT "_SYSTEM"."_C244" PRIMARY KEY("CPROJECTMEDEWERKERS_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTMATERIALEN" ADD CONSTRAINT "_SYSTEM"."_C245" PRIMARY KEY("CPROJECTMATERIALEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTFASEN" ADD CONSTRAINT "_SYSTEM"."_C246" PRIMARY KEY("CPROJECTFASEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTFASEEXTRA" ADD CONSTRAINT "_SYSTEM"."_C247" PRIMARY KEY("CPROJECTFASEEXTRA_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C248" PRIMARY KEY("CPROJECTARTIKELS_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTVC" ADD CONSTRAINT "_SYSTEM"."_C249" UNIQUE("CINTERNEFIRMAS_FK","CINTERNEFIRMAVESTIGINGEN_FK","CNUMMER") INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTVC" ADD CONSTRAINT "_SYSTEM"."_C250" PRIMARY KEY("CPROJECTVC_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTVCLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C251" PRIMARY KEY("CPROJECTVCLIJNEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTVCBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C252" PRIMARY KEY("CPROJECTVCBIJLAGEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTOFFERTES" ADD CONSTRAINT "_SYSTEM"."_C253" PRIMARY KEY("CPROJECTOFFERTES_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTOFFERTES" ADD CONSTRAINT "_SYSTEM"."_C254" UNIQUE("CINTERNEFIRMAS_FK","CINTERNEFIRMAVESTIGINGEN_FK","CDOCUMENTTYPES_FK","CNUMMER") INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTCAMPAGNES" ADD CONSTRAINT "_SYSTEM"."_C255" PRIMARY KEY("CPROJECTCAMPAGNES_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTTYPEFASEN" ADD CONSTRAINT "_SYSTEM"."_C256" PRIMARY KEY("CPROJECTTYPEFASEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTFASERELATIES" ADD CONSTRAINT "_SYSTEM"."_C257" PRIMARY KEY("CPROJECTFASERELATIES_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVERKOOPBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C258" PRIMARY KEY("CVERKOOPBIJLAGEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TAANKOOPBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C259" PRIMARY KEY("CAANKOOPBIJLAGEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICEBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C260" PRIMARY KEY("CSERVICEBIJLAGEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TSERVICEINSTALLATIES" ADD CONSTRAINT "_SYSTEM"."_C261" PRIMARY KEY("CSERVICEINSTALLATIES_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TAGENDAFEESTDAGEN" ADD CONSTRAINT "_SYSTEM"."_C262" PRIMARY KEY("CAGENDAFEESTDAGEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TAGENDAFEESTDAGEN" ADD CONSTRAINT "_SYSTEM"."_C263" UNIQUE("CDATUM") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTTYPEFASERELATIES" ADD CONSTRAINT "_SYSTEM"."_C264" PRIMARY KEY("CPROJECTTYPEFASERELATIES_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TXPRESTATIES" ADD CONSTRAINT "_SYSTEM"."_C265" PRIMARY KEY("CXPRESTATIES_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVERKOOPLIJNAFMETINGEN" ADD CONSTRAINT "_SYSTEM"."_C1415" PRIMARY KEY("CVERKOOPLIJNAFMETINGEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TPROJECTBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C2569" PRIMARY KEY("CPROJECTBIJLAGEN_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TCONTACTBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C3728" PRIMARY KEY("CCONTACTBIJLAGEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCOMMUNICATIESOORTEN" ADD CONSTRAINT "_SYSTEM"."_C3732" PRIMARY KEY("CCOMMUNICATIESOORTEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCOMMUNICATIESOORTEN" ADD CONSTRAINT "_SYSTEM"."_C3733" UNIQUE("CCOMMUNICATIESOORT") INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TMEDEWERKERHANDTEKENINGEN" ADD CONSTRAINT "_SYSTEM"."_C3734" PRIMARY KEY("CMEDEWERKERHANDTEKENINGEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TMEDEWERKERBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C3740" PRIMARY KEY("CMEDEWERKERBIJLAGEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TNACECODES" ADD CONSTRAINT "_SYSTEM"."_C3743" PRIMARY KEY("CNACECODES_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TNACECODES" ADD CONSTRAINT "_SYSTEM"."_C3744" UNIQUE("CNACECODE") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TAGENDACONTACTEN" ADD CONSTRAINT "_SYSTEM"."_C3749" PRIMARY KEY("CAGENDACONTACTEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TAGENDACONTACTEN" ADD CONSTRAINT "_SYSTEM"."_C3753" UNIQUE("CAGENDA_FK","CCONTACTEN_FK","CCONTACTPERSONEN_FK") INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMCOMMUNICATIECONTACTEN" ADD CONSTRAINT "_SYSTEM"."_C3754" PRIMARY KEY("CCRMCOMMUNICATIECONTACTEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMCOMMUNICATIECONTACTEN" ADD CONSTRAINT "_SYSTEM"."_C3758" UNIQUE("CCRMCOMMUNICATIES_FK","CCONTACTEN_FK","CCONTACTPERSONEN_FK") INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMTAAKPRODUCTEN" ADD CONSTRAINT "_SYSTEM"."_C3759" PRIMARY KEY("CCRMTAAKPRODUCTEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMTAAKOMSCHRIJVINGEN" ADD CONSTRAINT "_SYSTEM"."_C3761" PRIMARY KEY("CCRMTAAKOMSCHRIJVINGEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMTAAKOMSCHRIJVINGEN" ADD CONSTRAINT "_SYSTEM"."_C3762" UNIQUE("CCRMTAAKOMSCHRIJVING") INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMSUPPORTSOORTEN" ADD CONSTRAINT "_SYSTEM"."_C3763" PRIMARY KEY("CCRMSUPPORTSOORTEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMSUPPORTSOORTEN" ADD CONSTRAINT "_SYSTEM"."_C3764" UNIQUE("CINTERNEFIRMAS_FK","CCRMSUPPORTSOORT") INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMWACHTRIJEN" ADD CONSTRAINT "_SYSTEM"."_C3766" PRIMARY KEY("CCRMWACHTRIJEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMWACHTRIJEN" ADD CONSTRAINT "_SYSTEM"."_C3767" UNIQUE("CINTERNEFIRMAS_FK","CCRMWACHTRIJ") INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMWACHTRIJMEDEWERKERS" ADD CONSTRAINT "_SYSTEM"."_C3769" PRIMARY KEY("CCRMWACHTRIJMEDEWERKERS_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMWACHTRIJMEDEWERKERS" ADD CONSTRAINT "_SYSTEM"."_C3770" UNIQUE("CCRMWACHTRIJEN_FK","CMEDEWERKERS_FK") INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMPRODUCTFAMILIES" ADD CONSTRAINT "_SYSTEM"."_C3773" PRIMARY KEY("CCRMPRODUCTFAMILIES_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMPRODUCTFAMILIES" ADD CONSTRAINT "_SYSTEM"."_C3774" UNIQUE("CINTERNEFIRMAS_FK","CCRMPRODUCTFAMILIE") INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMPRODUCTGROEPEN" ADD CONSTRAINT "_SYSTEM"."_C3776" PRIMARY KEY("CCRMPRODUCTGROEPEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMPRODUCTGROEPEN" ADD CONSTRAINT "_SYSTEM"."_C3777" UNIQUE("CINTERNEFIRMAS_FK","CCRMPRODUCTGROEP") INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMPRODUCTEN" ADD CONSTRAINT "_SYSTEM"."_C3779" PRIMARY KEY("CCRMPRODUCTEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMPRODUCTEN" ADD CONSTRAINT "_SYSTEM"."_C3780" UNIQUE("CINTERNEFIRMAS_FK","CCRMPRODUCT") INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMSUPPORTCALLS" ADD CONSTRAINT "_SYSTEM"."_C3782" PRIMARY KEY("CCRMSUPPORTCALLS_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TCRMSUPPORTCALLS" ADD CONSTRAINT "_SYSTEM"."_C3783" UNIQUE("CINTERNEFIRMAS_FK","CINTERNEFIRMAVESTIGINGEN_FK","CNUMMER") INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TCRMSUPPORTCALLLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C3793" PRIMARY KEY("CCRMSUPPORTCALLLIJNEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMSUPPORTCALLOPVOLGING" ADD CONSTRAINT "_SYSTEM"."_C3797" PRIMARY KEY("CCRMSUPPORTCALLOPVOLGING_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMCONTACTPRODUCTEN" ADD CONSTRAINT "_SYSTEM"."_C3800" PRIMARY KEY("CCRMCONTACTPRODUCTEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMCONTACTPRODUCTENHIST" ADD CONSTRAINT "_SYSTEM"."_C3803" PRIMARY KEY("CCRMCONTACTPRODUCTENHIST_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMABONNEMENTTYPES" ADD CONSTRAINT "_SYSTEM"."_C3806" PRIMARY KEY("CCRMABONNEMENTTYPES_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMABONNEMENTTYPELIJNEN" ADD CONSTRAINT "_SYSTEM"."_C3809" PRIMARY KEY("CCRMABONNEMENTTYPELIJNEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMABONNEMENTEN" ADD CONSTRAINT "_SYSTEM"."_C3813" PRIMARY KEY("CCRMABONNEMENTEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMABONNEMENTLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C3820" PRIMARY KEY("CCRMABONNEMENTLIJNEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMABONNEMENTFACTUREN" ADD CONSTRAINT "_SYSTEM"."_C3822" PRIMARY KEY("CCRMABONNEMENTFACTUREN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMABONNEMENTCORRECTIES" ADD CONSTRAINT "_SYSTEM"."_C3824" PRIMARY KEY("CCRMABONNEMENTCORRECTIES_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TPOP3EMAILS" ADD CONSTRAINT "_SYSTEM"."_C3830" PRIMARY KEY("CPOP3EMAILS_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TPOP3EMAILBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C3832" PRIMARY KEY("CPOP3EMAILBIJLAGEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TPOP3EMAILACCOUNTS" ADD CONSTRAINT "_SYSTEM"."_C3834" PRIMARY KEY("CPOP3EMAILACCOUNTS_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMKEUZELIJSTEN" ADD CONSTRAINT "_SYSTEM"."_C3839" PRIMARY KEY("CCRMKEUZELIJSTEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMKEUZELIJSTEN" ADD CONSTRAINT "_SYSTEM"."_C3840" UNIQUE("CCRMKEUZE","COMSCHRIJVING") INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMOORSPRONGEN" ADD CONSTRAINT "_SYSTEM"."_C3842" PRIMARY KEY("CCRMOORSPRONGEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMOORSPRONGEN" ADD CONSTRAINT "_SYSTEM"."_C3843" UNIQUE("CCRMOORSPRONG") INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMSUBOORSPRONGEN" ADD CONSTRAINT "_SYSTEM"."_C3845" PRIMARY KEY("CCRMSUBOORSPRONGEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMSUBOORSPRONGEN" ADD CONSTRAINT "_SYSTEM"."_C3847" UNIQUE("CCRMOORSPRONGEN_FK","CCRMSUBOORSPRONG") INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMAFGESLOTENSTATUSSEN" ADD CONSTRAINT "_SYSTEM"."_C3849" PRIMARY KEY("CCRMAFGESLOTENSTATUSSEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMAFGESLOTENSTATUSSEN" ADD CONSTRAINT "_SYSTEM"."_C3850" UNIQUE("CCRMAFGESLOTENSTATUS") INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMVERKOOPFASEN" ADD CONSTRAINT "_SYSTEM"."_C3852" PRIMARY KEY("CCRMVERKOOPFASEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMVERKOOPFASEN" ADD CONSTRAINT "_SYSTEM"."_C3853" UNIQUE("CCRMVERKOOPFASE") INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMVERKOOPKANSSOORTEN" ADD CONSTRAINT "_SYSTEM"."_C3855" PRIMARY KEY("CCRMVERKOOPKANSSOORTEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMVERKOOPKANSSOORTEN" ADD CONSTRAINT "_SYSTEM"."_C3856" UNIQUE("CCRMVERKOOPKANSSOORT") INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMVERKOOPKANSSOORTFASEN" ADD CONSTRAINT "_SYSTEM"."_C3857" PRIMARY KEY("CCRMVERKOOPKANSSOORTFASEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMVERKOOPKANSSOORTFASEN" ADD CONSTRAINT "_SYSTEM"."_C3860" UNIQUE("CCRMVERKOOPKANSSOORTEN_FK","CCRMVERKOOPFASEN_FK") INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCONTACTINTERESSES" ADD CONSTRAINT "_SYSTEM"."_C3861" PRIMARY KEY("CCONTACTINTERESSES_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCONTACTHUIDIGEPRODUCTEN" ADD CONSTRAINT "_SYSTEM"."_C3863" PRIMARY KEY("CCONTACTHUIDIGEPRODUCTEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMOPLEIDINGTYPES" ADD CONSTRAINT "_SYSTEM"."_C3865" PRIMARY KEY("CCRMOPLEIDINGTYPES_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMOPLEIDINGEN" ADD CONSTRAINT "_SYSTEM"."_C3867" PRIMARY KEY("CCRMOPLEIDINGEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMOPLEIDINGDEELNEMERS" ADD CONSTRAINT "_SYSTEM"."_C3873" PRIMARY KEY("CCRMOPLEIDINGDEELNEMERS_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TXCRMOPLEIDINGDEELNEMERS" ADD CONSTRAINT "_SYSTEM"."_C3877" PRIMARY KEY("CXCRMOPLEIDINGDEELNEMERS_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMVERKOOPKANSEN" ADD CONSTRAINT "_SYSTEM"."_C3878" PRIMARY KEY("CCRMVERKOOPKANSEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMVERKOOPKANSBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C3892" PRIMARY KEY("CCRMVERKOOPKANSBIJLAGEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TARTIKELINFIRMA" ADD CONSTRAINT "_SYSTEM"."_C3896" PRIMARY KEY("CARTIKELINFIRMA_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TARTIKELINFIRMA" ADD CONSTRAINT "_SYSTEM"."_C3900" UNIQUE("CARTIKELS_FK","CINTERNEFIRMAS_FK") INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TFLOW" ADD CONSTRAINT "_SYSTEM"."_C5933" PRIMARY KEY("CFLOW_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TFLOWORDER" ADD CONSTRAINT "_SYSTEM"."_C7295" PRIMARY KEY("CFLOWORDER_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMVERKOOPKANSFASEN" ADD CONSTRAINT "_SYSTEM"."_C7299" PRIMARY KEY("CCRMVERKOOPKANSFASEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TKLANTKAARTEN" ADD CONSTRAINT "_SYSTEM"."_C7302" PRIMARY KEY("CKLANTKAARTEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TKLANTKAARTEN" ADD CONSTRAINT "_SYSTEM"."_C7307" UNIQUE("CINTERNEFIRMAS_FK","CNUMMER") INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TKLANTKAARTLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C7308" PRIMARY KEY("CKLANTKAARTLIJNEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TLICENTIEIPAD" ADD CONSTRAINT "_SYSTEM"."_C7311" PRIMARY KEY("CLICENTIEIPAD_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TLICENTIEIPADS" ADD CONSTRAINT "_SYSTEM"."_C7312" PRIMARY KEY("CLICENTIEIPADS_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TEMAILTEKSTEN" ADD CONSTRAINT "_SYSTEM"."_C7317" PRIMARY KEY("CEMAILTEKSTEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TMEDEWERKERINFIRMA" ADD CONSTRAINT "_SYSTEM"."_C7321" PRIMARY KEY("CMEDEWERKERINFIRMA_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TLIBRARIES" ADD CONSTRAINT "_SYSTEM"."_C7324" PRIMARY KEY("CLIBRARIES_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TVOLUMEMAPPING" ADD CONSTRAINT "_SYSTEM"."_C7325" PRIMARY KEY("CVOLUMEMAPPING_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TBOEKINGBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C7327" PRIMARY KEY("CBOEKINGBIJLAGEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TDOMMANDATEN" ADD CONSTRAINT "_SYSTEM"."_C7333" PRIMARY KEY("CDOMMANDATEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TMAILINGCODES" ADD CONSTRAINT "_SYSTEM"."_C7338" PRIMARY KEY("CMAILINGCODES_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TMAILINGCODES" ADD CONSTRAINT "_SYSTEM"."_C7339" UNIQUE("CINTERNEFIRMAS_FK","CMAILINGCODE") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCONTACTPERSOONMAILINGCODES" ADD CONSTRAINT "_SYSTEM"."_C7342" PRIMARY KEY("CCONTACTPERSOONMAILINGCODES_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCONTACTPERSOONMAILINGCODES" ADD CONSTRAINT "_SYSTEM"."_C7347" UNIQUE("CINTERNEFIRMAS_FK","CMAILINGCODES_FK","CCONTACTEN_FK","CCONTACTPERSONEN_FK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TFACTVERSTUURD" ADD CONSTRAINT "_SYSTEM"."_C7349" PRIMARY KEY("CFACTVERSTUURD_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TARTIKELKLEURMAAT" ADD CONSTRAINT "_SYSTEM"."_C7352" PRIMARY KEY("CARTIKELKLEURMAAT_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TARTIKELKLEURMAAT" ADD CONSTRAINT "_SYSTEM"."_C7354" UNIQUE("CARTIKELS_FK","CKLEUR","CMAAT") INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TARTIKELKLEURMAATPRIJZEN" ADD CONSTRAINT "_SYSTEM"."_C7356" PRIMARY KEY("CARTIKELKLEURMAATPRIJZEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TARTIKELKLEURMAATPRIJZEN" ADD CONSTRAINT "_SYSTEM"."_C7359" UNIQUE("CARTIKELS_FK","CKLEUR","CMAAT","CARTIKELPRIJZEN_FK") INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TARTIKELKLEURMAATLEVERANCIERS" ADD CONSTRAINT "_SYSTEM"."_C7361" PRIMARY KEY("CARTIKELKLEURMAATLEVERANCIERS_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TARTIKELKLEURMAATLEVERANCIERS" ADD CONSTRAINT "_SYSTEM"."_C7364" UNIQUE("CARTIKELS_FK","CKLEUR","CMAAT","CARTIKELLEVERANCIERS_FK") INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TVERKOOPVERSTUURD" ADD CONSTRAINT "_SYSTEM"."_C7366" PRIMARY KEY("CVERKOOPVERSTUURD_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TVERKOOPSTATUSSEN" ADD CONSTRAINT "_SYSTEM"."_C7370" PRIMARY KEY("CVERKOOPSTATUSSEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TVERKOOPSTATUSSEN" ADD CONSTRAINT "_SYSTEM"."_C7371" UNIQUE("CINTERNEFIRMAS_FK","CDOCUMENTTYPES_FK","CVERKOOPSTATUS") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TAANKOOPLIJNAFMETINGEN" ADD CONSTRAINT "_SYSTEM"."_C7374" PRIMARY KEY("CAANKOOPLIJNAFMETINGEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TPROJECTGROEPEN" ADD CONSTRAINT "_SYSTEM"."_C7379" PRIMARY KEY("CPROJECTGROEPEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TPROJECTGROEPEN" ADD CONSTRAINT "_SYSTEM"."_C7380" UNIQUE("CPROJECTGROEP") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TPROJECTGROEPENPROJECT" ADD CONSTRAINT "_SYSTEM"."_C7383" PRIMARY KEY("CPROJECTGROEPENPROJECT_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TMEDEWERKEROFFICE365" ADD CONSTRAINT "_SYSTEM"."_C8716" PRIMARY KEY("CMEDEWERKEROFFICE365_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TPRESTATIESOORTGROEPEN" ADD CONSTRAINT "_SYSTEM"."_C8721" PRIMARY KEY("CPRESTATIESOORTGROEPEN_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TPRESTATIESOORTGROEPEN" ADD CONSTRAINT "_SYSTEM"."_C8723" UNIQUE("CINTERNEFIRMAS_FK","CPRESTATIESOORTGROEP") INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCONTACTARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C10344" PRIMARY KEY("CCONTACTARTIKELS_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCONTACTARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C10345" UNIQUE("CINTERNEFIRMAS_FK","CCONTACTEN_FK","CARTIKELS_FK","CKLEUR","CMAAT") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TARTIKELLEEGGOED" ADD CONSTRAINT "_SYSTEM"."_C10350" PRIMARY KEY("CARTIKELLEEGGOED_PK") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TEDIMSG" ADD CONSTRAINT "_SYSTEM"."_C11692" PRIMARY KEY("CEDIMSG_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TEDITEMPLATES" ADD CONSTRAINT "_SYSTEM"."_C11693" PRIMARY KEY("CEDITEMPLATES_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TCONTACTROLEDI" ADD CONSTRAINT "_SYSTEM"."_C11695" PRIMARY KEY("CCONTACTROLEDI_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TARTIKELKLANT" ADD CONSTRAINT "_SYSTEM"."_C11701" PRIMARY KEY("CARTIKELKLANT_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TARTIKELKLANT" ADD CONSTRAINT "_SYSTEM"."_C11702" UNIQUE("CARTIKELS_FK","CCONTACTEN_FK","CINTERNEFIRMAS_FK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPEPOLTRACKING" ADD CONSTRAINT "_SYSTEM"."_C13045" PRIMARY KEY("CPEPOLTRACKING_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TKAARTMERKIDENTIFIERS" ADD CONSTRAINT "_SYSTEM"."_C12025" PRIMARY KEY("CKAARTMERKIDENTIFIERS_PK") CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TKAARTMERKIDENTIFIERS" ADD CONSTRAINT "_SYSTEM"."_C12026" UNIQUE("CMERKID","CINTERNEFIRMAS_FK") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I266" ON "_SYSTEM"."TCONTACTEN"("CGEMEENTE") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I267" ON "_SYSTEM"."TCONTACTEN"("CZOEKNAAM") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I268" ON "_SYSTEM"."TCONTACTEN"("CNIETACTIEF") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I269" ON "_SYSTEM"."TCONTACTEN"("CSELECTIECODE") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I270" ON "_SYSTEM"."TCONTACTEN"("CBTWNUMMER") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I1430" ON "_SYSTEM"."TCONTACTEN"("CBANKREKENINGNUMMER") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I1432" ON "_SYSTEM"."TCONTACTEN"("CONDERNEMINGSNUMMER") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I271" ON "_SYSTEM"."TCONTACTPERSONEN"("CNAAM") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I272" ON "_SYSTEM"."TCONTACTPERSONEN"("CVOORNAAM") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I273" ON "_SYSTEM"."TCONTACTPERSONEN"("CSELECTIECODE") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I1431" ON "_SYSTEM"."TCONTACTPERSONEN"("CZOEKNAAM") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I274" ON "_SYSTEM"."TPOSTCODES"("CGEMEENTE") CACHE(16,158,100);
CREATE INDEX "_SYSTEM"."_I275" ON "_SYSTEM"."TPOSTCODES"("CPOSTCODE") CACHE(16,158,100);
CREATE INDEX "_SYSTEM"."_I276" ON "_SYSTEM"."TARTIKELS"("CARTIKEL") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I277" ON "_SYSTEM"."TARTIKELS"("COMSCHRIJVING1") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I869" ON "_SYSTEM"."TARTIKELS"("CARTIKELBARCODE") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I278" ON "_SYSTEM"."TARTIKELVOORRAAD"("CINTERNEFIRMAS_FK", "CINTERNEFIRMAVESTIGINGEN_FK", "CARTIKELS_FK") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I279" ON "_SYSTEM"."TVERKOPEN"("CAFGESLOTEN", "CINTERNEFIRMAS_FK", "CINTERNEFIRMAVESTIGINGEN_FK", "CDOCUMENTTYPES_FK") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I280" ON "_SYSTEM"."TVERKOPEN"("CDATUM", "CINTERNEFIRMAS_FK", "CINTERNEFIRMAVESTIGINGEN_FK", "CDOCUMENTTYPES_FK") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I1474" ON "_SYSTEM"."TVERKOPEN"("CELEKTRONISCHVERSTUURD", "CINTERNEFIRMAS_FK", "CINTERNEFIRMAVESTIGINGEN_FK", "CDOCUMENTTYPES_FK") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I281" ON "_SYSTEM"."TVERKOOPBETALINGEN"("CVERWERKT") CACHE(16,158,100);
CREATE INDEX "_SYSTEM"."_I282" ON "_SYSTEM"."TVERKOOPLIJNEN"("CLIJNFLOW_FK") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I283" ON "_SYSTEM"."TVERKOOPLIJNEN"("CLIJNVORIGE_FK") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I284" ON "_SYSTEM"."TVERKOOPLIJNEN"("CLEVERINGSDATUM") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I285" ON "_SYSTEM"."TAANKOPEN"("CAFGESLOTEN", "CINTERNEFIRMAS_FK", "CINTERNEFIRMAVESTIGINGEN_FK", "CDOCUMENTTYPES_FK") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I286" ON "_SYSTEM"."TAANKOPEN"("CDATUM", "CINTERNEFIRMAS_FK", "CINTERNEFIRMAVESTIGINGEN_FK", "CDOCUMENTTYPES_FK") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I1473" ON "_SYSTEM"."TAANKOPEN"("CINTERNEFIRMAS_FK", "CDOCUMENTTYPES_FK", "CCONTACTEN_FK", "CNUMMERLEVERANCIER") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I287" ON "_SYSTEM"."TAANKOOPLIJNEN"("CLEVERINGSDATUM") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I1410" ON "_SYSTEM"."TAANKOOPLIJNEN"("CLIJNFLOW_FK") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I1476" ON "_SYSTEM"."TAANKOOPLIJNEN"("CLIJNVORIGE_FK") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I1402" ON "_SYSTEM"."TAGENDA"("CPLANDATUMVAN", "CPLANDATUMTOT", "CVERWIJDERD") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I288" ON "_SYSTEM"."TAGENDA"("CVERWIJDERD") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I1439" ON "_SYSTEM"."TAGENDA"("CDOCUMENTTYPES_FK", "CDOCUMENT_FK") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I289" ON "_SYSTEM"."TVOORRAADWIJZIGINGEN"("CDATUM", "CINTERNEFIRMAS_FK", "CINTERNEFIRMAVESTIGINGEN_FK") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I1479" ON "_SYSTEM"."TVOORRAADTRANSFERSERIENUMMERS"("CSERIENUMMER") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I1480" ON "_SYSTEM"."TVOORRAADWIJZIGINGSERIENUMMERS"("CSERIENUMMER") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I290" ON "_SYSTEM"."TVOORRAADTRANSFERS"("CDATUM", "CINTERNEFIRMAS_FK", "CINTERNEFIRMAVESTIGINGEN_FK") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I291" ON "_SYSTEM"."TVOORRAADTRANSFERS"("CDATUM", "CINTERNEFIRMAS_FK", "CINTERNEFIRMAVESTIGINGENNAAR_FK") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I292" ON "_SYSTEM"."TPRODUCTIE"("CAFGESLOTEN", "CINTERNEFIRMAS_FK", "CINTERNEFIRMAVESTIGINGEN_FK", "CDOCUMENTTYPES_FK") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I1475" ON "_SYSTEM"."TPRODUCTIE"("CINTERNEFIRMAS_FK", "CINTERNEFIRMAVESTIGINGEN_FK", "CDOCUMENTTYPES_FK", "CNUMMER") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I731" ON "_SYSTEM"."TCRMCOMMUNICATIES"("CDATUMVERSTUURD") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I732" ON "_SYSTEM"."TCRMCOMMUNICATIES"("CDATUM") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I1440" ON "_SYSTEM"."TCRMCOMMUNICATIEBIJLAGEN"("CDOCUMENTTYPES_FK", "CDOCUMENT_FK") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I867" ON "_SYSTEM"."TCRMTAKEN"("CAFGESLOTEN") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I1406" ON "_SYSTEM"."TCRMTAKEN"("CNUMMER") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I1407" ON "_SYSTEM"."TCRMTAKEN"("CISOPDRACHT") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I1408" ON "_SYSTEM"."TCRMTAKEN"("CGEFACTUREERD") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I1409" ON "_SYSTEM"."TCRMTAAKBIJLAGEN"("CDOCUMENTTYPES_FK", "CDOCUMENT_FK") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I293" ON "_SYSTEM"."TPRODUCTIELIJNEN"("CLEVERINGSDATUM") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I294" ON "_SYSTEM"."TBOEKINGEN"("CINTERNEFIRMAS_FK", "CCONTACTEN_FK", "CFACTNRLEV") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I295" ON "_SYSTEM"."TBOEKINGEN"("CINTERNEFIRMAS_FK", "CBOEKPERIODE") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I296" ON "_SYSTEM"."TBOEKINGHISTORIEK"("CALGEMENEREKENING", "CBOEKINGEN_FK") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I297" ON "_SYSTEM"."TBOEKINGHISTORIEK"("CSOORT", "CCONTACTEN_FK", "CAFGEPUNT", "CVOLGNR") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I298" ON "_SYSTEM"."TSERVICE"("CAFGESLOTEN", "CINTERNEFIRMAS_FK", "CINTERNEFIRMAVESTIGINGEN_FK", "CDOCUMENTTYPES_FK") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I299" ON "_SYSTEM"."TSERVICE"("CDATUM", "CINTERNEFIRMAS_FK", "CINTERNEFIRMAVESTIGINGEN_FK", "CDOCUMENTTYPES_FK") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I1490" ON "_SYSTEM"."TSERVICE"("CSERIENUMMER") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I300" ON "_SYSTEM"."TSERVICEBETALINGEN"("CVERWERKT") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I301" ON "_SYSTEM"."TSERVICELIJNEN"("CLIJNFLOW_FK") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I302" ON "_SYSTEM"."TSERVICELIJNEN"("CLIJNVORIGE_FK") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I303" ON "_SYSTEM"."TSERVICELIJNEN"("CLEVERINGSDATUM") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I1489" ON "_SYSTEM"."TSERVICELIJNSERIENUMMERS"("CSERIENUMMER") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I304" ON "_SYSTEM"."TKASSAUITGAVEN"("CVERWERKT") CACHE(2000,20000,100);
CREATE INDEX "_SYSTEM"."_I305" ON "_SYSTEM"."TKASSAUITGAVEN"("CINTERNEFIRMAS_FK", "CINTERNEFIRMAVESTIGINGEN_FK", "CKASSANUMMER", "CDATUM") CACHE(2000,20000,100);
CREATE INDEX "_SYSTEM"."_I1483" ON "_SYSTEM"."TARTIKELVOORRAADAANTALLEN"("CSERIENUMMER") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I1478" ON "_SYSTEM"."TVERKOOPLIJNAANTALLEN"("CSERIENUMMER") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I1477" ON "_SYSTEM"."TAANKOOPLIJNAANTALLEN"("CSERIENUMMER") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I1481" ON "_SYSTEM"."TPRODUCTIEAANTALLEN"("CSERIENUMMER") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I1482" ON "_SYSTEM"."TPRODUCTIELIJNAANTALLEN"("CSERIENUMMER") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I306" ON "_SYSTEM"."TPRESTATIES"("CINTERNEFIRMAS_FK", "CDATUM", "CMEDEWERKERS_FK") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I307" ON "_SYSTEM"."TPRESTATIES"("CINTERNEFIRMAS_FK", "CDOCUMENTTYPES_FK", "CDOCUMENT_FK") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I308" ON "_SYSTEM"."TPRESTATIES"("CGESTART", "CINTERNEFIRMAS_FK", "CMEDEWERKERS_FK") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I1416" ON "_SYSTEM"."TPRESTATIES"("CGEVERIFIEERD") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I1417" ON "_SYSTEM"."TPRESTATIES"("CGEFACTUREERD") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I1418" ON "_SYSTEM"."TPRESTATIES"("CINREGIE") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I1491" ON "_SYSTEM"."TSERVICEARTIKELS"("CSERIENUMMER") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I309" ON "_SYSTEM"."TPROJECTEN"("CAFGESLOTEN") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I310" ON "_SYSTEM"."TPROJECTVC"("CAFGESLOTEN") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I311" ON "_SYSTEM"."TPROJECTOFFERTES"("CAFGESLOTEN") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I721" ON "_SYSTEM"."TNACECODES"("COMSCHRIJVING1") CACHE(2000,20000,100);
CREATE INDEX "_SYSTEM"."_I868" ON "_SYSTEM"."TCRMSUPPORTCALLS"("CAFGESLOTEN") CACHE(500,500,100);
CREATE INDEX "_SYSTEM"."_I776" ON "_SYSTEM"."TCRMSUPPORTCALLLIJNEN"("CDATUMVERSTUURD") CACHE(2000,20000,100);
CREATE INDEX "_SYSTEM"."_I846" ON "_SYSTEM"."TCRMOPLEIDINGEN"("CAFGESLOTEN") CACHE(2000,20000,100);
CREATE INDEX "_SYSTEM"."_I863" ON "_SYSTEM"."TCRMVERKOOPKANSEN"("CAFGESLOTEN") CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCONTACTEN" ADD INDEX "FTI_TCONTACTEN_CZOEKNAAM"('-stop, -body') ON
 "CZOEKNAAM" TYPE 'text', "CNAAM1" TYPE 'text', "CNAAM2" TYPE 'text', "CPOSTCODE" TYPE 'text'
 COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE"
 CACHE(1280, 1536, 100)
 CHAR CACHE(10000, 20000, 80)
 BLOCK SIZE 4096;
ALTER TABLE "_SYSTEM"."TCONTACTPERSONEN" ADD INDEX "FTI_TCONTACTPERSONEN_CZOEKNAAM"('-stop, -body') ON
 "CZOEKNAAM" TYPE 'text', "CNAAM" TYPE 'text', "CVOORNAAM" TYPE 'text'
 COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE"
 CACHE(1280, 1536, 100)
 CHAR CACHE(10000, 20000, 80)
 BLOCK SIZE 4096;
ALTER TABLE "_SYSTEM"."TARTIKELS" ADD INDEX "FTI_TARTIKELS_COMSCHRIJVING"('-body') ON
 "COMSCHRIJVING1" TYPE 'text', "COMSCHRIJVING2" TYPE 'text', "COMSCHRIJVING3" TYPE 'text', "COMSCHRIJVING4" TYPE 'text'
 COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE"
 STOP WORDS IN (
    'a', 'an', 'and', 'are', 'as', 'at', 'be', 'but', 'by', 'etc', 'for', 'if', 'in', 'into', 'is', 'it', 'its', 'no', 'not', 'of', 'on', 'or', 's', 'such', 't', 'that', 'the', 'their', 'then', 'there', 'these', 'they', 'this', 'to', 'was', 'were', 'will', 'with'
 )
 CACHE(1280, 1536, 100)
 CHAR CACHE(10000, 20000, 80)
 BLOCK SIZE 4096;
ALTER TABLE "_SYSTEM"."TCRMCOMMUNICATIES" ADD INDEX "FTI_TCRMCOMMUNICATIES_CINFO"('-body') ON
 "CINFO" TYPE 'text'
 COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE"
 STOP WORDS IN (
    'a', 'an', 'and', 'are', 'as', 'at', 'be', 'but', 'by', 'etc', 'for', 'if', 'in', 'into', 'is', 'it', 'its', 'no', 'not', 'of', 'on', 'or', 's', 'such', 't', 'that', 'the', 'their', 'then', 'there', 'these', 'they', 'this', 'to', 'was', 'were', 'will', 'with'
 )
 CACHE(1280, 1536, 100)
 CHAR CACHE(10000, 20000, 80)
 BLOCK SIZE 4096;
ALTER TABLE "_SYSTEM"."TCRMTAKEN" ADD INDEX "FTI_TCRMTAKEN_CINFO"('-body') ON
 "CINFO" TYPE 'text'
 COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE"
 STOP WORDS IN (
    'a', 'an', 'and', 'are', 'as', 'at', 'be', 'but', 'by', 'etc', 'for', 'if', 'in', 'into', 'is', 'it', 'its', 'no', 'not', 'of', 'on', 'or', 's', 'such', 't', 'that', 'the', 'their', 'then', 'there', 'these', 'they', 'this', 'to', 'was', 'were', 'will', 'with'
 )
 CACHE(1280, 1536, 100)
 CHAR CACHE(10000, 20000, 80)
 BLOCK SIZE 4096;
ALTER TABLE "_SYSTEM"."TCRMSUPPORTCALLS" ADD INDEX "FTI_CRMSUPPORTCALLS_INFO"('-body') ON
 "CINFO" TYPE 'text'
 COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE"
 STOP WORDS IN (
    'a', 'an', 'and', 'are', 'as', 'at', 'be', 'but', 'by', 'etc', 'for', 'if', 'in', 'into', 'is', 'it', 'its', 'no', 'not', 'of', 'on', 'or', 's', 'such', 't', 'that', 'the', 'their', 'then', 'there', 'these', 'they', 'this', 'to', 'was', 'were', 'will', 'with'
 )
 CACHE(1280, 1536, 100)
 CHAR CACHE(10000, 20000, 80)
 BLOCK SIZE 4096;
ALTER TABLE "_SYSTEM"."TCRMSUPPORTCALLLIJNEN" ADD INDEX "FTI_CRMSUPPORTCALLLIJNEN_INFO"('-body') ON
 "CINFO" TYPE 'text'
 COLLATE "INFORMATION_SCHEMA"."CASE_INSENSITIVE"
 STOP WORDS IN (
    'a', 'an', 'and', 'are', 'as', 'at', 'be', 'but', 'by', 'etc', 'for', 'if', 'in', 'into', 'is', 'it', 'its', 'no', 'not', 'of', 'on', 'or', 's', 'such', 't', 'that', 'the', 'their', 'then', 'there', 'these', 'they', 'this', 'to', 'was', 'were', 'will', 'with'
 )
 CACHE(1280, 1536, 100)
 CHAR CACHE(10000, 20000, 80)
 BLOCK SIZE 4096;

CREATE TRIGGER "TRI_TCRMCONTACTPRODUCTEN" AFTER INSERT
ON "TCRMCONTACTPRODUCTEN" ORDER 4000
REFERENCING NEW ROW AS MYROW 
FOR EACH ROW 
BEGIN
 INSERT INTO "TCRMCONTACTPRODUCTENHIST"("CCRMCONTACTPRODUCTENHIST_PK","CINTERNEFIRMA","CINTERNEFIRMAS_FK","CCONTACTEN_FK","CDATUM","CCRMPRODUCTFAMILIE","CCRMPRODUCT","COMSCHRIJVING","CAANTAL","CBEDRAG","CINFO") VALUES(SELECT UNIQUE FROM "TCRMCONTACTPRODUCTENHIST","MYROW"."CINTERNEFIRMA","MYROW"."CINTERNEFIRMAS_FK","MYROW"."CCONTACTEN_FK","MYROW"."CDATUM","MYROW"."CCRMPRODUCTFAMILIE","MYROW"."CCRMPRODUCT","MYROW"."COMSCHRIJVING","MYROW"."CAANTAL","MYROW"."CBEDRAG","MYROW"."CINFO");
END; 

CREATE TRIGGER "TRD_TCRMCONTACTPRODUCTEN" AFTER DELETE
ON "TCRMCONTACTPRODUCTEN" ORDER 5000
REFERENCING OLD ROW AS MYROW 
FOR EACH ROW 
BEGIN
 INSERT INTO "TCRMCONTACTPRODUCTENHIST"("CCRMCONTACTPRODUCTENHIST_PK","CWIJZIGGEBRUIKER","CINTERNEFIRMA","CINTERNEFIRMAS_FK","CCONTACTEN_FK","CDATUM","CCRMPRODUCTFAMILIE","CCRMPRODUCT","COMSCHRIJVING","CAANTAL","CBEDRAG","CINFO") VALUES(SELECT UNIQUE FROM "TCRMCONTACTPRODUCTENHIST",'DELETE',"MYROW"."CINTERNEFIRMA","MYROW"."CINTERNEFIRMAS_FK","MYROW"."CCONTACTEN_FK","MYROW"."CDATUM","MYROW"."CCRMPRODUCTFAMILIE","MYROW"."CCRMPRODUCT","MYROW"."COMSCHRIJVING","MYROW"."CAANTAL","MYROW"."CBEDRAG","MYROW"."CINFO");
END; 

CREATE TRIGGER "TRI_VERKOOPLIJNEN" AFTER INSERT
ON "TVERKOOPLIJNEN" ORDER 6000
REFERENCING NEW ROW AS MYROW 
FOR EACH ROW 
BEGIN
 IF "MYROW"."CARTIKELS_FK">0 THEN CALL "PRO_VERKOOPLIJNEN"("MYROW"."CVERKOPEN_FK", "MYROW"."CARTIKELS_FK", "MYROW"."CKLEUR", "MYROW"."CMAAT", "MYROW"."CAANTALVOORRAAD"); END IF; DROP VARIABLES;
END; 


CREATE TRIGGER "TRI_AANKOOPLIJNEN" AFTER INSERT
ON "TAANKOOPLIJNEN" ORDER 7000
REFERENCING NEW ROW AS MYROW 
FOR EACH ROW 
BEGIN
 IF "MYROW"."CARTIKELS_FK">0 THEN CALL "PRO_AANKOOPLIJNEN"("MYROW"."CAANKOPEN_FK", "MYROW"."CARTIKELS_FK", "MYROW"."CKLEUR", "MYROW"."CMAAT", "MYROW"."CAANTALVOORRAAD"); END IF; DROP VARIABLES;
END; 

CREATE TRIGGER "TRD_VERKOOPLIJNEN" BEFORE DELETE
ON "TVERKOOPLIJNEN" ORDER 8000
REFERENCING OLD ROW AS MYROW 
FOR EACH ROW 
BEGIN
 IF "MYROW"."CARTIKELS_FK">0 THEN CALL "PRO_VERKOOPLIJNEN"("MYROW"."CVERKOPEN_FK", "MYROW"."CARTIKELS_FK", "MYROW"."CKLEUR", "MYROW"."CMAAT", "MYROW"."CAANTALVOORRAAD"*-1); END IF; DROP VARIABLES;
END; 

CREATE TRIGGER "TRD_AANKOOPLIJNEN" BEFORE DELETE
ON "TAANKOOPLIJNEN" ORDER 9000
REFERENCING OLD ROW AS MYROW 
FOR EACH ROW 
BEGIN
 IF "MYROW"."CARTIKELS_FK">0 THEN CALL "PRO_AANKOOPLIJNEN"("MYROW"."CAANKOPEN_FK", "MYROW"."CARTIKELS_FK", "MYROW"."CKLEUR", "MYROW"."CMAAT", "MYROW"."CAANTALVOORRAAD"*-1); END IF; DROP VARIABLES;
END; 
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
GRANT EXECUTE ON PROCEDURE "_SYSTEM"."SETSTATUSAANKOOP"(INTEGER) TO PUBLIC;
GRANT EXECUTE ON PROCEDURE "_SYSTEM"."UPDATECENTRALISATIE"(INTEGER, BOOLEAN, BOOLEAN) TO PUBLIC;
GRANT EXECUTE ON PROCEDURE "_SYSTEM"."SETSTATUSVERKOOP"(INTEGER) TO PUBLIC;
GRANT EXECUTE ON FUNCTION "_SYSTEM"."TABLES_FUNCTION_NEEDED_BY_FBODBC"(CHARACTER VARYING(16)) TO PUBLIC;
GRANT EXECUTE ON PROCEDURE "_SYSTEM"."REBUILDCONTACTSALDI"(INTEGER, INTEGER, CHARACTER VARYING(1)) TO PUBLIC;
GRANT EXECUTE ON PROCEDURE "_SYSTEM"."AFSLBOEKJAAR0"(INTEGER, INTEGER, INTEGER, INTEGER, INTEGER, DATE) TO PUBLIC;
GRANT EXECUTE ON PROCEDURE "_SYSTEM"."AFSLBOEKJAAR1"(INTEGER, INTEGER, INTEGER, INTEGER, INTEGER, DATE) TO PUBLIC;
GRANT EXECUTE ON PROCEDURE "_SYSTEM"."SETSTATUSSERVICE"(INTEGER) TO PUBLIC;
GRANT EXECUTE ON PROCEDURE "_SYSTEM"."AANTALINBESTELLINGKLANT"(INTEGER, CHARACTER VARYING(10), CHARACTER VARYING(10), FLOAT, INTEGER, CHARACTER VARYING(10), INTEGER, CHARACTER VARYING(10)) TO PUBLIC;
GRANT EXECUTE ON PROCEDURE "_SYSTEM"."PRO_VERKOOPLIJNEN"(INTEGER, INTEGER, CHARACTER VARYING(10), CHARACTER VARYING(10), FLOAT) TO PUBLIC;
GRANT EXECUTE ON PROCEDURE "_SYSTEM"."AANTALINBESTELLINGLEVERANCIER"(INTEGER, CHARACTER VARYING(10), CHARACTER VARYING(10), FLOAT, INTEGER, CHARACTER VARYING(10), INTEGER, CHARACTER VARYING(10)) TO PUBLIC;
GRANT EXECUTE ON PROCEDURE "_SYSTEM"."AANTALINCONSIGNATIEKLANT"(INTEGER, CHARACTER VARYING(10), CHARACTER VARYING(10), FLOAT, INTEGER, CHARACTER VARYING(10), INTEGER, CHARACTER VARYING(10)) TO PUBLIC;
GRANT EXECUTE ON PROCEDURE "_SYSTEM"."AANTALINCONSIGNATIELEVERANCIER"(INTEGER, CHARACTER VARYING(10), CHARACTER VARYING(10), FLOAT, INTEGER, CHARACTER VARYING(10), INTEGER, CHARACTER VARYING(10)) TO PUBLIC;
GRANT EXECUTE ON PROCEDURE "_SYSTEM"."AANTALINRESERVATIE"(INTEGER, CHARACTER VARYING(10), CHARACTER VARYING(10), FLOAT, INTEGER, CHARACTER VARYING(10), INTEGER, CHARACTER VARYING(10)) TO PUBLIC;
GRANT EXECUTE ON PROCEDURE "_SYSTEM"."AANTALVOORPRODUCTIE"(INTEGER, CHARACTER VARYING(10), CHARACTER VARYING(10), FLOAT, INTEGER, CHARACTER VARYING(10), INTEGER, CHARACTER VARYING(10)) TO PUBLIC;
GRANT EXECUTE ON PROCEDURE "_SYSTEM"."AANTALINPRODUCTIE"(INTEGER, CHARACTER VARYING(10), CHARACTER VARYING(10), FLOAT, INTEGER, CHARACTER VARYING(10), INTEGER, CHARACTER VARYING(10)) TO PUBLIC;
GRANT EXECUTE ON PROCEDURE "_SYSTEM"."PRO_ARTIKELVOORRAAD"(INTEGER, CHARACTER VARYING(10), CHARACTER VARYING(10), FLOAT, FLOAT, FLOAT, INTEGER, CHARACTER VARYING(10), INTEGER, CHARACTER VARYING(10), CHARACTER VARYING(10)) TO PUBLIC;
GRANT EXECUTE ON PROCEDURE "_SYSTEM"."PRO_AANKOOPLIJNEN"(INTEGER, INTEGER, CHARACTER VARYING(10), CHARACTER VARYING(10), FLOAT) TO PUBLIC;
GRANT EXECUTE ON PROCEDURE "_SYSTEM"."SETLIJNNUMMERVERKOOP"(INTEGER) TO PUBLIC;
GRANT EXECUTE ON PROCEDURE "_SYSTEM"."SETLIJNNUMMERAANKOOP"(INTEGER) TO PUBLIC;
GRANT EXECUTE ON PROCEDURE "_SYSTEM"."RECALCPROJECT"(INTEGER, BOOLEAN) TO PUBLIC;
GRANT EXECUTE ON PROCEDURE "_SYSTEM"."COPYARTIKEL"(INTEGER, CHARACTER VARYING(25), CHARACTER VARYING(256), BOOLEAN, BOOLEAN, BOOLEAN, BOOLEAN, BOOLEAN, BOOLEAN, BOOLEAN, BOOLEAN, INTEGER) TO PUBLIC;
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
ALTER TABLE "_SYSTEM"."TALGEMENEREKENINGEN" ADD CONSTRAINT "_SYSTEM"."_C266" CHECK("CALGEMENEREKENINGEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TALGEMENEREKENINGEN" ADD CONSTRAINT "_SYSTEM"."_C267" CHECK("CINTERNEFIRMAALGEMENEREKENINGEN" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TALGEMENEREKENINGEN" ADD CONSTRAINT "_SYSTEM"."_C268" CHECK("CALGEMENEREKENING" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TALGEMENEREKENINGEN" ADD CONSTRAINT "_SYSTEM"."_C269" CHECK("CNIETACTIEF" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TALGEMENEREKENINGEN" ADD CONSTRAINT "_SYSTEM"."_C270" CHECK("CANALYTISCHOPVOLGEN" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TBETALINGSVOORWAARDEN" ADD CONSTRAINT "_SYSTEM"."_C271" CHECK("CBETALINGSVOORWAARDEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBETALINGSVOORWAARDEN" ADD CONSTRAINT "_SYSTEM"."_C272" CHECK("CBETALINGSVOORWAARDE" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TBTWREGIMES" ADD CONSTRAINT "_SYSTEM"."_C273" CHECK("CBTWREGIMES_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWREGIMES" ADD CONSTRAINT "_SYSTEM"."_C274" CHECK("CBTWREGIME" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TCOLINFO" ADD CONSTRAINT "_SYSTEM"."_C275" CHECK("CCOLINFO_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCOLINFO" ADD CONSTRAINT "_SYSTEM"."_C276" CHECK("CKOLOM" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TCONTACTEN" ADD CONSTRAINT "_SYSTEM"."_C277" CHECK("CCONTACTEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCONTACTEN" ADD CONSTRAINT "_SYSTEM"."_C278" CHECK("CINTERNEFIRMACONTACTEN" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCONTACTEN" ADD CONSTRAINT "_SYSTEM"."_C279" CHECK("CCONTACT" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCONTACTEN" ADD CONSTRAINT "_SYSTEM"."_C280" CHECK("CNAAM1" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCONTACTEN" ADD CONSTRAINT "_SYSTEM"."_C281" CHECK("CNIETACTIEF" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCONTACTEN" ADD CONSTRAINT "_SYSTEM"."_C282" CHECK("CLAND" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCONTACTEN" ADD CONSTRAINT "_SYSTEM"."_C283" FOREIGN KEY("CMEDEWERKERS_FK") REFERENCES "_SYSTEM"."TMEDEWERKERS"("CMEDEWERKERS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TCONTACTEN" ADD CONSTRAINT "_SYSTEM"."_C284" FOREIGN KEY("CHOOFDCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TCONTACTEN" ADD CONSTRAINT "_SYSTEM"."_C3745" FOREIGN KEY("COORSPRONGCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TCONTACTEN" ADD CONSTRAINT "_SYSTEM"."_C3746" FOREIGN KEY("CNACECODES_FK") REFERENCES "_SYSTEM"."TNACECODES"("CNACECODES_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TCONTACTEN" ADD CONSTRAINT "_SYSTEM"."_C7296" FOREIGN KEY("CMEDEWERKERSINTERN_FK") REFERENCES "_SYSTEM"."TMEDEWERKERS"("CMEDEWERKERS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCONTACTGROEPEN" ADD CONSTRAINT "_SYSTEM"."_C285" CHECK("CCONTACTGROEPEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCONTACTGROEPEN" ADD CONSTRAINT "_SYSTEM"."_C286" CHECK("CCONTACTGROEP" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TCONTACTGROEPENCONTACT" ADD CONSTRAINT "_SYSTEM"."_C287" CHECK("CCONTACTGROEPENCONTACT_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCONTACTGROEPENCONTACT" ADD CONSTRAINT "_SYSTEM"."_C288" CHECK("CCONTACTEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCONTACTGROEPENCONTACT" ADD CONSTRAINT "_SYSTEM"."_C289" CHECK("CCONTACTGROEPEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCONTACTGROEPENCONTACT" ADD CONSTRAINT "_SYSTEM"."_C290" FOREIGN KEY("CCONTACTGROEPEN_FK") REFERENCES "_SYSTEM"."TCONTACTGROEPEN"("CCONTACTGROEPEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TCONTACTGROEPENCONTACT" ADD CONSTRAINT "_SYSTEM"."_C291" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCONTACTPERSONEN" ADD CONSTRAINT "_SYSTEM"."_C292" CHECK("CCONTACTPERSONEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCONTACTPERSONEN" ADD CONSTRAINT "_SYSTEM"."_C293" CHECK("CNAAM" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCONTACTPERSONEN" ADD CONSTRAINT "_SYSTEM"."_C294" CHECK("CCONTACTEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCONTACTPERSONEN" ADD CONSTRAINT "_SYSTEM"."_C295" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCONTACTROLLEN" ADD CONSTRAINT "_SYSTEM"."_C296" CHECK("CCONTACTROLLEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCONTACTROLLEN" ADD CONSTRAINT "_SYSTEM"."_C297" CHECK("CCONTACTROL" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCONTACTROLLEN" ADD CONSTRAINT "_SYSTEM"."_C298" CHECK("CCONTACTEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCONTACTROLLEN" ADD CONSTRAINT "_SYSTEM"."_C299" CHECK("CGEBLOKKEERD" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCONTACTROLLEN" ADD CONSTRAINT "_SYSTEM"."_C300" CHECK(("CCONTACTROL")=ANY (VALUES 'D', 'C'));
ALTER TABLE "_SYSTEM"."TCONTACTROLLEN" ADD CONSTRAINT "_SYSTEM"."_C301" FOREIGN KEY("CDEBTRANSPORTEURS_FK") REFERENCES "_SYSTEM"."TTRANSPORTEURS"("CTRANSPORTEURS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TCONTACTROLLEN" ADD CONSTRAINT "_SYSTEM"."_C302" FOREIGN KEY("CROLGROEPEN_FK") REFERENCES "_SYSTEM"."TROLGROEPEN"("CROLGROEPEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TCONTACTROLLEN" ADD CONSTRAINT "_SYSTEM"."_C303" FOREIGN KEY("CMUNTEN_FK") REFERENCES "_SYSTEM"."TMUNTEN"("CMUNTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TCONTACTROLLEN" ADD CONSTRAINT "_SYSTEM"."_C304" FOREIGN KEY("CLEVERINGSVOORWAARDEN_FK") REFERENCES "_SYSTEM"."TLEVERINGSVOORWAARDEN"("CLEVERINGSVOORWAARDEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TCONTACTROLLEN" ADD CONSTRAINT "_SYSTEM"."_C305" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TCONTACTROLLEN" ADD CONSTRAINT "_SYSTEM"."_C306" FOREIGN KEY("CDEBBTWREGIMES_FK") REFERENCES "_SYSTEM"."TBTWREGIMES"("CBTWREGIMES_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TCONTACTROLLEN" ADD CONSTRAINT "_SYSTEM"."_C307" FOREIGN KEY("CBETALINGSVOORWAARDEN_FK") REFERENCES "_SYSTEM"."TBETALINGSVOORWAARDEN"("CBETALINGSVOORWAARDEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TCONTACTROLLEN" ADD CONSTRAINT "_SYSTEM"."_C308" FOREIGN KEY("CCOLLECTIEVEREKENINGEN_FK") REFERENCES "_SYSTEM"."TALGEMENEREKENINGEN"("CALGEMENEREKENINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TCONTACTROLLEN" ADD CONSTRAINT "_SYSTEM"."_C309" FOREIGN KEY("CALGEMENEREKENINGEN_FK") REFERENCES "_SYSTEM"."TALGEMENEREKENINGEN"("CALGEMENEREKENINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TCONTACTROLLEN" ADD CONSTRAINT "_SYSTEM"."_C310" FOREIGN KEY("CTARIEVEN_FK") REFERENCES "_SYSTEM"."TTARIEVEN"("CTARIEVEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCONTACTROLLENBB" ADD CONSTRAINT "_SYSTEM"."_C311" CHECK("CCONTACTROLLENBB_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCONTACTROLLENBB" ADD CONSTRAINT "_SYSTEM"."_C312" CHECK("CCONTACTROLLEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCONTACTROLLENBB" ADD CONSTRAINT "_SYSTEM"."_C313" FOREIGN KEY("CCONTACTROLLEN_FK") REFERENCES "_SYSTEM"."TCONTACTROLLEN"("CCONTACTROLLEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TINTERNEFIRMAMEDEWERKERS" ADD CONSTRAINT "_SYSTEM"."_C314" CHECK("CINTERNEFIRMAMEDEWERKERS_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TINTERNEFIRMAMEDEWERKERS" ADD CONSTRAINT "_SYSTEM"."_C315" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TINTERNEFIRMAMEDEWERKERS" ADD CONSTRAINT "_SYSTEM"."_C316" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TINTERNEFIRMAMEDEWERKERS" ADD CONSTRAINT "_SYSTEM"."_C317" CHECK("CMEDEWERKER" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TINTERNEFIRMAMEDEWERKERS" ADD CONSTRAINT "_SYSTEM"."_C318" CHECK("CMEDEWERKERS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TINTERNEFIRMAMEDEWERKERS" ADD CONSTRAINT "_SYSTEM"."_C319" CHECK("CMEDEWERKERGROEP" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TINTERNEFIRMAMEDEWERKERS" ADD CONSTRAINT "_SYSTEM"."_C320" CHECK("CMEDEWERKERGROEPEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TINTERNEFIRMAMEDEWERKERS" ADD CONSTRAINT "_SYSTEM"."_C321" CHECK("CINTERNEFIRMAVESTIGING" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TINTERNEFIRMAMEDEWERKERS" ADD CONSTRAINT "_SYSTEM"."_C322" CHECK("CINTERNEFIRMAVESTIGINGEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TINTERNEFIRMAMEDEWERKERS" ADD CONSTRAINT "_SYSTEM"."_C323" FOREIGN KEY("CMEDEWERKERS_FK") REFERENCES "_SYSTEM"."TMEDEWERKERS"("CMEDEWERKERS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TINTERNEFIRMAMEDEWERKERS" ADD CONSTRAINT "_SYSTEM"."_C324" FOREIGN KEY("CMEDEWERKERGROEPEN_FK") REFERENCES "_SYSTEM"."TMEDEWERKERGROEPEN"("CMEDEWERKERGROEPEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TINTERNEFIRMAMEDEWERKERS" ADD CONSTRAINT "_SYSTEM"."_C325" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TINTERNEFIRMAMEDEWERKERS" ADD CONSTRAINT "_SYSTEM"."_C326" FOREIGN KEY("CINTERNEFIRMAVESTIGINGEN_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN"("CINTERNEFIRMAVESTIGINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TINTERNEFIRMAS" ADD CONSTRAINT "_SYSTEM"."_C327" CHECK("CINTERNEFIRMAS_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TINTERNEFIRMAS" ADD CONSTRAINT "_SYSTEM"."_C328" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TINTERNEFIRMAS" ADD CONSTRAINT "_SYSTEM"."_C329" CHECK("CNAAM1" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TINTERNEFIRMAS" ADD CONSTRAINT "_SYSTEM"."_C330" CHECK("CINTERNEFIRMAALGEMENEREKENINGEN" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TINTERNEFIRMAS" ADD CONSTRAINT "_SYSTEM"."_C331" CHECK("CINTERNEFIRMACONTACTEN" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TLANDEN" ADD CONSTRAINT "_SYSTEM"."_C332" CHECK("CLANDEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TLANDEN" ADD CONSTRAINT "_SYSTEM"."_C333" CHECK("CLAND" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TLANDEN" ADD CONSTRAINT "_SYSTEM"."_C334" CHECK("CLANDBTW" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TDOCUMENTSTATUSSEN" ADD CONSTRAINT "_SYSTEM"."_C335" CHECK("CDOCUMENTSTATUSSEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TDOCUMENTSTATUSSEN" ADD CONSTRAINT "_SYSTEM"."_C336" CHECK("CDOCUMENTTYPE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TDOCUMENTSTATUSSEN" ADD CONSTRAINT "_SYSTEM"."_C337" CHECK("CDOCUMENTTYPES_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TDOCUMENTSTATUSSEN" ADD CONSTRAINT "_SYSTEM"."_C338" CHECK("COMSCHRIJVING1" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TDOCUMENTSTATUSSEN" ADD CONSTRAINT "_SYSTEM"."_C339" CHECK("CSTATUS" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TDOCUMENTSTATUSSEN" ADD CONSTRAINT "_SYSTEM"."_C340" FOREIGN KEY("CDOCUMENTTYPES_FK") REFERENCES "_SYSTEM"."TDOCUMENTTYPES"("CDOCUMENTTYPES_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(16,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TLEVERINGSVOORWAARDEN" ADD CONSTRAINT "_SYSTEM"."_C341" CHECK("CLEVERINGSVOORWAARDEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TLEVERINGSVOORWAARDEN" ADD CONSTRAINT "_SYSTEM"."_C342" CHECK("CLEVERINGSVOORWAARDE" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TMEDEWERKERGROEPEN" ADD CONSTRAINT "_SYSTEM"."_C343" CHECK("CMEDEWERKERGROEPEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TMEDEWERKERGROEPEN" ADD CONSTRAINT "_SYSTEM"."_C344" CHECK("CMEDEWERKERGROEP" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TMEDEWERKERS" ADD CONSTRAINT "_SYSTEM"."_C345" CHECK("CMEDEWERKERS_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TMEDEWERKERS" ADD CONSTRAINT "_SYSTEM"."_C346" CHECK("CMEDEWERKER" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TMEDEWERKERS" ADD CONSTRAINT "_SYSTEM"."_C347" CHECK("CNAAM" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TMEDEWERKERS" ADD CONSTRAINT "_SYSTEM"."_C348" CHECK("CAUTOWIJZIG" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TMEDEWERKERS" ADD CONSTRAINT "_SYSTEM"."_C349" CHECK("CAUTOSELECTIE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TMEDEWERKERS" ADD CONSTRAINT "_SYSTEM"."_C350" CHECK("CREPINGAVE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TMEDEWERKERS" ADD CONSTRAINT "_SYSTEM"."_C351" CHECK("CGEBRUIKER" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TMUNTEN" ADD CONSTRAINT "_SYSTEM"."_C352" CHECK("CMUNTEN_PK" IS NOT NULL) INITIALLY DEFERRED DEFERRABLE;
ALTER TABLE "_SYSTEM"."TMUNTEN" ADD CONSTRAINT "_SYSTEM"."_C353" CHECK("CMUNT" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TMUNTEN" ADD CONSTRAINT "_SYSTEM"."_C354" CHECK("COMSCHRIJVING" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TNOACCESS" ADD CONSTRAINT "_SYSTEM"."_C355" CHECK("CNOACCESS_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TNOACCESS" ADD CONSTRAINT "_SYSTEM"."_C356" CHECK("CMEDEWERKERGROEP" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TNOACCESS" ADD CONSTRAINT "_SYSTEM"."_C357" CHECK("CMEDEWERKERGROEPEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TNOACCESS" ADD CONSTRAINT "_SYSTEM"."_C358" CHECK("COBJECT" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TNOACCESS" ADD CONSTRAINT "_SYSTEM"."_C359" FOREIGN KEY("CMEDEWERKERGROEPEN_FK") REFERENCES "_SYSTEM"."TMEDEWERKERGROEPEN"("CMEDEWERKERGROEPEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(16,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TPOSTCODES" ADD CONSTRAINT "_SYSTEM"."_C360" CHECK("CPOSTCODES_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TPOSTCODES" ADD CONSTRAINT "_SYSTEM"."_C361" CHECK("CPOSTCODE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TPOSTCODES" ADD CONSTRAINT "_SYSTEM"."_C362" CHECK("CGEMEENTE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TPOSTCODES" ADD CONSTRAINT "_SYSTEM"."_C363" CHECK("CLAND" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TROLGROEPEN" ADD CONSTRAINT "_SYSTEM"."_C364" CHECK("CROLGROEPEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TROLGROEPEN" ADD CONSTRAINT "_SYSTEM"."_C365" CHECK("CROLGROEP" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TROLGROEPEN" ADD CONSTRAINT "_SYSTEM"."_C366" CHECK("COMSCHRIJVING" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TTALEN" ADD CONSTRAINT "_SYSTEM"."_C367" CHECK("CTALEN_PK" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TTRANSPORTEURS" ADD CONSTRAINT "_SYSTEM"."_C368" CHECK("CTRANSPORTEURS_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TTRANSPORTEURS" ADD CONSTRAINT "_SYSTEM"."_C369" CHECK("CTRANSPORTEUR" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TVOORSTELREKENINGEN" ADD CONSTRAINT "_SYSTEM"."_C370" CHECK("CVOORSTELREKENINGEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVOORSTELREKENINGEN" ADD CONSTRAINT "_SYSTEM"."_C371" FOREIGN KEY("CALGEMENEREKENINGEN_FK") REFERENCES "_SYSTEM"."TALGEMENEREKENINGEN"("CALGEMENEREKENINGEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TWINPOSITIES" ADD CONSTRAINT "_SYSTEM"."_C372" CHECK("CWINPOSITIES_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TWINPOSITIES" ADD CONSTRAINT "_SYSTEM"."_C373" CHECK("CHEIGHT" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TWINPOSITIES" ADD CONSTRAINT "_SYSTEM"."_C374" CHECK("CLEFT" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TWINPOSITIES" ADD CONSTRAINT "_SYSTEM"."_C375" CHECK("CMEDEWERKER" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TWINPOSITIES" ADD CONSTRAINT "_SYSTEM"."_C376" CHECK("CMEDEWERKERS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TWINPOSITIES" ADD CONSTRAINT "_SYSTEM"."_C377" CHECK("COBJECT" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TWINPOSITIES" ADD CONSTRAINT "_SYSTEM"."_C378" CHECK("CTOP" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TWINPOSITIES" ADD CONSTRAINT "_SYSTEM"."_C379" CHECK("CWIDTH" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TWINPOSITIES" ADD CONSTRAINT "_SYSTEM"."_C380" FOREIGN KEY("CMEDEWERKERS_FK") REFERENCES "_SYSTEM"."TMEDEWERKERS"("CMEDEWERKERS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TROLLEN" ADD CONSTRAINT "_SYSTEM"."_C381" CHECK("CROLLEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TROLLEN" ADD CONSTRAINT "_SYSTEM"."_C382" CHECK("CROL" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TROLLEN" ADD CONSTRAINT "_SYSTEM"."_C383" CHECK("COMSCHRIJVING1" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TCODELIJSTEN" ADD CONSTRAINT "_SYSTEM"."_C384" CHECK("CCODELIJSTEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCODELIJSTEN" ADD CONSTRAINT "_SYSTEM"."_C385" CHECK("CCODE" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TCOLSELECT" ADD CONSTRAINT "_SYSTEM"."_C386" CHECK("CCOLSELECT_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCOLSELECT" ADD CONSTRAINT "_SYSTEM"."_C387" FOREIGN KEY("CMEDEWERKERS_FK") REFERENCES "_SYSTEM"."TMEDEWERKERS"("CMEDEWERKERS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCATEGORIEN" ADD CONSTRAINT "_SYSTEM"."_C388" CHECK("CCATEGORIEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCATEGORIEN" ADD CONSTRAINT "_SYSTEM"."_C389" CHECK("CCATEGORIE" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TARTIKELKORTINGENLEVERANCIERS" ADD CONSTRAINT "_SYSTEM"."_C390" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELKORTINGENLEVERANCIERS" ADD CONSTRAINT "_SYSTEM"."_C391" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELKORTINGENLEVERANCIERS" ADD CONSTRAINT "_SYSTEM"."_C392" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TARTIKELKORTINGENLEVERANCIERS" ADD CONSTRAINT "_SYSTEM"."_C393" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TARTIKELKORTINGENLEVERANCIERS" ADD CONSTRAINT "_SYSTEM"."_C394" FOREIGN KEY("CMUNTEN_FK") REFERENCES "_SYSTEM"."TMUNTEN"("CMUNTEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TARTIKELKORTINGENLEVERANCIERS" ADD CONSTRAINT "_SYSTEM"."_C395" FOREIGN KEY("CARTIKELS_FK") REFERENCES "_SYSTEM"."TARTIKELS"("CARTIKELS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TSUBCATEGORIEN" ADD CONSTRAINT "_SYSTEM"."_C396" CHECK("CSUBCATEGORIEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSUBCATEGORIEN" ADD CONSTRAINT "_SYSTEM"."_C397" CHECK("CCATEGORIEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSUBCATEGORIEN" ADD CONSTRAINT "_SYSTEM"."_C398" CHECK("CSUBCATEGORIE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSUBCATEGORIEN" ADD CONSTRAINT "_SYSTEM"."_C399" FOREIGN KEY("CCATEGORIEN_FK") REFERENCES "_SYSTEM"."TCATEGORIEN"("CCATEGORIEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TREPORTS" ADD CONSTRAINT "_SYSTEM"."_C400" CHECK("CREPORTS_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TREPORTS" ADD CONSTRAINT "_SYSTEM"."_C401" CHECK("CREPORT" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TREPORTS" ADD CONSTRAINT "_SYSTEM"."_C402" CHECK("CLIBRARY" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TREPORTS" ADD CONSTRAINT "_SYSTEM"."_C403" FOREIGN KEY("CREPTEMPLATES_FK") REFERENCES "_SYSTEM"."TREPTEMPLATES"("CREPTEMPLATES_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TREPTEMPLATES" ADD CONSTRAINT "_SYSTEM"."_C404" CHECK("CREPTEMPLATES_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TREPTEMPLATES" ADD CONSTRAINT "_SYSTEM"."_C405" CHECK("CREPTEMPLATE" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TMODULES" ADD CONSTRAINT "_SYSTEM"."_C406" CHECK("CMODULES_PK" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TINSTELLINGEN" ADD CONSTRAINT "_SYSTEM"."_C407" CHECK("CINSTELLINGEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TINSTELLINGEN" ADD CONSTRAINT "_SYSTEM"."_C408" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TINSTELLINGEN" ADD CONSTRAINT "_SYSTEM"."_C409" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TINSTELLINGEN" ADD CONSTRAINT "_SYSTEM"."_C410" CHECK("CMODULEVOLGNUMMER" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TINSTELLINGEN" ADD CONSTRAINT "_SYSTEM"."_C411" CHECK("CTYPEVOLGNUMMER" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TINSTELLINGEN" ADD CONSTRAINT "_SYSTEM"."_C412" CHECK("CINSTELLING" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TINSTELLINGEN" ADD CONSTRAINT "_SYSTEM"."_C413" CHECK("CINDEX" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TINSTELLINGEN" ADD CONSTRAINT "_SYSTEM"."_C414" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TINSTELLINGEN" ADD CONSTRAINT "_SYSTEM"."_C415" FOREIGN KEY("CINTERNEFIRMAVESTIGINGEN_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN"("CINTERNEFIRMAVESTIGINGEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TDOCUMENTTYPES" ADD CONSTRAINT "_SYSTEM"."_C416" CHECK("CDOCUMENTTYPES_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TDOCUMENTTYPES" ADD CONSTRAINT "_SYSTEM"."_C417" CHECK("COMSCHRIJVING1" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TDOCUMENTTYPES" ADD CONSTRAINT "_SYSTEM"."_C418" CHECK("CDOCUMENTTYPE" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN" ADD CONSTRAINT "_SYSTEM"."_C419" CHECK("CINTERNEFIRMAVESTIGINGEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN" ADD CONSTRAINT "_SYSTEM"."_C420" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN" ADD CONSTRAINT "_SYSTEM"."_C421" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN" ADD CONSTRAINT "_SYSTEM"."_C422" CHECK("CINTERNEFIRMAVESTIGING" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN" ADD CONSTRAINT "_SYSTEM"."_C423" CHECK("CHOOFDVESTIGING" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN" ADD CONSTRAINT "_SYSTEM"."_C424" CHECK("CADRES1" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN" ADD CONSTRAINT "_SYSTEM"."_C425" CHECK("CGEMEENTE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN" ADD CONSTRAINT "_SYSTEM"."_C426" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TRUIMTEN" ADD CONSTRAINT "_SYSTEM"."_C427" CHECK("CRUIMTEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TRUIMTEN" ADD CONSTRAINT "_SYSTEM"."_C428" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TRUIMTEN" ADD CONSTRAINT "_SYSTEM"."_C429" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TRUIMTEN" ADD CONSTRAINT "_SYSTEM"."_C430" CHECK("CRUIMTE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TRUIMTEN" ADD CONSTRAINT "_SYSTEM"."_C431" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TANALYTISCHEREKENINGEN" ADD CONSTRAINT "_SYSTEM"."_C432" CHECK("CANALYTISCHEREKENINGEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TANALYTISCHEREKENINGEN" ADD CONSTRAINT "_SYSTEM"."_C433" CHECK("CINTERNEFIRMAALGEMENEREKENINGEN" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TANALYTISCHEREKENINGEN" ADD CONSTRAINT "_SYSTEM"."_C434" CHECK("CANALYTISCHEREKENING" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TANALYTISCHEREKENINGEN" ADD CONSTRAINT "_SYSTEM"."_C435" CHECK("CNIETACTIEF" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TANALYTISCHEREKENINGEN" ADD CONSTRAINT "_SYSTEM"."_C436" CHECK("COMSCHRIJVING1" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TANALYTISCHEREKENINGEN" ADD CONSTRAINT "_SYSTEM"."_C8709" CHECK("CNIVEAU" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TBTWCODES" ADD CONSTRAINT "_SYSTEM"."_C437" CHECK("CBTWCODES_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWCODES" ADD CONSTRAINT "_SYSTEM"."_C438" CHECK("CBTWCODE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWCODES" ADD CONSTRAINT "_SYSTEM"."_C439" CHECK("CBTWPERCENTAGE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWCODES" ADD CONSTRAINT "_SYSTEM"."_C440" CHECK("CLANDBTW" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWCODES" ADD CONSTRAINT "_SYSTEM"."_C441" CHECK("CAANKOOP" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWCODES" ADD CONSTRAINT "_SYSTEM"."_C442" CHECK("CVERKOOP" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWCODES" ADD CONSTRAINT "_SYSTEM"."_C443" CHECK("CBTWPLICHTIG" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWCODES" ADD CONSTRAINT "_SYSTEM"."_C444" CHECK("CEXPORT" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWCODES" ADD CONSTRAINT "_SYSTEM"."_C445" CHECK("CIMPORT" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWCODES" ADD CONSTRAINT "_SYSTEM"."_C446" CHECK("CINTRA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWCODES" ADD CONSTRAINT "_SYSTEM"."_C447" CHECK("CMEDECONTRACTANT" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWCODES" ADD CONSTRAINT "_SYSTEM"."_C448" CHECK("COMSCHRIJVING1" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWCODES" ADD CONSTRAINT "_SYSTEM"."_C449" CHECK("CVRIJ" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TGNCODES" ADD CONSTRAINT "_SYSTEM"."_C450" CHECK("CGNCODES_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TGNCODES" ADD CONSTRAINT "_SYSTEM"."_C451" CHECK("CEENHEDENVERPLICHT" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TGNCODES" ADD CONSTRAINT "_SYSTEM"."_C452" CHECK("CMASSAOPTIONEEL" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TGNCODES" ADD CONSTRAINT "_SYSTEM"."_C453" CHECK("CGNCODE" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TARTIKELGROEPEN" ADD CONSTRAINT "_SYSTEM"."_C454" CHECK("CARTIKELGROEPEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELGROEPEN" ADD CONSTRAINT "_SYSTEM"."_C455" CHECK("CINTERNEFIRMAARTIKELS" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELGROEPEN" ADD CONSTRAINT "_SYSTEM"."_C456" CHECK("CARTIKELGROEP1" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TDOCUMENTACTIES" ADD CONSTRAINT "_SYSTEM"."_C457" CHECK("CDOCUMENTACTIES_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TDOCUMENTACTIES" ADD CONSTRAINT "_SYSTEM"."_C458" CHECK("CDOCUMENTTYPE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TDOCUMENTACTIES" ADD CONSTRAINT "_SYSTEM"."_C459" CHECK("CDOCUMENTTYPES_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TDOCUMENTACTIES" ADD CONSTRAINT "_SYSTEM"."_C460" CHECK("CDOCUMENTACTIE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TDOCUMENTACTIES" ADD CONSTRAINT "_SYSTEM"."_C461" FOREIGN KEY("CDOCUMENTTYPES_FK") REFERENCES "_SYSTEM"."TDOCUMENTTYPES"("CDOCUMENTTYPES_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TINCOTERMS" ADD CONSTRAINT "_SYSTEM"."_C462" CHECK("CINCOTERMS_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TINCOTERMS" ADD CONSTRAINT "_SYSTEM"."_C463" CHECK("CINCOTERM" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TINCOTERMS" ADD CONSTRAINT "_SYSTEM"."_C464" CHECK("COMSCHRIJVING1" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TINTRASTATGEWESTEN" ADD CONSTRAINT "_SYSTEM"."_C465" CHECK("CINTRASTATGEWESTEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TINTRASTATGEWESTEN" ADD CONSTRAINT "_SYSTEM"."_C466" CHECK("CINTRASTATGEWEST" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TINTRASTATGEWESTEN" ADD CONSTRAINT "_SYSTEM"."_C467" CHECK("COMSCHRIJVING1" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TINTRASTATTRANSACTIES" ADD CONSTRAINT "_SYSTEM"."_C468" CHECK("CINTRASTATTRANSACTIES_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TINTRASTATTRANSACTIES" ADD CONSTRAINT "_SYSTEM"."_C469" CHECK("CINTRASTATTRANSACTIE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TINTRASTATTRANSACTIES" ADD CONSTRAINT "_SYSTEM"."_C470" CHECK("COMSCHRIJVING1" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TINTRASTATVERVOER" ADD CONSTRAINT "_SYSTEM"."_C471" CHECK("CINTRASTATVERVOER_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TINTRASTATVERVOER" ADD CONSTRAINT "_SYSTEM"."_C472" CHECK("CINTRASTATVERVOER" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TINTRASTATVERVOER" ADD CONSTRAINT "_SYSTEM"."_C473" CHECK("COMSCHRIJVING1" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TVESTIGINGMAGAZIJNEN" ADD CONSTRAINT "_SYSTEM"."_C474" CHECK("CHOOFDMAGAZIJN" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVESTIGINGMAGAZIJNEN" ADD CONSTRAINT "_SYSTEM"."_C475" CHECK("CVESTIGINGMAGAZIJNEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVESTIGINGMAGAZIJNEN" ADD CONSTRAINT "_SYSTEM"."_C476" CHECK("CINTERNEFIRMAVESTIGINGEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVESTIGINGMAGAZIJNEN" ADD CONSTRAINT "_SYSTEM"."_C477" CHECK("CVESTIGINGMAGAZIJN" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVESTIGINGMAGAZIJNEN" ADD CONSTRAINT "_SYSTEM"."_C478" FOREIGN KEY("CINTERNEFIRMAVESTIGINGEN_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN"("CINTERNEFIRMAVESTIGINGEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C479" CHECK("CARTIKELS_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C480" CHECK("CARTIKEL" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C481" CHECK("CINTERNEFIRMAARTIKELS" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C482" CHECK("CGEENKORTINGEN" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C483" CHECK("CMETLOTNUMMERS" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C484" CHECK("CMETSERIENUMMERS" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C485" CHECK("CMETVOORRAAD" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C486" CHECK("CMETMONTAGE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C487" CHECK("CNIETACTIEF" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C488" CHECK("CMETKOPPELARTIKELEN" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C489" FOREIGN KEY("CGNCODES_FK") REFERENCES "_SYSTEM"."TGNCODES"("CGNCODES_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C490" FOREIGN KEY("CVERKOOPREKENINGEN_FK") REFERENCES "_SYSTEM"."TALGEMENEREKENINGEN"("CALGEMENEREKENINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C491" FOREIGN KEY("CAANKOOPREKENINGEN_FK") REFERENCES "_SYSTEM"."TALGEMENEREKENINGEN"("CALGEMENEREKENINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C492" FOREIGN KEY("CMATENBALKEN_FK") REFERENCES "_SYSTEM"."TMATENBALKEN"("CMATENBALKEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C493" FOREIGN KEY("CKLEURENKAARTEN_FK") REFERENCES "_SYSTEM"."TKLEURENKAARTEN"("CKLEURENKAARTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C494" FOREIGN KEY("CARTIKELGROEPEN_FK") REFERENCES "_SYSTEM"."TARTIKELGROEPEN"("CARTIKELGROEPEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TARTIKELLEVERANCIERS" ADD CONSTRAINT "_SYSTEM"."_C495" CHECK("CARTIKELLEVERANCIERS_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELLEVERANCIERS" ADD CONSTRAINT "_SYSTEM"."_C496" CHECK("CAANKOOPPRIJS" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELLEVERANCIERS" ADD CONSTRAINT "_SYSTEM"."_C497" CHECK("CARTIKELS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELLEVERANCIERS" ADD CONSTRAINT "_SYSTEM"."_C498" CHECK("CBEDRAG" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELLEVERANCIERS" ADD CONSTRAINT "_SYSTEM"."_C499" CHECK("CCONTACTEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELLEVERANCIERS" ADD CONSTRAINT "_SYSTEM"."_C500" CHECK("CMUNT" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELLEVERANCIERS" ADD CONSTRAINT "_SYSTEM"."_C501" CHECK("CMUNTEN_FK" IS NOT NULL) INITIALLY DEFERRED DEFERRABLE;
ALTER TABLE "_SYSTEM"."TARTIKELLEVERANCIERS" ADD CONSTRAINT "_SYSTEM"."_C502" CHECK("CHOOFDLEVERANCIER" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELLEVERANCIERS" ADD CONSTRAINT "_SYSTEM"."_C503" FOREIGN KEY("CMUNTEN_FK") REFERENCES "_SYSTEM"."TMUNTEN"("CMUNTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TARTIKELLEVERANCIERS" ADD CONSTRAINT "_SYSTEM"."_C504" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TARTIKELLEVERANCIERS" ADD CONSTRAINT "_SYSTEM"."_C505" FOREIGN KEY("CARTIKELS_FK") REFERENCES "_SYSTEM"."TARTIKELS"("CARTIKELS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TARTIKELLEVERANCIERS" ADD CONSTRAINT "_SYSTEM"."_C506" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TARTIKELLEVERANCIERS" ADD CONSTRAINT "_SYSTEM"."_C507" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELLEVERANCIERS" ADD CONSTRAINT "_SYSTEM"."_C508" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TARTIKELVOORRAAD" ADD CONSTRAINT "_SYSTEM"."_C509" CHECK("CARTIKELS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELVOORRAAD" ADD CONSTRAINT "_SYSTEM"."_C510" CHECK("CINTERNEFIRMAVESTIGING" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELVOORRAAD" ADD CONSTRAINT "_SYSTEM"."_C511" CHECK("CVESTIGINGMAGAZIJN" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELVOORRAAD" ADD CONSTRAINT "_SYSTEM"."_C512" CHECK("CVOORRAAD" IS NOT NULL) INITIALLY DEFERRED DEFERRABLE;
ALTER TABLE "_SYSTEM"."TARTIKELVOORRAAD" ADD CONSTRAINT "_SYSTEM"."_C513" CHECK("CVOORRAADBESCHIKBAAR" IS NOT NULL) INITIALLY DEFERRED DEFERRABLE;
ALTER TABLE "_SYSTEM"."TARTIKELVOORRAAD" ADD CONSTRAINT "_SYSTEM"."_C514" FOREIGN KEY("CARTIKELS_FK") REFERENCES "_SYSTEM"."TARTIKELS"("CARTIKELS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TARTIKELVOORRAAD" ADD CONSTRAINT "_SYSTEM"."_C515" FOREIGN KEY("CINTERNEFIRMAVESTIGINGEN_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN"("CINTERNEFIRMAVESTIGINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TARTIKELVOORRAAD" ADD CONSTRAINT "_SYSTEM"."_C516" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TKLEURENKAARTEN" ADD CONSTRAINT "_SYSTEM"."_C517" CHECK("CKLEURENKAARTEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TKLEURENKAARTEN" ADD CONSTRAINT "_SYSTEM"."_C518" CHECK("CKLEURENKAART" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TKLEUREN" ADD CONSTRAINT "_SYSTEM"."_C519" CHECK("CKLEUREN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TKLEUREN" ADD CONSTRAINT "_SYSTEM"."_C520" CHECK("CKLEUR" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TKLEUREN" ADD CONSTRAINT "_SYSTEM"."_C521" CHECK("CKLEURENKAARTEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TKLEUREN" ADD CONSTRAINT "_SYSTEM"."_C522" FOREIGN KEY("CKLEURENKAARTEN_FK") REFERENCES "_SYSTEM"."TKLEURENKAARTEN"("CKLEURENKAARTEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TMATENBALKEN" ADD CONSTRAINT "_SYSTEM"."_C523" CHECK("CMATENBALKEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TMATENBALKEN" ADD CONSTRAINT "_SYSTEM"."_C524" CHECK("CMATENBALK" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TMATEN" ADD CONSTRAINT "_SYSTEM"."_C525" CHECK("CMATEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TMATEN" ADD CONSTRAINT "_SYSTEM"."_C526" CHECK("CMAAT" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TMATEN" ADD CONSTRAINT "_SYSTEM"."_C527" CHECK("CMATENBALKEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TMATEN" ADD CONSTRAINT "_SYSTEM"."_C528" FOREIGN KEY("CMATENBALKEN_FK") REFERENCES "_SYSTEM"."TMATENBALKEN"("CMATENBALKEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TARTIKELINVESTIGING" ADD CONSTRAINT "_SYSTEM"."_C529" CHECK("CARTIKELINVESTIGING_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELINVESTIGING" ADD CONSTRAINT "_SYSTEM"."_C530" CHECK("CARTIKELS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELINVESTIGING" ADD CONSTRAINT "_SYSTEM"."_C531" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELINVESTIGING" ADD CONSTRAINT "_SYSTEM"."_C532" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL) INITIALLY DEFERRED DEFERRABLE;
ALTER TABLE "_SYSTEM"."TARTIKELINVESTIGING" ADD CONSTRAINT "_SYSTEM"."_C533" CHECK("CINTERNEFIRMAVESTIGING" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELINVESTIGING" ADD CONSTRAINT "_SYSTEM"."_C534" CHECK("CINTERNEFIRMAVESTIGINGEN_FK" IS NOT NULL) INITIALLY DEFERRED DEFERRABLE;
ALTER TABLE "_SYSTEM"."TARTIKELINVESTIGING" ADD CONSTRAINT "_SYSTEM"."_C535" FOREIGN KEY("CINTERNEFIRMAVESTIGINGEN_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN"("CINTERNEFIRMAVESTIGINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TARTIKELINVESTIGING" ADD CONSTRAINT "_SYSTEM"."_C536" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TARTIKELINVESTIGING" ADD CONSTRAINT "_SYSTEM"."_C537" FOREIGN KEY("CARTIKELS_FK") REFERENCES "_SYSTEM"."TARTIKELS"("CARTIKELS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TARTIKELKORTINGEN" ADD CONSTRAINT "_SYSTEM"."_C538" CHECK("CARTIKELKORTINGEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELKORTINGEN" ADD CONSTRAINT "_SYSTEM"."_C539" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELKORTINGEN" ADD CONSTRAINT "_SYSTEM"."_C540" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL) INITIALLY DEFERRED DEFERRABLE;
ALTER TABLE "_SYSTEM"."TARTIKELKORTINGEN" ADD CONSTRAINT "_SYSTEM"."_C541" FOREIGN KEY("CMUNTEN_FK") REFERENCES "_SYSTEM"."TMUNTEN"("CMUNTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TARTIKELKORTINGEN" ADD CONSTRAINT "_SYSTEM"."_C542" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TARTIKELKORTINGEN" ADD CONSTRAINT "_SYSTEM"."_C543" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TARTIKELKORTINGEN" ADD CONSTRAINT "_SYSTEM"."_C544" FOREIGN KEY("CARTIKELS_FK") REFERENCES "_SYSTEM"."TARTIKELS"("CARTIKELS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TARTIKELONDERDELEN" ADD CONSTRAINT "_SYSTEM"."_C545" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL) INITIALLY DEFERRED DEFERRABLE;
ALTER TABLE "_SYSTEM"."TARTIKELONDERDELEN" ADD CONSTRAINT "_SYSTEM"."_C546" CHECK("CARTIKELONDERDELEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELONDERDELEN" ADD CONSTRAINT "_SYSTEM"."_C547" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELONDERDELEN" ADD CONSTRAINT "_SYSTEM"."_C548" CHECK("CARTIKELS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELONDERDELEN" ADD CONSTRAINT "_SYSTEM"."_C549" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TARTIKELONDERDELEN" ADD CONSTRAINT "_SYSTEM"."_C550" FOREIGN KEY("CONDERDELEN_FK") REFERENCES "_SYSTEM"."TARTIKELS"("CARTIKELS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TARTIKELONDERDELEN" ADD CONSTRAINT "_SYSTEM"."_C551" FOREIGN KEY("CARTIKELS_FK") REFERENCES "_SYSTEM"."TARTIKELS"("CARTIKELS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TARTIKELGEKOPPELD" ADD CONSTRAINT "_SYSTEM"."_C552" CHECK("CARTIKELGEKOPPELD_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELGEKOPPELD" ADD CONSTRAINT "_SYSTEM"."_C553" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELGEKOPPELD" ADD CONSTRAINT "_SYSTEM"."_C554" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL) INITIALLY DEFERRED DEFERRABLE;
ALTER TABLE "_SYSTEM"."TARTIKELGEKOPPELD" ADD CONSTRAINT "_SYSTEM"."_C555" CHECK("CARTIKELS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELGEKOPPELD" ADD CONSTRAINT "_SYSTEM"."_C556" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TARTIKELGEKOPPELD" ADD CONSTRAINT "_SYSTEM"."_C557" FOREIGN KEY("CARTIKELS_FK") REFERENCES "_SYSTEM"."TARTIKELS"("CARTIKELS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TARTIKELGEKOPPELD" ADD CONSTRAINT "_SYSTEM"."_C558" FOREIGN KEY("CGEKOPPELD_FK") REFERENCES "_SYSTEM"."TARTIKELS"("CARTIKELS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TADRESTYPES" ADD CONSTRAINT "_SYSTEM"."_C559" CHECK("CADRESTYPES_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TADRESTYPES" ADD CONSTRAINT "_SYSTEM"."_C560" CHECK("CADRESTYPE" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TCONTACTADRESSEN" ADD CONSTRAINT "_SYSTEM"."_C561" CHECK("CCONTACTADRESSEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCONTACTADRESSEN" ADD CONSTRAINT "_SYSTEM"."_C562" CHECK("CNAAM1" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCONTACTADRESSEN" ADD CONSTRAINT "_SYSTEM"."_C563" CHECK("CADRESTYPE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCONTACTADRESSEN" ADD CONSTRAINT "_SYSTEM"."_C564" CHECK("CADRES1" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCONTACTADRESSEN" ADD CONSTRAINT "_SYSTEM"."_C565" CHECK("CCONTACTEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCONTACTADRESSEN" ADD CONSTRAINT "_SYSTEM"."_C566" CHECK("CGEMEENTE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCONTACTADRESSEN" ADD CONSTRAINT "_SYSTEM"."_C567" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TCONTACTADRESSEN" ADD CONSTRAINT "_SYSTEM"."_C568" FOREIGN KEY("CLEVERINGSVOORWAARDEN_FK") REFERENCES "_SYSTEM"."TLEVERINGSVOORWAARDEN"("CLEVERINGSVOORWAARDEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TCONTACTADRESSEN" ADD CONSTRAINT "_SYSTEM"."_C8718" FOREIGN KEY("CCONTACTPERSONEN_FK") REFERENCES "_SYSTEM"."TCONTACTPERSONEN"("CCONTACTPERSONEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TTARIEVEN" ADD CONSTRAINT "_SYSTEM"."_C569" CHECK("CTARIEVEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TTARIEVEN" ADD CONSTRAINT "_SYSTEM"."_C570" CHECK("CINCLBTW" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TTARIEVEN" ADD CONSTRAINT "_SYSTEM"."_C571" CHECK("CTARIEF" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TTARIEVEN" ADD CONSTRAINT "_SYSTEM"."_C572" FOREIGN KEY("CMUNTEN_FK") REFERENCES "_SYSTEM"."TMUNTEN"("CMUNTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TTARIEVEN" ADD CONSTRAINT "_SYSTEM"."_C573" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TARTIKELPRIJZEN" ADD CONSTRAINT "_SYSTEM"."_C574" CHECK("CARTIKELPRIJZEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELPRIJZEN" ADD CONSTRAINT "_SYSTEM"."_C575" CHECK("CARTIKELS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELPRIJZEN" ADD CONSTRAINT "_SYSTEM"."_C576" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELPRIJZEN" ADD CONSTRAINT "_SYSTEM"."_C577" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL) INITIALLY DEFERRED DEFERRABLE;
ALTER TABLE "_SYSTEM"."TARTIKELPRIJZEN" ADD CONSTRAINT "_SYSTEM"."_C578" CHECK("CTARIEVEN_FK" IS NOT NULL) INITIALLY DEFERRED DEFERRABLE;
ALTER TABLE "_SYSTEM"."TARTIKELPRIJZEN" ADD CONSTRAINT "_SYSTEM"."_C579" CHECK("CVERKOOPPRIJS" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELPRIJZEN" ADD CONSTRAINT "_SYSTEM"."_C580" FOREIGN KEY("CTARIEVEN_FK") REFERENCES "_SYSTEM"."TTARIEVEN"("CTARIEVEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TARTIKELPRIJZEN" ADD CONSTRAINT "_SYSTEM"."_C581" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TARTIKELPRIJZEN" ADD CONSTRAINT "_SYSTEM"."_C582" FOREIGN KEY("CARTIKELS_FK") REFERENCES "_SYSTEM"."TARTIKELS"("CARTIKELS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TVERKOPEN" ADD CONSTRAINT "_SYSTEM"."_C583" CHECK("CVERKOPEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVERKOPEN" ADD CONSTRAINT "_SYSTEM"."_C584" CHECK("CDOCUMENTTYPE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVERKOPEN" ADD CONSTRAINT "_SYSTEM"."_C585" CHECK("CDOCUMENTTYPES_FK" IS NOT NULL) DEFERRABLE;
ALTER TABLE "_SYSTEM"."TVERKOPEN" ADD CONSTRAINT "_SYSTEM"."_C586" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVERKOPEN" ADD CONSTRAINT "_SYSTEM"."_C587" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL) INITIALLY DEFERRED DEFERRABLE;
ALTER TABLE "_SYSTEM"."TVERKOPEN" ADD CONSTRAINT "_SYSTEM"."_C588" CHECK("CINTERNEFIRMAVESTIGING" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVERKOPEN" ADD CONSTRAINT "_SYSTEM"."_C589" CHECK("CINTERNEFIRMAVESTIGINGEN_FK" IS NOT NULL) INITIALLY DEFERRED DEFERRABLE;
ALTER TABLE "_SYSTEM"."TVERKOPEN" ADD CONSTRAINT "_SYSTEM"."_C590" CHECK("CNUMMER" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVERKOPEN" ADD CONSTRAINT "_SYSTEM"."_C591" CHECK("CAFGESLOTEN" IS NOT NULL) DEFERRABLE;
ALTER TABLE "_SYSTEM"."TVERKOPEN" ADD CONSTRAINT "_SYSTEM"."_C592" CHECK("CKASVERKOPEN" IS NOT NULL) DEFERRABLE;
ALTER TABLE "_SYSTEM"."TVERKOPEN" ADD CONSTRAINT "_SYSTEM"."_C593" CHECK("CCONTACTEN_FK" IS NOT NULL) DEFERRABLE;
ALTER TABLE "_SYSTEM"."TVERKOPEN" ADD CONSTRAINT "_SYSTEM"."_C594" CHECK("CINCLBTW" IS NOT NULL) DEFERRABLE;
ALTER TABLE "_SYSTEM"."TVERKOPEN" ADD CONSTRAINT "_SYSTEM"."_C595" CHECK("CSTATUS" IS NOT NULL) DEFERRABLE;
ALTER TABLE "_SYSTEM"."TVERKOPEN" ADD CONSTRAINT "_SYSTEM"."_C596" CHECK("CMETRESERVATIE" IS NOT NULL) DEFERRABLE;
ALTER TABLE "_SYSTEM"."TVERKOPEN" ADD CONSTRAINT "_SYSTEM"."_C597" FOREIGN KEY("CTRANSPORTEURS_FK") REFERENCES "_SYSTEM"."TTRANSPORTEURS"("CTRANSPORTEURS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVERKOPEN" ADD CONSTRAINT "_SYSTEM"."_C598" FOREIGN KEY("CTARIEVEN_FK") REFERENCES "_SYSTEM"."TTARIEVEN"("CTARIEVEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVERKOPEN" ADD CONSTRAINT "_SYSTEM"."_C599" FOREIGN KEY("CVERTEGENWOORDIGERS_FK") REFERENCES "_SYSTEM"."TMEDEWERKERS"("CMEDEWERKERS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVERKOPEN" ADD CONSTRAINT "_SYSTEM"."_C600" FOREIGN KEY("CLEVERINGSVOORWAARDEN_FK") REFERENCES "_SYSTEM"."TLEVERINGSVOORWAARDEN"("CLEVERINGSVOORWAARDEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVERKOPEN" ADD CONSTRAINT "_SYSTEM"."_C601" FOREIGN KEY("CINTERNEFIRMAVESTIGINGEN_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN"("CINTERNEFIRMAVESTIGINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVERKOPEN" ADD CONSTRAINT "_SYSTEM"."_C602" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVERKOPEN" ADD CONSTRAINT "_SYSTEM"."_C603" FOREIGN KEY("CDOCUMENTTYPES_FK") REFERENCES "_SYSTEM"."TDOCUMENTTYPES"("CDOCUMENTTYPES_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVERKOPEN" ADD CONSTRAINT "_SYSTEM"."_C604" FOREIGN KEY("CBETALINGSVOORWAARDEN_FK") REFERENCES "_SYSTEM"."TBETALINGSVOORWAARDEN"("CBETALINGSVOORWAARDEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVERKOPEN" ADD CONSTRAINT "_SYSTEM"."_C605" FOREIGN KEY("CCONTACTPERSONEN_FK") REFERENCES "_SYSTEM"."TCONTACTPERSONEN"("CCONTACTPERSONEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVERKOPEN" ADD CONSTRAINT "_SYSTEM"."_C606" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVERKOPEN" ADD CONSTRAINT "_SYSTEM"."_C607" FOREIGN KEY("CCONTACTADRESSEN_FK") REFERENCES "_SYSTEM"."TCONTACTADRESSEN"("CCONTACTADRESSEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVERKOPEN" ADD CONSTRAINT "_SYSTEM"."_C10349" FOREIGN KEY("CMEDEWERKERSINTERN_FK") REFERENCES "_SYSTEM"."TMEDEWERKERS"("CMEDEWERKERS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TVERKOOPCOLLI" ADD CONSTRAINT "_SYSTEM"."_C608" CHECK("CVERKOOPCOLLI_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVERKOOPCOLLI" ADD CONSTRAINT "_SYSTEM"."_C609" CHECK("CVERKOPEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVERKOOPCOLLI" ADD CONSTRAINT "_SYSTEM"."_C1414" FOREIGN KEY("CVERKOPEN_FK") REFERENCES "_SYSTEM"."TVERKOPEN"("CVERKOPEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TVERKOOPBETALINGEN" ADD CONSTRAINT "_SYSTEM"."_C610" CHECK("CVERKOOPBETALINGEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVERKOOPBETALINGEN" ADD CONSTRAINT "_SYSTEM"."_C611" CHECK("CVERKOPEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVERKOOPBETALINGEN" ADD CONSTRAINT "_SYSTEM"."_C612" CHECK("CVERWERKT" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVERKOOPBETALINGEN" ADD CONSTRAINT "_SYSTEM"."_C613" FOREIGN KEY("CMUNTEN_FK") REFERENCES "_SYSTEM"."TMUNTEN"("CMUNTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TVERKOOPBETALINGEN" ADD CONSTRAINT "_SYSTEM"."_C614" FOREIGN KEY("CVERKOPEN_FK") REFERENCES "_SYSTEM"."TVERKOPEN"("CVERKOPEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TVERKOOPBETALINGEN" ADD CONSTRAINT "_SYSTEM"."_C615" FOREIGN KEY("CKASSAAFSL_FK") REFERENCES "_SYSTEM"."TKASSAAFSL"("CKASSAAFSL_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TVERKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C616" CHECK("CVERKOOPLIJNEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVERKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C617" CHECK("CVERKOPEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVERKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C618" CHECK("CINCLBTW" IS NOT NULL) DEFERRABLE;
ALTER TABLE "_SYSTEM"."TVERKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C619" CHECK("CGEENKORTINGEN" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVERKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C620" CHECK("CMETVOORRAAD" IS NOT NULL) DEFERRABLE;
ALTER TABLE "_SYSTEM"."TVERKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C621" CHECK("CMETLOTNUMMERS" IS NOT NULL) DEFERRABLE;
ALTER TABLE "_SYSTEM"."TVERKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C622" CHECK("CMETSERIENUMMERS" IS NOT NULL) DEFERRABLE;
ALTER TABLE "_SYSTEM"."TVERKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C623" CHECK("CMETRESERVATIE" IS NOT NULL) DEFERRABLE;
ALTER TABLE "_SYSTEM"."TVERKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C624" CHECK("CSTATUS" IS NOT NULL) DEFERRABLE;
ALTER TABLE "_SYSTEM"."TVERKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C625" CHECK("CGEENKORTINGEN" IS NOT NULL) DEFERRABLE;
ALTER TABLE "_SYSTEM"."TVERKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C626" CHECK("CMETKOPPELARTIKELEN" IS NOT NULL) DEFERRABLE;
ALTER TABLE "_SYSTEM"."TVERKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C627" FOREIGN KEY("CARTIKELS_FK") REFERENCES "_SYSTEM"."TARTIKELS"("CARTIKELS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVERKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C628" FOREIGN KEY("CVERKOPEN_FK") REFERENCES "_SYSTEM"."TVERKOPEN"("CVERKOPEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVERKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C629" FOREIGN KEY("CTARIEVEN_FK") REFERENCES "_SYSTEM"."TTARIEVEN"("CTARIEVEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVERKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C630" FOREIGN KEY("CMATENBALKEN_FK") REFERENCES "_SYSTEM"."TMATENBALKEN"("CMATENBALKEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVERKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C631" FOREIGN KEY("CKLEURENKAARTEN_FK") REFERENCES "_SYSTEM"."TKLEURENKAARTEN"("CKLEURENKAARTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVERKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C632" FOREIGN KEY("CGNCODES_FK") REFERENCES "_SYSTEM"."TGNCODES"("CGNCODES_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVERKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C633" FOREIGN KEY("CANALYTISCHEREKENINGEN_FK") REFERENCES "_SYSTEM"."TANALYTISCHEREKENINGEN"("CANALYTISCHEREKENINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVERKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C634" FOREIGN KEY("CALGEMENEREKENINGEN_FK") REFERENCES "_SYSTEM"."TALGEMENEREKENINGEN"("CALGEMENEREKENINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVERKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C10353" FOREIGN KEY("CARTIKELLEEGGOED_FK") REFERENCES "_SYSTEM"."TARTIKELS"("CARTIKELS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TMATERIALEN" ADD CONSTRAINT "_SYSTEM"."_C635" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TAGENDALABELS" ADD CONSTRAINT "_SYSTEM"."_C636" CHECK("CAGENDALABEL" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TAANKOPEN" ADD CONSTRAINT "_SYSTEM"."_C637" CHECK("CAANKOPEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TAANKOPEN" ADD CONSTRAINT "_SYSTEM"."_C638" CHECK("CDOCUMENTTYPE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TAANKOPEN" ADD CONSTRAINT "_SYSTEM"."_C639" CHECK("CDOCUMENTTYPES_FK" IS NOT NULL) DEFERRABLE;
ALTER TABLE "_SYSTEM"."TAANKOPEN" ADD CONSTRAINT "_SYSTEM"."_C640" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TAANKOPEN" ADD CONSTRAINT "_SYSTEM"."_C641" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL) INITIALLY DEFERRED DEFERRABLE;
ALTER TABLE "_SYSTEM"."TAANKOPEN" ADD CONSTRAINT "_SYSTEM"."_C642" CHECK("CINTERNEFIRMAVESTIGING" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TAANKOPEN" ADD CONSTRAINT "_SYSTEM"."_C643" CHECK("CINTERNEFIRMAVESTIGINGEN_FK" IS NOT NULL) INITIALLY DEFERRED DEFERRABLE;
ALTER TABLE "_SYSTEM"."TAANKOPEN" ADD CONSTRAINT "_SYSTEM"."_C644" CHECK("CNUMMER" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TAANKOPEN" ADD CONSTRAINT "_SYSTEM"."_C645" CHECK("CAFGESLOTEN" IS NOT NULL) DEFERRABLE;
ALTER TABLE "_SYSTEM"."TAANKOPEN" ADD CONSTRAINT "_SYSTEM"."_C646" CHECK("CBETAALD" IS NOT NULL) DEFERRABLE;
ALTER TABLE "_SYSTEM"."TAANKOPEN" ADD CONSTRAINT "_SYSTEM"."_C647" CHECK("CCONTACTEN_FK" IS NOT NULL) DEFERRABLE;
ALTER TABLE "_SYSTEM"."TAANKOPEN" ADD CONSTRAINT "_SYSTEM"."_C648" CHECK("CINCLBTW" IS NOT NULL) DEFERRABLE;
ALTER TABLE "_SYSTEM"."TAANKOPEN" ADD CONSTRAINT "_SYSTEM"."_C649" CHECK("CSTATUS" IS NOT NULL) DEFERRABLE;
ALTER TABLE "_SYSTEM"."TAANKOPEN" ADD CONSTRAINT "_SYSTEM"."_C650" FOREIGN KEY("CINTERNEFIRMAVESTIGINGEN_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN"("CINTERNEFIRMAVESTIGINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TAANKOPEN" ADD CONSTRAINT "_SYSTEM"."_C651" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TAANKOPEN" ADD CONSTRAINT "_SYSTEM"."_C652" FOREIGN KEY("CDOCUMENTTYPES_FK") REFERENCES "_SYSTEM"."TDOCUMENTTYPES"("CDOCUMENTTYPES_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TAANKOPEN" ADD CONSTRAINT "_SYSTEM"."_C653" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TAANKOPEN" ADD CONSTRAINT "_SYSTEM"."_C654" FOREIGN KEY("CBETALINGSVOORWAARDEN_FK") REFERENCES "_SYSTEM"."TBETALINGSVOORWAARDEN"("CBETALINGSVOORWAARDEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TAANKOPEN" ADD CONSTRAINT "_SYSTEM"."_C655" FOREIGN KEY("CCONTACTPERSONEN_FK") REFERENCES "_SYSTEM"."TCONTACTPERSONEN"("CCONTACTPERSONEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TAANKOPEN" ADD CONSTRAINT "_SYSTEM"."_C656" FOREIGN KEY("CMEDEWERKERS_FK") REFERENCES "_SYSTEM"."TMEDEWERKERS"("CMEDEWERKERS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TAANKOPEN" ADD CONSTRAINT "_SYSTEM"."_C7376" FOREIGN KEY("CTRANSPORTEURS_FK") REFERENCES "_SYSTEM"."TTRANSPORTEURS"("CTRANSPORTEURS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TAANKOPEN" ADD CONSTRAINT "_SYSTEM"."_C7377" FOREIGN KEY("CLEVERINGSVOORWAARDEN_FK") REFERENCES "_SYSTEM"."TLEVERINGSVOORWAARDEN"("CLEVERINGSVOORWAARDEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TAANKOPEN" ADD CONSTRAINT "_SYSTEM"."_C8715" FOREIGN KEY("CCONTACTADRESSEN_FK") REFERENCES "_SYSTEM"."TCONTACTADRESSEN"("CCONTACTADRESSEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TAANKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C657" CHECK("CAANKOOPLIJNEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TAANKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C658" CHECK("CAANKOPEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TAANKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C659" CHECK("CINCLBTW" IS NOT NULL) DEFERRABLE;
ALTER TABLE "_SYSTEM"."TAANKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C660" CHECK("CMETVOORRAAD" IS NOT NULL) DEFERRABLE;
ALTER TABLE "_SYSTEM"."TAANKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C661" CHECK("CMETLOTNUMMERS" IS NOT NULL) DEFERRABLE;
ALTER TABLE "_SYSTEM"."TAANKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C662" CHECK("CMETSERIENUMMERS" IS NOT NULL) DEFERRABLE;
ALTER TABLE "_SYSTEM"."TAANKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C663" CHECK("CSTATUS" IS NOT NULL) DEFERRABLE;
ALTER TABLE "_SYSTEM"."TAANKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C664" CHECK("CUPDARTIKELLEVERANCIERS" IS NOT NULL) DEFERRABLE;
ALTER TABLE "_SYSTEM"."TAANKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C665" CHECK("CUPDLAATSTEAANKOOPPRIJS" IS NOT NULL) DEFERRABLE;
ALTER TABLE "_SYSTEM"."TAANKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C666" FOREIGN KEY("CMATENBALKEN_FK") REFERENCES "_SYSTEM"."TMATENBALKEN"("CMATENBALKEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TAANKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C667" FOREIGN KEY("CKLEURENKAARTEN_FK") REFERENCES "_SYSTEM"."TKLEURENKAARTEN"("CKLEURENKAARTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TAANKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C668" FOREIGN KEY("CARTIKELS_FK") REFERENCES "_SYSTEM"."TARTIKELS"("CARTIKELS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TAANKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C669" FOREIGN KEY("CANALYTISCHEREKENINGEN_FK") REFERENCES "_SYSTEM"."TANALYTISCHEREKENINGEN"("CANALYTISCHEREKENINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TAANKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C670" FOREIGN KEY("CALGEMENEREKENINGEN_FK") REFERENCES "_SYSTEM"."TALGEMENEREKENINGEN"("CALGEMENEREKENINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TAANKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C671" FOREIGN KEY("CAANKOPEN_FK") REFERENCES "_SYSTEM"."TAANKOPEN"("CAANKOPEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TAGENDA" ADD CONSTRAINT "_SYSTEM"."_C674" FOREIGN KEY("CMEDEWERKERS_FK") REFERENCES "_SYSTEM"."TMEDEWERKERS"("CMEDEWERKERS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TAGENDA" ADD CONSTRAINT "_SYSTEM"."_C675" FOREIGN KEY("CAGENDALABELS_FK") REFERENCES "_SYSTEM"."TAGENDALABELS"("CAGENDALABELS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TAGENDA" ADD CONSTRAINT "_SYSTEM"."_C676" FOREIGN KEY("CRUIMTEN_FK") REFERENCES "_SYSTEM"."TRUIMTEN"("CRUIMTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TAGENDA" ADD CONSTRAINT "_SYSTEM"."_C677" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TAGENDA" ADD CONSTRAINT "_SYSTEM"."_C678" FOREIGN KEY("CCONTACTPERSONEN_FK") REFERENCES "_SYSTEM"."TCONTACTPERSONEN"("CCONTACTPERSONEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TAGENDA" ADD CONSTRAINT "_SYSTEM"."_C3748" FOREIGN KEY("CCONTACTADRESSEN_FK") REFERENCES "_SYSTEM"."TCONTACTADRESSEN"("CCONTACTADRESSEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TVOORRAADWIJZIGINGEN" ADD CONSTRAINT "_SYSTEM"."_C679" CHECK("CVOORRAADWIJZIGINGEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVOORRAADWIJZIGINGEN" ADD CONSTRAINT "_SYSTEM"."_C680" CHECK("CARTIKELS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVOORRAADWIJZIGINGEN" ADD CONSTRAINT "_SYSTEM"."_C681" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVOORRAADWIJZIGINGEN" ADD CONSTRAINT "_SYSTEM"."_C682" CHECK("CINTERNEFIRMAVESTIGINGEN_FK" IS NOT NULL) INITIALLY DEFERRED DEFERRABLE;
ALTER TABLE "_SYSTEM"."TVOORRAADWIJZIGINGEN" ADD CONSTRAINT "_SYSTEM"."_C683" CHECK("CINTERNEFIRMAVESTIGING" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVOORRAADWIJZIGINGEN" ADD CONSTRAINT "_SYSTEM"."_C684" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL) INITIALLY DEFERRED DEFERRABLE;
ALTER TABLE "_SYSTEM"."TVOORRAADWIJZIGINGEN" ADD CONSTRAINT "_SYSTEM"."_C685" CHECK("CVESTIGINGMAGAZIJN" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVOORRAADWIJZIGINGEN" ADD CONSTRAINT "_SYSTEM"."_C686" CHECK("CVOORRAADVOOR" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVOORRAADWIJZIGINGEN" ADD CONSTRAINT "_SYSTEM"."_C687" CHECK("CVOORRAADNA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVOORRAADWIJZIGINGEN" ADD CONSTRAINT "_SYSTEM"."_C688" CHECK("CVOORRAADWIJZIGING" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVOORRAADWIJZIGINGEN" ADD CONSTRAINT "_SYSTEM"."_C689" FOREIGN KEY("CINTERNEFIRMAVESTIGINGEN_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN"("CINTERNEFIRMAVESTIGINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVOORRAADWIJZIGINGEN" ADD CONSTRAINT "_SYSTEM"."_C690" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVOORRAADWIJZIGINGEN" ADD CONSTRAINT "_SYSTEM"."_C691" FOREIGN KEY("CARTIKELS_FK") REFERENCES "_SYSTEM"."TARTIKELS"("CARTIKELS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TVOORRAADTRANSFERSERIENUMMERS" ADD CONSTRAINT "_SYSTEM"."_C692" CHECK("CVOORRAADTRANSFERSERIENUMMERS_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVOORRAADTRANSFERSERIENUMMERS" ADD CONSTRAINT "_SYSTEM"."_C693" CHECK("CVOORRAADTRANSFERS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVOORRAADTRANSFERSERIENUMMERS" ADD CONSTRAINT "_SYSTEM"."_C694" CHECK("CSERIENUMMER" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TVOORRAADWIJZIGINGSERIENUMMERS" ADD CONSTRAINT "_SYSTEM"."_C695" CHECK("CVOORRAADWIJZIGINGSERIENUMMERS_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVOORRAADWIJZIGINGSERIENUMMERS" ADD CONSTRAINT "_SYSTEM"."_C696" CHECK("CVOORRAADWIJZIGINGEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVOORRAADWIJZIGINGSERIENUMMERS" ADD CONSTRAINT "_SYSTEM"."_C697" CHECK("CSERIENUMMER" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVOORRAADWIJZIGINGSERIENUMMERS" ADD CONSTRAINT "_SYSTEM"."_C698" FOREIGN KEY("CVOORRAADWIJZIGINGEN_FK") REFERENCES "_SYSTEM"."TVOORRAADWIJZIGINGEN"("CVOORRAADWIJZIGINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TVOORRAADTRANSFERS" ADD CONSTRAINT "_SYSTEM"."_C699" CHECK("CVOORRAADTRANSFERS_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVOORRAADTRANSFERS" ADD CONSTRAINT "_SYSTEM"."_C700" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVOORRAADTRANSFERS" ADD CONSTRAINT "_SYSTEM"."_C701" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVOORRAADTRANSFERS" ADD CONSTRAINT "_SYSTEM"."_C702" CHECK("CINTERNEFIRMAVESTIGING" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVOORRAADTRANSFERS" ADD CONSTRAINT "_SYSTEM"."_C703" CHECK("CINTERNEFIRMAVESTIGINGEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVOORRAADTRANSFERS" ADD CONSTRAINT "_SYSTEM"."_C704" CHECK("CINTERNEFIRMAVESTIGINGENNAAR_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVOORRAADTRANSFERS" ADD CONSTRAINT "_SYSTEM"."_C705" CHECK("CINTERNEFIRMAVESTIGINGNAAR" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVOORRAADTRANSFERS" ADD CONSTRAINT "_SYSTEM"."_C706" CHECK("CVESTIGINGMAGAZIJN" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVOORRAADTRANSFERS" ADD CONSTRAINT "_SYSTEM"."_C707" CHECK("CVESTIGINGMAGAZIJNNAAR" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVOORRAADTRANSFERS" ADD CONSTRAINT "_SYSTEM"."_C708" CHECK("CARTIKELS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVOORRAADTRANSFERS" ADD CONSTRAINT "_SYSTEM"."_C709" CHECK("CVOORRAADTRANSFER" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVOORRAADTRANSFERS" ADD CONSTRAINT "_SYSTEM"."_C710" FOREIGN KEY("CINTERNEFIRMAVESTIGINGENNAAR_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN"("CINTERNEFIRMAVESTIGINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVOORRAADTRANSFERS" ADD CONSTRAINT "_SYSTEM"."_C711" FOREIGN KEY("CINTERNEFIRMAVESTIGINGEN_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN"("CINTERNEFIRMAVESTIGINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVOORRAADTRANSFERS" ADD CONSTRAINT "_SYSTEM"."_C712" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVOORRAADTRANSFERS" ADD CONSTRAINT "_SYSTEM"."_C713" FOREIGN KEY("CARTIKELS_FK") REFERENCES "_SYSTEM"."TARTIKELS"("CARTIKELS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TLICENTIE" ADD CONSTRAINT "_SYSTEM"."_C714" CHECK("CLICENTIE_PK" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TSESSIES" ADD CONSTRAINT "_SYSTEM"."_C715" CHECK("CSESSIES_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSESSIES" ADD CONSTRAINT "_SYSTEM"."_C716" CHECK("CMEDEWERKER" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSESSIES" ADD CONSTRAINT "_SYSTEM"."_C717" CHECK("CMODULE" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TARTIKELLOCATIES" ADD CONSTRAINT "_SYSTEM"."_C718" CHECK("CARTIKELLOCATIES_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELLOCATIES" ADD CONSTRAINT "_SYSTEM"."_C719" CHECK("CARTIKELS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELLOCATIES" ADD CONSTRAINT "_SYSTEM"."_C720" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELLOCATIES" ADD CONSTRAINT "_SYSTEM"."_C721" CHECK("CINTERNEFIRMAVESTIGINGEN_FK" IS NOT NULL) INITIALLY DEFERRED DEFERRABLE;
ALTER TABLE "_SYSTEM"."TARTIKELLOCATIES" ADD CONSTRAINT "_SYSTEM"."_C722" CHECK("CINTERNEFIRMAVESTIGING" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELLOCATIES" ADD CONSTRAINT "_SYSTEM"."_C723" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL) INITIALLY DEFERRED DEFERRABLE;
ALTER TABLE "_SYSTEM"."TARTIKELLOCATIES" ADD CONSTRAINT "_SYSTEM"."_C724" CHECK("CVESTIGINGMAGAZIJN" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELLOCATIES" ADD CONSTRAINT "_SYSTEM"."_C725" FOREIGN KEY("CINTERNEFIRMAVESTIGINGEN_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN"("CINTERNEFIRMAVESTIGINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TARTIKELLOCATIES" ADD CONSTRAINT "_SYSTEM"."_C726" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TARTIKELLOCATIES" ADD CONSTRAINT "_SYSTEM"."_C727" FOREIGN KEY("CARTIKELS_FK") REFERENCES "_SYSTEM"."TARTIKELS"("CARTIKELS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TPRODUCTIE" ADD CONSTRAINT "_SYSTEM"."_C728" CHECK("CPRODUCTIE_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TPRODUCTIE" ADD CONSTRAINT "_SYSTEM"."_C729" CHECK("CDOCUMENTTYPE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TPRODUCTIE" ADD CONSTRAINT "_SYSTEM"."_C730" CHECK("CDOCUMENTTYPES_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TPRODUCTIE" ADD CONSTRAINT "_SYSTEM"."_C731" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TPRODUCTIE" ADD CONSTRAINT "_SYSTEM"."_C732" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL) INITIALLY DEFERRED DEFERRABLE;
ALTER TABLE "_SYSTEM"."TPRODUCTIE" ADD CONSTRAINT "_SYSTEM"."_C733" CHECK("CINTERNEFIRMAVESTIGING" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TPRODUCTIE" ADD CONSTRAINT "_SYSTEM"."_C734" CHECK("CUPDLAATSTEAANKOOPPRIJS" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TPRODUCTIE" ADD CONSTRAINT "_SYSTEM"."_C735" CHECK("CINTERNEFIRMAVESTIGINGEN_FK" IS NOT NULL) INITIALLY DEFERRED DEFERRABLE;
ALTER TABLE "_SYSTEM"."TPRODUCTIE" ADD CONSTRAINT "_SYSTEM"."_C736" CHECK("CVESTIGINGMAGAZIJN" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TPRODUCTIE" ADD CONSTRAINT "_SYSTEM"."_C737" CHECK("CNUMMER" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TPRODUCTIE" ADD CONSTRAINT "_SYSTEM"."_C738" CHECK("CAFGESLOTEN" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TPRODUCTIE" ADD CONSTRAINT "_SYSTEM"."_C739" CHECK("CARTIKEL" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TPRODUCTIE" ADD CONSTRAINT "_SYSTEM"."_C740" CHECK("CARTIKELS_FK" IS NOT NULL) INITIALLY DEFERRED DEFERRABLE;
ALTER TABLE "_SYSTEM"."TPRODUCTIE" ADD CONSTRAINT "_SYSTEM"."_C741" CHECK("CDATUM" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TPRODUCTIE" ADD CONSTRAINT "_SYSTEM"."_C742" CHECK("CGEPLAND" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TPRODUCTIE" ADD CONSTRAINT "_SYSTEM"."_C743" CHECK("CMETLOTNUMMERS" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TPRODUCTIE" ADD CONSTRAINT "_SYSTEM"."_C744" CHECK("CMETSERIENUMMERS" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TPRODUCTIE" ADD CONSTRAINT "_SYSTEM"."_C745" CHECK("CMETVOORRAAD" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TPRODUCTIE" ADD CONSTRAINT "_SYSTEM"."_C746" CHECK("CMONTEREN" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TPRODUCTIE" ADD CONSTRAINT "_SYSTEM"."_C747" CHECK("CSTATUS" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TPRODUCTIE" ADD CONSTRAINT "_SYSTEM"."_C748" FOREIGN KEY("CMATENBALKEN_FK") REFERENCES "_SYSTEM"."TMATENBALKEN"("CMATENBALKEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPRODUCTIE" ADD CONSTRAINT "_SYSTEM"."_C749" FOREIGN KEY("CKLEURENKAARTEN_FK") REFERENCES "_SYSTEM"."TKLEURENKAARTEN"("CKLEURENKAARTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPRODUCTIE" ADD CONSTRAINT "_SYSTEM"."_C750" FOREIGN KEY("CINTERNEFIRMAVESTIGINGEN_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN"("CINTERNEFIRMAVESTIGINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPRODUCTIE" ADD CONSTRAINT "_SYSTEM"."_C751" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPRODUCTIE" ADD CONSTRAINT "_SYSTEM"."_C752" FOREIGN KEY("CDOCUMENTTYPES_FK") REFERENCES "_SYSTEM"."TDOCUMENTTYPES"("CDOCUMENTTYPES_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPRODUCTIE" ADD CONSTRAINT "_SYSTEM"."_C753" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPRODUCTIE" ADD CONSTRAINT "_SYSTEM"."_C754" FOREIGN KEY("CARTIKELS_FK") REFERENCES "_SYSTEM"."TARTIKELS"("CARTIKELS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TARTIKELVERPAKKINGEN" ADD CONSTRAINT "_SYSTEM"."_C755" CHECK("CARTIKELVERPAKKINGEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELVERPAKKINGEN" ADD CONSTRAINT "_SYSTEM"."_C756" CHECK("CARTIKELS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELVERPAKKINGEN" ADD CONSTRAINT "_SYSTEM"."_C757" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELVERPAKKINGEN" ADD CONSTRAINT "_SYSTEM"."_C758" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELVERPAKKINGEN" ADD CONSTRAINT "_SYSTEM"."_C759" CHECK("CVERPAKKING" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELVERPAKKINGEN" ADD CONSTRAINT "_SYSTEM"."_C760" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TARTIKELVERPAKKINGEN" ADD CONSTRAINT "_SYSTEM"."_C761" FOREIGN KEY("CARTIKELS_FK") REFERENCES "_SYSTEM"."TARTIKELS"("CARTIKELS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCRMCOMMUNICATIES" ADD CONSTRAINT "_SYSTEM"."_C762" CHECK("CCRMCOMMUNICATIES_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCRMCOMMUNICATIES" ADD CONSTRAINT "_SYSTEM"."_C763" CHECK("CCONTACTEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCRMCOMMUNICATIES" ADD CONSTRAINT "_SYSTEM"."_C764" CHECK("CRICHTING" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCRMCOMMUNICATIES" ADD CONSTRAINT "_SYSTEM"."_C765" FOREIGN KEY("CCONTACTPERSONEN_FK") REFERENCES "_SYSTEM"."TCONTACTPERSONEN"("CCONTACTPERSONEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TCRMCOMMUNICATIES" ADD CONSTRAINT "_SYSTEM"."_C766" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TCRMCOMMUNICATIES" ADD CONSTRAINT "_SYSTEM"."_C767" FOREIGN KEY("CCATEGORIEN_FK") REFERENCES "_SYSTEM"."TCATEGORIEN"("CCATEGORIEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TCRMCOMMUNICATIES" ADD CONSTRAINT "_SYSTEM"."_C768" FOREIGN KEY("CMEDEWERKERS_FK") REFERENCES "_SYSTEM"."TMEDEWERKERS"("CMEDEWERKERS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCRMCOMMUNICATIEBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C769" FOREIGN KEY("CCRMCOMMUNICATIES_FK") REFERENCES "_SYSTEM"."TCRMCOMMUNICATIES"("CCRMCOMMUNICATIES_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TCRMCOMMUNICATIEBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C770" CHECK("CCRMCOMMUNICATIEBIJLAGEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCRMCOMMUNICATIEBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C771" CHECK("CCRMCOMMUNICATIES_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCRMCOMMUNICATIEBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C772" CHECK("CTYPE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCRMCOMMUNICATIEBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C773" CHECK("CTYPENUMMER" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCRMCOMMUNICATIEBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C774" FOREIGN KEY("CDOCUMENTTYPES_FK") REFERENCES "_SYSTEM"."TDOCUMENTTYPES"("CDOCUMENTTYPES_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCRMTAKEN" ADD CONSTRAINT "_SYSTEM"."_C775" CHECK("CCRMTAKEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCRMTAKEN" ADD CONSTRAINT "_SYSTEM"."_C776" CHECK("CGEPLAND" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCRMTAKEN" ADD CONSTRAINT "_SYSTEM"."_C777" CHECK("CMETOPVOLGING" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCRMTAKEN" ADD CONSTRAINT "_SYSTEM"."_C778" FOREIGN KEY("CMEDEWERKERSVAN_FK") REFERENCES "_SYSTEM"."TMEDEWERKERS"("CMEDEWERKERS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TCRMTAKEN" ADD CONSTRAINT "_SYSTEM"."_C779" FOREIGN KEY("CMEDEWERKERSVOOR_FK") REFERENCES "_SYSTEM"."TMEDEWERKERS"("CMEDEWERKERS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TCRMTAKEN" ADD CONSTRAINT "_SYSTEM"."_C780" FOREIGN KEY("CCONTACTPERSONEN_FK") REFERENCES "_SYSTEM"."TCONTACTPERSONEN"("CCONTACTPERSONEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TCRMTAKEN" ADD CONSTRAINT "_SYSTEM"."_C781" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TCRMTAKEN" ADD CONSTRAINT "_SYSTEM"."_C782" FOREIGN KEY("CCATEGORIEN_FK") REFERENCES "_SYSTEM"."TCATEGORIEN"("CCATEGORIEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCRMTAAKBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C783" CHECK("CCRMTAAKBIJLAGEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCRMTAAKBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C784" CHECK("CCRMTAKEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCRMTAAKBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C785" CHECK("CTYPE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCRMTAAKBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C786" CHECK("CTYPENUMMER" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCRMTAAKBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C787" FOREIGN KEY("CDOCUMENTTYPES_FK") REFERENCES "_SYSTEM"."TDOCUMENTTYPES"("CDOCUMENTTYPES_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TCRMTAAKBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C788" FOREIGN KEY("CCRMTAKEN_FK") REFERENCES "_SYSTEM"."TCRMTAKEN"("CCRMTAKEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TPRODUCTIELIJNEN" ADD CONSTRAINT "_SYSTEM"."_C789" CHECK("CPRODUCTIELIJNEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TPRODUCTIELIJNEN" ADD CONSTRAINT "_SYSTEM"."_C790" CHECK("CPRODUCTIE_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TPRODUCTIELIJNEN" ADD CONSTRAINT "_SYSTEM"."_C791" CHECK("CMETLOTNUMMERS" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TPRODUCTIELIJNEN" ADD CONSTRAINT "_SYSTEM"."_C792" CHECK("CMETSERIENUMMERS" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TPRODUCTIELIJNEN" ADD CONSTRAINT "_SYSTEM"."_C793" CHECK("CMETVOORRAAD" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TPRODUCTIELIJNEN" ADD CONSTRAINT "_SYSTEM"."_C794" CHECK("CVESTIGINGMAGAZIJN" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TPRODUCTIELIJNEN" ADD CONSTRAINT "_SYSTEM"."_C795" FOREIGN KEY("CPRODUCTIE_FK") REFERENCES "_SYSTEM"."TPRODUCTIE"("CPRODUCTIE_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPRODUCTIELIJNEN" ADD CONSTRAINT "_SYSTEM"."_C796" FOREIGN KEY("CMATENBALKEN_FK") REFERENCES "_SYSTEM"."TMATENBALKEN"("CMATENBALKEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPRODUCTIELIJNEN" ADD CONSTRAINT "_SYSTEM"."_C797" FOREIGN KEY("CKLEURENKAARTEN_FK") REFERENCES "_SYSTEM"."TKLEURENKAARTEN"("CKLEURENKAARTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPRODUCTIELIJNEN" ADD CONSTRAINT "_SYSTEM"."_C798" FOREIGN KEY("CARTIKELS_FK") REFERENCES "_SYSTEM"."TARTIKELS"("CARTIKELS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TAGENDAEXTRA" ADD CONSTRAINT "_SYSTEM"."_C799" FOREIGN KEY("CAGENDA_FK") REFERENCES "_SYSTEM"."TAGENDA"("CAGENDA_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TAGENDAEXTRA" ADD CONSTRAINT "_SYSTEM"."_C800" FOREIGN KEY("CMEDEWERKERS_FK") REFERENCES "_SYSTEM"."TMEDEWERKERS"("CMEDEWERKERS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TAGENDAEXTRA" ADD CONSTRAINT "_SYSTEM"."_C801" FOREIGN KEY("CMATERIALEN_FK") REFERENCES "_SYSTEM"."TMATERIALEN"("CMATERIALEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TAGENDAPREFS" ADD CONSTRAINT "_SYSTEM"."_C802" CHECK("CAGENDAPREF" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TAGENDAPREFS" ADD CONSTRAINT "_SYSTEM"."_C803" CHECK("CWAARDE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TAGENDAPREFS" ADD CONSTRAINT "_SYSTEM"."_C804" FOREIGN KEY("CMEDEWERKERS_FK") REFERENCES "_SYSTEM"."TMEDEWERKERS"("CMEDEWERKERS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TKASSAAFSL" ADD CONSTRAINT "_SYSTEM"."_C805" CHECK("CKASSAAFSL_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TKASSAAFSL" ADD CONSTRAINT "_SYSTEM"."_C806" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TKASSAAFSL" ADD CONSTRAINT "_SYSTEM"."_C807" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TKASSAAFSL" ADD CONSTRAINT "_SYSTEM"."_C808" CHECK("CINTERNEFIRMAVESTIGING" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TKASSAAFSL" ADD CONSTRAINT "_SYSTEM"."_C809" CHECK("CINTERNEFIRMAVESTIGINGEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TKASSAAFSL" ADD CONSTRAINT "_SYSTEM"."_C810" CHECK("CAFGESLOTEN" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TKASSAAFSL" ADD CONSTRAINT "_SYSTEM"."_C811" FOREIGN KEY("CINTERNEFIRMAVESTIGINGEN_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN"("CINTERNEFIRMAVESTIGINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TKASSAAFSL" ADD CONSTRAINT "_SYSTEM"."_C812" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TKASSAAFSLBETAALWIJZEN" ADD CONSTRAINT "_SYSTEM"."_C813" CHECK("CKASSAAFSLBETAALWIJZEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TKASSAAFSLBETAALWIJZEN" ADD CONSTRAINT "_SYSTEM"."_C814" CHECK("CKASSAAFSL_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TKASSAAFSLBETAALWIJZEN" ADD CONSTRAINT "_SYSTEM"."_C815" CHECK("CCASH" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TKASSAAFSLBETAALWIJZEN" ADD CONSTRAINT "_SYSTEM"."_C816" FOREIGN KEY("CKASSAAFSL_FK") REFERENCES "_SYSTEM"."TKASSAAFSL"("CKASSAAFSL_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
ALTER TABLE "_SYSTEM"."TKASSAAFSLBETAALWIJZEN" ADD CONSTRAINT "_SYSTEM"."_C817" FOREIGN KEY("CALGEMENEREKENINGEN_FK") REFERENCES "_SYSTEM"."TALGEMENEREKENINGEN"("CALGEMENEREKENINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(16,158,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TKASSAAFSLOMZETTEN" ADD CONSTRAINT "_SYSTEM"."_C819" CHECK("CKASSAAFSL_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TKASSAAFSLOMZETTEN" ADD CONSTRAINT "_SYSTEM"."_C820" FOREIGN KEY("CKASSAAFSL_FK") REFERENCES "_SYSTEM"."TKASSAAFSL"("CKASSAAFSL_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TKASSAAFSLOMZETTEN" ADD CONSTRAINT "_SYSTEM"."_C821" FOREIGN KEY("CALGEMENEREKENINGEN_FK") REFERENCES "_SYSTEM"."TALGEMENEREKENINGEN"("CALGEMENEREKENINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TBETAALWIJZEN" ADD CONSTRAINT "_SYSTEM"."_C822" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TBETAALWIJZEN" ADD CONSTRAINT "_SYSTEM"."_C823" CHECK("CBETAALWIJZEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBETAALWIJZEN" ADD CONSTRAINT "_SYSTEM"."_C824" CHECK("CBETAALWIJZE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBETAALWIJZEN" ADD CONSTRAINT "_SYSTEM"."_C825" FOREIGN KEY("CALGEMENEREKENINGEN_FK") REFERENCES "_SYSTEM"."TALGEMENEREKENINGEN"("CALGEMENEREKENINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TBETAALWIJZEN" ADD CONSTRAINT "_SYSTEM"."_C826" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBETAALWIJZEN" ADD CONSTRAINT "_SYSTEM"."_C827" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TCONTACTSALDI" ADD CONSTRAINT "_SYSTEM"."_C828" CHECK("CCONTACTSALDI_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCONTACTSALDI" ADD CONSTRAINT "_SYSTEM"."_C829" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCONTACTSALDI" ADD CONSTRAINT "_SYSTEM"."_C830" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCONTACTSALDI" ADD CONSTRAINT "_SYSTEM"."_C831" CHECK("CCONTACTEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCONTACTSALDI" ADD CONSTRAINT "_SYSTEM"."_C832" CHECK("CCONTACTROL" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCONTACTSALDI" ADD CONSTRAINT "_SYSTEM"."_C833" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TCONTACTSALDI" ADD CONSTRAINT "_SYSTEM"."_C834" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TBTWVAKKEN" ADD CONSTRAINT "_SYSTEM"."_C835" CHECK("CBTWVAKKEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWVAKKEN" ADD CONSTRAINT "_SYSTEM"."_C836" CHECK("CBTWVAK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWVAKKEN" ADD CONSTRAINT "_SYSTEM"."_C837" CHECK("CLANDBTW" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWVAKKEN" ADD CONSTRAINT "_SYSTEM"."_C838" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TBTWVAKKEN" ADD CONSTRAINT "_SYSTEM"."_C839" FOREIGN KEY("CALGEMENEREKENINGEN_FK") REFERENCES "_SYSTEM"."TALGEMENEREKENINGEN"("CALGEMENEREKENINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TBTWCODESPERVAK" ADD CONSTRAINT "_SYSTEM"."_C840" CHECK("CBTWCODESPERVAK_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWCODESPERVAK" ADD CONSTRAINT "_SYSTEM"."_C841" CHECK("CBTWVAK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWCODESPERVAK" ADD CONSTRAINT "_SYSTEM"."_C842" CHECK("CLANDBTW" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWCODESPERVAK" ADD CONSTRAINT "_SYSTEM"."_C843" CHECK("CBTWCODE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWCODESPERVAK" ADD CONSTRAINT "_SYSTEM"."_C844" CHECK("CBTWCODES_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWCODESPERVAK" ADD CONSTRAINT "_SYSTEM"."_C845" CHECK("CAANKOOP" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWCODESPERVAK" ADD CONSTRAINT "_SYSTEM"."_C846" CHECK("CAANKOOPBTW" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWCODESPERVAK" ADD CONSTRAINT "_SYSTEM"."_C847" CHECK("CAANKOOPCN" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWCODESPERVAK" ADD CONSTRAINT "_SYSTEM"."_C848" CHECK("CAANKOOPCNBTW" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWCODESPERVAK" ADD CONSTRAINT "_SYSTEM"."_C849" CHECK("CFINAANKOOP" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWCODESPERVAK" ADD CONSTRAINT "_SYSTEM"."_C850" CHECK("CFINAANKOOPBTW" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWCODESPERVAK" ADD CONSTRAINT "_SYSTEM"."_C851" CHECK("CFINVERKOOP" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWCODESPERVAK" ADD CONSTRAINT "_SYSTEM"."_C852" CHECK("CFINVERKOOPBTW" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWCODESPERVAK" ADD CONSTRAINT "_SYSTEM"."_C853" CHECK("CVERKOOP" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWCODESPERVAK" ADD CONSTRAINT "_SYSTEM"."_C854" CHECK("CVERKOOPBTW" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWCODESPERVAK" ADD CONSTRAINT "_SYSTEM"."_C855" CHECK("CVERKOOPCN" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWCODESPERVAK" ADD CONSTRAINT "_SYSTEM"."_C856" CHECK("CVERKOOPCNBTW" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWCODESPERVAK" ADD CONSTRAINT "_SYSTEM"."_C857" FOREIGN KEY("CBTWCODES_FK") REFERENCES "_SYSTEM"."TBTWCODES"("CBTWCODES_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TBOEKJAREN" ADD CONSTRAINT "_SYSTEM"."_C858" CHECK("CBOEKJAREN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBOEKJAREN" ADD CONSTRAINT "_SYSTEM"."_C859" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBOEKJAREN" ADD CONSTRAINT "_SYSTEM"."_C860" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBOEKJAREN" ADD CONSTRAINT "_SYSTEM"."_C861" CHECK("CBOEKJAAR" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBOEKJAREN" ADD CONSTRAINT "_SYSTEM"."_C862" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TKALENDERJAREN" ADD CONSTRAINT "_SYSTEM"."_C863" CHECK("CKALENDERJAREN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TKALENDERJAREN" ADD CONSTRAINT "_SYSTEM"."_C864" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TKALENDERJAREN" ADD CONSTRAINT "_SYSTEM"."_C865" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TKALENDERJAREN" ADD CONSTRAINT "_SYSTEM"."_C866" CHECK("CKALENDERJAAR" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TBTWPERIODEN" ADD CONSTRAINT "_SYSTEM"."_C867" CHECK("CBTWPERIODEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWPERIODEN" ADD CONSTRAINT "_SYSTEM"."_C868" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWPERIODEN" ADD CONSTRAINT "_SYSTEM"."_C869" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWPERIODEN" ADD CONSTRAINT "_SYSTEM"."_C870" CHECK("CBTWPERIODE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWPERIODEN" ADD CONSTRAINT "_SYSTEM"."_C871" CHECK("CKALENDERJAAR" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWPERIODEN" ADD CONSTRAINT "_SYSTEM"."_C872" CHECK("CKALENDERJAREN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWPERIODEN" ADD CONSTRAINT "_SYSTEM"."_C873" FOREIGN KEY("CKALENDERJAREN_FK") REFERENCES "_SYSTEM"."TKALENDERJAREN"("CKALENDERJAREN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TBTWPERIODEN" ADD CONSTRAINT "_SYSTEM"."_C874" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TBOEKPERIODEN" ADD CONSTRAINT "_SYSTEM"."_C875" CHECK("CBOEKPERIODEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBOEKPERIODEN" ADD CONSTRAINT "_SYSTEM"."_C876" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBOEKPERIODEN" ADD CONSTRAINT "_SYSTEM"."_C877" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBOEKPERIODEN" ADD CONSTRAINT "_SYSTEM"."_C878" CHECK("CBOEKJAAR" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBOEKPERIODEN" ADD CONSTRAINT "_SYSTEM"."_C879" CHECK("CBOEKJAREN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBOEKPERIODEN" ADD CONSTRAINT "_SYSTEM"."_C880" CHECK("CBOEKPERIODE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBOEKPERIODEN" ADD CONSTRAINT "_SYSTEM"."_C881" CHECK("CBTWPERIODEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBOEKPERIODEN" ADD CONSTRAINT "_SYSTEM"."_C882" FOREIGN KEY("CBOEKJAREN_FK") REFERENCES "_SYSTEM"."TBOEKJAREN"("CBOEKJAREN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TBOEKPERIODEN" ADD CONSTRAINT "_SYSTEM"."_C883" FOREIGN KEY("CBTWPERIODEN_FK") REFERENCES "_SYSTEM"."TBTWPERIODEN"("CBTWPERIODEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TBOEKPERIODEN" ADD CONSTRAINT "_SYSTEM"."_C884" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TINTRASTATAANGEVER" ADD CONSTRAINT "_SYSTEM"."_C885" CHECK("CINTRASTATAANGEVER_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TINTRASTATAANGEVER" ADD CONSTRAINT "_SYSTEM"."_C886" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TINTRASTATAANGEVER" ADD CONSTRAINT "_SYSTEM"."_C887" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TINTRASTATAANGEVER" ADD CONSTRAINT "_SYSTEM"."_C888" CHECK("CAANGIFTEAANKOMST" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TINTRASTATAANGEVER" ADD CONSTRAINT "_SYSTEM"."_C889" CHECK("CAANGIFTEVERZENDING" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TINTRASTATAANGEVER" ADD CONSTRAINT "_SYSTEM"."_C890" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TDAGBOEKEN" ADD CONSTRAINT "_SYSTEM"."_C891" CHECK("CDAGBOEKEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TDAGBOEKEN" ADD CONSTRAINT "_SYSTEM"."_C892" CHECK("CDAGBOEK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TDAGBOEKEN" ADD CONSTRAINT "_SYSTEM"."_C893" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TDAGBOEKEN" ADD CONSTRAINT "_SYSTEM"."_C894" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TDAGBOEKEN" ADD CONSTRAINT "_SYSTEM"."_C895" CHECK("CAUTONUMMER" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TDAGBOEKEN" ADD CONSTRAINT "_SYSTEM"."_C896" CHECK("CBANKCODE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TDAGBOEKEN" ADD CONSTRAINT "_SYSTEM"."_C897" CHECK("CBUITENLANDS" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TDAGBOEKEN" ADD CONSTRAINT "_SYSTEM"."_C898" FOREIGN KEY("CMUNTEN_FK") REFERENCES "_SYSTEM"."TMUNTEN"("CMUNTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TDAGBOEKEN" ADD CONSTRAINT "_SYSTEM"."_C899" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TDAGBOEKEN" ADD CONSTRAINT "_SYSTEM"."_C900" FOREIGN KEY("CALGEMENEREKENINGEN_FK") REFERENCES "_SYSTEM"."TALGEMENEREKENINGEN"("CALGEMENEREKENINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TDAGBOEKVOLGNR" ADD CONSTRAINT "_SYSTEM"."_C901" CHECK("CDAGBOEKVOLGNR_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TDAGBOEKVOLGNR" ADD CONSTRAINT "_SYSTEM"."_C902" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TDAGBOEKVOLGNR" ADD CONSTRAINT "_SYSTEM"."_C903" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TDAGBOEKVOLGNR" ADD CONSTRAINT "_SYSTEM"."_C904" CHECK("CBOEKJAAR" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TDAGBOEKVOLGNR" ADD CONSTRAINT "_SYSTEM"."_C905" CHECK("CBOEKJAREN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TDAGBOEKVOLGNR" ADD CONSTRAINT "_SYSTEM"."_C906" CHECK("CDAGBOEK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TDAGBOEKVOLGNR" ADD CONSTRAINT "_SYSTEM"."_C907" CHECK("CDAGBOEKEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TDAGBOEKVOLGNR" ADD CONSTRAINT "_SYSTEM"."_C908" CHECK("CVOLGNR" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TDAGBOEKVOLGNR" ADD CONSTRAINT "_SYSTEM"."_C909" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TDAGBOEKVOLGNR" ADD CONSTRAINT "_SYSTEM"."_C910" FOREIGN KEY("CDAGBOEKEN_FK") REFERENCES "_SYSTEM"."TDAGBOEKEN"("CDAGBOEKEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TDAGBOEKVOLGNR" ADD CONSTRAINT "_SYSTEM"."_C911" FOREIGN KEY("CBOEKJAREN_FK") REFERENCES "_SYSTEM"."TBOEKJAREN"("CBOEKJAREN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TTEKSTENRAPPEL" ADD CONSTRAINT "_SYSTEM"."_C912" CHECK("CTEKSTENRAPPEL_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TTEKSTENRAPPEL" ADD CONSTRAINT "_SYSTEM"."_C913" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TTEKSTENRAPPEL" ADD CONSTRAINT "_SYSTEM"."_C914" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TTEKSTENRAPPEL" ADD CONSTRAINT "_SYSTEM"."_C915" CHECK("CTEKSTRAPPEL" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TANALSLEUTELS" ADD CONSTRAINT "_SYSTEM"."_C916" CHECK("CANALSLEUTELS_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TANALSLEUTELS" ADD CONSTRAINT "_SYSTEM"."_C917" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TANALSLEUTELS" ADD CONSTRAINT "_SYSTEM"."_C918" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TANALSLEUTELS" ADD CONSTRAINT "_SYSTEM"."_C919" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TANALSLEUTELS" ADD CONSTRAINT "_SYSTEM"."_C920" FOREIGN KEY("CALGEMENEREKENINGEN_FK") REFERENCES "_SYSTEM"."TALGEMENEREKENINGEN"("CALGEMENEREKENINGEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TANALSLEUTELS" ADD CONSTRAINT "_SYSTEM"."_C921" FOREIGN KEY("CANALYTISCHEREKENINGEN_FK") REFERENCES "_SYSTEM"."TANALYTISCHEREKENINGEN"("CANALYTISCHEREKENINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TBOEKINGEN" ADD CONSTRAINT "_SYSTEM"."_C922" CHECK("CBOEKINGEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBOEKINGEN" ADD CONSTRAINT "_SYSTEM"."_C923" CHECK("CDAGBOEK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBOEKINGEN" ADD CONSTRAINT "_SYSTEM"."_C924" CHECK("CDAGBOEKEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBOEKINGEN" ADD CONSTRAINT "_SYSTEM"."_C925" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBOEKINGEN" ADD CONSTRAINT "_SYSTEM"."_C926" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBOEKINGEN" ADD CONSTRAINT "_SYSTEM"."_C927" CHECK("CBOEKJAAR" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBOEKINGEN" ADD CONSTRAINT "_SYSTEM"."_C928" CHECK("CBOEKJAREN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBOEKINGEN" ADD CONSTRAINT "_SYSTEM"."_C929" CHECK("CBOEKPERIODE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBOEKINGEN" ADD CONSTRAINT "_SYSTEM"."_C930" CHECK("CBOEKPERIODEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBOEKINGEN" ADD CONSTRAINT "_SYSTEM"."_C931" CHECK("CFOUTBTWTOEGELATEN" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBOEKINGEN" ADD CONSTRAINT "_SYSTEM"."_C932" CHECK("CREEDSOVERGEBOEKT" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBOEKINGEN" ADD CONSTRAINT "_SYSTEM"."_C933" CHECK("CVOLGNR" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBOEKINGEN" ADD CONSTRAINT "_SYSTEM"."_C934" FOREIGN KEY("CMUNTEN_FK") REFERENCES "_SYSTEM"."TMUNTEN"("CMUNTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TBOEKINGEN" ADD CONSTRAINT "_SYSTEM"."_C935" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TBOEKINGEN" ADD CONSTRAINT "_SYSTEM"."_C936" FOREIGN KEY("CDAGBOEKEN_FK") REFERENCES "_SYSTEM"."TDAGBOEKEN"("CDAGBOEKEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TBOEKINGEN" ADD CONSTRAINT "_SYSTEM"."_C937" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TBOEKINGEN" ADD CONSTRAINT "_SYSTEM"."_C938" FOREIGN KEY("CBOEKPERIODEN_FK") REFERENCES "_SYSTEM"."TBOEKPERIODEN"("CBOEKPERIODEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TBOEKINGEN" ADD CONSTRAINT "_SYSTEM"."_C939" FOREIGN KEY("CBOEKJAREN_FK") REFERENCES "_SYSTEM"."TBOEKJAREN"("CBOEKJAREN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TBOEKINGEN" ADD CONSTRAINT "_SYSTEM"."_C940" FOREIGN KEY("CBETALINGSVOORWAARDEN_FK") REFERENCES "_SYSTEM"."TBETALINGSVOORWAARDEN"("CBETALINGSVOORWAARDEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TBOEKINGHISTORIEK" ADD CONSTRAINT "_SYSTEM"."_C941" CHECK("CBOEKINGHISTORIEK_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBOEKINGHISTORIEK" ADD CONSTRAINT "_SYSTEM"."_C942" CHECK("CBOEKINGEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBOEKINGHISTORIEK" ADD CONSTRAINT "_SYSTEM"."_C943" CHECK("CTYPE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBOEKINGHISTORIEK" ADD CONSTRAINT "_SYSTEM"."_C944" CHECK("CSOORT" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBOEKINGHISTORIEK" ADD CONSTRAINT "_SYSTEM"."_C945" CHECK("CAFGEPUNT" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBOEKINGHISTORIEK" ADD CONSTRAINT "_SYSTEM"."_C946" CHECK("CALGEMENEREKENING" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBOEKINGHISTORIEK" ADD CONSTRAINT "_SYSTEM"."_C947" CHECK("CALGEMENEREKENINGEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBOEKINGHISTORIEK" ADD CONSTRAINT "_SYSTEM"."_C948" CHECK("CREEDSBETAALD" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBOEKINGHISTORIEK" ADD CONSTRAINT "_SYSTEM"."_C949" CHECK("CTEKSTRAPPEL" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBOEKINGHISTORIEK" ADD CONSTRAINT "_SYSTEM"."_C950" FOREIGN KEY("CMUNTEN_FK") REFERENCES "_SYSTEM"."TMUNTEN"("CMUNTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TBOEKINGHISTORIEK" ADD CONSTRAINT "_SYSTEM"."_C951" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TBOEKINGHISTORIEK" ADD CONSTRAINT "_SYSTEM"."_C952" FOREIGN KEY("CBOEKINGEN_FK") REFERENCES "_SYSTEM"."TBOEKINGEN"("CBOEKINGEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TBOEKINGHISTORIEK" ADD CONSTRAINT "_SYSTEM"."_C953" FOREIGN KEY("CANALYTISCHEREKENINGEN_FK") REFERENCES "_SYSTEM"."TANALYTISCHEREKENINGEN"("CANALYTISCHEREKENINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TBOEKINGHISTORIEK" ADD CONSTRAINT "_SYSTEM"."_C954" FOREIGN KEY("CALGEMENEREKENINGEN_FK") REFERENCES "_SYSTEM"."TALGEMENEREKENINGEN"("CALGEMENEREKENINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TBOEKINGHISTORIEK" ADD CONSTRAINT "_SYSTEM"."_C7336" FOREIGN KEY("CDOMMANDATEN_FK") REFERENCES "_SYSTEM"."TDOMMANDATEN"("CDOMMANDATEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TBOEKINGBTW" ADD CONSTRAINT "_SYSTEM"."_C955" CHECK("CBOEKINGBTW_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBOEKINGBTW" ADD CONSTRAINT "_SYSTEM"."_C956" CHECK("CBOEKINGEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBOEKINGBTW" ADD CONSTRAINT "_SYSTEM"."_C957" FOREIGN KEY("CBOEKINGEN_FK") REFERENCES "_SYSTEM"."TBOEKINGEN"("CBOEKINGEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TBOEKINGINTRASTAT" ADD CONSTRAINT "_SYSTEM"."_C958" CHECK("CBOEKINGINTRASTAT_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBOEKINGINTRASTAT" ADD CONSTRAINT "_SYSTEM"."_C959" CHECK("CBOEKINGEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBOEKINGINTRASTAT" ADD CONSTRAINT "_SYSTEM"."_C960" CHECK("CSOORT" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBOEKINGINTRASTAT" ADD CONSTRAINT "_SYSTEM"."_C961" FOREIGN KEY("CGNCODES_FK") REFERENCES "_SYSTEM"."TGNCODES"("CGNCODES_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TBOEKINGINTRASTAT" ADD CONSTRAINT "_SYSTEM"."_C962" FOREIGN KEY("CBOEKINGEN_FK") REFERENCES "_SYSTEM"."TBOEKINGEN"("CBOEKINGEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C963" CHECK("CCENTRALISATIE_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C964" CHECK("CDAGBOEK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C965" CHECK("CDAGBOEKEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C966" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C967" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C968" CHECK("CALGEMENEREKENING" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C969" CHECK("CALGEMENEREKENINGEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C970" CHECK("CBOEKJAAR" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C971" CHECK("CBOEKJAREN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C972" CHECK("CBOEKPERIODE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C973" CHECK("CBOEKPERIODEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C974" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C975" FOREIGN KEY("CDAGBOEKEN_FK") REFERENCES "_SYSTEM"."TDAGBOEKEN"("CDAGBOEKEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C976" FOREIGN KEY("CBOEKPERIODEN_FK") REFERENCES "_SYSTEM"."TBOEKPERIODEN"("CBOEKPERIODEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C977" FOREIGN KEY("CBOEKJAREN_FK") REFERENCES "_SYSTEM"."TBOEKJAREN"("CBOEKJAREN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C978" FOREIGN KEY("CALGEMENEREKENINGEN_FK") REFERENCES "_SYSTEM"."TALGEMENEREKENINGEN"("CALGEMENEREKENINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C979" CHECK("CBEDRAGCREDITREF" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C980" CHECK("CBEDRAGDEBETREF" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TANALCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C981" CHECK("CBEDRAGCREDITREF" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TANALCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C982" CHECK("CBEDRAGDEBETREF" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TANALCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C983" CHECK("CANALCENTRALISATIE_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TANALCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C984" CHECK("CDAGBOEK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TANALCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C985" CHECK("CDAGBOEKEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TANALCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C986" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TANALCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C987" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TANALCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C988" CHECK("CALGEMENEREKENING" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TANALCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C989" CHECK("CALGEMENEREKENINGEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TANALCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C8713" CHECK("CANALYTISCHEREKENING" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TANALCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C991" CHECK("CANALYTISCHEREKENINGEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TANALCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C992" CHECK("CBOEKJAAR" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TANALCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C993" CHECK("CBOEKJAREN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TANALCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C994" CHECK("CBOEKPERIODE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TANALCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C995" CHECK("CBOEKPERIODEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TANALCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C996" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TANALCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C997" FOREIGN KEY("CDAGBOEKEN_FK") REFERENCES "_SYSTEM"."TDAGBOEKEN"("CDAGBOEKEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TANALCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C998" FOREIGN KEY("CBOEKPERIODEN_FK") REFERENCES "_SYSTEM"."TBOEKPERIODEN"("CBOEKPERIODEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TANALCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C999" FOREIGN KEY("CBOEKJAREN_FK") REFERENCES "_SYSTEM"."TBOEKJAREN"("CBOEKJAREN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TANALCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C1000" FOREIGN KEY("CANALYTISCHEREKENINGEN_FK") REFERENCES "_SYSTEM"."TANALYTISCHEREKENINGEN"("CANALYTISCHEREKENINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TANALCENTRALISATIE" ADD CONSTRAINT "_SYSTEM"."_C1001" FOREIGN KEY("CALGEMENEREKENINGEN_FK") REFERENCES "_SYSTEM"."TALGEMENEREKENINGEN"("CALGEMENEREKENINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCENTRALISATIEOMZETTEN" ADD CONSTRAINT "_SYSTEM"."_C1002" CHECK("CCENTRALISATIEOMZETTEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCENTRALISATIEOMZETTEN" ADD CONSTRAINT "_SYSTEM"."_C1003" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCENTRALISATIEOMZETTEN" ADD CONSTRAINT "_SYSTEM"."_C1004" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCENTRALISATIEOMZETTEN" ADD CONSTRAINT "_SYSTEM"."_C1005" CHECK("CTYPE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCENTRALISATIEOMZETTEN" ADD CONSTRAINT "_SYSTEM"."_C1006" CHECK("CBEDRAGCREDITREF" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCENTRALISATIEOMZETTEN" ADD CONSTRAINT "_SYSTEM"."_C1007" CHECK("CBEDRAGDEBETREF" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCENTRALISATIEOMZETTEN" ADD CONSTRAINT "_SYSTEM"."_C1008" CHECK("CBEDRAGBTWREF" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCENTRALISATIEOMZETTEN" ADD CONSTRAINT "_SYSTEM"."_C1009" CHECK("CBEDRAG" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCENTRALISATIEOMZETTEN" ADD CONSTRAINT "_SYSTEM"."_C1010" CHECK("CBOEKJAAR" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCENTRALISATIEOMZETTEN" ADD CONSTRAINT "_SYSTEM"."_C1011" CHECK("CBOEKJAREN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCENTRALISATIEOMZETTEN" ADD CONSTRAINT "_SYSTEM"."_C1012" CHECK("CBOEKPERIODE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCENTRALISATIEOMZETTEN" ADD CONSTRAINT "_SYSTEM"."_C1013" CHECK("CBOEKPERIODEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCENTRALISATIEOMZETTEN" ADD CONSTRAINT "_SYSTEM"."_C1014" CHECK("CCONTACTEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCENTRALISATIEOMZETTEN" ADD CONSTRAINT "_SYSTEM"."_C1015" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCENTRALISATIEOMZETTEN" ADD CONSTRAINT "_SYSTEM"."_C1016" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCENTRALISATIEOMZETTEN" ADD CONSTRAINT "_SYSTEM"."_C1017" FOREIGN KEY("CBOEKPERIODEN_FK") REFERENCES "_SYSTEM"."TBOEKPERIODEN"("CBOEKPERIODEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCENTRALISATIEOMZETTEN" ADD CONSTRAINT "_SYSTEM"."_C1018" FOREIGN KEY("CBOEKJAREN_FK") REFERENCES "_SYSTEM"."TBOEKJAREN"("CBOEKJAREN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TAFSCHRIJVINGEN" ADD CONSTRAINT "_SYSTEM"."_C1019" CHECK("CAFSCHRIJVINGEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TAFSCHRIJVINGEN" ADD CONSTRAINT "_SYSTEM"."_C1020" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TAFSCHRIJVINGEN" ADD CONSTRAINT "_SYSTEM"."_C1021" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TAFSCHRIJVINGEN" ADD CONSTRAINT "_SYSTEM"."_C1022" CHECK("CAFSCHRIJVINGDEGRESSIEF" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TAFSCHRIJVINGEN" ADD CONSTRAINT "_SYSTEM"."_C1023" CHECK("CAFSCHRIJVINGSOORT" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TAFSCHRIJVINGEN" ADD CONSTRAINT "_SYSTEM"."_C1024" CHECK("CALGEMENEREKENINGENINVEST_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TAFSCHRIJVINGEN" ADD CONSTRAINT "_SYSTEM"."_C1025" CHECK("CALGEMENEREKENINGINVEST" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TAFSCHRIJVINGEN" ADD CONSTRAINT "_SYSTEM"."_C1026" CHECK("CBOEKJAAR" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TAFSCHRIJVINGEN" ADD CONSTRAINT "_SYSTEM"."_C1027" CHECK("CBOEKJAARAANSCHAF" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TAFSCHRIJVINGEN" ADD CONSTRAINT "_SYSTEM"."_C1028" CHECK("CBOEKJAREN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TAFSCHRIJVINGEN" ADD CONSTRAINT "_SYSTEM"."_C1029" CHECK("CVERWIJDERD" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TAFSCHRIJVINGEN" ADD CONSTRAINT "_SYSTEM"."_C1030" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TAFSCHRIJVINGEN" ADD CONSTRAINT "_SYSTEM"."_C1031" FOREIGN KEY("CBOEKJAREN_FK") REFERENCES "_SYSTEM"."TBOEKJAREN"("CBOEKJAREN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TAFSCHRIJVINGEN" ADD CONSTRAINT "_SYSTEM"."_C1032" FOREIGN KEY("CBOEKINGEN_FK") REFERENCES "_SYSTEM"."TBOEKINGEN"("CBOEKINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TAFSCHRIJVINGEN" ADD CONSTRAINT "_SYSTEM"."_C1033" FOREIGN KEY("CALGEMENEREKENINGENINVEST_FK") REFERENCES "_SYSTEM"."TALGEMENEREKENINGEN"("CALGEMENEREKENINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TAFSCHRIJVINGEN" ADD CONSTRAINT "_SYSTEM"."_C1034" FOREIGN KEY("CALGEMENEREKENINGENAFSCHR_FK") REFERENCES "_SYSTEM"."TALGEMENEREKENINGEN"("CALGEMENEREKENINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TAFSCHRIJVINGEN" ADD CONSTRAINT "_SYSTEM"."_C1035" FOREIGN KEY("CALGEMENEREKENINGENKOST_FK") REFERENCES "_SYSTEM"."TALGEMENEREKENINGEN"("CALGEMENEREKENINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TFICHE28150" ADD CONSTRAINT "_SYSTEM"."_C1036" CHECK("CFICHE28150_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TFICHE28150" ADD CONSTRAINT "_SYSTEM"."_C1037" CHECK("CCONTACT" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TFICHE28150" ADD CONSTRAINT "_SYSTEM"."_C1038" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TFICHE28150" ADD CONSTRAINT "_SYSTEM"."_C1039" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TFICHE28150" ADD CONSTRAINT "_SYSTEM"."_C1040" CHECK("CKALENDERJAAR" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TFICHE28150" ADD CONSTRAINT "_SYSTEM"."_C1041" CHECK("CKALENDERJAREN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TFICHE28150" ADD CONSTRAINT "_SYSTEM"."_C1042" CHECK("CVOLGNR" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TFICHE28150" ADD CONSTRAINT "_SYSTEM"."_C1043" FOREIGN KEY("CKALENDERJAREN_FK") REFERENCES "_SYSTEM"."TKALENDERJAREN"("CKALENDERJAREN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TFICHE28150" ADD CONSTRAINT "_SYSTEM"."_C1044" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TFICHE28150" ADD CONSTRAINT "_SYSTEM"."_C1045" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TFICHE28150" ADD CONSTRAINT "_SYSTEM"."_C3747" FOREIGN KEY("CBOEKINGEN_FK") REFERENCES "_SYSTEM"."TBOEKINGEN"("CBOEKINGEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TBUDGETTEN" ADD CONSTRAINT "_SYSTEM"."_C1047" CHECK("CBUDGETTEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBUDGETTEN" ADD CONSTRAINT "_SYSTEM"."_C1048" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBUDGETTEN" ADD CONSTRAINT "_SYSTEM"."_C1049" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBUDGETTEN" ADD CONSTRAINT "_SYSTEM"."_C1050" CHECK("CALGEMENEREKENING" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBUDGETTEN" ADD CONSTRAINT "_SYSTEM"."_C1051" CHECK("CALGEMENEREKENINGEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBUDGETTEN" ADD CONSTRAINT "_SYSTEM"."_C1052" CHECK("CBOEKJAAR" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBUDGETTEN" ADD CONSTRAINT "_SYSTEM"."_C1053" CHECK("CBOEKJAREN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBUDGETTEN" ADD CONSTRAINT "_SYSTEM"."_C1054" CHECK("CBOEKPERIODE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBUDGETTEN" ADD CONSTRAINT "_SYSTEM"."_C1055" CHECK("CBOEKPERIODEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBUDGETTEN" ADD CONSTRAINT "_SYSTEM"."_C1056" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TBUDGETTEN" ADD CONSTRAINT "_SYSTEM"."_C1057" FOREIGN KEY("CBOEKPERIODEN_FK") REFERENCES "_SYSTEM"."TBOEKPERIODEN"("CBOEKPERIODEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TBUDGETTEN" ADD CONSTRAINT "_SYSTEM"."_C1058" FOREIGN KEY("CBOEKJAREN_FK") REFERENCES "_SYSTEM"."TBOEKJAREN"("CBOEKJAREN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TBUDGETTEN" ADD CONSTRAINT "_SYSTEM"."_C1059" FOREIGN KEY("CALGEMENEREKENINGEN_FK") REFERENCES "_SYSTEM"."TALGEMENEREKENINGEN"("CALGEMENEREKENINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TBUDGETTEN" ADD CONSTRAINT "_SYSTEM"."_C1060" CHECK("CBEDRAGCREDITREF" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBUDGETTEN" ADD CONSTRAINT "_SYSTEM"."_C1061" CHECK("CBEDRAGDEBETREF" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TANALBUDGETTEN" ADD CONSTRAINT "_SYSTEM"."_C8711" CHECK("CANALYTISCHEREKENING" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TANALBUDGETTEN" ADD CONSTRAINT "_SYSTEM"."_C1062" CHECK("CBEDRAGCREDITREF" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TANALBUDGETTEN" ADD CONSTRAINT "_SYSTEM"."_C1063" CHECK("CBEDRAGDEBETREF" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TANALBUDGETTEN" ADD CONSTRAINT "_SYSTEM"."_C1064" CHECK("CANALBUDGETTEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TANALBUDGETTEN" ADD CONSTRAINT "_SYSTEM"."_C1065" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TANALBUDGETTEN" ADD CONSTRAINT "_SYSTEM"."_C1066" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TANALBUDGETTEN" ADD CONSTRAINT "_SYSTEM"."_C1067" CHECK("CALGEMENEREKENING" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TANALBUDGETTEN" ADD CONSTRAINT "_SYSTEM"."_C1068" CHECK("CALGEMENEREKENINGEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TANALBUDGETTEN" ADD CONSTRAINT "_SYSTEM"."_C1070" CHECK("CANALYTISCHEREKENINGEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TANALBUDGETTEN" ADD CONSTRAINT "_SYSTEM"."_C1071" CHECK("CBOEKJAAR" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TANALBUDGETTEN" ADD CONSTRAINT "_SYSTEM"."_C1072" CHECK("CBOEKJAREN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TANALBUDGETTEN" ADD CONSTRAINT "_SYSTEM"."_C1073" CHECK("CBOEKPERIODE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TANALBUDGETTEN" ADD CONSTRAINT "_SYSTEM"."_C1074" CHECK("CBOEKPERIODEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TANALBUDGETTEN" ADD CONSTRAINT "_SYSTEM"."_C1075" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TANALBUDGETTEN" ADD CONSTRAINT "_SYSTEM"."_C1076" FOREIGN KEY("CBOEKPERIODEN_FK") REFERENCES "_SYSTEM"."TBOEKPERIODEN"("CBOEKPERIODEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TANALBUDGETTEN" ADD CONSTRAINT "_SYSTEM"."_C1077" FOREIGN KEY("CBOEKJAREN_FK") REFERENCES "_SYSTEM"."TBOEKJAREN"("CBOEKJAREN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TANALBUDGETTEN" ADD CONSTRAINT "_SYSTEM"."_C1078" FOREIGN KEY("CANALYTISCHEREKENINGEN_FK") REFERENCES "_SYSTEM"."TANALYTISCHEREKENINGEN"("CANALYTISCHEREKENINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TANALBUDGETTEN" ADD CONSTRAINT "_SYSTEM"."_C1079" FOREIGN KEY("CALGEMENEREKENINGEN_FK") REFERENCES "_SYSTEM"."TALGEMENEREKENINGEN"("CALGEMENEREKENINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TBTWAANGIFTENBE" ADD CONSTRAINT "_SYSTEM"."_C1080" CHECK("CBTWAANGIFTENBE_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWAANGIFTENBE" ADD CONSTRAINT "_SYSTEM"."_C1081" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWAANGIFTENBE" ADD CONSTRAINT "_SYSTEM"."_C1082" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWAANGIFTENBE" ADD CONSTRAINT "_SYSTEM"."_C1083" CHECK("CAANVRAAGBETAALFORM" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWAANGIFTENBE" ADD CONSTRAINT "_SYSTEM"."_C1084" CHECK("CAANVRAAGTERUGBETALING" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWAANGIFTENBE" ADD CONSTRAINT "_SYSTEM"."_C1085" CHECK("CBTWPERIODE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWAANGIFTENBE" ADD CONSTRAINT "_SYSTEM"."_C1086" CHECK("CBTWPERIODEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWAANGIFTENBE" ADD CONSTRAINT "_SYSTEM"."_C1087" CHECK("CKALENDERJAAR" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWAANGIFTENBE" ADD CONSTRAINT "_SYSTEM"."_C1088" CHECK("CKALENDERJAREN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBTWAANGIFTENBE" ADD CONSTRAINT "_SYSTEM"."_C1089" FOREIGN KEY("CKALENDERJAREN_FK") REFERENCES "_SYSTEM"."TKALENDERJAREN"("CKALENDERJAREN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TBTWAANGIFTENBE" ADD CONSTRAINT "_SYSTEM"."_C1090" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TBTWAANGIFTENBE" ADD CONSTRAINT "_SYSTEM"."_C1091" FOREIGN KEY("CBTWPERIODEN_FK") REFERENCES "_SYSTEM"."TBTWPERIODEN"("CBTWPERIODEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TSTRUCTUREN" ADD CONSTRAINT "_SYSTEM"."_C1092" CHECK("CSTRUCTUUR" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSTRUCTUREN" ADD CONSTRAINT "_SYSTEM"."_C1093" CHECK("CTAAL" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSTRUCTUREN" ADD CONSTRAINT "_SYSTEM"."_C1094" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TSTRUCTUURDETAILS" ADD CONSTRAINT "_SYSTEM"."_C1095" CHECK("CTITEL1" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSTRUCTUURDETAILS" ADD CONSTRAINT "_SYSTEM"."_C1096" FOREIGN KEY("CSTRUCTUREN_FK") REFERENCES "_SYSTEM"."TSTRUCTUREN"("CSTRUCTUREN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TSERVICE" ADD CONSTRAINT "_SYSTEM"."_C1097" CHECK("CSERVICE_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICE" ADD CONSTRAINT "_SYSTEM"."_C1098" CHECK("CDOCUMENTTYPE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICE" ADD CONSTRAINT "_SYSTEM"."_C1099" CHECK("CDOCUMENTTYPES_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICE" ADD CONSTRAINT "_SYSTEM"."_C1100" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICE" ADD CONSTRAINT "_SYSTEM"."_C1101" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICE" ADD CONSTRAINT "_SYSTEM"."_C1102" CHECK("CINTERNEFIRMAVESTIGING" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICE" ADD CONSTRAINT "_SYSTEM"."_C1103" CHECK("CINTERNEFIRMAVESTIGINGEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICE" ADD CONSTRAINT "_SYSTEM"."_C1104" CHECK("CNUMMER" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICE" ADD CONSTRAINT "_SYSTEM"."_C1105" CHECK("CAFGESLOTEN" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICE" ADD CONSTRAINT "_SYSTEM"."_C1106" CHECK("CCONTACTEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICE" ADD CONSTRAINT "_SYSTEM"."_C1107" CHECK("CGEPLAND" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICE" ADD CONSTRAINT "_SYSTEM"."_C1108" CHECK("CGEPRINT" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICE" ADD CONSTRAINT "_SYSTEM"."_C1109" CHECK("CINCLBTW" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICE" ADD CONSTRAINT "_SYSTEM"."_C1118" FOREIGN KEY("CTRANSPORTEURS_FK") REFERENCES "_SYSTEM"."TTRANSPORTEURS"("CTRANSPORTEURS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICE" ADD CONSTRAINT "_SYSTEM"."_C1119" FOREIGN KEY("CTARIEVEN_FK") REFERENCES "_SYSTEM"."TTARIEVEN"("CTARIEVEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICE" ADD CONSTRAINT "_SYSTEM"."_C1120" FOREIGN KEY("CMUNTEN_FK") REFERENCES "_SYSTEM"."TMUNTEN"("CMUNTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICE" ADD CONSTRAINT "_SYSTEM"."_C1121" FOREIGN KEY("CVERTEGENWOORDIGERS_FK") REFERENCES "_SYSTEM"."TMEDEWERKERS"("CMEDEWERKERS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICE" ADD CONSTRAINT "_SYSTEM"."_C1122" FOREIGN KEY("CMEDEWERKERS_FK") REFERENCES "_SYSTEM"."TMEDEWERKERS"("CMEDEWERKERS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICE" ADD CONSTRAINT "_SYSTEM"."_C1123" FOREIGN KEY("CMATENBALKEN_FK") REFERENCES "_SYSTEM"."TMATENBALKEN"("CMATENBALKEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICE" ADD CONSTRAINT "_SYSTEM"."_C1124" FOREIGN KEY("CLEVERINGSVOORWAARDEN_FK") REFERENCES "_SYSTEM"."TLEVERINGSVOORWAARDEN"("CLEVERINGSVOORWAARDEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICE" ADD CONSTRAINT "_SYSTEM"."_C1125" FOREIGN KEY("CKLEURENKAARTEN_FK") REFERENCES "_SYSTEM"."TKLEURENKAARTEN"("CKLEURENKAARTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICE" ADD CONSTRAINT "_SYSTEM"."_C1126" FOREIGN KEY("CINTERNEFIRMAVESTIGINGEN_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN"("CINTERNEFIRMAVESTIGINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICE" ADD CONSTRAINT "_SYSTEM"."_C1127" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICE" ADD CONSTRAINT "_SYSTEM"."_C1128" FOREIGN KEY("CDOCUMENTTYPES_FK") REFERENCES "_SYSTEM"."TDOCUMENTTYPES"("CDOCUMENTTYPES_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICE" ADD CONSTRAINT "_SYSTEM"."_C1129" FOREIGN KEY("CCONTACTPERSONEN_FK") REFERENCES "_SYSTEM"."TCONTACTPERSONEN"("CCONTACTPERSONEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICE" ADD CONSTRAINT "_SYSTEM"."_C1130" FOREIGN KEY("CLEVERANCIERS_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICE" ADD CONSTRAINT "_SYSTEM"."_C1131" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICE" ADD CONSTRAINT "_SYSTEM"."_C1132" FOREIGN KEY("CBETALINGSVOORWAARDEN_FK") REFERENCES "_SYSTEM"."TBETALINGSVOORWAARDEN"("CBETALINGSVOORWAARDEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICE" ADD CONSTRAINT "_SYSTEM"."_C1134" FOREIGN KEY("CVERVANGARTIKELS_FK") REFERENCES "_SYSTEM"."TARTIKELS"("CARTIKELS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICE" ADD CONSTRAINT "_SYSTEM"."_C1135" FOREIGN KEY("CCONTACTADRESSEN_FK") REFERENCES "_SYSTEM"."TCONTACTADRESSEN"("CCONTACTADRESSEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICE" ADD CONSTRAINT "_SYSTEM"."_C8725" FOREIGN KEY("CCONTACTPERSONENSERVICE_FK") REFERENCES "_SYSTEM"."TCONTACTPERSONEN"("CCONTACTPERSONEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TSERVICEBETALINGEN" ADD CONSTRAINT "_SYSTEM"."_C1136" CHECK("CSERVICEBETALINGEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICEBETALINGEN" ADD CONSTRAINT "_SYSTEM"."_C1137" CHECK("CSERVICE_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICEBETALINGEN" ADD CONSTRAINT "_SYSTEM"."_C1138" CHECK("CCASH" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICEBETALINGEN" ADD CONSTRAINT "_SYSTEM"."_C1139" CHECK("CVERWERKT" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICEBETALINGEN" ADD CONSTRAINT "_SYSTEM"."_C1140" FOREIGN KEY("CSERVICE_FK") REFERENCES "_SYSTEM"."TSERVICE"("CSERVICE_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICEBETALINGEN" ADD CONSTRAINT "_SYSTEM"."_C1141" FOREIGN KEY("CMUNTEN_FK") REFERENCES "_SYSTEM"."TMUNTEN"("CMUNTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICEBETALINGEN" ADD CONSTRAINT "_SYSTEM"."_C1142" FOREIGN KEY("CKASSAAFSL_FK") REFERENCES "_SYSTEM"."TKASSAAFSL"("CKASSAAFSL_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TSERVICEHISTORIEK" ADD CONSTRAINT "_SYSTEM"."_C1143" CHECK("CSERVICEHISTORIEK_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICEHISTORIEK" ADD CONSTRAINT "_SYSTEM"."_C1144" CHECK("CSERVICE_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICEHISTORIEK" ADD CONSTRAINT "_SYSTEM"."_C1145" FOREIGN KEY("CSERVICE_FK") REFERENCES "_SYSTEM"."TSERVICE"("CSERVICE_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TSERVICELIJNEN" ADD CONSTRAINT "_SYSTEM"."_C1146" CHECK("CSERVICELIJNEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICELIJNEN" ADD CONSTRAINT "_SYSTEM"."_C1147" CHECK("CSERVICE_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICELIJNEN" ADD CONSTRAINT "_SYSTEM"."_C1148" CHECK("CBTWCODE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICELIJNEN" ADD CONSTRAINT "_SYSTEM"."_C1149" CHECK("CGEENKORTINGEN" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICELIJNEN" ADD CONSTRAINT "_SYSTEM"."_C1150" CHECK("CINCLBTW" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICELIJNEN" ADD CONSTRAINT "_SYSTEM"."_C1151" CHECK("CMETKOPPELARTIKELEN" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICELIJNEN" ADD CONSTRAINT "_SYSTEM"."_C1152" CHECK("CMETLOTNUMMERS" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICELIJNEN" ADD CONSTRAINT "_SYSTEM"."_C1153" CHECK("CMETSERIENUMMERS" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICELIJNEN" ADD CONSTRAINT "_SYSTEM"."_C1154" CHECK("CMETTITEL" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICELIJNEN" ADD CONSTRAINT "_SYSTEM"."_C1155" CHECK("CMETVOORRAAD" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICELIJNEN" ADD CONSTRAINT "_SYSTEM"."_C1156" CHECK("CSTATUS" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICELIJNEN" ADD CONSTRAINT "_SYSTEM"."_C1157" FOREIGN KEY("CTARIEVEN_FK") REFERENCES "_SYSTEM"."TTARIEVEN"("CTARIEVEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICELIJNEN" ADD CONSTRAINT "_SYSTEM"."_C1158" FOREIGN KEY("CSERVICE_FK") REFERENCES "_SYSTEM"."TSERVICE"("CSERVICE_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICELIJNEN" ADD CONSTRAINT "_SYSTEM"."_C1159" FOREIGN KEY("CMATENBALKEN_FK") REFERENCES "_SYSTEM"."TMATENBALKEN"("CMATENBALKEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICELIJNEN" ADD CONSTRAINT "_SYSTEM"."_C1160" FOREIGN KEY("CKLEURENKAARTEN_FK") REFERENCES "_SYSTEM"."TKLEURENKAARTEN"("CKLEURENKAARTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICELIJNEN" ADD CONSTRAINT "_SYSTEM"."_C1161" FOREIGN KEY("CGNCODES_FK") REFERENCES "_SYSTEM"."TGNCODES"("CGNCODES_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICELIJNEN" ADD CONSTRAINT "_SYSTEM"."_C1162" FOREIGN KEY("CARTIKELS_FK") REFERENCES "_SYSTEM"."TARTIKELS"("CARTIKELS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICELIJNEN" ADD CONSTRAINT "_SYSTEM"."_C1163" FOREIGN KEY("CANALYTISCHEREKENINGEN_FK") REFERENCES "_SYSTEM"."TANALYTISCHEREKENINGEN"("CANALYTISCHEREKENINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICELIJNEN" ADD CONSTRAINT "_SYSTEM"."_C1164" FOREIGN KEY("CALGEMENEREKENINGEN_FK") REFERENCES "_SYSTEM"."TALGEMENEREKENINGEN"("CALGEMENEREKENINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TSERVICELIJNSERIENUMMERS" ADD CONSTRAINT "_SYSTEM"."_C1165" CHECK("CSERVICELIJNSERIENUMMERS_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICELIJNSERIENUMMERS" ADD CONSTRAINT "_SYSTEM"."_C1166" CHECK("CSERVICELIJNEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICELIJNSERIENUMMERS" ADD CONSTRAINT "_SYSTEM"."_C1167" CHECK("CSERIENUMMER" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICELIJNSERIENUMMERS" ADD CONSTRAINT "_SYSTEM"."_C1168" FOREIGN KEY("CSERVICELIJNEN_FK") REFERENCES "_SYSTEM"."TSERVICELIJNEN"("CSERVICELIJNEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TSERVICESTATUSSEN" ADD CONSTRAINT "_SYSTEM"."_C1169" CHECK("CSERVICESTATUSSEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICESTATUSSEN" ADD CONSTRAINT "_SYSTEM"."_C1170" CHECK("CDOCUMENTTYPE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICESTATUSSEN" ADD CONSTRAINT "_SYSTEM"."_C1171" CHECK("CDOCUMENTTYPES_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICESTATUSSEN" ADD CONSTRAINT "_SYSTEM"."_C1172" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICESTATUSSEN" ADD CONSTRAINT "_SYSTEM"."_C1173" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICESTATUSSEN" ADD CONSTRAINT "_SYSTEM"."_C1174" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TSERVICESTATUSSEN" ADD CONSTRAINT "_SYSTEM"."_C1175" FOREIGN KEY("CDOCUMENTTYPES_FK") REFERENCES "_SYSTEM"."TDOCUMENTTYPES"("CDOCUMENTTYPES_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TKASSAUITGAVEN" ADD CONSTRAINT "_SYSTEM"."_C1176" CHECK("CKASSAUITGAVEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TKASSAUITGAVEN" ADD CONSTRAINT "_SYSTEM"."_C1177" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TKASSAUITGAVEN" ADD CONSTRAINT "_SYSTEM"."_C1178" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TKASSAUITGAVEN" ADD CONSTRAINT "_SYSTEM"."_C1179" CHECK("CINTERNEFIRMAVESTIGING" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TKASSAUITGAVEN" ADD CONSTRAINT "_SYSTEM"."_C1180" CHECK("CINTERNEFIRMAVESTIGINGEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TKASSAUITGAVEN" ADD CONSTRAINT "_SYSTEM"."_C1181" CHECK("CVERWERKT" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TKASSAUITGAVEN" ADD CONSTRAINT "_SYSTEM"."_C1182" FOREIGN KEY("CINTERNEFIRMAVESTIGINGEN_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN"("CINTERNEFIRMAVESTIGINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TKASSAUITGAVEN" ADD CONSTRAINT "_SYSTEM"."_C1183" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TKASSAUITGAVEN" ADD CONSTRAINT "_SYSTEM"."_C1184" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TKASSAUITGAVEN" ADD CONSTRAINT "_SYSTEM"."_C1185" FOREIGN KEY("CKASSAAFSL_FK") REFERENCES "_SYSTEM"."TKASSAAFSL"("CKASSAAFSL_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TKASSAUITGAVEN" ADD CONSTRAINT "_SYSTEM"."_C11706" FOREIGN KEY("CALGEMENEREKENINGEN_FK") REFERENCES "_SYSTEM"."TALGEMENEREKENINGEN"("CALGEMENEREKENINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TFACTUREN" ADD CONSTRAINT "_SYSTEM"."_C1186" CHECK("CFACTUREN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TFACTUREN" ADD CONSTRAINT "_SYSTEM"."_C1187" CHECK("CDAGBOEK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TFACTUREN" ADD CONSTRAINT "_SYSTEM"."_C1188" CHECK("CDAGBOEKEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TFACTUREN" ADD CONSTRAINT "_SYSTEM"."_C1189" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TFACTUREN" ADD CONSTRAINT "_SYSTEM"."_C1190" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TFACTUREN" ADD CONSTRAINT "_SYSTEM"."_C1191" CHECK("CNUMMER" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TFACTUREN" ADD CONSTRAINT "_SYSTEM"."_C1192" CHECK("CAFGESLOTEN" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TFACTUREN" ADD CONSTRAINT "_SYSTEM"."_C1193" CHECK("CBOEKJAAR" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TFACTUREN" ADD CONSTRAINT "_SYSTEM"."_C1194" CHECK("CBOEKJAREN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TFACTUREN" ADD CONSTRAINT "_SYSTEM"."_C1195" CHECK("CCONTACTEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TFACTUREN" ADD CONSTRAINT "_SYSTEM"."_C1196" CHECK("CGEPRINT" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TFACTUREN" ADD CONSTRAINT "_SYSTEM"."_C1197" CHECK("CINCLBTW" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TFACTUREN" ADD CONSTRAINT "_SYSTEM"."_C1198" FOREIGN KEY("CMUNTEN_FK") REFERENCES "_SYSTEM"."TMUNTEN"("CMUNTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TFACTUREN" ADD CONSTRAINT "_SYSTEM"."_C1199" FOREIGN KEY("CVERTEGENWOORDIGERS_FK") REFERENCES "_SYSTEM"."TMEDEWERKERS"("CMEDEWERKERS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TFACTUREN" ADD CONSTRAINT "_SYSTEM"."_C1200" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TFACTUREN" ADD CONSTRAINT "_SYSTEM"."_C1201" FOREIGN KEY("CDAGBOEKEN_FK") REFERENCES "_SYSTEM"."TDAGBOEKEN"("CDAGBOEKEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TFACTUREN" ADD CONSTRAINT "_SYSTEM"."_C1202" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TFACTUREN" ADD CONSTRAINT "_SYSTEM"."_C1203" FOREIGN KEY("CBOEKJAREN_FK") REFERENCES "_SYSTEM"."TBOEKJAREN"("CBOEKJAREN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TFACTUREN" ADD CONSTRAINT "_SYSTEM"."_C1204" FOREIGN KEY("CBETALINGSVOORWAARDEN_FK") REFERENCES "_SYSTEM"."TBETALINGSVOORWAARDEN"("CBETALINGSVOORWAARDEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TFACTLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C1205" CHECK("CFACTLIJNEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TFACTLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C1206" CHECK("CFACTUREN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TFACTLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C1207" CHECK("CBTWCODE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TFACTLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C1208" FOREIGN KEY("CFACTUREN_FK") REFERENCES "_SYSTEM"."TFACTUREN"("CFACTUREN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TFACTLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C1209" FOREIGN KEY("CANALYTISCHEREKENINGEN_FK") REFERENCES "_SYSTEM"."TANALYTISCHEREKENINGEN"("CANALYTISCHEREKENINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TFACTLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C1210" FOREIGN KEY("CALGEMENEREKENINGEN_FK") REFERENCES "_SYSTEM"."TALGEMENEREKENINGEN"("CALGEMENEREKENINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TFACTARTIKELGROEPEN" ADD CONSTRAINT "_SYSTEM"."_C1211" CHECK("CFACTARTIKELGROEPEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TFACTARTIKELGROEPEN" ADD CONSTRAINT "_SYSTEM"."_C1212" CHECK("CFACTARTIKELGROEP" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TFACTARTIKELGROEPEN" ADD CONSTRAINT "_SYSTEM"."_C1213" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TFACTARTIKELGROEPEN" ADD CONSTRAINT "_SYSTEM"."_C1214" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TFACTARTIKELGROEPEN" ADD CONSTRAINT "_SYSTEM"."_C1215" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TFACTARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C1216" CHECK("CFACTARTIKELS_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TFACTARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C1217" CHECK("CFACTARTIKEL" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TFACTARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C1218" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TFACTARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C1219" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TFACTARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C1220" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TFACTARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C1221" FOREIGN KEY("CFACTARTIKELGROEPEN_FK") REFERENCES "_SYSTEM"."TFACTARTIKELGROEPEN"("CFACTARTIKELGROEPEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TFACTARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C1222" FOREIGN KEY("CBTWCODES_FK") REFERENCES "_SYSTEM"."TBTWCODES"("CBTWCODES_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TFACTARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C1223" FOREIGN KEY("CVERKOOPREKENINGEN_FK") REFERENCES "_SYSTEM"."TALGEMENEREKENINGEN"("CALGEMENEREKENINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TKASSANUMMERS" ADD CONSTRAINT "_SYSTEM"."_C1224" CHECK("CKASSANUMMERS_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TKASSANUMMERS" ADD CONSTRAINT "_SYSTEM"."_C1225" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TKASSANUMMERS" ADD CONSTRAINT "_SYSTEM"."_C1226" CHECK("CDAGBOEK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TKASSANUMMERS" ADD CONSTRAINT "_SYSTEM"."_C1227" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TKASSANUMMERS" ADD CONSTRAINT "_SYSTEM"."_C1228" CHECK("CINTERNEFIRMAVESTIGING" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TKASSANUMMERS" ADD CONSTRAINT "_SYSTEM"."_C1229" CHECK("CINTERNEFIRMAVESTIGINGEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TKASSANUMMERS" ADD CONSTRAINT "_SYSTEM"."_C1230" CHECK("CKASSANUMMER" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TKASSANUMMERS" ADD CONSTRAINT "_SYSTEM"."_C1231" FOREIGN KEY("CINTERNEFIRMAVESTIGINGEN_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN"("CINTERNEFIRMAVESTIGINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TKASSANUMMERS" ADD CONSTRAINT "_SYSTEM"."_C1232" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TVERWORPENUITGAVEN" ADD CONSTRAINT "_SYSTEM"."_C1233" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVERWORPENUITGAVEN" ADD CONSTRAINT "_SYSTEM"."_C1234" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVERWORPENUITGAVEN" ADD CONSTRAINT "_SYSTEM"."_C1235" CHECK("CALGEMENEREKENING" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVERWORPENUITGAVEN" ADD CONSTRAINT "_SYSTEM"."_C1236" CHECK("CALGEMENEREKENINGEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVERWORPENUITGAVEN" ADD CONSTRAINT "_SYSTEM"."_C1237" CHECK("CPERCENTAGE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVERWORPENUITGAVEN" ADD CONSTRAINT "_SYSTEM"."_C1238" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVERWORPENUITGAVEN" ADD CONSTRAINT "_SYSTEM"."_C1239" FOREIGN KEY("CALGEMENEREKENINGEN_FK") REFERENCES "_SYSTEM"."TALGEMENEREKENINGEN"("CALGEMENEREKENINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCRMMAILINGTEKSTEN" ADD CONSTRAINT "_SYSTEM"."_C1240" CHECK("CCRMMAILINGTEKSTEN_PK" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TXCONTACTEN" ADD CONSTRAINT "_SYSTEM"."_C1241" CHECK("CXCONTACTEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TXCONTACTEN" ADD CONSTRAINT "_SYSTEM"."_C1242" CHECK("CINTERNEFIRMACONTACTEN" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TXCONTACTEN" ADD CONSTRAINT "_SYSTEM"."_C1243" CHECK("CCONTACT" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TXCONTACTEN" ADD CONSTRAINT "_SYSTEM"."_C1244" CHECK("CNAAM1" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TXCONTACTEN" ADD CONSTRAINT "_SYSTEM"."_C1245" CHECK("CLAND" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TXCONTACTPERSONEN" ADD CONSTRAINT "_SYSTEM"."_C1246" CHECK("CXCONTACTPERSONEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TXCONTACTPERSONEN" ADD CONSTRAINT "_SYSTEM"."_C1247" CHECK("CINTERNEFIRMACONTACTEN" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TXCONTACTPERSONEN" ADD CONSTRAINT "_SYSTEM"."_C1248" CHECK("CCONTACT" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TXCONTACTPERSONEN" ADD CONSTRAINT "_SYSTEM"."_C1249" CHECK("CNAAM" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TXCONTACTADRESSEN" ADD CONSTRAINT "_SYSTEM"."_C1250" CHECK("CXCONTACTADRESSEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TXCONTACTADRESSEN" ADD CONSTRAINT "_SYSTEM"."_C1251" CHECK("CINTERNEFIRMACONTACTEN" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TXCONTACTADRESSEN" ADD CONSTRAINT "_SYSTEM"."_C1252" CHECK("CCONTACT" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TXCONTACTADRESSEN" ADD CONSTRAINT "_SYSTEM"."_C1253" CHECK("CADRESTYPE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TXCONTACTADRESSEN" ADD CONSTRAINT "_SYSTEM"."_C1254" CHECK("CNAAM1" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TXCONTACTADRESSEN" ADD CONSTRAINT "_SYSTEM"."_C1255" CHECK("CLAND" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TXVERKOPEN" ADD CONSTRAINT "_SYSTEM"."_C1256" CHECK("CXVERKOPEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TXVERKOPEN" ADD CONSTRAINT "_SYSTEM"."_C1257" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TXVERKOPEN" ADD CONSTRAINT "_SYSTEM"."_C1258" CHECK("CINTERNEFIRMAVESTIGING" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TXVERKOPEN" ADD CONSTRAINT "_SYSTEM"."_C1259" CHECK("CCONTACT" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TXVERKOPEN" ADD CONSTRAINT "_SYSTEM"."_C1260" CHECK("CNUMMER" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TXVERKOPEN" ADD CONSTRAINT "_SYSTEM"."_C1261" CHECK("CDATUM" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TXVERKOPEN" ADD CONSTRAINT "_SYSTEM"."_C1262" CHECK("CMUNT" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TXVERKOPEN" ADD CONSTRAINT "_SYSTEM"."_C1263" CHECK("CDOCUMENTTYPE" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TXVERKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C1264" CHECK("CXVERKOOPLIJNEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TXVERKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C1265" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TXVERKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C1266" CHECK("CINTERNEFIRMAVESTIGING" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TXVERKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C1267" CHECK("CNUMMER" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TXVERKOOPLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C1268" CHECK("CLIJNNUMMER" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TXVERKOOPBETALINGEN" ADD CONSTRAINT "_SYSTEM"."_C1269" CHECK("CXVERKOOPBETALINGEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TXVERKOOPBETALINGEN" ADD CONSTRAINT "_SYSTEM"."_C1270" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TXVERKOOPBETALINGEN" ADD CONSTRAINT "_SYSTEM"."_C1271" CHECK("CINTERNEFIRMAVESTIGING" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TXVERKOOPBETALINGEN" ADD CONSTRAINT "_SYSTEM"."_C1272" CHECK("CNUMMER" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TXVERKOOPBETALINGEN" ADD CONSTRAINT "_SYSTEM"."_C1273" CHECK("CLIJNNUMMER" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TXVERKOOPBETALINGEN" ADD CONSTRAINT "_SYSTEM"."_C1274" CHECK("CBEDRAG" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TMAGAZIJNLOCATIES" ADD CONSTRAINT "_SYSTEM"."_C1275" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TMAGAZIJNLOCATIES" ADD CONSTRAINT "_SYSTEM"."_C1276" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TMAGAZIJNLOCATIES" ADD CONSTRAINT "_SYSTEM"."_C1277" CHECK("CINTERNEFIRMAVESTIGING" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TMAGAZIJNLOCATIES" ADD CONSTRAINT "_SYSTEM"."_C1278" CHECK("CVESTIGINGMAGAZIJN" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TMAGAZIJNLOCATIES" ADD CONSTRAINT "_SYSTEM"."_C1279" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TMAGAZIJNLOCATIES" ADD CONSTRAINT "_SYSTEM"."_C1280" FOREIGN KEY("CINTERNEFIRMAVESTIGINGEN_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN"("CINTERNEFIRMAVESTIGINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TMAGAZIJNLOCATIES" ADD CONSTRAINT "_SYSTEM"."_C1281" CHECK("CINTERNEFIRMAVESTIGINGEN_FK" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TARTIKELBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C1282" CHECK("CARTIKELS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C1283" CHECK("CTYPE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C1284" CHECK("CTYPENUMMER" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C1285" FOREIGN KEY("CARTIKELS_FK") REFERENCES "_SYSTEM"."TARTIKELS"("CARTIKELS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TARTIKELVOORRAADAANTALLEN" ADD CONSTRAINT "_SYSTEM"."_C1286" CHECK("CMAGAZIJNLOCATIE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELVOORRAADAANTALLEN" ADD CONSTRAINT "_SYSTEM"."_C1287" CHECK("CSERIENUMMER" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELVOORRAADAANTALLEN" ADD CONSTRAINT "_SYSTEM"."_C1288" CHECK("CLOTNUMMER" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELVOORRAADAANTALLEN" ADD CONSTRAINT "_SYSTEM"."_C1289" FOREIGN KEY("CARTIKELVOORRAAD_FK") REFERENCES "_SYSTEM"."TARTIKELVOORRAAD"("CARTIKELVOORRAAD_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TVERKOOPLIJNAANTALLEN" ADD CONSTRAINT "_SYSTEM"."_C1290" FOREIGN KEY("CVERKOOPLIJNEN_FK") REFERENCES "_SYSTEM"."TVERKOOPLIJNEN"("CVERKOOPLIJNEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TAANKOOPLIJNAANTALLEN" ADD CONSTRAINT "_SYSTEM"."_C1291" FOREIGN KEY("CAANKOOPLIJNEN_FK") REFERENCES "_SYSTEM"."TAANKOOPLIJNEN"("CAANKOOPLIJNEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TPRODUCTIEAANTALLEN" ADD CONSTRAINT "_SYSTEM"."_C1292" FOREIGN KEY("CPRODUCTIE_FK") REFERENCES "_SYSTEM"."TPRODUCTIE"("CPRODUCTIE_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TPRODUCTIELIJNAANTALLEN" ADD CONSTRAINT "_SYSTEM"."_C1293" FOREIGN KEY("CPRODUCTIELIJNEN_FK") REFERENCES "_SYSTEM"."TPRODUCTIELIJNEN"("CPRODUCTIELIJNEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TSERVICELIJNAANTALLEN" ADD CONSTRAINT "_SYSTEM"."_C1294" FOREIGN KEY("CSERVICELIJNEN_FK") REFERENCES "_SYSTEM"."TSERVICELIJNEN"("CSERVICELIJNEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TXCONTACTGROEPEN" ADD CONSTRAINT "_SYSTEM"."_C1295" CHECK("CXCONTACTGROEPEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TXCONTACTGROEPEN" ADD CONSTRAINT "_SYSTEM"."_C1296" CHECK("CINTERNEFIRMACONTACTEN" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TXCONTACTGROEPEN" ADD CONSTRAINT "_SYSTEM"."_C1297" CHECK("CCONTACT" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TXCONTACTGROEPEN" ADD CONSTRAINT "_SYSTEM"."_C1298" CHECK("CCONTACTGROEP" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TEENHEDEN" ADD CONSTRAINT "_SYSTEM"."_C1299" CHECK("CEENHEID1" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TMUNTWAARDEN" ADD CONSTRAINT "_SYSTEM"."_C1300" FOREIGN KEY("CMUNTEN_FK") REFERENCES "_SYSTEM"."TMUNTEN"("CMUNTEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TDOCTEMPLATES" ADD CONSTRAINT "_SYSTEM"."_C1301" CHECK("CTYPE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TDOCTEMPLATES" ADD CONSTRAINT "_SYSTEM"."_C1302" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TAGENDAGROEPMEDEWERKERS" ADD CONSTRAINT "_SYSTEM"."_C1303" FOREIGN KEY("CMEDEWERKERS_FK") REFERENCES "_SYSTEM"."TMEDEWERKERS"("CMEDEWERKERS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TAGENDAGROEPMEDEWERKERS" ADD CONSTRAINT "_SYSTEM"."_C1304" FOREIGN KEY("CAGENDAGROEPEN_FK") REFERENCES "_SYSTEM"."TAGENDAGROEPEN"("CAGENDAGROEPEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TUURROOSTERS" ADD CONSTRAINT "_SYSTEM"."_C1305" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TUURROOSTERS" ADD CONSTRAINT "_SYSTEM"."_C1306" FOREIGN KEY("CMEDEWERKERS_FK") REFERENCES "_SYSTEM"."TMEDEWERKERS"("CMEDEWERKERS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TMEDEWERKERUURKOST" ADD CONSTRAINT "_SYSTEM"."_C1307" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TMEDEWERKERUURKOST" ADD CONSTRAINT "_SYSTEM"."_C1308" FOREIGN KEY("CMEDEWERKERS_FK") REFERENCES "_SYSTEM"."TMEDEWERKERS"("CMEDEWERKERS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TPRESTATIESOORTEN" ADD CONSTRAINT "_SYSTEM"."_C1309" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPRESTATIESOORTEN" ADD CONSTRAINT "_SYSTEM"."_C1310" FOREIGN KEY("CALGEMENEREKENINGEN_FK") REFERENCES "_SYSTEM"."TALGEMENEREKENINGEN"("CALGEMENEREKENINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPRESTATIESOORTEN" ADD CONSTRAINT "_SYSTEM"."_C8724" FOREIGN KEY("CPRESTATIESOORTGROEPEN_FK") REFERENCES "_SYSTEM"."TPRESTATIESOORTGROEPEN"("CPRESTATIESOORTGROEPEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TPRESTATIES" ADD CONSTRAINT "_SYSTEM"."_C1311" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPRESTATIES" ADD CONSTRAINT "_SYSTEM"."_C1312" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPRESTATIES" ADD CONSTRAINT "_SYSTEM"."_C1313" FOREIGN KEY("CDOCUMENTTYPES_FK") REFERENCES "_SYSTEM"."TDOCUMENTTYPES"("CDOCUMENTTYPES_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPRESTATIES" ADD CONSTRAINT "_SYSTEM"."_C1314" FOREIGN KEY("CMEDEWERKERS_FK") REFERENCES "_SYSTEM"."TMEDEWERKERS"("CMEDEWERKERS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPRESTATIES" ADD CONSTRAINT "_SYSTEM"."_C1315" FOREIGN KEY("CPRESTATIESOORTEN_FK") REFERENCES "_SYSTEM"."TPRESTATIESOORTEN"("CPRESTATIESOORTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TSERVICEARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C1316" CHECK("CSERVICEARTIKELS_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICEARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C1317" CHECK("CSERVICE_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICEARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C1318" CHECK("CINHERSTELLINGLEVERANCIER" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICEARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C1319" CHECK("CMETCONTRACT" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICEARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C1320" CHECK("CMETGARANTIE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICEARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C1321" CHECK("CMETLOTNUMMERS" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICEARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C1322" CHECK("CMETSERIENUMMERS" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICEARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C1323" CHECK("CMETVERVANGARTIKEL" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICEARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C1324" CHECK("CMETVOORRAAD" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICEARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C1325" CHECK("CTERPLAATSE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICEARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C1326" FOREIGN KEY("CSERVICE_FK") REFERENCES "_SYSTEM"."TSERVICE"("CSERVICE_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICEARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C1327" FOREIGN KEY("CMATENBALKEN_FK") REFERENCES "_SYSTEM"."TMATENBALKEN"("CMATENBALKEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICEARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C1328" FOREIGN KEY("CKLEURENKAARTEN_FK") REFERENCES "_SYSTEM"."TKLEURENKAARTEN"("CKLEURENKAARTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICEARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C1329" FOREIGN KEY("CLEVERANCIERS_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICEARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C1330" FOREIGN KEY("CARTIKELS_FK") REFERENCES "_SYSTEM"."TARTIKELS"("CARTIKELS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICEARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C1331" FOREIGN KEY("CVERVANGARTIKELS_FK") REFERENCES "_SYSTEM"."TARTIKELS"("CARTIKELS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TPROJECTTYPES" ADD CONSTRAINT "_SYSTEM"."_C1332" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TPROJECTEN" ADD CONSTRAINT "_SYSTEM"."_C1333" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTEN" ADD CONSTRAINT "_SYSTEM"."_C1334" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTEN" ADD CONSTRAINT "_SYSTEM"."_C1335" FOREIGN KEY("CINTERNEFIRMAVESTIGINGEN_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN"("CINTERNEFIRMAVESTIGINGEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTEN" ADD CONSTRAINT "_SYSTEM"."_C1336" FOREIGN KEY("CDOCUMENTTYPES_FK") REFERENCES "_SYSTEM"."TDOCUMENTTYPES"("CDOCUMENTTYPES_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTEN" ADD CONSTRAINT "_SYSTEM"."_C1337" FOREIGN KEY("CPROJECTTYPES_FK") REFERENCES "_SYSTEM"."TPROJECTTYPES"("CPROJECTTYPES_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTEN" ADD CONSTRAINT "_SYSTEM"."_C1338" FOREIGN KEY("CPROJECTVC_FK") REFERENCES "_SYSTEM"."TPROJECTVC"("CPROJECTVC_PK") ON UPDATE NO ACTION ON DELETE NO ACTION DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTEN" ADD CONSTRAINT "_SYSTEM"."_C1339" FOREIGN KEY("CPROJECTOFFERTES_FK") REFERENCES "_SYSTEM"."TPROJECTOFFERTES"("CPROJECTOFFERTES_PK") ON UPDATE NO ACTION ON DELETE NO ACTION DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTEN" ADD CONSTRAINT "_SYSTEM"."_C1340" FOREIGN KEY("CPROJECTCAMPAGNES_FK") REFERENCES "_SYSTEM"."TPROJECTCAMPAGNES"("CPROJECTCAMPAGNES_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTEN" ADD CONSTRAINT "_SYSTEM"."_C1341" FOREIGN KEY("CMEDEWERKERS_FK") REFERENCES "_SYSTEM"."TMEDEWERKERS"("CMEDEWERKERS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTEN" ADD CONSTRAINT "_SYSTEM"."_C1342" FOREIGN KEY("CVERTEGENWOORDIGERS_FK") REFERENCES "_SYSTEM"."TMEDEWERKERS"("CMEDEWERKERS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTEN" ADD CONSTRAINT "_SYSTEM"."_C1343" FOREIGN KEY("CANALYTISCHEREKENINGEN_FK") REFERENCES "_SYSTEM"."TANALYTISCHEREKENINGEN"("CANALYTISCHEREKENINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTEN" ADD CONSTRAINT "_SYSTEM"."_C3901" FOREIGN KEY("CFACTCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TPROJECTCONTACTEN" ADD CONSTRAINT "_SYSTEM"."_C1344" FOREIGN KEY("CPROJECTEN_FK") REFERENCES "_SYSTEM"."TPROJECTEN"("CPROJECTEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTCONTACTEN" ADD CONSTRAINT "_SYSTEM"."_C1345" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTCONTACTEN" ADD CONSTRAINT "_SYSTEM"."_C1346" FOREIGN KEY("CCONTACTPERSONEN_FK") REFERENCES "_SYSTEM"."TCONTACTPERSONEN"("CCONTACTPERSONEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TPROJECTMEDEWERKERS" ADD CONSTRAINT "_SYSTEM"."_C1347" FOREIGN KEY("CPROJECTEN_FK") REFERENCES "_SYSTEM"."TPROJECTEN"("CPROJECTEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTMEDEWERKERS" ADD CONSTRAINT "_SYSTEM"."_C1348" FOREIGN KEY("CMEDEWERKERS_FK") REFERENCES "_SYSTEM"."TMEDEWERKERS"("CMEDEWERKERS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TPROJECTMATERIALEN" ADD CONSTRAINT "_SYSTEM"."_C1349" FOREIGN KEY("CPROJECTEN_FK") REFERENCES "_SYSTEM"."TPROJECTEN"("CPROJECTEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTMATERIALEN" ADD CONSTRAINT "_SYSTEM"."_C1350" FOREIGN KEY("CMATERIALEN_FK") REFERENCES "_SYSTEM"."TMATERIALEN"("CMATERIALEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TPROJECTFASEN" ADD CONSTRAINT "_SYSTEM"."_C1351" FOREIGN KEY("CPROJECTEN_FK") REFERENCES "_SYSTEM"."TPROJECTEN"("CPROJECTEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTFASEN" ADD CONSTRAINT "_SYSTEM"."_C1352" FOREIGN KEY("CMEDEWERKERS_FK") REFERENCES "_SYSTEM"."TMEDEWERKERS"("CMEDEWERKERS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTFASEN" ADD CONSTRAINT "_SYSTEM"."_C1353" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTFASEN" ADD CONSTRAINT "_SYSTEM"."_C1354" FOREIGN KEY("CCONTACTPERSONEN_FK") REFERENCES "_SYSTEM"."TCONTACTPERSONEN"("CCONTACTPERSONEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTFASEN" ADD CONSTRAINT "_SYSTEM"."_C1355" FOREIGN KEY("CALGEMENEREKENINGEN_FK") REFERENCES "_SYSTEM"."TALGEMENEREKENINGEN"("CALGEMENEREKENINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTFASEN" ADD CONSTRAINT "_SYSTEM"."_C3903" FOREIGN KEY("CPRESTATIESOORTEN_FK") REFERENCES "_SYSTEM"."TPRESTATIESOORTEN"("CPRESTATIESOORTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TPROJECTFASEEXTRA" ADD CONSTRAINT "_SYSTEM"."_C1356" FOREIGN KEY("CPROJECTEN_FK") REFERENCES "_SYSTEM"."TPROJECTEN"("CPROJECTEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTFASEEXTRA" ADD CONSTRAINT "_SYSTEM"."_C1357" FOREIGN KEY("CPROJECTFASEN_FK") REFERENCES "_SYSTEM"."TPROJECTFASEN"("CPROJECTFASEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTFASEEXTRA" ADD CONSTRAINT "_SYSTEM"."_C1358" FOREIGN KEY("CMEDEWERKERS_FK") REFERENCES "_SYSTEM"."TMEDEWERKERS"("CMEDEWERKERS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTFASEEXTRA" ADD CONSTRAINT "_SYSTEM"."_C1359" FOREIGN KEY("CMATERIALEN_FK") REFERENCES "_SYSTEM"."TMATERIALEN"("CMATERIALEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TPROJECTARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C1360" FOREIGN KEY("CPROJECTEN_FK") REFERENCES "_SYSTEM"."TPROJECTEN"("CPROJECTEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TPROJECTVC" ADD CONSTRAINT "_SYSTEM"."_C1361" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTVC" ADD CONSTRAINT "_SYSTEM"."_C1362" FOREIGN KEY("CCONTACTPERSONEN_FK") REFERENCES "_SYSTEM"."TCONTACTPERSONEN"("CCONTACTPERSONEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTVC" ADD CONSTRAINT "_SYSTEM"."_C1363" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTVC" ADD CONSTRAINT "_SYSTEM"."_C1364" FOREIGN KEY("CINTERNEFIRMAVESTIGINGEN_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN"("CINTERNEFIRMAVESTIGINGEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTVC" ADD CONSTRAINT "_SYSTEM"."_C1365" FOREIGN KEY("CPROJECTTYPES_FK") REFERENCES "_SYSTEM"."TPROJECTTYPES"("CPROJECTTYPES_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TPROJECTVCLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C1366" FOREIGN KEY("CPROJECTVC_FK") REFERENCES "_SYSTEM"."TPROJECTVC"("CPROJECTVC_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTVCLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C1367" FOREIGN KEY("CPRESTATIESOORTEN_FK") REFERENCES "_SYSTEM"."TPRESTATIESOORTEN"("CPRESTATIESOORTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TPROJECTVCBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C1368" CHECK("CTYPE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TPROJECTVCBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C1369" CHECK("CTYPENUMMER" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TPROJECTVCBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C1370" FOREIGN KEY("CPROJECTVC_FK") REFERENCES "_SYSTEM"."TPROJECTVC"("CPROJECTVC_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTVCBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C1371" FOREIGN KEY("CDOCUMENTTYPES_FK") REFERENCES "_SYSTEM"."TDOCUMENTTYPES"("CDOCUMENTTYPES_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TPROJECTOFFERTES" ADD CONSTRAINT "_SYSTEM"."_C1372" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTOFFERTES" ADD CONSTRAINT "_SYSTEM"."_C1373" FOREIGN KEY("CCONTACTPERSONEN_FK") REFERENCES "_SYSTEM"."TCONTACTPERSONEN"("CCONTACTPERSONEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTOFFERTES" ADD CONSTRAINT "_SYSTEM"."_C1374" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTOFFERTES" ADD CONSTRAINT "_SYSTEM"."_C1375" FOREIGN KEY("CINTERNEFIRMAVESTIGINGEN_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN"("CINTERNEFIRMAVESTIGINGEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTOFFERTES" ADD CONSTRAINT "_SYSTEM"."_C1376" FOREIGN KEY("CDOCUMENTTYPES_FK") REFERENCES "_SYSTEM"."TDOCUMENTTYPES"("CDOCUMENTTYPES_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTOFFERTES" ADD CONSTRAINT "_SYSTEM"."_C1377" FOREIGN KEY("CPROJECTTYPES_FK") REFERENCES "_SYSTEM"."TPROJECTTYPES"("CPROJECTTYPES_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTOFFERTES" ADD CONSTRAINT "_SYSTEM"."_C1378" FOREIGN KEY("CPROJECTVC_FK") REFERENCES "_SYSTEM"."TPROJECTVC"("CPROJECTVC_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TPROJECTCAMPAGNES" ADD CONSTRAINT "_SYSTEM"."_C1379" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTCAMPAGNES" ADD CONSTRAINT "_SYSTEM"."_C1380" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TPROJECTTYPEFASEN" ADD CONSTRAINT "_SYSTEM"."_C1381" FOREIGN KEY("CPROJECTTYPES_FK") REFERENCES "_SYSTEM"."TPROJECTTYPES"("CPROJECTTYPES_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTTYPEFASEN" ADD CONSTRAINT "_SYSTEM"."_C1382" FOREIGN KEY("CALGEMENEREKENINGEN_FK") REFERENCES "_SYSTEM"."TALGEMENEREKENINGEN"("CALGEMENEREKENINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTTYPEFASEN" ADD CONSTRAINT "_SYSTEM"."_C3902" FOREIGN KEY("CPRESTATIESOORTEN_FK") REFERENCES "_SYSTEM"."TPRESTATIESOORTEN"("CPRESTATIESOORTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TPROJECTFASERELATIES" ADD CONSTRAINT "_SYSTEM"."_C1383" FOREIGN KEY("CPROJECTEN_FK") REFERENCES "_SYSTEM"."TPROJECTEN"("CPROJECTEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTFASERELATIES" ADD CONSTRAINT "_SYSTEM"."_C1384" FOREIGN KEY("CPROJECTFASEN_FK") REFERENCES "_SYSTEM"."TPROJECTFASEN"("CPROJECTFASEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTFASERELATIES" ADD CONSTRAINT "_SYSTEM"."_C1385" FOREIGN KEY("CPROJECTFASEN2_FK") REFERENCES "_SYSTEM"."TPROJECTFASEN"("CPROJECTFASEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TVERKOOPBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C1386" CHECK("CVERKOPEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVERKOOPBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C1387" CHECK("CTYPE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVERKOOPBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C1388" CHECK("CTYPENUMMER" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVERKOOPBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C1389" FOREIGN KEY("CVERKOPEN_FK") REFERENCES "_SYSTEM"."TVERKOPEN"("CVERKOPEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TVERKOOPBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C1390" FOREIGN KEY("CDOCUMENTTYPES_FK") REFERENCES "_SYSTEM"."TDOCUMENTTYPES"("CDOCUMENTTYPES_PK") ON UPDATE NO ACTION ON DELETE NO ACTION CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TAANKOOPBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C1391" CHECK("CAANKOPEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TAANKOOPBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C1392" CHECK("CTYPE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TAANKOOPBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C1393" CHECK("CTYPENUMMER" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TAANKOOPBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C1394" FOREIGN KEY("CAANKOPEN_FK") REFERENCES "_SYSTEM"."TAANKOPEN"("CAANKOPEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TAANKOOPBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C1395" FOREIGN KEY("CDOCUMENTTYPES_FK") REFERENCES "_SYSTEM"."TDOCUMENTTYPES"("CDOCUMENTTYPES_PK") ON UPDATE NO ACTION ON DELETE NO ACTION CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TSERVICEBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C1396" CHECK("CSERVICE_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICEBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C1397" CHECK("CTYPE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICEBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C1398" CHECK("CTYPENUMMER" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TSERVICEBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C1399" FOREIGN KEY("CSERVICE_FK") REFERENCES "_SYSTEM"."TSERVICE"("CSERVICE_PK") ON UPDATE NO ACTION ON DELETE CASCADE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TSERVICEBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C1400" FOREIGN KEY("CDOCUMENTTYPES_FK") REFERENCES "_SYSTEM"."TDOCUMENTTYPES"("CDOCUMENTTYPES_PK") ON UPDATE NO ACTION ON DELETE NO ACTION CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TSERVICEINSTALLATIES" ADD CONSTRAINT "_SYSTEM"."_C1401" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICEINSTALLATIES" ADD CONSTRAINT "_SYSTEM"."_C1402" FOREIGN KEY("CINTERNEFIRMAVESTIGINGEN_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN"("CINTERNEFIRMAVESTIGINGEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICEINSTALLATIES" ADD CONSTRAINT "_SYSTEM"."_C1403" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TSERVICEINSTALLATIES" ADD CONSTRAINT "_SYSTEM"."_C1404" FOREIGN KEY("CARTIKELS_FK") REFERENCES "_SYSTEM"."TARTIKELS"("CARTIKELS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TPROJECTTYPEFASERELATIES" ADD CONSTRAINT "_SYSTEM"."_C1405" FOREIGN KEY("CPROJECTTYPES_FK") REFERENCES "_SYSTEM"."TPROJECTTYPES"("CPROJECTTYPES_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTTYPEFASERELATIES" ADD CONSTRAINT "_SYSTEM"."_C1406" FOREIGN KEY("CPROJECTTYPEFASEN_FK") REFERENCES "_SYSTEM"."TPROJECTTYPEFASEN"("CPROJECTTYPEFASEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTTYPEFASERELATIES" ADD CONSTRAINT "_SYSTEM"."_C1407" FOREIGN KEY("CPROJECTTYPEFASEN2_FK") REFERENCES "_SYSTEM"."TPROJECTTYPEFASEN"("CPROJECTTYPEFASEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TXPRESTATIES" ADD CONSTRAINT "_SYSTEM"."_C1408" CHECK("CXPRESTATIES_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TXPRESTATIES" ADD CONSTRAINT "_SYSTEM"."_C1409" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TXPRESTATIES" ADD CONSTRAINT "_SYSTEM"."_C1410" CHECK("CMEDEWERKER" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TXPRESTATIES" ADD CONSTRAINT "_SYSTEM"."_C1411" CHECK("CCONTACT" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TXPRESTATIES" ADD CONSTRAINT "_SYSTEM"."_C1413" CHECK("CDATUM" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TVERKOOPLIJNAFMETINGEN" ADD CONSTRAINT "_SYSTEM"."_C1416" FOREIGN KEY("CVERKOOPLIJNEN_FK") REFERENCES "_SYSTEM"."TVERKOOPLIJNEN"("CVERKOOPLIJNEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TPROJECTBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C2566" CHECK("CPROJECTEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TPROJECTBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C2567" CHECK("CTYPE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TPROJECTBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C2568" CHECK("CTYPENUMMER" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TPROJECTBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C2570" FOREIGN KEY("CPROJECTEN_FK") REFERENCES "_SYSTEM"."TPROJECTEN"("CPROJECTEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TPROJECTBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C2571" FOREIGN KEY("CDOCUMENTTYPES_FK") REFERENCES "_SYSTEM"."TDOCUMENTTYPES"("CDOCUMENTTYPES_PK") ON UPDATE NO ACTION ON DELETE NO ACTION CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCONTACTBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C3725" CHECK("CCONTACTEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCONTACTBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C3726" CHECK("CTYPE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCONTACTBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C3727" CHECK("CTYPENUMMER" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCONTACTBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C3729" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCONTACTBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C3730" FOREIGN KEY("CDOCUMENTTYPES_FK") REFERENCES "_SYSTEM"."TDOCUMENTTYPES"("CDOCUMENTTYPES_PK") ON UPDATE NO ACTION ON DELETE NO ACTION CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TMEDEWERKERHANDTEKENINGEN" ADD CONSTRAINT "_SYSTEM"."_C3735" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TMEDEWERKERHANDTEKENINGEN" ADD CONSTRAINT "_SYSTEM"."_C3736" FOREIGN KEY("CMEDEWERKERS_FK") REFERENCES "_SYSTEM"."TMEDEWERKERS"("CMEDEWERKERS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TMEDEWERKERBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C3737" CHECK("CMEDEWERKERS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TMEDEWERKERBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C3738" CHECK("CTYPE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TMEDEWERKERBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C3739" CHECK("CTYPENUMMER" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TMEDEWERKERBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C3741" FOREIGN KEY("CMEDEWERKERS_FK") REFERENCES "_SYSTEM"."TMEDEWERKERS"("CMEDEWERKERS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TNACECODES" ADD CONSTRAINT "_SYSTEM"."_C3742" CHECK("CNACECODE" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TAGENDACONTACTEN" ADD CONSTRAINT "_SYSTEM"."_C3750" FOREIGN KEY("CAGENDA_FK") REFERENCES "_SYSTEM"."TAGENDA"("CAGENDA_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TAGENDACONTACTEN" ADD CONSTRAINT "_SYSTEM"."_C3751" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TAGENDACONTACTEN" ADD CONSTRAINT "_SYSTEM"."_C3752" FOREIGN KEY("CCONTACTPERSONEN_FK") REFERENCES "_SYSTEM"."TCONTACTPERSONEN"("CCONTACTPERSONEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCRMCOMMUNICATIECONTACTEN" ADD CONSTRAINT "_SYSTEM"."_C3755" FOREIGN KEY("CCRMCOMMUNICATIES_FK") REFERENCES "_SYSTEM"."TCRMCOMMUNICATIES"("CCRMCOMMUNICATIES_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMCOMMUNICATIECONTACTEN" ADD CONSTRAINT "_SYSTEM"."_C3756" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMCOMMUNICATIECONTACTEN" ADD CONSTRAINT "_SYSTEM"."_C3757" FOREIGN KEY("CCONTACTPERSONEN_FK") REFERENCES "_SYSTEM"."TCONTACTPERSONEN"("CCONTACTPERSONEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCRMTAAKPRODUCTEN" ADD CONSTRAINT "_SYSTEM"."_C3760" FOREIGN KEY("CCRMTAKEN_FK") REFERENCES "_SYSTEM"."TCRMTAKEN"("CCRMTAKEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCRMSUPPORTSOORTEN" ADD CONSTRAINT "_SYSTEM"."_C3765" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCRMWACHTRIJEN" ADD CONSTRAINT "_SYSTEM"."_C3768" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCRMWACHTRIJMEDEWERKERS" ADD CONSTRAINT "_SYSTEM"."_C3771" FOREIGN KEY("CCRMWACHTRIJEN_FK") REFERENCES "_SYSTEM"."TCRMWACHTRIJEN"("CCRMWACHTRIJEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMWACHTRIJMEDEWERKERS" ADD CONSTRAINT "_SYSTEM"."_C3772" FOREIGN KEY("CMEDEWERKERS_FK") REFERENCES "_SYSTEM"."TMEDEWERKERS"("CMEDEWERKERS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCRMPRODUCTFAMILIES" ADD CONSTRAINT "_SYSTEM"."_C3775" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCRMPRODUCTGROEPEN" ADD CONSTRAINT "_SYSTEM"."_C3778" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCRMPRODUCTEN" ADD CONSTRAINT "_SYSTEM"."_C3781" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCRMSUPPORTCALLS" ADD CONSTRAINT "_SYSTEM"."_C3784" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TCRMSUPPORTCALLS" ADD CONSTRAINT "_SYSTEM"."_C3785" FOREIGN KEY("CINTERNEFIRMAVESTIGINGEN_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN"("CINTERNEFIRMAVESTIGINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TCRMSUPPORTCALLS" ADD CONSTRAINT "_SYSTEM"."_C3786" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TCRMSUPPORTCALLS" ADD CONSTRAINT "_SYSTEM"."_C3787" FOREIGN KEY("CCONTACTPERSONEN_FK") REFERENCES "_SYSTEM"."TCONTACTPERSONEN"("CCONTACTPERSONEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TCRMSUPPORTCALLS" ADD CONSTRAINT "_SYSTEM"."_C3788" FOREIGN KEY("CMEDEWERKERS_FK") REFERENCES "_SYSTEM"."TMEDEWERKERS"("CMEDEWERKERS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TCRMSUPPORTCALLS" ADD CONSTRAINT "_SYSTEM"."_C3789" FOREIGN KEY("CVERTEGENWOORDIGERS_FK") REFERENCES "_SYSTEM"."TMEDEWERKERS"("CMEDEWERKERS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TCRMSUPPORTCALLS" ADD CONSTRAINT "_SYSTEM"."_C3790" FOREIGN KEY("CDOCUMENTTYPES_FK") REFERENCES "_SYSTEM"."TDOCUMENTTYPES"("CDOCUMENTTYPES_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TCRMSUPPORTCALLS" ADD CONSTRAINT "_SYSTEM"."_C3791" FOREIGN KEY("CCRMWACHTRIJEN_FK") REFERENCES "_SYSTEM"."TCRMWACHTRIJEN"("CCRMWACHTRIJEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TCRMSUPPORTCALLS" ADD CONSTRAINT "_SYSTEM"."_C3792" FOREIGN KEY("CCRMSUPPORTSOORTEN_FK") REFERENCES "_SYSTEM"."TCRMSUPPORTSOORTEN"("CCRMSUPPORTSOORTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCRMSUPPORTCALLLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C3794" FOREIGN KEY("CCRMSUPPORTCALLS_FK") REFERENCES "_SYSTEM"."TCRMSUPPORTCALLS"("CCRMSUPPORTCALLS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMSUPPORTCALLLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C3795" FOREIGN KEY("CMEDEWERKERS_FK") REFERENCES "_SYSTEM"."TMEDEWERKERS"("CMEDEWERKERS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMSUPPORTCALLLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C3796" FOREIGN KEY("CDOCUMENTTYPES_FK") REFERENCES "_SYSTEM"."TDOCUMENTTYPES"("CDOCUMENTTYPES_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCRMSUPPORTCALLOPVOLGING" ADD CONSTRAINT "_SYSTEM"."_C3798" FOREIGN KEY("CCRMSUPPORTCALLS_FK") REFERENCES "_SYSTEM"."TCRMSUPPORTCALLS"("CCRMSUPPORTCALLS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMSUPPORTCALLOPVOLGING" ADD CONSTRAINT "_SYSTEM"."_C3799" FOREIGN KEY("CMEDEWERKERS_FK") REFERENCES "_SYSTEM"."TMEDEWERKERS"("CMEDEWERKERS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCRMCONTACTPRODUCTEN" ADD CONSTRAINT "_SYSTEM"."_C3801" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMCONTACTPRODUCTEN" ADD CONSTRAINT "_SYSTEM"."_C3802" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCRMCONTACTPRODUCTENHIST" ADD CONSTRAINT "_SYSTEM"."_C3804" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMCONTACTPRODUCTENHIST" ADD CONSTRAINT "_SYSTEM"."_C3805" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCRMABONNEMENTTYPES" ADD CONSTRAINT "_SYSTEM"."_C3807" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMABONNEMENTTYPES" ADD CONSTRAINT "_SYSTEM"."_C3808" FOREIGN KEY("CBETALINGSVOORWAARDEN_FK") REFERENCES "_SYSTEM"."TBETALINGSVOORWAARDEN"("CBETALINGSVOORWAARDEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCRMABONNEMENTTYPELIJNEN" ADD CONSTRAINT "_SYSTEM"."_C3810" FOREIGN KEY("CCRMABONNEMENTTYPES_FK") REFERENCES "_SYSTEM"."TCRMABONNEMENTTYPES"("CCRMABONNEMENTTYPES_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMABONNEMENTTYPELIJNEN" ADD CONSTRAINT "_SYSTEM"."_C3811" FOREIGN KEY("CARTIKELS_FK") REFERENCES "_SYSTEM"."TARTIKELS"("CARTIKELS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMABONNEMENTTYPELIJNEN" ADD CONSTRAINT "_SYSTEM"."_C3812" FOREIGN KEY("CFACTARTIKELS_FK") REFERENCES "_SYSTEM"."TFACTARTIKELS"("CFACTARTIKELS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCRMABONNEMENTEN" ADD CONSTRAINT "_SYSTEM"."_C3814" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMABONNEMENTEN" ADD CONSTRAINT "_SYSTEM"."_C3815" FOREIGN KEY("CINTERNEFIRMAVESTIGINGEN_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN"("CINTERNEFIRMAVESTIGINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMABONNEMENTEN" ADD CONSTRAINT "_SYSTEM"."_C3816" FOREIGN KEY("CCRMABONNEMENTTYPES_FK") REFERENCES "_SYSTEM"."TCRMABONNEMENTTYPES"("CCRMABONNEMENTTYPES_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMABONNEMENTEN" ADD CONSTRAINT "_SYSTEM"."_C3817" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMABONNEMENTEN" ADD CONSTRAINT "_SYSTEM"."_C3818" FOREIGN KEY("CFACTCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMABONNEMENTEN" ADD CONSTRAINT "_SYSTEM"."_C3819" FOREIGN KEY("CBETALINGSVOORWAARDEN_FK") REFERENCES "_SYSTEM"."TBETALINGSVOORWAARDEN"("CBETALINGSVOORWAARDEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCRMABONNEMENTLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C3821" FOREIGN KEY("CCRMABONNEMENTEN_FK") REFERENCES "_SYSTEM"."TCRMABONNEMENTEN"("CCRMABONNEMENTEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMABONNEMENTLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C3826" FOREIGN KEY("CARTIKELS_FK") REFERENCES "_SYSTEM"."TARTIKELS"("CARTIKELS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMABONNEMENTLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C3828" FOREIGN KEY("CFACTARTIKELS_FK") REFERENCES "_SYSTEM"."TFACTARTIKELS"("CFACTARTIKELS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCRMABONNEMENTFACTUREN" ADD CONSTRAINT "_SYSTEM"."_C3823" FOREIGN KEY("CCRMABONNEMENTEN_FK") REFERENCES "_SYSTEM"."TCRMABONNEMENTEN"("CCRMABONNEMENTEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMABONNEMENTFACTUREN" ADD CONSTRAINT "_SYSTEM"."_C3827" FOREIGN KEY("CVERKOPEN_FK") REFERENCES "_SYSTEM"."TVERKOPEN"("CVERKOPEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMABONNEMENTFACTUREN" ADD CONSTRAINT "_SYSTEM"."_C3829" FOREIGN KEY("CFACTUREN_FK") REFERENCES "_SYSTEM"."TFACTUREN"("CFACTUREN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCRMABONNEMENTCORRECTIES" ADD CONSTRAINT "_SYSTEM"."_C3825" FOREIGN KEY("CCRMABONNEMENTEN_FK") REFERENCES "_SYSTEM"."TCRMABONNEMENTEN"("CCRMABONNEMENTEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TPOP3EMAILBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C3831" CHECK("CPOP3EMAILS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TPOP3EMAILBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C3833" FOREIGN KEY("CPOP3EMAILS_FK") REFERENCES "_SYSTEM"."TPOP3EMAILS"("CPOP3EMAILS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TPOP3EMAILACCOUNTS" ADD CONSTRAINT "_SYSTEM"."_C3835" FOREIGN KEY("CMEDEWERKERS_FK") REFERENCES "_SYSTEM"."TMEDEWERKERS"("CMEDEWERKERS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TPOP3EMAILACCOUNTS" ADD CONSTRAINT "_SYSTEM"."_C3836" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TPOP3EMAILACCOUNTS" ADD CONSTRAINT "_SYSTEM"."_C3837" FOREIGN KEY("CINTERNEFIRMAVESTIGINGEN_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN"("CINTERNEFIRMAVESTIGINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCRMKEUZELIJSTEN" ADD CONSTRAINT "_SYSTEM"."_C3838" CHECK("CCRMKEUZE" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TCRMOORSPRONGEN" ADD CONSTRAINT "_SYSTEM"."_C3841" CHECK("CCRMOORSPRONG" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TCRMSUBOORSPRONGEN" ADD CONSTRAINT "_SYSTEM"."_C3844" CHECK("CCRMSUBOORSPRONG" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCRMSUBOORSPRONGEN" ADD CONSTRAINT "_SYSTEM"."_C3846" FOREIGN KEY("CCRMOORSPRONGEN_FK") REFERENCES "_SYSTEM"."TCRMOORSPRONGEN"("CCRMOORSPRONGEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCRMAFGESLOTENSTATUSSEN" ADD CONSTRAINT "_SYSTEM"."_C3848" CHECK("CCRMAFGESLOTENSTATUS" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TCRMVERKOOPFASEN" ADD CONSTRAINT "_SYSTEM"."_C3851" CHECK("CCRMVERKOOPFASE" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TCRMVERKOOPKANSSOORTEN" ADD CONSTRAINT "_SYSTEM"."_C3854" CHECK("CCRMVERKOOPKANSSOORT" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TCRMVERKOOPKANSSOORTFASEN" ADD CONSTRAINT "_SYSTEM"."_C3858" FOREIGN KEY("CCRMVERKOOPKANSSOORTEN_FK") REFERENCES "_SYSTEM"."TCRMVERKOOPKANSSOORTEN"("CCRMVERKOOPKANSSOORTEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMVERKOOPKANSSOORTFASEN" ADD CONSTRAINT "_SYSTEM"."_C3859" FOREIGN KEY("CCRMVERKOOPFASEN_FK") REFERENCES "_SYSTEM"."TCRMVERKOOPFASEN"("CCRMVERKOOPFASEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCONTACTINTERESSES" ADD CONSTRAINT "_SYSTEM"."_C3862" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCONTACTHUIDIGEPRODUCTEN" ADD CONSTRAINT "_SYSTEM"."_C3864" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCRMOPLEIDINGTYPES" ADD CONSTRAINT "_SYSTEM"."_C3866" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCRMOPLEIDINGEN" ADD CONSTRAINT "_SYSTEM"."_C3868" FOREIGN KEY("CCRMOPLEIDINGTYPES_FK") REFERENCES "_SYSTEM"."TCRMOPLEIDINGTYPES"("CCRMOPLEIDINGTYPES_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMOPLEIDINGEN" ADD CONSTRAINT "_SYSTEM"."_C3869" FOREIGN KEY("CMEDEWERKERS_FK") REFERENCES "_SYSTEM"."TMEDEWERKERS"("CMEDEWERKERS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMOPLEIDINGEN" ADD CONSTRAINT "_SYSTEM"."_C3870" FOREIGN KEY("CVERTEGENWOORDIGERS_FK") REFERENCES "_SYSTEM"."TMEDEWERKERS"("CMEDEWERKERS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMOPLEIDINGEN" ADD CONSTRAINT "_SYSTEM"."_C3871" FOREIGN KEY("CDOCUMENTTYPES_FK") REFERENCES "_SYSTEM"."TDOCUMENTTYPES"("CDOCUMENTTYPES_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMOPLEIDINGEN" ADD CONSTRAINT "_SYSTEM"."_C3872" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCRMOPLEIDINGDEELNEMERS" ADD CONSTRAINT "_SYSTEM"."_C3874" FOREIGN KEY("CCRMOPLEIDINGEN_FK") REFERENCES "_SYSTEM"."TCRMOPLEIDINGEN"("CCRMOPLEIDINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMOPLEIDINGDEELNEMERS" ADD CONSTRAINT "_SYSTEM"."_C3875" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMOPLEIDINGDEELNEMERS" ADD CONSTRAINT "_SYSTEM"."_C3876" FOREIGN KEY("CCONTACTPERSONEN_FK") REFERENCES "_SYSTEM"."TCONTACTPERSONEN"("CCONTACTPERSONEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCRMVERKOOPKANSEN" ADD CONSTRAINT "_SYSTEM"."_C3879" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMVERKOOPKANSEN" ADD CONSTRAINT "_SYSTEM"."_C3880" FOREIGN KEY("CINTERNEFIRMAVESTIGINGEN_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN"("CINTERNEFIRMAVESTIGINGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMVERKOOPKANSEN" ADD CONSTRAINT "_SYSTEM"."_C3881" FOREIGN KEY("CDOCUMENTTYPES_FK") REFERENCES "_SYSTEM"."TDOCUMENTTYPES"("CDOCUMENTTYPES_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMVERKOOPKANSEN" ADD CONSTRAINT "_SYSTEM"."_C3882" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMVERKOOPKANSEN" ADD CONSTRAINT "_SYSTEM"."_C3883" FOREIGN KEY("CCONTACTPERSONEN_FK") REFERENCES "_SYSTEM"."TCONTACTPERSONEN"("CCONTACTPERSONEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMVERKOOPKANSEN" ADD CONSTRAINT "_SYSTEM"."_C3884" FOREIGN KEY("CCRMVERKOOPKANSSOORTEN_FK") REFERENCES "_SYSTEM"."TCRMVERKOOPKANSSOORTEN"("CCRMVERKOOPKANSSOORTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMVERKOOPKANSEN" ADD CONSTRAINT "_SYSTEM"."_C3885" FOREIGN KEY("CCRMOORSPRONGEN_FK") REFERENCES "_SYSTEM"."TCRMOORSPRONGEN"("CCRMOORSPRONGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMVERKOOPKANSEN" ADD CONSTRAINT "_SYSTEM"."_C3886" FOREIGN KEY("CCRMSUBOORSPRONGEN_FK") REFERENCES "_SYSTEM"."TCRMSUBOORSPRONGEN"("CCRMSUBOORSPRONGEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMVERKOOPKANSEN" ADD CONSTRAINT "_SYSTEM"."_C3887" FOREIGN KEY("CMEDEWERKERS_FK") REFERENCES "_SYSTEM"."TMEDEWERKERS"("CMEDEWERKERS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMVERKOOPKANSEN" ADD CONSTRAINT "_SYSTEM"."_C3888" FOREIGN KEY("CCRMVERKOOPFASEN_FK") REFERENCES "_SYSTEM"."TCRMVERKOOPFASEN"("CCRMVERKOOPFASEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCRMVERKOOPKANSBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C3889" CHECK("CCRMVERKOOPKANSEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCRMVERKOOPKANSBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C3890" CHECK("CTYPE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCRMVERKOOPKANSBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C3891" CHECK("CTYPENUMMER" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCRMVERKOOPKANSBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C3893" FOREIGN KEY("CCRMVERKOOPKANSEN_FK") REFERENCES "_SYSTEM"."TCRMVERKOOPKANSEN"("CCRMVERKOOPKANSEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMVERKOOPKANSBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C3894" FOREIGN KEY("CDOCUMENTTYPES_FK") REFERENCES "_SYSTEM"."TDOCUMENTTYPES"("CDOCUMENTTYPES_PK") ON UPDATE NO ACTION ON DELETE NO ACTION CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TARTIKELINFIRMA" ADD CONSTRAINT "_SYSTEM"."_C3895" CHECK("CARTIKELS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELINFIRMA" ADD CONSTRAINT "_SYSTEM"."_C3897" FOREIGN KEY("CARTIKELS_FK") REFERENCES "_SYSTEM"."TARTIKELS"("CARTIKELS_PK") ON UPDATE NO ACTION ON DELETE CASCADE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TARTIKELINFIRMA" ADD CONSTRAINT "_SYSTEM"."_C3898" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE CASCADE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TARTIKELINFIRMA" ADD CONSTRAINT "_SYSTEM"."_C3899" FOREIGN KEY("CAANKOOPREKENINGEN_FK") REFERENCES "_SYSTEM"."TALGEMENEREKENINGEN"("CALGEMENEREKENINGEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCRMVERKOOPKANSFASEN" ADD CONSTRAINT "_SYSTEM"."_C7297" CHECK("CCRMVERKOOPKANSEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCRMVERKOOPKANSFASEN" ADD CONSTRAINT "_SYSTEM"."_C7298" CHECK("CCRMVERKOOPFASEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCRMVERKOOPKANSFASEN" ADD CONSTRAINT "_SYSTEM"."_C7300" FOREIGN KEY("CCRMVERKOOPKANSEN_FK") REFERENCES "_SYSTEM"."TCRMVERKOOPKANSEN"("CCRMVERKOOPKANSEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCRMVERKOOPKANSFASEN" ADD CONSTRAINT "_SYSTEM"."_C7301" FOREIGN KEY("CCRMVERKOOPFASEN_FK") REFERENCES "_SYSTEM"."TCRMVERKOOPFASEN"("CCRMVERKOOPFASEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TKLANTKAARTEN" ADD CONSTRAINT "_SYSTEM"."_C7303" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TKLANTKAARTEN" ADD CONSTRAINT "_SYSTEM"."_C7304" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TKLANTKAARTEN" ADD CONSTRAINT "_SYSTEM"."_C7305" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TKLANTKAARTEN" ADD CONSTRAINT "_SYSTEM"."_C7306" CHECK("CNUMMER" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TKLANTKAARTLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C7309" FOREIGN KEY("CKLANTKAARTEN_FK") REFERENCES "_SYSTEM"."TKLANTKAARTEN"("CKLANTKAARTEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TKLANTKAARTLIJNEN" ADD CONSTRAINT "_SYSTEM"."_C7310" CHECK("CKLANTKAARTEN_FK" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TEMAILTEKSTEN" ADD CONSTRAINT "_SYSTEM"."_C7313" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TEMAILTEKSTEN" ADD CONSTRAINT "_SYSTEM"."_C7314" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TEMAILTEKSTEN" ADD CONSTRAINT "_SYSTEM"."_C7315" CHECK("CINTERNEFIRMAVESTIGING" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TEMAILTEKSTEN" ADD CONSTRAINT "_SYSTEM"."_C7316" CHECK("CINTERNEFIRMAVESTIGINGEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TEMAILTEKSTEN" ADD CONSTRAINT "_SYSTEM"."_C7318" FOREIGN KEY("CDOCUMENTTYPES_FK") REFERENCES "_SYSTEM"."TDOCUMENTTYPES"("CDOCUMENTTYPES_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TEMAILTEKSTEN" ADD CONSTRAINT "_SYSTEM"."_C7319" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TEMAILTEKSTEN" ADD CONSTRAINT "_SYSTEM"."_C7320" FOREIGN KEY("CINTERNEFIRMAVESTIGINGEN_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAVESTIGINGEN"("CINTERNEFIRMAVESTIGINGEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TMEDEWERKERINFIRMA" ADD CONSTRAINT "_SYSTEM"."_C7322" FOREIGN KEY("CMEDEWERKERS_FK") REFERENCES "_SYSTEM"."TMEDEWERKERS"("CMEDEWERKERS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TMEDEWERKERINFIRMA" ADD CONSTRAINT "_SYSTEM"."_C7323" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TBOEKINGBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C7326" CHECK("CBOEKINGEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TBOEKINGBIJLAGEN" ADD CONSTRAINT "_SYSTEM"."_C7328" FOREIGN KEY("CBOEKINGEN_FK") REFERENCES "_SYSTEM"."TBOEKINGEN"("CBOEKINGEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TDOMMANDATEN" ADD CONSTRAINT "_SYSTEM"."_C7329" CHECK("CCONTACTEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TDOMMANDATEN" ADD CONSTRAINT "_SYSTEM"."_C7330" CHECK("CINTERNEFIRMA" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TDOMMANDATEN" ADD CONSTRAINT "_SYSTEM"."_C7331" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TDOMMANDATEN" ADD CONSTRAINT "_SYSTEM"."_C7332" CHECK("CNIETACTIEF" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TDOMMANDATEN" ADD CONSTRAINT "_SYSTEM"."_C7334" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TDOMMANDATEN" ADD CONSTRAINT "_SYSTEM"."_C7335" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TMAILINGCODES" ADD CONSTRAINT "_SYSTEM"."_C7337" CHECK("CMAILINGCODE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TMAILINGCODES" ADD CONSTRAINT "_SYSTEM"."_C7340" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCONTACTPERSOONMAILINGCODES" ADD CONSTRAINT "_SYSTEM"."_C7341" CHECK("CMAILINGCODE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCONTACTPERSOONMAILINGCODES" ADD CONSTRAINT "_SYSTEM"."_C7343" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCONTACTPERSOONMAILINGCODES" ADD CONSTRAINT "_SYSTEM"."_C7344" FOREIGN KEY("CCONTACTPERSONEN_FK") REFERENCES "_SYSTEM"."TCONTACTPERSONEN"("CCONTACTPERSONEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCONTACTPERSOONMAILINGCODES" ADD CONSTRAINT "_SYSTEM"."_C7345" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCONTACTPERSOONMAILINGCODES" ADD CONSTRAINT "_SYSTEM"."_C7346" FOREIGN KEY("CMAILINGCODES_FK") REFERENCES "_SYSTEM"."TMAILINGCODES"("CMAILINGCODES_PK") ON UPDATE NO ACTION ON DELETE CASCADE DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TFACTVERSTUURD" ADD CONSTRAINT "_SYSTEM"."_C7348" CHECK("CFACTUREN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TFACTVERSTUURD" ADD CONSTRAINT "_SYSTEM"."_C7350" FOREIGN KEY("CFACTUREN_FK") REFERENCES "_SYSTEM"."TFACTUREN"("CFACTUREN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TARTIKELKLEURMAAT" ADD CONSTRAINT "_SYSTEM"."_C7351" CHECK("CARTIKELS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELKLEURMAAT" ADD CONSTRAINT "_SYSTEM"."_C7353" FOREIGN KEY("CARTIKELS_FK") REFERENCES "_SYSTEM"."TARTIKELS"("CARTIKELS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TARTIKELKLEURMAATPRIJZEN" ADD CONSTRAINT "_SYSTEM"."_C7355" CHECK("CARTIKELS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELKLEURMAATPRIJZEN" ADD CONSTRAINT "_SYSTEM"."_C7357" FOREIGN KEY("CARTIKELS_FK") REFERENCES "_SYSTEM"."TARTIKELS"("CARTIKELS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TARTIKELKLEURMAATPRIJZEN" ADD CONSTRAINT "_SYSTEM"."_C7358" FOREIGN KEY("CARTIKELPRIJZEN_FK") REFERENCES "_SYSTEM"."TARTIKELPRIJZEN"("CARTIKELPRIJZEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TARTIKELKLEURMAATLEVERANCIERS" ADD CONSTRAINT "_SYSTEM"."_C7360" CHECK("CARTIKELS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELKLEURMAATLEVERANCIERS" ADD CONSTRAINT "_SYSTEM"."_C7362" FOREIGN KEY("CARTIKELS_FK") REFERENCES "_SYSTEM"."TARTIKELS"("CARTIKELS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TARTIKELKLEURMAATLEVERANCIERS" ADD CONSTRAINT "_SYSTEM"."_C7363" FOREIGN KEY("CARTIKELLEVERANCIERS_FK") REFERENCES "_SYSTEM"."TARTIKELLEVERANCIERS"("CARTIKELLEVERANCIERS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TVERKOOPVERSTUURD" ADD CONSTRAINT "_SYSTEM"."_C7365" CHECK("CVERKOPEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVERKOOPVERSTUURD" ADD CONSTRAINT "_SYSTEM"."_C7367" FOREIGN KEY("CVERKOPEN_FK") REFERENCES "_SYSTEM"."TVERKOPEN"("CVERKOPEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TVERKOOPSTATUSSEN" ADD CONSTRAINT "_SYSTEM"."_C7368" CHECK("CDOCUMENTTYPE" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVERKOOPSTATUSSEN" ADD CONSTRAINT "_SYSTEM"."_C7369" CHECK("CDOCUMENTTYPES_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TVERKOOPSTATUSSEN" ADD CONSTRAINT "_SYSTEM"."_C7372" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TVERKOOPSTATUSSEN" ADD CONSTRAINT "_SYSTEM"."_C7373" FOREIGN KEY("CDOCUMENTTYPES_FK") REFERENCES "_SYSTEM"."TDOCUMENTTYPES"("CDOCUMENTTYPES_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TAANKOOPLIJNAFMETINGEN" ADD CONSTRAINT "_SYSTEM"."_C7375" FOREIGN KEY("CAANKOOPLIJNEN_FK") REFERENCES "_SYSTEM"."TAANKOOPLIJNEN"("CAANKOOPLIJNEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TPROJECTGROEPEN" ADD CONSTRAINT "_SYSTEM"."_C7378" CHECK("CPROJECTGROEP" IS NOT NULL);
COMMIT;

ALTER TABLE "_SYSTEM"."TPROJECTGROEPENPROJECT" ADD CONSTRAINT "_SYSTEM"."_C7381" CHECK("CPROJECTEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TPROJECTGROEPENPROJECT" ADD CONSTRAINT "_SYSTEM"."_C7382" CHECK("CPROJECTGROEPEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TPROJECTGROEPENPROJECT" ADD CONSTRAINT "_SYSTEM"."_C7384" FOREIGN KEY("CPROJECTEN_FK") REFERENCES "_SYSTEM"."TPROJECTEN"("CPROJECTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TPROJECTGROEPENPROJECT" ADD CONSTRAINT "_SYSTEM"."_C7385" FOREIGN KEY("CPROJECTGROEPEN_FK") REFERENCES "_SYSTEM"."TPROJECTGROEPEN"("CPROJECTGROEPEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TMEDEWERKEROFFICE365" ADD CONSTRAINT "_SYSTEM"."_C8717" FOREIGN KEY("CMEDEWERKERS_FK") REFERENCES "_SYSTEM"."TMEDEWERKERS"("CMEDEWERKERS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TPRESTATIESOORTGROEPEN" ADD CONSTRAINT "_SYSTEM"."_C8720" CHECK("CPRESTATIESOORTGROEPEN_PK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TPRESTATIESOORTGROEPEN" ADD CONSTRAINT "_SYSTEM"."_C8722" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCONTACTARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C10341" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCONTACTARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C10342" CHECK("CCONTACTEN_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCONTACTARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C10343" CHECK("CARTIKELS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TCONTACTARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C10346" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCONTACTARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C10347" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TCONTACTARTIKELS" ADD CONSTRAINT "_SYSTEM"."_C10348" FOREIGN KEY("CARTIKELS_FK") REFERENCES "_SYSTEM"."TARTIKELS"("CARTIKELS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TARTIKELLEEGGOED" ADD CONSTRAINT "_SYSTEM"."_C10351" FOREIGN KEY("CARTIKELS_FK") REFERENCES "_SYSTEM"."TARTIKELS"("CARTIKELS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION CACHE(2000,20000,100);
ALTER TABLE "_SYSTEM"."TARTIKELLEEGGOED" ADD CONSTRAINT "_SYSTEM"."_C10352" FOREIGN KEY("CARTIKELLEEGGOED_FK") REFERENCES "_SYSTEM"."TARTIKELS"("CARTIKELS_PK") ON UPDATE NO ACTION ON DELETE NO ACTION CACHE(2000,20000,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TEDITEMPLATES" ADD CONSTRAINT "_SYSTEM"."_C11694" FOREIGN KEY("CEDIMSG_FK") REFERENCES "_SYSTEM"."TEDIMSG"("CEDIMSG_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TCONTACTROLEDI" ADD CONSTRAINT "_SYSTEM"."_C11696" FOREIGN KEY("CEDIMSG_FK") REFERENCES "_SYSTEM"."TEDIMSG"("CEDIMSG_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TARTIKELKLANT" ADD CONSTRAINT "_SYSTEM"."_C11697" CHECK("CINTERNEFIRMAARTIKELS" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELKLANT" ADD CONSTRAINT "_SYSTEM"."_C11698" CHECK("CARTIKEL" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELKLANT" ADD CONSTRAINT "_SYSTEM"."_C11699" CHECK("CCONTACT" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELKLANT" ADD CONSTRAINT "_SYSTEM"."_C11700" CHECK("CARTIKELKLANT" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TARTIKELKLANT" ADD CONSTRAINT "_SYSTEM"."_C11703" FOREIGN KEY("CCONTACTEN_FK") REFERENCES "_SYSTEM"."TCONTACTEN"("CCONTACTEN_PK") ON UPDATE NO ACTION ON DELETE CASCADE DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TARTIKELKLANT" ADD CONSTRAINT "_SYSTEM"."_C11704" FOREIGN KEY("CARTIKELS_FK") REFERENCES "_SYSTEM"."TARTIKELS"("CARTIKELS_PK") ON UPDATE NO ACTION ON DELETE CASCADE DEFERRABLE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TARTIKELKLANT" ADD CONSTRAINT "_SYSTEM"."_C11705" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TPEPOLTRACKING" ADD CONSTRAINT "_SYSTEM"."_C13046" FOREIGN KEY("CVERKOPEN_FK") REFERENCES "_SYSTEM"."TVERKOPEN"("CVERKOPEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION INITIALLY DEFERRED DEFERRABLE CACHE(500,500,100);
COMMIT;

ALTER TABLE "_SYSTEM"."TKAARTMERKIDENTIFIERS" ADD CONSTRAINT "_SYSTEM"."_C12028" FOREIGN KEY("CBETAALWIJZEN_FK") REFERENCES "_SYSTEM"."TBETAALWIJZEN"("CBETAALWIJZEN_PK") ON UPDATE NO ACTION ON DELETE NO ACTION CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TKAARTMERKIDENTIFIERS" ADD CONSTRAINT "_SYSTEM"."_C12031" FOREIGN KEY("CINTERNEFIRMAS_FK") REFERENCES "_SYSTEM"."TINTERNEFIRMAS"("CINTERNEFIRMAS_PK") ON UPDATE NO ACTION ON DELETE CASCADE CACHE(500,500,100);
ALTER TABLE "_SYSTEM"."TKAARTMERKIDENTIFIERS" ADD CONSTRAINT "_SYSTEM"."_C12027" CHECK("CMERKID" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TKAARTMERKIDENTIFIERS" ADD CONSTRAINT "_SYSTEM"."_C13052" CHECK("CINTERNEFIRMAS_FK" IS NOT NULL);
ALTER TABLE "_SYSTEM"."TKAARTMERKIDENTIFIERS" ADD CONSTRAINT "_SYSTEM"."_C13053" CHECK("CINTERNEFIRMA" IS NOT NULL);
COMMIT;

SET SESSION AUTHORIZATION "_SYSTEM";
SET DATABASE TRANSACTION 126662;
COMMIT;
